/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.SpotAllocationStrategy;
import software.amazon.awssdk.services.ec2.model.SpotInstanceInterruptionBehavior;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpotOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SpotOptions> {
    private static final SdkField<String> ALLOCATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SpotOptions.getter(SpotOptions::allocationStrategyAsString)).setter(SpotOptions.setter(Builder::allocationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationStrategy").unmarshallLocationName("allocationStrategy").build()}).build();
    private static final SdkField<String> INSTANCE_INTERRUPTION_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SpotOptions.getter(SpotOptions::instanceInterruptionBehaviorAsString)).setter(SpotOptions.setter(Builder::instanceInterruptionBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInterruptionBehavior").unmarshallLocationName("instanceInterruptionBehavior").build()}).build();
    private static final SdkField<Integer> INSTANCE_POOLS_TO_USE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(SpotOptions.getter(SpotOptions::instancePoolsToUseCount)).setter(SpotOptions.setter(Builder::instancePoolsToUseCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancePoolsToUseCount").unmarshallLocationName("instancePoolsToUseCount").build()}).build();
    private static final SdkField<Boolean> SINGLE_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(SpotOptions.getter(SpotOptions::singleInstanceType)).setter(SpotOptions.setter(Builder::singleInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleInstanceType").unmarshallLocationName("singleInstanceType").build()}).build();
    private static final SdkField<Boolean> SINGLE_AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(SpotOptions.getter(SpotOptions::singleAvailabilityZone)).setter(SpotOptions.setter(Builder::singleAvailabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleAvailabilityZone").unmarshallLocationName("singleAvailabilityZone").build()}).build();
    private static final SdkField<Integer> MIN_TARGET_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(SpotOptions.getter(SpotOptions::minTargetCapacity)).setter(SpotOptions.setter(Builder::minTargetCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinTargetCapacity").unmarshallLocationName("minTargetCapacity").build()}).build();
    private static final SdkField<String> MAX_TOTAL_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SpotOptions.getter(SpotOptions::maxTotalPrice)).setter(SpotOptions.setter(Builder::maxTotalPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxTotalPrice").unmarshallLocationName("maxTotalPrice").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_STRATEGY_FIELD, INSTANCE_INTERRUPTION_BEHAVIOR_FIELD, INSTANCE_POOLS_TO_USE_COUNT_FIELD, SINGLE_INSTANCE_TYPE_FIELD, SINGLE_AVAILABILITY_ZONE_FIELD, MIN_TARGET_CAPACITY_FIELD, MAX_TOTAL_PRICE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String allocationStrategy;
    private final String instanceInterruptionBehavior;
    private final Integer instancePoolsToUseCount;
    private final Boolean singleInstanceType;
    private final Boolean singleAvailabilityZone;
    private final Integer minTargetCapacity;
    private final String maxTotalPrice;

    private SpotOptions(BuilderImpl builder) {
        this.allocationStrategy = builder.allocationStrategy;
        this.instanceInterruptionBehavior = builder.instanceInterruptionBehavior;
        this.instancePoolsToUseCount = builder.instancePoolsToUseCount;
        this.singleInstanceType = builder.singleInstanceType;
        this.singleAvailabilityZone = builder.singleAvailabilityZone;
        this.minTargetCapacity = builder.minTargetCapacity;
        this.maxTotalPrice = builder.maxTotalPrice;
    }

    public SpotAllocationStrategy allocationStrategy() {
        return SpotAllocationStrategy.fromValue(this.allocationStrategy);
    }

    public String allocationStrategyAsString() {
        return this.allocationStrategy;
    }

    public SpotInstanceInterruptionBehavior instanceInterruptionBehavior() {
        return SpotInstanceInterruptionBehavior.fromValue(this.instanceInterruptionBehavior);
    }

    public String instanceInterruptionBehaviorAsString() {
        return this.instanceInterruptionBehavior;
    }

    public Integer instancePoolsToUseCount() {
        return this.instancePoolsToUseCount;
    }

    public Boolean singleInstanceType() {
        return this.singleInstanceType;
    }

    public Boolean singleAvailabilityZone() {
        return this.singleAvailabilityZone;
    }

    public Integer minTargetCapacity() {
        return this.minTargetCapacity;
    }

    public String maxTotalPrice() {
        return this.maxTotalPrice;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceInterruptionBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancePoolsToUseCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.singleInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.singleAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.minTargetCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxTotalPrice());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotOptions)) {
            return false;
        }
        SpotOptions other = (SpotOptions)obj;
        return Objects.equals(this.allocationStrategyAsString(), other.allocationStrategyAsString()) && Objects.equals(this.instanceInterruptionBehaviorAsString(), other.instanceInterruptionBehaviorAsString()) && Objects.equals(this.instancePoolsToUseCount(), other.instancePoolsToUseCount()) && Objects.equals(this.singleInstanceType(), other.singleInstanceType()) && Objects.equals(this.singleAvailabilityZone(), other.singleAvailabilityZone()) && Objects.equals(this.minTargetCapacity(), other.minTargetCapacity()) && Objects.equals(this.maxTotalPrice(), other.maxTotalPrice());
    }

    public String toString() {
        return ToString.builder((String)"SpotOptions").add("AllocationStrategy", (Object)this.allocationStrategyAsString()).add("InstanceInterruptionBehavior", (Object)this.instanceInterruptionBehaviorAsString()).add("InstancePoolsToUseCount", (Object)this.instancePoolsToUseCount()).add("SingleInstanceType", (Object)this.singleInstanceType()).add("SingleAvailabilityZone", (Object)this.singleAvailabilityZone()).add("MinTargetCapacity", (Object)this.minTargetCapacity()).add("MaxTotalPrice", (Object)this.maxTotalPrice()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllocationStrategy": {
                return Optional.ofNullable(clazz.cast(this.allocationStrategyAsString()));
            }
            case "InstanceInterruptionBehavior": {
                return Optional.ofNullable(clazz.cast(this.instanceInterruptionBehaviorAsString()));
            }
            case "InstancePoolsToUseCount": {
                return Optional.ofNullable(clazz.cast(this.instancePoolsToUseCount()));
            }
            case "SingleInstanceType": {
                return Optional.ofNullable(clazz.cast(this.singleInstanceType()));
            }
            case "SingleAvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.singleAvailabilityZone()));
            }
            case "MinTargetCapacity": {
                return Optional.ofNullable(clazz.cast(this.minTargetCapacity()));
            }
            case "MaxTotalPrice": {
                return Optional.ofNullable(clazz.cast(this.maxTotalPrice()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpotOptions, T> g) {
        return obj -> g.apply((SpotOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String allocationStrategy;
        private String instanceInterruptionBehavior;
        private Integer instancePoolsToUseCount;
        private Boolean singleInstanceType;
        private Boolean singleAvailabilityZone;
        private Integer minTargetCapacity;
        private String maxTotalPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotOptions model) {
            this.allocationStrategy(model.allocationStrategy);
            this.instanceInterruptionBehavior(model.instanceInterruptionBehavior);
            this.instancePoolsToUseCount(model.instancePoolsToUseCount);
            this.singleInstanceType(model.singleInstanceType);
            this.singleAvailabilityZone(model.singleAvailabilityZone);
            this.minTargetCapacity(model.minTargetCapacity);
            this.maxTotalPrice(model.maxTotalPrice);
        }

        public final String getAllocationStrategyAsString() {
            return this.allocationStrategy;
        }

        @Override
        public final Builder allocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        @Override
        public final Builder allocationStrategy(SpotAllocationStrategy allocationStrategy) {
            this.allocationStrategy(allocationStrategy == null ? null : allocationStrategy.toString());
            return this;
        }

        public final void setAllocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
        }

        public final String getInstanceInterruptionBehaviorAsString() {
            return this.instanceInterruptionBehavior;
        }

        @Override
        public final Builder instanceInterruptionBehavior(String instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior = instanceInterruptionBehavior;
            return this;
        }

        @Override
        public final Builder instanceInterruptionBehavior(SpotInstanceInterruptionBehavior instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior(instanceInterruptionBehavior == null ? null : instanceInterruptionBehavior.toString());
            return this;
        }

        public final void setInstanceInterruptionBehavior(String instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior = instanceInterruptionBehavior;
        }

        public final Integer getInstancePoolsToUseCount() {
            return this.instancePoolsToUseCount;
        }

        @Override
        public final Builder instancePoolsToUseCount(Integer instancePoolsToUseCount) {
            this.instancePoolsToUseCount = instancePoolsToUseCount;
            return this;
        }

        public final void setInstancePoolsToUseCount(Integer instancePoolsToUseCount) {
            this.instancePoolsToUseCount = instancePoolsToUseCount;
        }

        public final Boolean getSingleInstanceType() {
            return this.singleInstanceType;
        }

        @Override
        public final Builder singleInstanceType(Boolean singleInstanceType) {
            this.singleInstanceType = singleInstanceType;
            return this;
        }

        public final void setSingleInstanceType(Boolean singleInstanceType) {
            this.singleInstanceType = singleInstanceType;
        }

        public final Boolean getSingleAvailabilityZone() {
            return this.singleAvailabilityZone;
        }

        @Override
        public final Builder singleAvailabilityZone(Boolean singleAvailabilityZone) {
            this.singleAvailabilityZone = singleAvailabilityZone;
            return this;
        }

        public final void setSingleAvailabilityZone(Boolean singleAvailabilityZone) {
            this.singleAvailabilityZone = singleAvailabilityZone;
        }

        public final Integer getMinTargetCapacity() {
            return this.minTargetCapacity;
        }

        @Override
        public final Builder minTargetCapacity(Integer minTargetCapacity) {
            this.minTargetCapacity = minTargetCapacity;
            return this;
        }

        public final void setMinTargetCapacity(Integer minTargetCapacity) {
            this.minTargetCapacity = minTargetCapacity;
        }

        public final String getMaxTotalPrice() {
            return this.maxTotalPrice;
        }

        @Override
        public final Builder maxTotalPrice(String maxTotalPrice) {
            this.maxTotalPrice = maxTotalPrice;
            return this;
        }

        public final void setMaxTotalPrice(String maxTotalPrice) {
            this.maxTotalPrice = maxTotalPrice;
        }

        public SpotOptions build() {
            return new SpotOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SpotOptions> {
        public Builder allocationStrategy(String var1);

        public Builder allocationStrategy(SpotAllocationStrategy var1);

        public Builder instanceInterruptionBehavior(String var1);

        public Builder instanceInterruptionBehavior(SpotInstanceInterruptionBehavior var1);

        public Builder instancePoolsToUseCount(Integer var1);

        public Builder singleInstanceType(Boolean var1);

        public Builder singleAvailabilityZone(Boolean var1);

        public Builder minTargetCapacity(Integer var1);

        public Builder maxTotalPrice(String var1);
    }
}

