/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthorizeSecurityGroupEgressRequest extends Ec2Request implements
        ToCopyableBuilder<AuthorizeSecurityGroupEgressRequest.Builder, AuthorizeSecurityGroupEgressRequest> {
    private static final SdkField<String> GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AuthorizeSecurityGroupEgressRequest::groupId))
            .setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId")
                    .unmarshallLocationName("groupId").build()).build();

    private static final SdkField<List<IpPermission>> IP_PERMISSIONS_FIELD = SdkField
            .<List<IpPermission>> builder(MarshallingType.LIST)
            .getter(getter(AuthorizeSecurityGroupEgressRequest::ipPermissions))
            .setter(setter(Builder::ipPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpPermissions")
                    .unmarshallLocationName("ipPermissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<IpPermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpPermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> CIDR_IP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AuthorizeSecurityGroupEgressRequest::cidrIp))
            .setter(setter(Builder::cidrIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrIp")
                    .unmarshallLocationName("cidrIp").build()).build();

    private static final SdkField<Integer> FROM_PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(AuthorizeSecurityGroupEgressRequest::fromPort))
            .setter(setter(Builder::fromPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromPort")
                    .unmarshallLocationName("fromPort").build()).build();

    private static final SdkField<String> IP_PROTOCOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AuthorizeSecurityGroupEgressRequest::ipProtocol))
            .setter(setter(Builder::ipProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpProtocol")
                    .unmarshallLocationName("ipProtocol").build()).build();

    private static final SdkField<Integer> TO_PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(AuthorizeSecurityGroupEgressRequest::toPort))
            .setter(setter(Builder::toPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToPort")
                    .unmarshallLocationName("toPort").build()).build();

    private static final SdkField<String> SOURCE_SECURITY_GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AuthorizeSecurityGroupEgressRequest::sourceSecurityGroupName))
            .setter(setter(Builder::sourceSecurityGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSecurityGroupName")
                    .unmarshallLocationName("sourceSecurityGroupName").build()).build();

    private static final SdkField<String> SOURCE_SECURITY_GROUP_OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AuthorizeSecurityGroupEgressRequest::sourceSecurityGroupOwnerId))
            .setter(setter(Builder::sourceSecurityGroupOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSecurityGroupOwnerId")
                    .unmarshallLocationName("sourceSecurityGroupOwnerId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ID_FIELD,
            IP_PERMISSIONS_FIELD, CIDR_IP_FIELD, FROM_PORT_FIELD, IP_PROTOCOL_FIELD, TO_PORT_FIELD,
            SOURCE_SECURITY_GROUP_NAME_FIELD, SOURCE_SECURITY_GROUP_OWNER_ID_FIELD));

    private final String groupId;

    private final List<IpPermission> ipPermissions;

    private final String cidrIp;

    private final Integer fromPort;

    private final String ipProtocol;

    private final Integer toPort;

    private final String sourceSecurityGroupName;

    private final String sourceSecurityGroupOwnerId;

    private AuthorizeSecurityGroupEgressRequest(BuilderImpl builder) {
        super(builder);
        this.groupId = builder.groupId;
        this.ipPermissions = builder.ipPermissions;
        this.cidrIp = builder.cidrIp;
        this.fromPort = builder.fromPort;
        this.ipProtocol = builder.ipProtocol;
        this.toPort = builder.toPort;
        this.sourceSecurityGroupName = builder.sourceSecurityGroupName;
        this.sourceSecurityGroupOwnerId = builder.sourceSecurityGroupOwnerId;
    }

    /**
     * <p>
     * The ID of the security group.
     * </p>
     * 
     * @return The ID of the security group.
     */
    public String groupId() {
        return groupId;
    }

    /**
     * Returns true if the IpPermissions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasIpPermissions() {
        return ipPermissions != null && !(ipPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The sets of IP permissions. You can't specify a destination security group and a CIDR IP address range in the
     * same set of permissions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIpPermissions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The sets of IP permissions. You can't specify a destination security group and a CIDR IP address range in
     *         the same set of permissions.
     */
    public List<IpPermission> ipPermissions() {
        return ipPermissions;
    }

    /**
     * <p>
     * Not supported. Use a set of IP permissions to specify the CIDR.
     * </p>
     * 
     * @return Not supported. Use a set of IP permissions to specify the CIDR.
     */
    public String cidrIp() {
        return cidrIp;
    }

    /**
     * <p>
     * Not supported. Use a set of IP permissions to specify the port.
     * </p>
     * 
     * @return Not supported. Use a set of IP permissions to specify the port.
     */
    public Integer fromPort() {
        return fromPort;
    }

    /**
     * <p>
     * Not supported. Use a set of IP permissions to specify the protocol name or number.
     * </p>
     * 
     * @return Not supported. Use a set of IP permissions to specify the protocol name or number.
     */
    public String ipProtocol() {
        return ipProtocol;
    }

    /**
     * <p>
     * Not supported. Use a set of IP permissions to specify the port.
     * </p>
     * 
     * @return Not supported. Use a set of IP permissions to specify the port.
     */
    public Integer toPort() {
        return toPort;
    }

    /**
     * <p>
     * Not supported. Use a set of IP permissions to specify a destination security group.
     * </p>
     * 
     * @return Not supported. Use a set of IP permissions to specify a destination security group.
     */
    public String sourceSecurityGroupName() {
        return sourceSecurityGroupName;
    }

    /**
     * <p>
     * Not supported. Use a set of IP permissions to specify a destination security group.
     * </p>
     * 
     * @return Not supported. Use a set of IP permissions to specify a destination security group.
     */
    public String sourceSecurityGroupOwnerId() {
        return sourceSecurityGroupOwnerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(ipPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(cidrIp());
        hashCode = 31 * hashCode + Objects.hashCode(fromPort());
        hashCode = 31 * hashCode + Objects.hashCode(ipProtocol());
        hashCode = 31 * hashCode + Objects.hashCode(toPort());
        hashCode = 31 * hashCode + Objects.hashCode(sourceSecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceSecurityGroupOwnerId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizeSecurityGroupEgressRequest)) {
            return false;
        }
        AuthorizeSecurityGroupEgressRequest other = (AuthorizeSecurityGroupEgressRequest) obj;
        return Objects.equals(groupId(), other.groupId()) && Objects.equals(ipPermissions(), other.ipPermissions())
                && Objects.equals(cidrIp(), other.cidrIp()) && Objects.equals(fromPort(), other.fromPort())
                && Objects.equals(ipProtocol(), other.ipProtocol()) && Objects.equals(toPort(), other.toPort())
                && Objects.equals(sourceSecurityGroupName(), other.sourceSecurityGroupName())
                && Objects.equals(sourceSecurityGroupOwnerId(), other.sourceSecurityGroupOwnerId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AuthorizeSecurityGroupEgressRequest").add("GroupId", groupId())
                .add("IpPermissions", ipPermissions()).add("CidrIp", cidrIp()).add("FromPort", fromPort())
                .add("IpProtocol", ipProtocol()).add("ToPort", toPort())
                .add("SourceSecurityGroupName", sourceSecurityGroupName())
                .add("SourceSecurityGroupOwnerId", sourceSecurityGroupOwnerId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "IpPermissions":
            return Optional.ofNullable(clazz.cast(ipPermissions()));
        case "CidrIp":
            return Optional.ofNullable(clazz.cast(cidrIp()));
        case "FromPort":
            return Optional.ofNullable(clazz.cast(fromPort()));
        case "IpProtocol":
            return Optional.ofNullable(clazz.cast(ipProtocol()));
        case "ToPort":
            return Optional.ofNullable(clazz.cast(toPort()));
        case "SourceSecurityGroupName":
            return Optional.ofNullable(clazz.cast(sourceSecurityGroupName()));
        case "SourceSecurityGroupOwnerId":
            return Optional.ofNullable(clazz.cast(sourceSecurityGroupOwnerId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthorizeSecurityGroupEgressRequest, T> g) {
        return obj -> g.apply((AuthorizeSecurityGroupEgressRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, AuthorizeSecurityGroupEgressRequest> {
        /**
         * <p>
         * The ID of the security group.
         * </p>
         * 
         * @param groupId
         *        The ID of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * The sets of IP permissions. You can't specify a destination security group and a CIDR IP address range in the
         * same set of permissions.
         * </p>
         * 
         * @param ipPermissions
         *        The sets of IP permissions. You can't specify a destination security group and a CIDR IP address range
         *        in the same set of permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissions(Collection<IpPermission> ipPermissions);

        /**
         * <p>
         * The sets of IP permissions. You can't specify a destination security group and a CIDR IP address range in the
         * same set of permissions.
         * </p>
         * 
         * @param ipPermissions
         *        The sets of IP permissions. You can't specify a destination security group and a CIDR IP address range
         *        in the same set of permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissions(IpPermission... ipPermissions);

        /**
         * <p>
         * The sets of IP permissions. You can't specify a destination security group and a CIDR IP address range in the
         * same set of permissions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IpPermission>.Builder} avoiding the need to
         * create one manually via {@link List<IpPermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IpPermission>.Builder#build()} is called immediately and its
         * result is passed to {@link #ipPermissions(List<IpPermission>)}.
         * 
         * @param ipPermissions
         *        a consumer that will call methods on {@link List<IpPermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipPermissions(List<IpPermission>)
         */
        Builder ipPermissions(Consumer<IpPermission.Builder>... ipPermissions);

        /**
         * <p>
         * Not supported. Use a set of IP permissions to specify the CIDR.
         * </p>
         * 
         * @param cidrIp
         *        Not supported. Use a set of IP permissions to specify the CIDR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrIp(String cidrIp);

        /**
         * <p>
         * Not supported. Use a set of IP permissions to specify the port.
         * </p>
         * 
         * @param fromPort
         *        Not supported. Use a set of IP permissions to specify the port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromPort(Integer fromPort);

        /**
         * <p>
         * Not supported. Use a set of IP permissions to specify the protocol name or number.
         * </p>
         * 
         * @param ipProtocol
         *        Not supported. Use a set of IP permissions to specify the protocol name or number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipProtocol(String ipProtocol);

        /**
         * <p>
         * Not supported. Use a set of IP permissions to specify the port.
         * </p>
         * 
         * @param toPort
         *        Not supported. Use a set of IP permissions to specify the port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toPort(Integer toPort);

        /**
         * <p>
         * Not supported. Use a set of IP permissions to specify a destination security group.
         * </p>
         * 
         * @param sourceSecurityGroupName
         *        Not supported. Use a set of IP permissions to specify a destination security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSecurityGroupName(String sourceSecurityGroupName);

        /**
         * <p>
         * Not supported. Use a set of IP permissions to specify a destination security group.
         * </p>
         * 
         * @param sourceSecurityGroupOwnerId
         *        Not supported. Use a set of IP permissions to specify a destination security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSecurityGroupOwnerId(String sourceSecurityGroupOwnerId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String groupId;

        private List<IpPermission> ipPermissions = DefaultSdkAutoConstructList.getInstance();

        private String cidrIp;

        private Integer fromPort;

        private String ipProtocol;

        private Integer toPort;

        private String sourceSecurityGroupName;

        private String sourceSecurityGroupOwnerId;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizeSecurityGroupEgressRequest model) {
            super(model);
            groupId(model.groupId);
            ipPermissions(model.ipPermissions);
            cidrIp(model.cidrIp);
            fromPort(model.fromPort);
            ipProtocol(model.ipProtocol);
            toPort(model.toPort);
            sourceSecurityGroupName(model.sourceSecurityGroupName);
            sourceSecurityGroupOwnerId(model.sourceSecurityGroupOwnerId);
        }

        public final String getGroupId() {
            return groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final Collection<IpPermission.Builder> getIpPermissions() {
            return ipPermissions != null ? ipPermissions.stream().map(IpPermission::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder ipPermissions(Collection<IpPermission> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copy(ipPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissions(IpPermission... ipPermissions) {
            ipPermissions(Arrays.asList(ipPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissions(Consumer<IpPermission.Builder>... ipPermissions) {
            ipPermissions(Stream.of(ipPermissions).map(c -> IpPermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setIpPermissions(Collection<IpPermission.BuilderImpl> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copyFromBuilder(ipPermissions);
        }

        public final String getCidrIp() {
            return cidrIp;
        }

        @Override
        public final Builder cidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
            return this;
        }

        public final void setCidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
        }

        public final Integer getFromPort() {
            return fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        public final String getIpProtocol() {
            return ipProtocol;
        }

        @Override
        public final Builder ipProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        public final void setIpProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
        }

        public final Integer getToPort() {
            return toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        public final String getSourceSecurityGroupName() {
            return sourceSecurityGroupName;
        }

        @Override
        public final Builder sourceSecurityGroupName(String sourceSecurityGroupName) {
            this.sourceSecurityGroupName = sourceSecurityGroupName;
            return this;
        }

        public final void setSourceSecurityGroupName(String sourceSecurityGroupName) {
            this.sourceSecurityGroupName = sourceSecurityGroupName;
        }

        public final String getSourceSecurityGroupOwnerId() {
            return sourceSecurityGroupOwnerId;
        }

        @Override
        public final Builder sourceSecurityGroupOwnerId(String sourceSecurityGroupOwnerId) {
            this.sourceSecurityGroupOwnerId = sourceSecurityGroupOwnerId;
            return this;
        }

        public final void setSourceSecurityGroupOwnerId(String sourceSecurityGroupOwnerId) {
            this.sourceSecurityGroupOwnerId = sourceSecurityGroupOwnerId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AuthorizeSecurityGroupEgressRequest build() {
            return new AuthorizeSecurityGroupEgressRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
