/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportImageRequest extends Ec2Request implements
        ToCopyableBuilder<ExportImageRequest.Builder, ExportImageRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ExportImageRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ExportImageRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<String> DISK_IMAGE_FORMAT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ExportImageRequest::diskImageFormatAsString))
            .setter(setter(Builder::diskImageFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskImageFormat")
                    .unmarshallLocationName("DiskImageFormat").build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ExportImageRequest::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId")
                    .unmarshallLocationName("ImageId").build()).build();

    private static final SdkField<ExportTaskS3LocationRequest> S3_EXPORT_LOCATION_FIELD = SdkField
            .<ExportTaskS3LocationRequest> builder(MarshallingType.SDK_POJO)
            .getter(getter(ExportImageRequest::s3ExportLocation))
            .setter(setter(Builder::s3ExportLocation))
            .constructor(ExportTaskS3LocationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ExportLocation")
                    .unmarshallLocationName("S3ExportLocation").build()).build();

    private static final SdkField<String> ROLE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ExportImageRequest::roleName))
            .setter(setter(Builder::roleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleName")
                    .unmarshallLocationName("RoleName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DESCRIPTION_FIELD, DISK_IMAGE_FORMAT_FIELD, IMAGE_ID_FIELD, S3_EXPORT_LOCATION_FIELD, ROLE_NAME_FIELD));

    private final String clientToken;

    private final String description;

    private final String diskImageFormat;

    private final String imageId;

    private final ExportTaskS3LocationRequest s3ExportLocation;

    private final String roleName;

    private ExportImageRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.diskImageFormat = builder.diskImageFormat;
        this.imageId = builder.imageId;
        this.s3ExportLocation = builder.s3ExportLocation;
        this.roleName = builder.roleName;
    }

    /**
     * <p>
     * Token to enable idempotency for export image requests.
     * </p>
     * 
     * @return Token to enable idempotency for export image requests.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * A description of the image being exported. The maximum length is 255 bytes.
     * </p>
     * 
     * @return A description of the image being exported. The maximum length is 255 bytes.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The disk image format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #diskImageFormat}
     * will return {@link DiskImageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #diskImageFormatAsString}.
     * </p>
     * 
     * @return The disk image format.
     * @see DiskImageFormat
     */
    public DiskImageFormat diskImageFormat() {
        return DiskImageFormat.fromValue(diskImageFormat);
    }

    /**
     * <p>
     * The disk image format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #diskImageFormat}
     * will return {@link DiskImageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #diskImageFormatAsString}.
     * </p>
     * 
     * @return The disk image format.
     * @see DiskImageFormat
     */
    public String diskImageFormatAsString() {
        return diskImageFormat;
    }

    /**
     * <p>
     * The ID of the image.
     * </p>
     * 
     * @return The ID of the image.
     */
    public String imageId() {
        return imageId;
    }

    /**
     * <p>
     * Information about the destination S3 bucket. The bucket must exist and grant WRITE and READ_ACP permissions to
     * the AWS account vm-import-export@amazon.com.
     * </p>
     * 
     * @return Information about the destination S3 bucket. The bucket must exist and grant WRITE and READ_ACP
     *         permissions to the AWS account vm-import-export@amazon.com.
     */
    public ExportTaskS3LocationRequest s3ExportLocation() {
        return s3ExportLocation;
    }

    /**
     * <p>
     * The name of the role that grants VM Import/Export permission to export images to your S3 bucket. If this
     * parameter is not specified, the default role is named 'vmimport'.
     * </p>
     * 
     * @return The name of the role that grants VM Import/Export permission to export images to your S3 bucket. If this
     *         parameter is not specified, the default role is named 'vmimport'.
     */
    public String roleName() {
        return roleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(diskImageFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(s3ExportLocation());
        hashCode = 31 * hashCode + Objects.hashCode(roleName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportImageRequest)) {
            return false;
        }
        ExportImageRequest other = (ExportImageRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(description(), other.description())
                && Objects.equals(diskImageFormatAsString(), other.diskImageFormatAsString())
                && Objects.equals(imageId(), other.imageId()) && Objects.equals(s3ExportLocation(), other.s3ExportLocation())
                && Objects.equals(roleName(), other.roleName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ExportImageRequest").add("ClientToken", clientToken()).add("Description", description())
                .add("DiskImageFormat", diskImageFormatAsString()).add("ImageId", imageId())
                .add("S3ExportLocation", s3ExportLocation()).add("RoleName", roleName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DiskImageFormat":
            return Optional.ofNullable(clazz.cast(diskImageFormatAsString()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "S3ExportLocation":
            return Optional.ofNullable(clazz.cast(s3ExportLocation()));
        case "RoleName":
            return Optional.ofNullable(clazz.cast(roleName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportImageRequest, T> g) {
        return obj -> g.apply((ExportImageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ExportImageRequest> {
        /**
         * <p>
         * Token to enable idempotency for export image requests.
         * </p>
         * 
         * @param clientToken
         *        Token to enable idempotency for export image requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A description of the image being exported. The maximum length is 255 bytes.
         * </p>
         * 
         * @param description
         *        A description of the image being exported. The maximum length is 255 bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The disk image format.
         * </p>
         * 
         * @param diskImageFormat
         *        The disk image format.
         * @see DiskImageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiskImageFormat
         */
        Builder diskImageFormat(String diskImageFormat);

        /**
         * <p>
         * The disk image format.
         * </p>
         * 
         * @param diskImageFormat
         *        The disk image format.
         * @see DiskImageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiskImageFormat
         */
        Builder diskImageFormat(DiskImageFormat diskImageFormat);

        /**
         * <p>
         * The ID of the image.
         * </p>
         * 
         * @param imageId
         *        The ID of the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * Information about the destination S3 bucket. The bucket must exist and grant WRITE and READ_ACP permissions
         * to the AWS account vm-import-export@amazon.com.
         * </p>
         * 
         * @param s3ExportLocation
         *        Information about the destination S3 bucket. The bucket must exist and grant WRITE and READ_ACP
         *        permissions to the AWS account vm-import-export@amazon.com.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ExportLocation(ExportTaskS3LocationRequest s3ExportLocation);

        /**
         * <p>
         * Information about the destination S3 bucket. The bucket must exist and grant WRITE and READ_ACP permissions
         * to the AWS account vm-import-export@amazon.com.
         * </p>
         * This is a convenience that creates an instance of the {@link ExportTaskS3LocationRequest.Builder} avoiding
         * the need to create one manually via {@link ExportTaskS3LocationRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExportTaskS3LocationRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #s3ExportLocation(ExportTaskS3LocationRequest)}.
         * 
         * @param s3ExportLocation
         *        a consumer that will call methods on {@link ExportTaskS3LocationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3ExportLocation(ExportTaskS3LocationRequest)
         */
        default Builder s3ExportLocation(Consumer<ExportTaskS3LocationRequest.Builder> s3ExportLocation) {
            return s3ExportLocation(ExportTaskS3LocationRequest.builder().applyMutation(s3ExportLocation).build());
        }

        /**
         * <p>
         * The name of the role that grants VM Import/Export permission to export images to your S3 bucket. If this
         * parameter is not specified, the default role is named 'vmimport'.
         * </p>
         * 
         * @param roleName
         *        The name of the role that grants VM Import/Export permission to export images to your S3 bucket. If
         *        this parameter is not specified, the default role is named 'vmimport'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleName(String roleName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String clientToken;

        private String description;

        private String diskImageFormat;

        private String imageId;

        private ExportTaskS3LocationRequest s3ExportLocation;

        private String roleName;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportImageRequest model) {
            super(model);
            clientToken(model.clientToken);
            description(model.description);
            diskImageFormat(model.diskImageFormat);
            imageId(model.imageId);
            s3ExportLocation(model.s3ExportLocation);
            roleName(model.roleName);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDiskImageFormatAsString() {
            return diskImageFormat;
        }

        @Override
        public final Builder diskImageFormat(String diskImageFormat) {
            this.diskImageFormat = diskImageFormat;
            return this;
        }

        @Override
        public final Builder diskImageFormat(DiskImageFormat diskImageFormat) {
            this.diskImageFormat(diskImageFormat == null ? null : diskImageFormat.toString());
            return this;
        }

        public final void setDiskImageFormat(String diskImageFormat) {
            this.diskImageFormat = diskImageFormat;
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final ExportTaskS3LocationRequest.Builder getS3ExportLocation() {
            return s3ExportLocation != null ? s3ExportLocation.toBuilder() : null;
        }

        @Override
        public final Builder s3ExportLocation(ExportTaskS3LocationRequest s3ExportLocation) {
            this.s3ExportLocation = s3ExportLocation;
            return this;
        }

        public final void setS3ExportLocation(ExportTaskS3LocationRequest.BuilderImpl s3ExportLocation) {
            this.s3ExportLocation = s3ExportLocation != null ? s3ExportLocation.build() : null;
        }

        public final String getRoleName() {
            return roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExportImageRequest build() {
            return new ExportImageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
