/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a load permission.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoadPermissionRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<LoadPermissionRequest.Builder, LoadPermissionRequest> {
    private static final SdkField<String> GROUP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(LoadPermissionRequest::groupAsString))
            .setter(setter(Builder::group))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group")
                    .unmarshallLocationName("Group").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(LoadPermissionRequest::userId))
            .setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId")
                    .unmarshallLocationName("UserId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_FIELD, USER_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String group;

    private final String userId;

    private LoadPermissionRequest(BuilderImpl builder) {
        this.group = builder.group;
        this.userId = builder.userId;
    }

    /**
     * <p>
     * The name of the group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #group} will return
     * {@link PermissionGroup#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupAsString}.
     * </p>
     * 
     * @return The name of the group.
     * @see PermissionGroup
     */
    public PermissionGroup group() {
        return PermissionGroup.fromValue(group);
    }

    /**
     * <p>
     * The name of the group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #group} will return
     * {@link PermissionGroup#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupAsString}.
     * </p>
     * 
     * @return The name of the group.
     * @see PermissionGroup
     */
    public String groupAsString() {
        return group;
    }

    /**
     * <p>
     * The AWS account ID.
     * </p>
     * 
     * @return The AWS account ID.
     */
    public String userId() {
        return userId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadPermissionRequest)) {
            return false;
        }
        LoadPermissionRequest other = (LoadPermissionRequest) obj;
        return Objects.equals(groupAsString(), other.groupAsString()) && Objects.equals(userId(), other.userId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LoadPermissionRequest").add("Group", groupAsString()).add("UserId", userId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Group":
            return Optional.ofNullable(clazz.cast(groupAsString()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoadPermissionRequest, T> g) {
        return obj -> g.apply((LoadPermissionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoadPermissionRequest> {
        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param group
         *        The name of the group.
         * @see PermissionGroup
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionGroup
         */
        Builder group(String group);

        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param group
         *        The name of the group.
         * @see PermissionGroup
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionGroup
         */
        Builder group(PermissionGroup group);

        /**
         * <p>
         * The AWS account ID.
         * </p>
         * 
         * @param userId
         *        The AWS account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);
    }

    static final class BuilderImpl implements Builder {
        private String group;

        private String userId;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadPermissionRequest model) {
            group(model.group);
            userId(model.userId);
        }

        public final String getGroupAsString() {
            return group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        @Override
        public final Builder group(PermissionGroup group) {
            this.group(group == null ? null : group.toString());
            return this;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        public final String getUserId() {
            return userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public LoadPermissionRequest build() {
            return new LoadPermissionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
