/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a placement group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PlacementGroup implements SdkPojo, Serializable, ToCopyableBuilder<PlacementGroup.Builder, PlacementGroup> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PlacementGroup::groupName))
            .setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName")
                    .unmarshallLocationName("groupName").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PlacementGroup::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<String> STRATEGY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PlacementGroup::strategyAsString))
            .setter(setter(Builder::strategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Strategy")
                    .unmarshallLocationName("strategy").build()).build();

    private static final SdkField<Integer> PARTITION_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(PlacementGroup::partitionCount))
            .setter(setter(Builder::partitionCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionCount")
                    .unmarshallLocationName("partitionCount").build()).build();

    private static final SdkField<String> GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PlacementGroup::groupId))
            .setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId")
                    .unmarshallLocationName("groupId").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(PlacementGroup::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD, STATE_FIELD,
            STRATEGY_FIELD, PARTITION_COUNT_FIELD, GROUP_ID_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String groupName;

    private final String state;

    private final String strategy;

    private final Integer partitionCount;

    private final String groupId;

    private final List<Tag> tags;

    private PlacementGroup(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.state = builder.state;
        this.strategy = builder.strategy;
        this.partitionCount = builder.partitionCount;
        this.groupId = builder.groupId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the placement group.
     * </p>
     * 
     * @return The name of the placement group.
     */
    public String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The state of the placement group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link PlacementGroupState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the placement group.
     * @see PlacementGroupState
     */
    public PlacementGroupState state() {
        return PlacementGroupState.fromValue(state);
    }

    /**
     * <p>
     * The state of the placement group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link PlacementGroupState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the placement group.
     * @see PlacementGroupState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The placement strategy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #strategy} will
     * return {@link PlacementStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #strategyAsString}.
     * </p>
     * 
     * @return The placement strategy.
     * @see PlacementStrategy
     */
    public PlacementStrategy strategy() {
        return PlacementStrategy.fromValue(strategy);
    }

    /**
     * <p>
     * The placement strategy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #strategy} will
     * return {@link PlacementStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #strategyAsString}.
     * </p>
     * 
     * @return The placement strategy.
     * @see PlacementStrategy
     */
    public String strategyAsString() {
        return strategy;
    }

    /**
     * <p>
     * The number of partitions. Valid only if <b>strategy</b> is set to <code>partition</code>.
     * </p>
     * 
     * @return The number of partitions. Valid only if <b>strategy</b> is set to <code>partition</code>.
     */
    public Integer partitionCount() {
        return partitionCount;
    }

    /**
     * <p>
     * The ID of the placement group.
     * </p>
     * 
     * @return The ID of the placement group.
     */
    public String groupId() {
        return groupId;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags applied to the placement group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Any tags applied to the placement group.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(strategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(partitionCount());
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlacementGroup)) {
            return false;
        }
        PlacementGroup other = (PlacementGroup) obj;
        return Objects.equals(groupName(), other.groupName()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(strategyAsString(), other.strategyAsString())
                && Objects.equals(partitionCount(), other.partitionCount()) && Objects.equals(groupId(), other.groupId())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PlacementGroup").add("GroupName", groupName()).add("State", stateAsString())
                .add("Strategy", strategyAsString()).add("PartitionCount", partitionCount()).add("GroupId", groupId())
                .add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Strategy":
            return Optional.ofNullable(clazz.cast(strategyAsString()));
        case "PartitionCount":
            return Optional.ofNullable(clazz.cast(partitionCount()));
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PlacementGroup, T> g) {
        return obj -> g.apply((PlacementGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PlacementGroup> {
        /**
         * <p>
         * The name of the placement group.
         * </p>
         * 
         * @param groupName
         *        The name of the placement group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The state of the placement group.
         * </p>
         * 
         * @param state
         *        The state of the placement group.
         * @see PlacementGroupState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlacementGroupState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the placement group.
         * </p>
         * 
         * @param state
         *        The state of the placement group.
         * @see PlacementGroupState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlacementGroupState
         */
        Builder state(PlacementGroupState state);

        /**
         * <p>
         * The placement strategy.
         * </p>
         * 
         * @param strategy
         *        The placement strategy.
         * @see PlacementStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlacementStrategy
         */
        Builder strategy(String strategy);

        /**
         * <p>
         * The placement strategy.
         * </p>
         * 
         * @param strategy
         *        The placement strategy.
         * @see PlacementStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlacementStrategy
         */
        Builder strategy(PlacementStrategy strategy);

        /**
         * <p>
         * The number of partitions. Valid only if <b>strategy</b> is set to <code>partition</code>.
         * </p>
         * 
         * @param partitionCount
         *        The number of partitions. Valid only if <b>strategy</b> is set to <code>partition</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionCount(Integer partitionCount);

        /**
         * <p>
         * The ID of the placement group.
         * </p>
         * 
         * @param groupId
         *        The ID of the placement group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * Any tags applied to the placement group.
         * </p>
         * 
         * @param tags
         *        Any tags applied to the placement group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags applied to the placement group.
         * </p>
         * 
         * @param tags
         *        Any tags applied to the placement group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags applied to the placement group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String groupName;

        private String state;

        private String strategy;

        private Integer partitionCount;

        private String groupId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PlacementGroup model) {
            groupName(model.groupName);
            state(model.state);
            strategy(model.strategy);
            partitionCount(model.partitionCount);
            groupId(model.groupId);
            tags(model.tags);
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getStateAsString() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(PlacementGroupState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStrategyAsString() {
            return strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public final Builder strategy(PlacementStrategy strategy) {
            this.strategy(strategy == null ? null : strategy.toString());
            return this;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        public final Integer getPartitionCount() {
            return partitionCount;
        }

        @Override
        public final Builder partitionCount(Integer partitionCount) {
            this.partitionCount = partitionCount;
            return this;
        }

        public final void setPartitionCount(Integer partitionCount) {
            this.partitionCount = partitionCount;
        }

        public final String getGroupId() {
            return groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public PlacementGroup build() {
            return new PlacementGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
