/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCoipPoolsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeCoipPoolsResponse.Builder, DescribeCoipPoolsResponse> {
    private static final SdkField<List<CoipPool>> COIP_POOLS_FIELD = SdkField
            .<List<CoipPool>> builder(MarshallingType.LIST)
            .getter(getter(DescribeCoipPoolsResponse::coipPools))
            .setter(setter(Builder::coipPools))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoipPoolSet")
                    .unmarshallLocationName("coipPoolSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<CoipPool> builder(MarshallingType.SDK_POJO)
                                            .constructor(CoipPool::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeCoipPoolsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COIP_POOLS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<CoipPool> coipPools;

    private final String nextToken;

    private DescribeCoipPoolsResponse(BuilderImpl builder) {
        super(builder);
        this.coipPools = builder.coipPools;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the CoipPools property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCoipPools() {
        return coipPools != null && !(coipPools instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the address pools.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCoipPools()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the address pools.
     */
    public List<CoipPool> coipPools() {
        return coipPools;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(coipPools());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCoipPoolsResponse)) {
            return false;
        }
        DescribeCoipPoolsResponse other = (DescribeCoipPoolsResponse) obj;
        return Objects.equals(coipPools(), other.coipPools()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeCoipPoolsResponse").add("CoipPools", coipPools()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoipPools":
            return Optional.ofNullable(clazz.cast(coipPools()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCoipPoolsResponse, T> g) {
        return obj -> g.apply((DescribeCoipPoolsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCoipPoolsResponse> {
        /**
         * <p>
         * Information about the address pools.
         * </p>
         * 
         * @param coipPools
         *        Information about the address pools.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coipPools(Collection<CoipPool> coipPools);

        /**
         * <p>
         * Information about the address pools.
         * </p>
         * 
         * @param coipPools
         *        Information about the address pools.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coipPools(CoipPool... coipPools);

        /**
         * <p>
         * Information about the address pools.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CoipPool>.Builder} avoiding the need to
         * create one manually via {@link List<CoipPool>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CoipPool>.Builder#build()} is called immediately and its
         * result is passed to {@link #coipPools(List<CoipPool>)}.
         * 
         * @param coipPools
         *        a consumer that will call methods on {@link List<CoipPool>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #coipPools(List<CoipPool>)
         */
        Builder coipPools(Consumer<CoipPool.Builder>... coipPools);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<CoipPool> coipPools = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCoipPoolsResponse model) {
            super(model);
            coipPools(model.coipPools);
            nextToken(model.nextToken);
        }

        public final Collection<CoipPool.Builder> getCoipPools() {
            return coipPools != null ? coipPools.stream().map(CoipPool::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder coipPools(Collection<CoipPool> coipPools) {
            this.coipPools = CoipPoolSetCopier.copy(coipPools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder coipPools(CoipPool... coipPools) {
            coipPools(Arrays.asList(coipPools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder coipPools(Consumer<CoipPool.Builder>... coipPools) {
            coipPools(Stream.of(coipPools).map(c -> CoipPool.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCoipPools(Collection<CoipPool.BuilderImpl> coipPools) {
            this.coipPools = CoipPoolSetCopier.copyFromBuilder(coipPools);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeCoipPoolsResponse build() {
            return new DescribeCoipPoolsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
