/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Amazon EBS features supported by the instance type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EbsInfo implements SdkPojo, Serializable, ToCopyableBuilder<EbsInfo.Builder, EbsInfo> {
    private static final SdkField<String> EBS_OPTIMIZED_SUPPORT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(EbsInfo::ebsOptimizedSupportAsString))
            .setter(setter(Builder::ebsOptimizedSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimizedSupport")
                    .unmarshallLocationName("ebsOptimizedSupport").build()).build();

    private static final SdkField<String> ENCRYPTION_SUPPORT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(EbsInfo::encryptionSupportAsString))
            .setter(setter(Builder::encryptionSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionSupport")
                    .unmarshallLocationName("encryptionSupport").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EBS_OPTIMIZED_SUPPORT_FIELD,
            ENCRYPTION_SUPPORT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ebsOptimizedSupport;

    private final String encryptionSupport;

    private EbsInfo(BuilderImpl builder) {
        this.ebsOptimizedSupport = builder.ebsOptimizedSupport;
        this.encryptionSupport = builder.encryptionSupport;
    }

    /**
     * <p>
     * Indicates that the instance type is Amazon EBS-optimized. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon EBS-Optimized Instances</a>
     * in <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #ebsOptimizedSupport} will return {@link EbsOptimizedSupport#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #ebsOptimizedSupportAsString}.
     * </p>
     * 
     * @return Indicates that the instance type is Amazon EBS-optimized. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon EBS-Optimized
     *         Instances</a> in <i>Amazon EC2 User Guide for Linux Instances</i>.
     * @see EbsOptimizedSupport
     */
    public EbsOptimizedSupport ebsOptimizedSupport() {
        return EbsOptimizedSupport.fromValue(ebsOptimizedSupport);
    }

    /**
     * <p>
     * Indicates that the instance type is Amazon EBS-optimized. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon EBS-Optimized Instances</a>
     * in <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #ebsOptimizedSupport} will return {@link EbsOptimizedSupport#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #ebsOptimizedSupportAsString}.
     * </p>
     * 
     * @return Indicates that the instance type is Amazon EBS-optimized. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon EBS-Optimized
     *         Instances</a> in <i>Amazon EC2 User Guide for Linux Instances</i>.
     * @see EbsOptimizedSupport
     */
    public String ebsOptimizedSupportAsString() {
        return ebsOptimizedSupport;
    }

    /**
     * <p>
     * Indicates whether Amazon EBS encryption is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionSupport}
     * will return {@link EbsEncryptionSupport#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #encryptionSupportAsString}.
     * </p>
     * 
     * @return Indicates whether Amazon EBS encryption is supported.
     * @see EbsEncryptionSupport
     */
    public EbsEncryptionSupport encryptionSupport() {
        return EbsEncryptionSupport.fromValue(encryptionSupport);
    }

    /**
     * <p>
     * Indicates whether Amazon EBS encryption is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionSupport}
     * will return {@link EbsEncryptionSupport#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #encryptionSupportAsString}.
     * </p>
     * 
     * @return Indicates whether Amazon EBS encryption is supported.
     * @see EbsEncryptionSupport
     */
    public String encryptionSupportAsString() {
        return encryptionSupport;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimizedSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionSupportAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsInfo)) {
            return false;
        }
        EbsInfo other = (EbsInfo) obj;
        return Objects.equals(ebsOptimizedSupportAsString(), other.ebsOptimizedSupportAsString())
                && Objects.equals(encryptionSupportAsString(), other.encryptionSupportAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EbsInfo").add("EbsOptimizedSupport", ebsOptimizedSupportAsString())
                .add("EncryptionSupport", encryptionSupportAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EbsOptimizedSupport":
            return Optional.ofNullable(clazz.cast(ebsOptimizedSupportAsString()));
        case "EncryptionSupport":
            return Optional.ofNullable(clazz.cast(encryptionSupportAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EbsInfo, T> g) {
        return obj -> g.apply((EbsInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EbsInfo> {
        /**
         * <p>
         * Indicates that the instance type is Amazon EBS-optimized. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon EBS-Optimized
         * Instances</a> in <i>Amazon EC2 User Guide for Linux Instances</i>.
         * </p>
         * 
         * @param ebsOptimizedSupport
         *        Indicates that the instance type is Amazon EBS-optimized. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon EBS-Optimized
         *        Instances</a> in <i>Amazon EC2 User Guide for Linux Instances</i>.
         * @see EbsOptimizedSupport
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EbsOptimizedSupport
         */
        Builder ebsOptimizedSupport(String ebsOptimizedSupport);

        /**
         * <p>
         * Indicates that the instance type is Amazon EBS-optimized. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon EBS-Optimized
         * Instances</a> in <i>Amazon EC2 User Guide for Linux Instances</i>.
         * </p>
         * 
         * @param ebsOptimizedSupport
         *        Indicates that the instance type is Amazon EBS-optimized. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon EBS-Optimized
         *        Instances</a> in <i>Amazon EC2 User Guide for Linux Instances</i>.
         * @see EbsOptimizedSupport
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EbsOptimizedSupport
         */
        Builder ebsOptimizedSupport(EbsOptimizedSupport ebsOptimizedSupport);

        /**
         * <p>
         * Indicates whether Amazon EBS encryption is supported.
         * </p>
         * 
         * @param encryptionSupport
         *        Indicates whether Amazon EBS encryption is supported.
         * @see EbsEncryptionSupport
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EbsEncryptionSupport
         */
        Builder encryptionSupport(String encryptionSupport);

        /**
         * <p>
         * Indicates whether Amazon EBS encryption is supported.
         * </p>
         * 
         * @param encryptionSupport
         *        Indicates whether Amazon EBS encryption is supported.
         * @see EbsEncryptionSupport
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EbsEncryptionSupport
         */
        Builder encryptionSupport(EbsEncryptionSupport encryptionSupport);
    }

    static final class BuilderImpl implements Builder {
        private String ebsOptimizedSupport;

        private String encryptionSupport;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsInfo model) {
            ebsOptimizedSupport(model.ebsOptimizedSupport);
            encryptionSupport(model.encryptionSupport);
        }

        public final String getEbsOptimizedSupport() {
            return ebsOptimizedSupport;
        }

        @Override
        public final Builder ebsOptimizedSupport(String ebsOptimizedSupport) {
            this.ebsOptimizedSupport = ebsOptimizedSupport;
            return this;
        }

        @Override
        public final Builder ebsOptimizedSupport(EbsOptimizedSupport ebsOptimizedSupport) {
            this.ebsOptimizedSupport(ebsOptimizedSupport == null ? null : ebsOptimizedSupport.toString());
            return this;
        }

        public final void setEbsOptimizedSupport(String ebsOptimizedSupport) {
            this.ebsOptimizedSupport = ebsOptimizedSupport;
        }

        public final String getEncryptionSupport() {
            return encryptionSupport;
        }

        @Override
        public final Builder encryptionSupport(String encryptionSupport) {
            this.encryptionSupport = encryptionSupport;
            return this;
        }

        @Override
        public final Builder encryptionSupport(EbsEncryptionSupport encryptionSupport) {
            this.encryptionSupport(encryptionSupport == null ? null : encryptionSupport.toString());
            return this;
        }

        public final void setEncryptionSupport(String encryptionSupport) {
            this.encryptionSupport = encryptionSupport;
        }

        @Override
        public EbsInfo build() {
            return new EbsInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
