/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RevokeClientVpnIngressRequest extends Ec2Request implements
        ToCopyableBuilder<RevokeClientVpnIngressRequest.Builder, RevokeClientVpnIngressRequest> {
    private static final SdkField<String> CLIENT_VPN_ENDPOINT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(RevokeClientVpnIngressRequest::clientVpnEndpointId))
            .setter(setter(Builder::clientVpnEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVpnEndpointId")
                    .unmarshallLocationName("ClientVpnEndpointId").build()).build();

    private static final SdkField<String> TARGET_NETWORK_CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(RevokeClientVpnIngressRequest::targetNetworkCidr))
            .setter(setter(Builder::targetNetworkCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetNetworkCidr")
                    .unmarshallLocationName("TargetNetworkCidr").build()).build();

    private static final SdkField<String> ACCESS_GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(RevokeClientVpnIngressRequest::accessGroupId))
            .setter(setter(Builder::accessGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGroupId")
                    .unmarshallLocationName("AccessGroupId").build()).build();

    private static final SdkField<Boolean> REVOKE_ALL_GROUPS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(RevokeClientVpnIngressRequest::revokeAllGroups))
            .setter(setter(Builder::revokeAllGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevokeAllGroups")
                    .unmarshallLocationName("RevokeAllGroups").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VPN_ENDPOINT_ID_FIELD,
            TARGET_NETWORK_CIDR_FIELD, ACCESS_GROUP_ID_FIELD, REVOKE_ALL_GROUPS_FIELD));

    private final String clientVpnEndpointId;

    private final String targetNetworkCidr;

    private final String accessGroupId;

    private final Boolean revokeAllGroups;

    private RevokeClientVpnIngressRequest(BuilderImpl builder) {
        super(builder);
        this.clientVpnEndpointId = builder.clientVpnEndpointId;
        this.targetNetworkCidr = builder.targetNetworkCidr;
        this.accessGroupId = builder.accessGroupId;
        this.revokeAllGroups = builder.revokeAllGroups;
    }

    /**
     * <p>
     * The ID of the Client VPN endpoint with which the authorization rule is associated.
     * </p>
     * 
     * @return The ID of the Client VPN endpoint with which the authorization rule is associated.
     */
    public String clientVpnEndpointId() {
        return clientVpnEndpointId;
    }

    /**
     * <p>
     * The IPv4 address range, in CIDR notation, of the network for which access is being removed.
     * </p>
     * 
     * @return The IPv4 address range, in CIDR notation, of the network for which access is being removed.
     */
    public String targetNetworkCidr() {
        return targetNetworkCidr;
    }

    /**
     * <p>
     * The ID of the Active Directory group for which to revoke access.
     * </p>
     * 
     * @return The ID of the Active Directory group for which to revoke access.
     */
    public String accessGroupId() {
        return accessGroupId;
    }

    /**
     * <p>
     * Indicates whether access should be revoked for all clients.
     * </p>
     * 
     * @return Indicates whether access should be revoked for all clients.
     */
    public Boolean revokeAllGroups() {
        return revokeAllGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientVpnEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(targetNetworkCidr());
        hashCode = 31 * hashCode + Objects.hashCode(accessGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(revokeAllGroups());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokeClientVpnIngressRequest)) {
            return false;
        }
        RevokeClientVpnIngressRequest other = (RevokeClientVpnIngressRequest) obj;
        return Objects.equals(clientVpnEndpointId(), other.clientVpnEndpointId())
                && Objects.equals(targetNetworkCidr(), other.targetNetworkCidr())
                && Objects.equals(accessGroupId(), other.accessGroupId())
                && Objects.equals(revokeAllGroups(), other.revokeAllGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RevokeClientVpnIngressRequest").add("ClientVpnEndpointId", clientVpnEndpointId())
                .add("TargetNetworkCidr", targetNetworkCidr()).add("AccessGroupId", accessGroupId())
                .add("RevokeAllGroups", revokeAllGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientVpnEndpointId":
            return Optional.ofNullable(clazz.cast(clientVpnEndpointId()));
        case "TargetNetworkCidr":
            return Optional.ofNullable(clazz.cast(targetNetworkCidr()));
        case "AccessGroupId":
            return Optional.ofNullable(clazz.cast(accessGroupId()));
        case "RevokeAllGroups":
            return Optional.ofNullable(clazz.cast(revokeAllGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RevokeClientVpnIngressRequest, T> g) {
        return obj -> g.apply((RevokeClientVpnIngressRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, RevokeClientVpnIngressRequest> {
        /**
         * <p>
         * The ID of the Client VPN endpoint with which the authorization rule is associated.
         * </p>
         * 
         * @param clientVpnEndpointId
         *        The ID of the Client VPN endpoint with which the authorization rule is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientVpnEndpointId(String clientVpnEndpointId);

        /**
         * <p>
         * The IPv4 address range, in CIDR notation, of the network for which access is being removed.
         * </p>
         * 
         * @param targetNetworkCidr
         *        The IPv4 address range, in CIDR notation, of the network for which access is being removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetNetworkCidr(String targetNetworkCidr);

        /**
         * <p>
         * The ID of the Active Directory group for which to revoke access.
         * </p>
         * 
         * @param accessGroupId
         *        The ID of the Active Directory group for which to revoke access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessGroupId(String accessGroupId);

        /**
         * <p>
         * Indicates whether access should be revoked for all clients.
         * </p>
         * 
         * @param revokeAllGroups
         *        Indicates whether access should be revoked for all clients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revokeAllGroups(Boolean revokeAllGroups);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String clientVpnEndpointId;

        private String targetNetworkCidr;

        private String accessGroupId;

        private Boolean revokeAllGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(RevokeClientVpnIngressRequest model) {
            super(model);
            clientVpnEndpointId(model.clientVpnEndpointId);
            targetNetworkCidr(model.targetNetworkCidr);
            accessGroupId(model.accessGroupId);
            revokeAllGroups(model.revokeAllGroups);
        }

        public final String getClientVpnEndpointId() {
            return clientVpnEndpointId;
        }

        @Override
        public final Builder clientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
            return this;
        }

        public final void setClientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
        }

        public final String getTargetNetworkCidr() {
            return targetNetworkCidr;
        }

        @Override
        public final Builder targetNetworkCidr(String targetNetworkCidr) {
            this.targetNetworkCidr = targetNetworkCidr;
            return this;
        }

        public final void setTargetNetworkCidr(String targetNetworkCidr) {
            this.targetNetworkCidr = targetNetworkCidr;
        }

        public final String getAccessGroupId() {
            return accessGroupId;
        }

        @Override
        public final Builder accessGroupId(String accessGroupId) {
            this.accessGroupId = accessGroupId;
            return this;
        }

        public final void setAccessGroupId(String accessGroupId) {
            this.accessGroupId = accessGroupId;
        }

        public final Boolean getRevokeAllGroups() {
            return revokeAllGroups;
        }

        @Override
        public final Builder revokeAllGroups(Boolean revokeAllGroups) {
            this.revokeAllGroups = revokeAllGroups;
            return this;
        }

        public final void setRevokeAllGroups(Boolean revokeAllGroups) {
            this.revokeAllGroups = revokeAllGroups;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RevokeClientVpnIngressRequest build() {
            return new RevokeClientVpnIngressRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
