/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the number of instances that can be launched onto the Dedicated Host.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceCapacity implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceCapacity.Builder, InstanceCapacity> {
    private static final SdkField<Integer> AVAILABLE_CAPACITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(InstanceCapacity::availableCapacity))
            .setter(setter(Builder::availableCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableCapacity")
                    .unmarshallLocationName("availableCapacity").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(InstanceCapacity::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("instanceType").build()).build();

    private static final SdkField<Integer> TOTAL_CAPACITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(InstanceCapacity::totalCapacity))
            .setter(setter(Builder::totalCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCapacity")
                    .unmarshallLocationName("totalCapacity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABLE_CAPACITY_FIELD,
            INSTANCE_TYPE_FIELD, TOTAL_CAPACITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer availableCapacity;

    private final String instanceType;

    private final Integer totalCapacity;

    private InstanceCapacity(BuilderImpl builder) {
        this.availableCapacity = builder.availableCapacity;
        this.instanceType = builder.instanceType;
        this.totalCapacity = builder.totalCapacity;
    }

    /**
     * <p>
     * The number of instances that can be launched onto the Dedicated Host based on the host's available capacity.
     * </p>
     * 
     * @return The number of instances that can be launched onto the Dedicated Host based on the host's available
     *         capacity.
     */
    public Integer availableCapacity() {
        return availableCapacity;
    }

    /**
     * <p>
     * The instance type supported by the Dedicated Host.
     * </p>
     * 
     * @return The instance type supported by the Dedicated Host.
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The total number of instances that can be launched onto the Dedicated Host if there are no instances running on
     * it.
     * </p>
     * 
     * @return The total number of instances that can be launched onto the Dedicated Host if there are no instances
     *         running on it.
     */
    public Integer totalCapacity() {
        return totalCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availableCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(totalCapacity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceCapacity)) {
            return false;
        }
        InstanceCapacity other = (InstanceCapacity) obj;
        return Objects.equals(availableCapacity(), other.availableCapacity())
                && Objects.equals(instanceType(), other.instanceType()) && Objects.equals(totalCapacity(), other.totalCapacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InstanceCapacity").add("AvailableCapacity", availableCapacity())
                .add("InstanceType", instanceType()).add("TotalCapacity", totalCapacity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailableCapacity":
            return Optional.ofNullable(clazz.cast(availableCapacity()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "TotalCapacity":
            return Optional.ofNullable(clazz.cast(totalCapacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceCapacity, T> g) {
        return obj -> g.apply((InstanceCapacity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceCapacity> {
        /**
         * <p>
         * The number of instances that can be launched onto the Dedicated Host based on the host's available capacity.
         * </p>
         * 
         * @param availableCapacity
         *        The number of instances that can be launched onto the Dedicated Host based on the host's available
         *        capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableCapacity(Integer availableCapacity);

        /**
         * <p>
         * The instance type supported by the Dedicated Host.
         * </p>
         * 
         * @param instanceType
         *        The instance type supported by the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The total number of instances that can be launched onto the Dedicated Host if there are no instances running
         * on it.
         * </p>
         * 
         * @param totalCapacity
         *        The total number of instances that can be launched onto the Dedicated Host if there are no instances
         *        running on it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCapacity(Integer totalCapacity);
    }

    static final class BuilderImpl implements Builder {
        private Integer availableCapacity;

        private String instanceType;

        private Integer totalCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceCapacity model) {
            availableCapacity(model.availableCapacity);
            instanceType(model.instanceType);
            totalCapacity(model.totalCapacity);
        }

        public final Integer getAvailableCapacity() {
            return availableCapacity;
        }

        @Override
        public final Builder availableCapacity(Integer availableCapacity) {
            this.availableCapacity = availableCapacity;
            return this;
        }

        public final void setAvailableCapacity(Integer availableCapacity) {
            this.availableCapacity = availableCapacity;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Integer getTotalCapacity() {
            return totalCapacity;
        }

        @Override
        public final Builder totalCapacity(Integer totalCapacity) {
            this.totalCapacity = totalCapacity;
            return this;
        }

        public final void setTotalCapacity(Integer totalCapacity) {
            this.totalCapacity = totalCapacity;
        }

        @Override
        public InstanceCapacity build() {
            return new InstanceCapacity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
