/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastGroup;
import software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchTransitGatewayMulticastGroupsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, SearchTransitGatewayMulticastGroupsResponse> {
    private static final SdkField<List<TransitGatewayMulticastGroup>> MULTICAST_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SearchTransitGatewayMulticastGroupsResponse.getter(SearchTransitGatewayMulticastGroupsResponse::multicastGroups)).setter(SearchTransitGatewayMulticastGroupsResponse.setter(Builder::multicastGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MulticastGroups").unmarshallLocationName("multicastGroups").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransitGatewayMulticastGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SearchTransitGatewayMulticastGroupsResponse.getter(SearchTransitGatewayMulticastGroupsResponse::nextToken)).setter(SearchTransitGatewayMulticastGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTICAST_GROUPS_FIELD, NEXT_TOKEN_FIELD));
    private final List<TransitGatewayMulticastGroup> multicastGroups;
    private final String nextToken;

    private SearchTransitGatewayMulticastGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.multicastGroups = builder.multicastGroups;
        this.nextToken = builder.nextToken;
    }

    public boolean hasMulticastGroups() {
        return this.multicastGroups != null && !(this.multicastGroups instanceof SdkAutoConstructList);
    }

    public List<TransitGatewayMulticastGroup> multicastGroups() {
        return this.multicastGroups;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.multicastGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchTransitGatewayMulticastGroupsResponse)) {
            return false;
        }
        SearchTransitGatewayMulticastGroupsResponse other = (SearchTransitGatewayMulticastGroupsResponse)((Object)obj);
        return Objects.equals(this.multicastGroups(), other.multicastGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"SearchTransitGatewayMulticastGroupsResponse").add("MulticastGroups", this.multicastGroups()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MulticastGroups": {
                return Optional.ofNullable(clazz.cast(this.multicastGroups()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchTransitGatewayMulticastGroupsResponse, T> g) {
        return obj -> g.apply((SearchTransitGatewayMulticastGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<TransitGatewayMulticastGroup> multicastGroups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchTransitGatewayMulticastGroupsResponse model) {
            super(model);
            this.multicastGroups(model.multicastGroups);
            this.nextToken(model.nextToken);
        }

        public final Collection<TransitGatewayMulticastGroup.Builder> getMulticastGroups() {
            return this.multicastGroups != null ? (Collection)this.multicastGroups.stream().map(TransitGatewayMulticastGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder multicastGroups(Collection<TransitGatewayMulticastGroup> multicastGroups) {
            this.multicastGroups = TransitGatewayMulticastGroupListCopier.copy(multicastGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multicastGroups(TransitGatewayMulticastGroup ... multicastGroups) {
            this.multicastGroups(Arrays.asList(multicastGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multicastGroups(Consumer<TransitGatewayMulticastGroup.Builder> ... multicastGroups) {
            this.multicastGroups(Stream.of(multicastGroups).map(c -> (TransitGatewayMulticastGroup)((TransitGatewayMulticastGroup.Builder)TransitGatewayMulticastGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMulticastGroups(Collection<TransitGatewayMulticastGroup.BuilderImpl> multicastGroups) {
            this.multicastGroups = TransitGatewayMulticastGroupListCopier.copyFromBuilder(multicastGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public SearchTransitGatewayMulticastGroupsResponse build() {
            return new SearchTransitGatewayMulticastGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchTransitGatewayMulticastGroupsResponse> {
        public Builder multicastGroups(Collection<TransitGatewayMulticastGroup> var1);

        public Builder multicastGroups(TransitGatewayMulticastGroup ... var1);

        public Builder multicastGroups(Consumer<TransitGatewayMulticastGroup.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

