/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output for DescribeReservedInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReservedInstancesResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeReservedInstancesResponse.Builder, DescribeReservedInstancesResponse> {
    private static final SdkField<List<ReservedInstances>> RESERVED_INSTANCES_FIELD = SdkField
            .<List<ReservedInstances>> builder(MarshallingType.LIST)
            .getter(getter(DescribeReservedInstancesResponse::reservedInstances))
            .setter(setter(Builder::reservedInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesSet")
                    .unmarshallLocationName("reservedInstancesSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ReservedInstances> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReservedInstances::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_INSTANCES_FIELD));

    private final List<ReservedInstances> reservedInstances;

    private DescribeReservedInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.reservedInstances = builder.reservedInstances;
    }

    /**
     * Returns true if the ReservedInstances property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasReservedInstances() {
        return reservedInstances != null && !(reservedInstances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Reserved Instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReservedInstances()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of Reserved Instances.
     */
    public List<ReservedInstances> reservedInstances() {
        return reservedInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstances());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesResponse)) {
            return false;
        }
        DescribeReservedInstancesResponse other = (DescribeReservedInstancesResponse) obj;
        return Objects.equals(reservedInstances(), other.reservedInstances());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeReservedInstancesResponse").add("ReservedInstances", reservedInstances()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedInstances":
            return Optional.ofNullable(clazz.cast(reservedInstances()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedInstancesResponse, T> g) {
        return obj -> g.apply((DescribeReservedInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeReservedInstancesResponse> {
        /**
         * <p>
         * A list of Reserved Instances.
         * </p>
         * 
         * @param reservedInstances
         *        A list of Reserved Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstances(Collection<ReservedInstances> reservedInstances);

        /**
         * <p>
         * A list of Reserved Instances.
         * </p>
         * 
         * @param reservedInstances
         *        A list of Reserved Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstances(ReservedInstances... reservedInstances);

        /**
         * <p>
         * A list of Reserved Instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReservedInstances>.Builder} avoiding the
         * need to create one manually via {@link List<ReservedInstances>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReservedInstances>.Builder#build()} is called immediately
         * and its result is passed to {@link #reservedInstances(List<ReservedInstances>)}.
         * 
         * @param reservedInstances
         *        a consumer that will call methods on {@link List<ReservedInstances>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservedInstances(List<ReservedInstances>)
         */
        Builder reservedInstances(Consumer<ReservedInstances.Builder>... reservedInstances);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<ReservedInstances> reservedInstances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesResponse model) {
            super(model);
            reservedInstances(model.reservedInstances);
        }

        public final Collection<ReservedInstances.Builder> getReservedInstances() {
            return reservedInstances != null ? reservedInstances.stream().map(ReservedInstances::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedInstances(Collection<ReservedInstances> reservedInstances) {
            this.reservedInstances = ReservedInstancesListCopier.copy(reservedInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstances(ReservedInstances... reservedInstances) {
            reservedInstances(Arrays.asList(reservedInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstances(Consumer<ReservedInstances.Builder>... reservedInstances) {
            reservedInstances(Stream.of(reservedInstances).map(c -> ReservedInstances.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setReservedInstances(Collection<ReservedInstances.BuilderImpl> reservedInstances) {
            this.reservedInstances = ReservedInstancesListCopier.copyFromBuilder(reservedInstances);
        }

        @Override
        public DescribeReservedInstancesResponse build() {
            return new DescribeReservedInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
