/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.PlacementGroup;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePlacementGroupResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CreatePlacementGroupResponse> {
    private static final SdkField<PlacementGroup> PLACEMENT_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreatePlacementGroupResponse.getter(CreatePlacementGroupResponse::placementGroup)).setter(CreatePlacementGroupResponse.setter(Builder::placementGroup)).constructor(PlacementGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementGroup").unmarshallLocationName("placementGroup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLACEMENT_GROUP_FIELD));
    private final PlacementGroup placementGroup;

    private CreatePlacementGroupResponse(BuilderImpl builder) {
        super(builder);
        this.placementGroup = builder.placementGroup;
    }

    public PlacementGroup placementGroup() {
        return this.placementGroup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.placementGroup());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlacementGroupResponse)) {
            return false;
        }
        CreatePlacementGroupResponse other = (CreatePlacementGroupResponse)((Object)obj);
        return Objects.equals(this.placementGroup(), other.placementGroup());
    }

    public String toString() {
        return ToString.builder((String)"CreatePlacementGroupResponse").add("PlacementGroup", (Object)this.placementGroup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlacementGroup": {
                return Optional.ofNullable(clazz.cast(this.placementGroup()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePlacementGroupResponse, T> g) {
        return obj -> g.apply((CreatePlacementGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private PlacementGroup placementGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlacementGroupResponse model) {
            super(model);
            this.placementGroup(model.placementGroup);
        }

        public final PlacementGroup.Builder getPlacementGroup() {
            return this.placementGroup != null ? this.placementGroup.toBuilder() : null;
        }

        @Override
        public final Builder placementGroup(PlacementGroup placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        public final void setPlacementGroup(PlacementGroup.BuilderImpl placementGroup) {
            this.placementGroup = placementGroup != null ? placementGroup.build() : null;
        }

        @Override
        public CreatePlacementGroupResponse build() {
            return new CreatePlacementGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePlacementGroupResponse> {
        public Builder placementGroup(PlacementGroup var1);

        default public Builder placementGroup(Consumer<PlacementGroup.Builder> placementGroup) {
            return this.placementGroup((PlacementGroup)((PlacementGroup.Builder)PlacementGroup.builder().applyMutation(placementGroup)).build());
        }
    }
}

