/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.UnlimitedSupportedInstanceFamily;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDefaultCreditSpecificationRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, GetDefaultCreditSpecificationRequest> {
    private static final SdkField<String> INSTANCE_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDefaultCreditSpecificationRequest.getter(GetDefaultCreditSpecificationRequest::instanceFamilyAsString)).setter(GetDefaultCreditSpecificationRequest.setter(Builder::instanceFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFamily").unmarshallLocationName("InstanceFamily").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_FAMILY_FIELD));
    private final String instanceFamily;

    private GetDefaultCreditSpecificationRequest(BuilderImpl builder) {
        super(builder);
        this.instanceFamily = builder.instanceFamily;
    }

    public UnlimitedSupportedInstanceFamily instanceFamily() {
        return UnlimitedSupportedInstanceFamily.fromValue(this.instanceFamily);
    }

    public String instanceFamilyAsString() {
        return this.instanceFamily;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceFamilyAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDefaultCreditSpecificationRequest)) {
            return false;
        }
        GetDefaultCreditSpecificationRequest other = (GetDefaultCreditSpecificationRequest)((Object)obj);
        return Objects.equals(this.instanceFamilyAsString(), other.instanceFamilyAsString());
    }

    public String toString() {
        return ToString.builder((String)"GetDefaultCreditSpecificationRequest").add("InstanceFamily", (Object)this.instanceFamilyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceFamily": {
                return Optional.ofNullable(clazz.cast(this.instanceFamilyAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDefaultCreditSpecificationRequest, T> g) {
        return obj -> g.apply((GetDefaultCreditSpecificationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String instanceFamily;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDefaultCreditSpecificationRequest model) {
            super(model);
            this.instanceFamily(model.instanceFamily);
        }

        public final String getInstanceFamily() {
            return this.instanceFamily;
        }

        @Override
        public final Builder instanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        @Override
        public final Builder instanceFamily(UnlimitedSupportedInstanceFamily instanceFamily) {
            this.instanceFamily(instanceFamily == null ? null : instanceFamily.toString());
            return this;
        }

        public final void setInstanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDefaultCreditSpecificationRequest build() {
            return new GetDefaultCreditSpecificationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDefaultCreditSpecificationRequest> {
        public Builder instanceFamily(String var1);

        public Builder instanceFamily(UnlimitedSupportedInstanceFamily var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

