/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteVpcEndpointConnectionNotificationsRequest extends Ec2Request
        implements
        ToCopyableBuilder<DeleteVpcEndpointConnectionNotificationsRequest.Builder, DeleteVpcEndpointConnectionNotificationsRequest> {
    private static final SdkField<List<String>> CONNECTION_NOTIFICATION_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DeleteVpcEndpointConnectionNotificationsRequest::connectionNotificationIds))
            .setter(setter(Builder::connectionNotificationIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionNotificationId")
                    .unmarshallLocationName("ConnectionNotificationId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CONNECTION_NOTIFICATION_IDS_FIELD));

    private final List<String> connectionNotificationIds;

    private DeleteVpcEndpointConnectionNotificationsRequest(BuilderImpl builder) {
        super(builder);
        this.connectionNotificationIds = builder.connectionNotificationIds;
    }

    /**
     * Returns true if the ConnectionNotificationIds property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasConnectionNotificationIds() {
        return connectionNotificationIds != null && !(connectionNotificationIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more notification IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConnectionNotificationIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more notification IDs.
     */
    public List<String> connectionNotificationIds() {
        return connectionNotificationIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectionNotificationIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVpcEndpointConnectionNotificationsRequest)) {
            return false;
        }
        DeleteVpcEndpointConnectionNotificationsRequest other = (DeleteVpcEndpointConnectionNotificationsRequest) obj;
        return Objects.equals(connectionNotificationIds(), other.connectionNotificationIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteVpcEndpointConnectionNotificationsRequest")
                .add("ConnectionNotificationIds", connectionNotificationIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionNotificationIds":
            return Optional.ofNullable(clazz.cast(connectionNotificationIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteVpcEndpointConnectionNotificationsRequest, T> g) {
        return obj -> g.apply((DeleteVpcEndpointConnectionNotificationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteVpcEndpointConnectionNotificationsRequest> {
        /**
         * <p>
         * One or more notification IDs.
         * </p>
         * 
         * @param connectionNotificationIds
         *        One or more notification IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionNotificationIds(Collection<String> connectionNotificationIds);

        /**
         * <p>
         * One or more notification IDs.
         * </p>
         * 
         * @param connectionNotificationIds
         *        One or more notification IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionNotificationIds(String... connectionNotificationIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> connectionNotificationIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVpcEndpointConnectionNotificationsRequest model) {
            super(model);
            connectionNotificationIds(model.connectionNotificationIds);
        }

        public final Collection<String> getConnectionNotificationIds() {
            return connectionNotificationIds;
        }

        @Override
        public final Builder connectionNotificationIds(Collection<String> connectionNotificationIds) {
            this.connectionNotificationIds = ValueStringListCopier.copy(connectionNotificationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionNotificationIds(String... connectionNotificationIds) {
            connectionNotificationIds(Arrays.asList(connectionNotificationIds));
            return this;
        }

        public final void setConnectionNotificationIds(Collection<String> connectionNotificationIds) {
            this.connectionNotificationIds = ValueStringListCopier.copy(connectionNotificationIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteVpcEndpointConnectionNotificationsRequest build() {
            return new DeleteVpcEndpointConnectionNotificationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
