/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableFastSnapshotRestoresRequest extends Ec2Request implements
        ToCopyableBuilder<EnableFastSnapshotRestoresRequest.Builder, EnableFastSnapshotRestoresRequest> {
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(EnableFastSnapshotRestoresRequest::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("AvailabilityZone").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("AvailabilityZone")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("AvailabilityZone").unmarshallLocationName("AvailabilityZone")
                                                    .build()).build()).build()).build();

    private static final SdkField<List<String>> SOURCE_SNAPSHOT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(EnableFastSnapshotRestoresRequest::sourceSnapshotIds))
            .setter(setter(Builder::sourceSnapshotIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSnapshotId")
                    .unmarshallLocationName("SourceSnapshotId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SnapshotId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SnapshotId").unmarshallLocationName("SnapshotId").build())
                                            .build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONES_FIELD,
            SOURCE_SNAPSHOT_IDS_FIELD));

    private final List<String> availabilityZones;

    private final List<String> sourceSnapshotIds;

    private EnableFastSnapshotRestoresRequest(BuilderImpl builder) {
        super(builder);
        this.availabilityZones = builder.availabilityZones;
        this.sourceSnapshotIds = builder.sourceSnapshotIds;
    }

    /**
     * Returns true if the AvailabilityZones property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more Availability Zones. For example, <code>us-east-2a</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAvailabilityZones()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more Availability Zones. For example, <code>us-east-2a</code>.
     */
    public List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * Returns true if the SourceSnapshotIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSourceSnapshotIds() {
        return sourceSnapshotIds != null && !(sourceSnapshotIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of one or more snapshots. For example, <code>snap-1234567890abcdef0</code>. You can specify a snapshot
     * that was shared with you from another AWS account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSourceSnapshotIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of one or more snapshots. For example, <code>snap-1234567890abcdef0</code>. You can specify a
     *         snapshot that was shared with you from another AWS account.
     */
    public List<String> sourceSnapshotIds() {
        return sourceSnapshotIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(sourceSnapshotIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableFastSnapshotRestoresRequest)) {
            return false;
        }
        EnableFastSnapshotRestoresRequest other = (EnableFastSnapshotRestoresRequest) obj;
        return Objects.equals(availabilityZones(), other.availabilityZones())
                && Objects.equals(sourceSnapshotIds(), other.sourceSnapshotIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EnableFastSnapshotRestoresRequest").add("AvailabilityZones", availabilityZones())
                .add("SourceSnapshotIds", sourceSnapshotIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "SourceSnapshotIds":
            return Optional.ofNullable(clazz.cast(sourceSnapshotIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableFastSnapshotRestoresRequest, T> g) {
        return obj -> g.apply((EnableFastSnapshotRestoresRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, EnableFastSnapshotRestoresRequest> {
        /**
         * <p>
         * One or more Availability Zones. For example, <code>us-east-2a</code>.
         * </p>
         * 
         * @param availabilityZones
         *        One or more Availability Zones. For example, <code>us-east-2a</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * One or more Availability Zones. For example, <code>us-east-2a</code>.
         * </p>
         * 
         * @param availabilityZones
         *        One or more Availability Zones. For example, <code>us-east-2a</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * The IDs of one or more snapshots. For example, <code>snap-1234567890abcdef0</code>. You can specify a
         * snapshot that was shared with you from another AWS account.
         * </p>
         * 
         * @param sourceSnapshotIds
         *        The IDs of one or more snapshots. For example, <code>snap-1234567890abcdef0</code>. You can specify a
         *        snapshot that was shared with you from another AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSnapshotIds(Collection<String> sourceSnapshotIds);

        /**
         * <p>
         * The IDs of one or more snapshots. For example, <code>snap-1234567890abcdef0</code>. You can specify a
         * snapshot that was shared with you from another AWS account.
         * </p>
         * 
         * @param sourceSnapshotIds
         *        The IDs of one or more snapshots. For example, <code>snap-1234567890abcdef0</code>. You can specify a
         *        snapshot that was shared with you from another AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSnapshotIds(String... sourceSnapshotIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private List<String> sourceSnapshotIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnableFastSnapshotRestoresRequest model) {
            super(model);
            availabilityZones(model.availabilityZones);
            sourceSnapshotIds(model.sourceSnapshotIds);
        }

        public final Collection<String> getAvailabilityZones() {
            return availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZoneStringListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZoneStringListCopier.copy(availabilityZones);
        }

        public final Collection<String> getSourceSnapshotIds() {
            return sourceSnapshotIds;
        }

        @Override
        public final Builder sourceSnapshotIds(Collection<String> sourceSnapshotIds) {
            this.sourceSnapshotIds = SnapshotIdStringListCopier.copy(sourceSnapshotIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceSnapshotIds(String... sourceSnapshotIds) {
            sourceSnapshotIds(Arrays.asList(sourceSnapshotIds));
            return this;
        }

        public final void setSourceSnapshotIds(Collection<String> sourceSnapshotIds) {
            this.sourceSnapshotIds = SnapshotIdStringListCopier.copy(sourceSnapshotIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableFastSnapshotRestoresRequest build() {
            return new EnableFastSnapshotRestoresRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
