/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the status of an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceStatus implements SdkPojo, Serializable, ToCopyableBuilder<InstanceStatus.Builder, InstanceStatus> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(InstanceStatus::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(InstanceStatus::outpostArn))
            .setter(setter(Builder::outpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn")
                    .unmarshallLocationName("outpostArn").build()).build();

    private static final SdkField<List<InstanceStatusEvent>> EVENTS_FIELD = SdkField
            .<List<InstanceStatusEvent>> builder(MarshallingType.LIST)
            .getter(getter(InstanceStatus::events))
            .setter(setter(Builder::events))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventsSet")
                    .unmarshallLocationName("eventsSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InstanceStatusEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceStatusEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(InstanceStatus::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("instanceId").build()).build();

    private static final SdkField<InstanceState> INSTANCE_STATE_FIELD = SdkField
            .<InstanceState> builder(MarshallingType.SDK_POJO)
            .getter(getter(InstanceStatus::instanceState))
            .setter(setter(Builder::instanceState))
            .constructor(InstanceState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceState")
                    .unmarshallLocationName("instanceState").build()).build();

    private static final SdkField<InstanceStatusSummary> INSTANCE_STATUS_FIELD = SdkField
            .<InstanceStatusSummary> builder(MarshallingType.SDK_POJO)
            .getter(getter(InstanceStatus::instanceStatus))
            .setter(setter(Builder::instanceStatus))
            .constructor(InstanceStatusSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceStatus")
                    .unmarshallLocationName("instanceStatus").build()).build();

    private static final SdkField<InstanceStatusSummary> SYSTEM_STATUS_FIELD = SdkField
            .<InstanceStatusSummary> builder(MarshallingType.SDK_POJO)
            .getter(getter(InstanceStatus::systemStatus))
            .setter(setter(Builder::systemStatus))
            .constructor(InstanceStatusSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SystemStatus")
                    .unmarshallLocationName("systemStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD, OUTPOST_ARN_FIELD, EVENTS_FIELD, INSTANCE_ID_FIELD,
                    INSTANCE_STATE_FIELD, INSTANCE_STATUS_FIELD, SYSTEM_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String availabilityZone;

    private final String outpostArn;

    private final List<InstanceStatusEvent> events;

    private final String instanceId;

    private final InstanceState instanceState;

    private final InstanceStatusSummary instanceStatus;

    private final InstanceStatusSummary systemStatus;

    private InstanceStatus(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.outpostArn = builder.outpostArn;
        this.events = builder.events;
        this.instanceId = builder.instanceId;
        this.instanceState = builder.instanceState;
        this.instanceStatus = builder.instanceStatus;
        this.systemStatus = builder.systemStatus;
    }

    /**
     * <p>
     * The Availability Zone of the instance.
     * </p>
     * 
     * @return The Availability Zone of the instance.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Outpost.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Outpost.
     */
    public String outpostArn() {
        return outpostArn;
    }

    /**
     * Returns true if the Events property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEvents() {
        return events != null && !(events instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any scheduled events associated with the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEvents()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Any scheduled events associated with the instance.
     */
    public List<InstanceStatusEvent> events() {
        return events;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The intended state of the instance. <a>DescribeInstanceStatus</a> requires that an instance be in the
     * <code>running</code> state.
     * </p>
     * 
     * @return The intended state of the instance. <a>DescribeInstanceStatus</a> requires that an instance be in the
     *         <code>running</code> state.
     */
    public InstanceState instanceState() {
        return instanceState;
    }

    /**
     * <p>
     * Reports impaired functionality that stems from issues internal to the instance, such as impaired reachability.
     * </p>
     * 
     * @return Reports impaired functionality that stems from issues internal to the instance, such as impaired
     *         reachability.
     */
    public InstanceStatusSummary instanceStatus() {
        return instanceStatus;
    }

    /**
     * <p>
     * Reports impaired functionality that stems from issues related to the systems that support an instance, such as
     * hardware failures and network connectivity problems.
     * </p>
     * 
     * @return Reports impaired functionality that stems from issues related to the systems that support an instance,
     *         such as hardware failures and network connectivity problems.
     */
    public InstanceStatusSummary systemStatus() {
        return systemStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(events());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceState());
        hashCode = 31 * hashCode + Objects.hashCode(instanceStatus());
        hashCode = 31 * hashCode + Objects.hashCode(systemStatus());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStatus)) {
            return false;
        }
        InstanceStatus other = (InstanceStatus) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(outpostArn(), other.outpostArn())
                && Objects.equals(events(), other.events()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(instanceState(), other.instanceState())
                && Objects.equals(instanceStatus(), other.instanceStatus())
                && Objects.equals(systemStatus(), other.systemStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InstanceStatus").add("AvailabilityZone", availabilityZone()).add("OutpostArn", outpostArn())
                .add("Events", events()).add("InstanceId", instanceId()).add("InstanceState", instanceState())
                .add("InstanceStatus", instanceStatus()).add("SystemStatus", systemStatus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "OutpostArn":
            return Optional.ofNullable(clazz.cast(outpostArn()));
        case "Events":
            return Optional.ofNullable(clazz.cast(events()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "InstanceState":
            return Optional.ofNullable(clazz.cast(instanceState()));
        case "InstanceStatus":
            return Optional.ofNullable(clazz.cast(instanceStatus()));
        case "SystemStatus":
            return Optional.ofNullable(clazz.cast(systemStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceStatus, T> g) {
        return obj -> g.apply((InstanceStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceStatus> {
        /**
         * <p>
         * The Availability Zone of the instance.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Outpost.
         * </p>
         * 
         * @param outpostArn
         *        The Amazon Resource Name (ARN) of the Outpost.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostArn(String outpostArn);

        /**
         * <p>
         * Any scheduled events associated with the instance.
         * </p>
         * 
         * @param events
         *        Any scheduled events associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<InstanceStatusEvent> events);

        /**
         * <p>
         * Any scheduled events associated with the instance.
         * </p>
         * 
         * @param events
         *        Any scheduled events associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(InstanceStatusEvent... events);

        /**
         * <p>
         * Any scheduled events associated with the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceStatusEvent>.Builder} avoiding the
         * need to create one manually via {@link List<InstanceStatusEvent>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceStatusEvent>.Builder#build()} is called immediately
         * and its result is passed to {@link #events(List<InstanceStatusEvent>)}.
         * 
         * @param events
         *        a consumer that will call methods on {@link List<InstanceStatusEvent>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #events(List<InstanceStatusEvent>)
         */
        Builder events(Consumer<InstanceStatusEvent.Builder>... events);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The intended state of the instance. <a>DescribeInstanceStatus</a> requires that an instance be in the
         * <code>running</code> state.
         * </p>
         * 
         * @param instanceState
         *        The intended state of the instance. <a>DescribeInstanceStatus</a> requires that an instance be in the
         *        <code>running</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceState(InstanceState instanceState);

        /**
         * <p>
         * The intended state of the instance. <a>DescribeInstanceStatus</a> requires that an instance be in the
         * <code>running</code> state.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceState.Builder} avoiding the need to
         * create one manually via {@link InstanceState#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceState.Builder#build()} is called immediately and its
         * result is passed to {@link #instanceState(InstanceState)}.
         * 
         * @param instanceState
         *        a consumer that will call methods on {@link InstanceState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceState(InstanceState)
         */
        default Builder instanceState(Consumer<InstanceState.Builder> instanceState) {
            return instanceState(InstanceState.builder().applyMutation(instanceState).build());
        }

        /**
         * <p>
         * Reports impaired functionality that stems from issues internal to the instance, such as impaired
         * reachability.
         * </p>
         * 
         * @param instanceStatus
         *        Reports impaired functionality that stems from issues internal to the instance, such as impaired
         *        reachability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceStatus(InstanceStatusSummary instanceStatus);

        /**
         * <p>
         * Reports impaired functionality that stems from issues internal to the instance, such as impaired
         * reachability.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceStatusSummary.Builder} avoiding the need
         * to create one manually via {@link InstanceStatusSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceStatusSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceStatus(InstanceStatusSummary)}.
         * 
         * @param instanceStatus
         *        a consumer that will call methods on {@link InstanceStatusSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceStatus(InstanceStatusSummary)
         */
        default Builder instanceStatus(Consumer<InstanceStatusSummary.Builder> instanceStatus) {
            return instanceStatus(InstanceStatusSummary.builder().applyMutation(instanceStatus).build());
        }

        /**
         * <p>
         * Reports impaired functionality that stems from issues related to the systems that support an instance, such
         * as hardware failures and network connectivity problems.
         * </p>
         * 
         * @param systemStatus
         *        Reports impaired functionality that stems from issues related to the systems that support an instance,
         *        such as hardware failures and network connectivity problems.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemStatus(InstanceStatusSummary systemStatus);

        /**
         * <p>
         * Reports impaired functionality that stems from issues related to the systems that support an instance, such
         * as hardware failures and network connectivity problems.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceStatusSummary.Builder} avoiding the need
         * to create one manually via {@link InstanceStatusSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceStatusSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #systemStatus(InstanceStatusSummary)}.
         * 
         * @param systemStatus
         *        a consumer that will call methods on {@link InstanceStatusSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #systemStatus(InstanceStatusSummary)
         */
        default Builder systemStatus(Consumer<InstanceStatusSummary.Builder> systemStatus) {
            return systemStatus(InstanceStatusSummary.builder().applyMutation(systemStatus).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private String outpostArn;

        private List<InstanceStatusEvent> events = DefaultSdkAutoConstructList.getInstance();

        private String instanceId;

        private InstanceState instanceState;

        private InstanceStatusSummary instanceStatus;

        private InstanceStatusSummary systemStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceStatus model) {
            availabilityZone(model.availabilityZone);
            outpostArn(model.outpostArn);
            events(model.events);
            instanceId(model.instanceId);
            instanceState(model.instanceState);
            instanceStatus(model.instanceStatus);
            systemStatus(model.systemStatus);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getOutpostArn() {
            return outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        public final Collection<InstanceStatusEvent.Builder> getEvents() {
            return events != null ? events.stream().map(InstanceStatusEvent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder events(Collection<InstanceStatusEvent> events) {
            this.events = InstanceStatusEventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(InstanceStatusEvent... events) {
            events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<InstanceStatusEvent.Builder>... events) {
            events(Stream.of(events).map(c -> InstanceStatusEvent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEvents(Collection<InstanceStatusEvent.BuilderImpl> events) {
            this.events = InstanceStatusEventListCopier.copyFromBuilder(events);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final InstanceState.Builder getInstanceState() {
            return instanceState != null ? instanceState.toBuilder() : null;
        }

        @Override
        public final Builder instanceState(InstanceState instanceState) {
            this.instanceState = instanceState;
            return this;
        }

        public final void setInstanceState(InstanceState.BuilderImpl instanceState) {
            this.instanceState = instanceState != null ? instanceState.build() : null;
        }

        public final InstanceStatusSummary.Builder getInstanceStatus() {
            return instanceStatus != null ? instanceStatus.toBuilder() : null;
        }

        @Override
        public final Builder instanceStatus(InstanceStatusSummary instanceStatus) {
            this.instanceStatus = instanceStatus;
            return this;
        }

        public final void setInstanceStatus(InstanceStatusSummary.BuilderImpl instanceStatus) {
            this.instanceStatus = instanceStatus != null ? instanceStatus.build() : null;
        }

        public final InstanceStatusSummary.Builder getSystemStatus() {
            return systemStatus != null ? systemStatus.toBuilder() : null;
        }

        @Override
        public final Builder systemStatus(InstanceStatusSummary systemStatus) {
            this.systemStatus = systemStatus;
            return this;
        }

        public final void setSystemStatus(InstanceStatusSummary.BuilderImpl systemStatus) {
            this.systemStatus = systemStatus != null ? systemStatus.build() : null;
        }

        @Override
        public InstanceStatus build() {
            return new InstanceStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
