/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyVpcEndpointServiceConfigurationRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyVpcEndpointServiceConfigurationRequest.Builder, ModifyVpcEndpointServiceConfigurationRequest> {
    private static final SdkField<String> SERVICE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyVpcEndpointServiceConfigurationRequest::serviceId))
            .setter(setter(Builder::serviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId")
                    .unmarshallLocationName("ServiceId").build()).build();

    private static final SdkField<String> PRIVATE_DNS_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyVpcEndpointServiceConfigurationRequest::privateDnsName))
            .setter(setter(Builder::privateDnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsName")
                    .unmarshallLocationName("PrivateDnsName").build()).build();

    private static final SdkField<Boolean> REMOVE_PRIVATE_DNS_NAME_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ModifyVpcEndpointServiceConfigurationRequest::removePrivateDnsName))
            .setter(setter(Builder::removePrivateDnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemovePrivateDnsName")
                    .unmarshallLocationName("RemovePrivateDnsName").build()).build();

    private static final SdkField<Boolean> ACCEPTANCE_REQUIRED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ModifyVpcEndpointServiceConfigurationRequest::acceptanceRequired))
            .setter(setter(Builder::acceptanceRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptanceRequired")
                    .unmarshallLocationName("AcceptanceRequired").build()).build();

    private static final SdkField<List<String>> ADD_NETWORK_LOAD_BALANCER_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ModifyVpcEndpointServiceConfigurationRequest::addNetworkLoadBalancerArns))
            .setter(setter(Builder::addNetworkLoadBalancerArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddNetworkLoadBalancerArn")
                    .unmarshallLocationName("AddNetworkLoadBalancerArn").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> REMOVE_NETWORK_LOAD_BALANCER_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ModifyVpcEndpointServiceConfigurationRequest::removeNetworkLoadBalancerArns))
            .setter(setter(Builder::removeNetworkLoadBalancerArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveNetworkLoadBalancerArn")
                    .unmarshallLocationName("RemoveNetworkLoadBalancerArn").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ID_FIELD,
            PRIVATE_DNS_NAME_FIELD, REMOVE_PRIVATE_DNS_NAME_FIELD, ACCEPTANCE_REQUIRED_FIELD,
            ADD_NETWORK_LOAD_BALANCER_ARNS_FIELD, REMOVE_NETWORK_LOAD_BALANCER_ARNS_FIELD));

    private final String serviceId;

    private final String privateDnsName;

    private final Boolean removePrivateDnsName;

    private final Boolean acceptanceRequired;

    private final List<String> addNetworkLoadBalancerArns;

    private final List<String> removeNetworkLoadBalancerArns;

    private ModifyVpcEndpointServiceConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.serviceId = builder.serviceId;
        this.privateDnsName = builder.privateDnsName;
        this.removePrivateDnsName = builder.removePrivateDnsName;
        this.acceptanceRequired = builder.acceptanceRequired;
        this.addNetworkLoadBalancerArns = builder.addNetworkLoadBalancerArns;
        this.removeNetworkLoadBalancerArns = builder.removeNetworkLoadBalancerArns;
    }

    /**
     * <p>
     * The ID of the service.
     * </p>
     * 
     * @return The ID of the service.
     */
    public String serviceId() {
        return serviceId;
    }

    /**
     * <p>
     * The private DNS name to assign to the endpoint service.
     * </p>
     * 
     * @return The private DNS name to assign to the endpoint service.
     */
    public String privateDnsName() {
        return privateDnsName;
    }

    /**
     * <p>
     * Removes the private DNS name of the endpoint service.
     * </p>
     * 
     * @return Removes the private DNS name of the endpoint service.
     */
    public Boolean removePrivateDnsName() {
        return removePrivateDnsName;
    }

    /**
     * <p>
     * Indicates whether requests to create an endpoint to your service must be accepted.
     * </p>
     * 
     * @return Indicates whether requests to create an endpoint to your service must be accepted.
     */
    public Boolean acceptanceRequired() {
        return acceptanceRequired;
    }

    /**
     * Returns true if the AddNetworkLoadBalancerArns property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasAddNetworkLoadBalancerArns() {
        return addNetworkLoadBalancerArns != null && !(addNetworkLoadBalancerArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of Network Load Balancers to add to your service configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAddNetworkLoadBalancerArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of Network Load Balancers to add to your service configuration.
     */
    public List<String> addNetworkLoadBalancerArns() {
        return addNetworkLoadBalancerArns;
    }

    /**
     * Returns true if the RemoveNetworkLoadBalancerArns property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasRemoveNetworkLoadBalancerArns() {
        return removeNetworkLoadBalancerArns != null && !(removeNetworkLoadBalancerArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of Network Load Balancers to remove from your service configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRemoveNetworkLoadBalancerArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of Network Load Balancers to remove from your service configuration.
     */
    public List<String> removeNetworkLoadBalancerArns() {
        return removeNetworkLoadBalancerArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(removePrivateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(acceptanceRequired());
        hashCode = 31 * hashCode + Objects.hashCode(addNetworkLoadBalancerArns());
        hashCode = 31 * hashCode + Objects.hashCode(removeNetworkLoadBalancerArns());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcEndpointServiceConfigurationRequest)) {
            return false;
        }
        ModifyVpcEndpointServiceConfigurationRequest other = (ModifyVpcEndpointServiceConfigurationRequest) obj;
        return Objects.equals(serviceId(), other.serviceId()) && Objects.equals(privateDnsName(), other.privateDnsName())
                && Objects.equals(removePrivateDnsName(), other.removePrivateDnsName())
                && Objects.equals(acceptanceRequired(), other.acceptanceRequired())
                && Objects.equals(addNetworkLoadBalancerArns(), other.addNetworkLoadBalancerArns())
                && Objects.equals(removeNetworkLoadBalancerArns(), other.removeNetworkLoadBalancerArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyVpcEndpointServiceConfigurationRequest").add("ServiceId", serviceId())
                .add("PrivateDnsName", privateDnsName()).add("RemovePrivateDnsName", removePrivateDnsName())
                .add("AcceptanceRequired", acceptanceRequired()).add("AddNetworkLoadBalancerArns", addNetworkLoadBalancerArns())
                .add("RemoveNetworkLoadBalancerArns", removeNetworkLoadBalancerArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceId":
            return Optional.ofNullable(clazz.cast(serviceId()));
        case "PrivateDnsName":
            return Optional.ofNullable(clazz.cast(privateDnsName()));
        case "RemovePrivateDnsName":
            return Optional.ofNullable(clazz.cast(removePrivateDnsName()));
        case "AcceptanceRequired":
            return Optional.ofNullable(clazz.cast(acceptanceRequired()));
        case "AddNetworkLoadBalancerArns":
            return Optional.ofNullable(clazz.cast(addNetworkLoadBalancerArns()));
        case "RemoveNetworkLoadBalancerArns":
            return Optional.ofNullable(clazz.cast(removeNetworkLoadBalancerArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpcEndpointServiceConfigurationRequest, T> g) {
        return obj -> g.apply((ModifyVpcEndpointServiceConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyVpcEndpointServiceConfigurationRequest> {
        /**
         * <p>
         * The ID of the service.
         * </p>
         * 
         * @param serviceId
         *        The ID of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceId(String serviceId);

        /**
         * <p>
         * The private DNS name to assign to the endpoint service.
         * </p>
         * 
         * @param privateDnsName
         *        The private DNS name to assign to the endpoint service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsName(String privateDnsName);

        /**
         * <p>
         * Removes the private DNS name of the endpoint service.
         * </p>
         * 
         * @param removePrivateDnsName
         *        Removes the private DNS name of the endpoint service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removePrivateDnsName(Boolean removePrivateDnsName);

        /**
         * <p>
         * Indicates whether requests to create an endpoint to your service must be accepted.
         * </p>
         * 
         * @param acceptanceRequired
         *        Indicates whether requests to create an endpoint to your service must be accepted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptanceRequired(Boolean acceptanceRequired);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of Network Load Balancers to add to your service configuration.
         * </p>
         * 
         * @param addNetworkLoadBalancerArns
         *        The Amazon Resource Names (ARNs) of Network Load Balancers to add to your service configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addNetworkLoadBalancerArns(Collection<String> addNetworkLoadBalancerArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of Network Load Balancers to add to your service configuration.
         * </p>
         * 
         * @param addNetworkLoadBalancerArns
         *        The Amazon Resource Names (ARNs) of Network Load Balancers to add to your service configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addNetworkLoadBalancerArns(String... addNetworkLoadBalancerArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of Network Load Balancers to remove from your service configuration.
         * </p>
         * 
         * @param removeNetworkLoadBalancerArns
         *        The Amazon Resource Names (ARNs) of Network Load Balancers to remove from your service configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeNetworkLoadBalancerArns(Collection<String> removeNetworkLoadBalancerArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of Network Load Balancers to remove from your service configuration.
         * </p>
         * 
         * @param removeNetworkLoadBalancerArns
         *        The Amazon Resource Names (ARNs) of Network Load Balancers to remove from your service configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeNetworkLoadBalancerArns(String... removeNetworkLoadBalancerArns);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String serviceId;

        private String privateDnsName;

        private Boolean removePrivateDnsName;

        private Boolean acceptanceRequired;

        private List<String> addNetworkLoadBalancerArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> removeNetworkLoadBalancerArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcEndpointServiceConfigurationRequest model) {
            super(model);
            serviceId(model.serviceId);
            privateDnsName(model.privateDnsName);
            removePrivateDnsName(model.removePrivateDnsName);
            acceptanceRequired(model.acceptanceRequired);
            addNetworkLoadBalancerArns(model.addNetworkLoadBalancerArns);
            removeNetworkLoadBalancerArns(model.removeNetworkLoadBalancerArns);
        }

        public final String getServiceId() {
            return serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public final String getPrivateDnsName() {
            return privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        public final Boolean getRemovePrivateDnsName() {
            return removePrivateDnsName;
        }

        @Override
        public final Builder removePrivateDnsName(Boolean removePrivateDnsName) {
            this.removePrivateDnsName = removePrivateDnsName;
            return this;
        }

        public final void setRemovePrivateDnsName(Boolean removePrivateDnsName) {
            this.removePrivateDnsName = removePrivateDnsName;
        }

        public final Boolean getAcceptanceRequired() {
            return acceptanceRequired;
        }

        @Override
        public final Builder acceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
            return this;
        }

        public final void setAcceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
        }

        public final Collection<String> getAddNetworkLoadBalancerArns() {
            return addNetworkLoadBalancerArns;
        }

        @Override
        public final Builder addNetworkLoadBalancerArns(Collection<String> addNetworkLoadBalancerArns) {
            this.addNetworkLoadBalancerArns = ValueStringListCopier.copy(addNetworkLoadBalancerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addNetworkLoadBalancerArns(String... addNetworkLoadBalancerArns) {
            addNetworkLoadBalancerArns(Arrays.asList(addNetworkLoadBalancerArns));
            return this;
        }

        public final void setAddNetworkLoadBalancerArns(Collection<String> addNetworkLoadBalancerArns) {
            this.addNetworkLoadBalancerArns = ValueStringListCopier.copy(addNetworkLoadBalancerArns);
        }

        public final Collection<String> getRemoveNetworkLoadBalancerArns() {
            return removeNetworkLoadBalancerArns;
        }

        @Override
        public final Builder removeNetworkLoadBalancerArns(Collection<String> removeNetworkLoadBalancerArns) {
            this.removeNetworkLoadBalancerArns = ValueStringListCopier.copy(removeNetworkLoadBalancerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeNetworkLoadBalancerArns(String... removeNetworkLoadBalancerArns) {
            removeNetworkLoadBalancerArns(Arrays.asList(removeNetworkLoadBalancerArns));
            return this;
        }

        public final void setRemoveNetworkLoadBalancerArns(Collection<String> removeNetworkLoadBalancerArns) {
            this.removeNetworkLoadBalancerArns = ValueStringListCopier.copy(removeNetworkLoadBalancerArns);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpcEndpointServiceConfigurationRequest build() {
            return new ModifyVpcEndpointServiceConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
