/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a range of ports.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PortRange implements SdkPojo, Serializable, ToCopyableBuilder<PortRange.Builder, PortRange> {
    private static final SdkField<Integer> FROM_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(PortRange::from))
            .setter(setter(Builder::from))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("From")
                    .unmarshallLocationName("from").build()).build();

    private static final SdkField<Integer> TO_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(PortRange::to))
            .setter(setter(Builder::to))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("To").unmarshallLocationName("to")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_FIELD, TO_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer from;

    private final Integer to;

    private PortRange(BuilderImpl builder) {
        this.from = builder.from;
        this.to = builder.to;
    }

    /**
     * <p>
     * The first port in the range.
     * </p>
     * 
     * @return The first port in the range.
     */
    public Integer from() {
        return from;
    }

    /**
     * <p>
     * The last port in the range.
     * </p>
     * 
     * @return The last port in the range.
     */
    public Integer to() {
        return to;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(from());
        hashCode = 31 * hashCode + Objects.hashCode(to());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortRange)) {
            return false;
        }
        PortRange other = (PortRange) obj;
        return Objects.equals(from(), other.from()) && Objects.equals(to(), other.to());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PortRange").add("From", from()).add("To", to()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "From":
            return Optional.ofNullable(clazz.cast(from()));
        case "To":
            return Optional.ofNullable(clazz.cast(to()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PortRange, T> g) {
        return obj -> g.apply((PortRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PortRange> {
        /**
         * <p>
         * The first port in the range.
         * </p>
         * 
         * @param from
         *        The first port in the range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder from(Integer from);

        /**
         * <p>
         * The last port in the range.
         * </p>
         * 
         * @param to
         *        The last port in the range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder to(Integer to);
    }

    static final class BuilderImpl implements Builder {
        private Integer from;

        private Integer to;

        private BuilderImpl() {
        }

        private BuilderImpl(PortRange model) {
            from(model.from);
            to(model.to);
        }

        public final Integer getFrom() {
            return from;
        }

        @Override
        public final Builder from(Integer from) {
            this.from = from;
            return this;
        }

        public final void setFrom(Integer from) {
            this.from = from;
        }

        public final Integer getTo() {
            return to;
        }

        @Override
        public final Builder to(Integer to) {
            this.to = to;
            return this;
        }

        public final void setTo(Integer to) {
            this.to = to;
        }

        @Override
        public PortRange build() {
            return new PortRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
