/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.protocols.query.AwsEc2ProtocolFactory;
import software.amazon.awssdk.services.ec2.model.AcceptReservedInstancesExchangeQuoteRequest;
import software.amazon.awssdk.services.ec2.model.AcceptReservedInstancesExchangeQuoteResponse;
import software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayPeeringAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayPeeringAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayVpcAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayVpcAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.AcceptVpcEndpointConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.AcceptVpcEndpointConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.ec2.model.AdvertiseByoipCidrRequest;
import software.amazon.awssdk.services.ec2.model.AdvertiseByoipCidrResponse;
import software.amazon.awssdk.services.ec2.model.AllocateAddressRequest;
import software.amazon.awssdk.services.ec2.model.AllocateAddressResponse;
import software.amazon.awssdk.services.ec2.model.AllocateHostsRequest;
import software.amazon.awssdk.services.ec2.model.AllocateHostsResponse;
import software.amazon.awssdk.services.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkRequest;
import software.amazon.awssdk.services.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkResponse;
import software.amazon.awssdk.services.ec2.model.AssignIpv6AddressesRequest;
import software.amazon.awssdk.services.ec2.model.AssignIpv6AddressesResponse;
import software.amazon.awssdk.services.ec2.model.AssignPrivateIpAddressesRequest;
import software.amazon.awssdk.services.ec2.model.AssignPrivateIpAddressesResponse;
import software.amazon.awssdk.services.ec2.model.AssociateAddressRequest;
import software.amazon.awssdk.services.ec2.model.AssociateAddressResponse;
import software.amazon.awssdk.services.ec2.model.AssociateClientVpnTargetNetworkRequest;
import software.amazon.awssdk.services.ec2.model.AssociateClientVpnTargetNetworkResponse;
import software.amazon.awssdk.services.ec2.model.AssociateDhcpOptionsRequest;
import software.amazon.awssdk.services.ec2.model.AssociateDhcpOptionsResponse;
import software.amazon.awssdk.services.ec2.model.AssociateIamInstanceProfileRequest;
import software.amazon.awssdk.services.ec2.model.AssociateIamInstanceProfileResponse;
import software.amazon.awssdk.services.ec2.model.AssociateRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.AssociateRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.AssociateSubnetCidrBlockRequest;
import software.amazon.awssdk.services.ec2.model.AssociateSubnetCidrBlockResponse;
import software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayMulticastDomainRequest;
import software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayMulticastDomainResponse;
import software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.AssociateVpcCidrBlockRequest;
import software.amazon.awssdk.services.ec2.model.AssociateVpcCidrBlockResponse;
import software.amazon.awssdk.services.ec2.model.AttachClassicLinkVpcRequest;
import software.amazon.awssdk.services.ec2.model.AttachClassicLinkVpcResponse;
import software.amazon.awssdk.services.ec2.model.AttachInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.AttachInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.AttachVolumeRequest;
import software.amazon.awssdk.services.ec2.model.AttachVolumeResponse;
import software.amazon.awssdk.services.ec2.model.AttachVpnGatewayRequest;
import software.amazon.awssdk.services.ec2.model.AttachVpnGatewayResponse;
import software.amazon.awssdk.services.ec2.model.AuthorizeClientVpnIngressRequest;
import software.amazon.awssdk.services.ec2.model.AuthorizeClientVpnIngressResponse;
import software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupEgressRequest;
import software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupEgressResponse;
import software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupIngressRequest;
import software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupIngressResponse;
import software.amazon.awssdk.services.ec2.model.BundleInstanceRequest;
import software.amazon.awssdk.services.ec2.model.BundleInstanceResponse;
import software.amazon.awssdk.services.ec2.model.CancelBundleTaskRequest;
import software.amazon.awssdk.services.ec2.model.CancelBundleTaskResponse;
import software.amazon.awssdk.services.ec2.model.CancelCapacityReservationRequest;
import software.amazon.awssdk.services.ec2.model.CancelCapacityReservationResponse;
import software.amazon.awssdk.services.ec2.model.CancelConversionTaskRequest;
import software.amazon.awssdk.services.ec2.model.CancelConversionTaskResponse;
import software.amazon.awssdk.services.ec2.model.CancelExportTaskRequest;
import software.amazon.awssdk.services.ec2.model.CancelExportTaskResponse;
import software.amazon.awssdk.services.ec2.model.CancelImportTaskRequest;
import software.amazon.awssdk.services.ec2.model.CancelImportTaskResponse;
import software.amazon.awssdk.services.ec2.model.CancelReservedInstancesListingRequest;
import software.amazon.awssdk.services.ec2.model.CancelReservedInstancesListingResponse;
import software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsRequest;
import software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsResponse;
import software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestsRequest;
import software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestsResponse;
import software.amazon.awssdk.services.ec2.model.ConfirmProductInstanceRequest;
import software.amazon.awssdk.services.ec2.model.ConfirmProductInstanceResponse;
import software.amazon.awssdk.services.ec2.model.CopyFpgaImageRequest;
import software.amazon.awssdk.services.ec2.model.CopyFpgaImageResponse;
import software.amazon.awssdk.services.ec2.model.CopyImageRequest;
import software.amazon.awssdk.services.ec2.model.CopyImageResponse;
import software.amazon.awssdk.services.ec2.model.CopySnapshotRequest;
import software.amazon.awssdk.services.ec2.model.CopySnapshotResponse;
import software.amazon.awssdk.services.ec2.model.CreateCapacityReservationRequest;
import software.amazon.awssdk.services.ec2.model.CreateCapacityReservationResponse;
import software.amazon.awssdk.services.ec2.model.CreateClientVpnEndpointRequest;
import software.amazon.awssdk.services.ec2.model.CreateClientVpnEndpointResponse;
import software.amazon.awssdk.services.ec2.model.CreateClientVpnRouteRequest;
import software.amazon.awssdk.services.ec2.model.CreateClientVpnRouteResponse;
import software.amazon.awssdk.services.ec2.model.CreateCustomerGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateCustomerGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateDefaultSubnetRequest;
import software.amazon.awssdk.services.ec2.model.CreateDefaultSubnetResponse;
import software.amazon.awssdk.services.ec2.model.CreateDefaultVpcRequest;
import software.amazon.awssdk.services.ec2.model.CreateDefaultVpcResponse;
import software.amazon.awssdk.services.ec2.model.CreateDhcpOptionsRequest;
import software.amazon.awssdk.services.ec2.model.CreateDhcpOptionsResponse;
import software.amazon.awssdk.services.ec2.model.CreateEgressOnlyInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateEgressOnlyInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateFleetRequest;
import software.amazon.awssdk.services.ec2.model.CreateFleetResponse;
import software.amazon.awssdk.services.ec2.model.CreateFlowLogsRequest;
import software.amazon.awssdk.services.ec2.model.CreateFlowLogsResponse;
import software.amazon.awssdk.services.ec2.model.CreateFpgaImageRequest;
import software.amazon.awssdk.services.ec2.model.CreateFpgaImageResponse;
import software.amazon.awssdk.services.ec2.model.CreateImageRequest;
import software.amazon.awssdk.services.ec2.model.CreateImageResponse;
import software.amazon.awssdk.services.ec2.model.CreateInstanceExportTaskRequest;
import software.amazon.awssdk.services.ec2.model.CreateInstanceExportTaskResponse;
import software.amazon.awssdk.services.ec2.model.CreateInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateKeyPairRequest;
import software.amazon.awssdk.services.ec2.model.CreateKeyPairResponse;
import software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateRequest;
import software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateResponse;
import software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateVersionRequest;
import software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateVersionResponse;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteRequest;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteResponse;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVpcAssociationRequest;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVpcAssociationResponse;
import software.amazon.awssdk.services.ec2.model.CreateNatGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateNatGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateNetworkAclEntryRequest;
import software.amazon.awssdk.services.ec2.model.CreateNetworkAclEntryResponse;
import software.amazon.awssdk.services.ec2.model.CreateNetworkAclRequest;
import software.amazon.awssdk.services.ec2.model.CreateNetworkAclResponse;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInterfacePermissionRequest;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInterfacePermissionResponse;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.CreatePlacementGroupRequest;
import software.amazon.awssdk.services.ec2.model.CreatePlacementGroupResponse;
import software.amazon.awssdk.services.ec2.model.CreateReservedInstancesListingRequest;
import software.amazon.awssdk.services.ec2.model.CreateReservedInstancesListingResponse;
import software.amazon.awssdk.services.ec2.model.CreateRouteRequest;
import software.amazon.awssdk.services.ec2.model.CreateRouteResponse;
import software.amazon.awssdk.services.ec2.model.CreateRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.CreateRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.CreateSecurityGroupRequest;
import software.amazon.awssdk.services.ec2.model.CreateSecurityGroupResponse;
import software.amazon.awssdk.services.ec2.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.ec2.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.ec2.model.CreateSnapshotsRequest;
import software.amazon.awssdk.services.ec2.model.CreateSnapshotsResponse;
import software.amazon.awssdk.services.ec2.model.CreateSpotDatafeedSubscriptionRequest;
import software.amazon.awssdk.services.ec2.model.CreateSpotDatafeedSubscriptionResponse;
import software.amazon.awssdk.services.ec2.model.CreateSubnetRequest;
import software.amazon.awssdk.services.ec2.model.CreateSubnetResponse;
import software.amazon.awssdk.services.ec2.model.CreateTagsRequest;
import software.amazon.awssdk.services.ec2.model.CreateTagsResponse;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterRequest;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterResponse;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterRuleRequest;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterRuleResponse;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorSessionRequest;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorSessionResponse;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorTargetRequest;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorTargetResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayMulticastDomainRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayMulticastDomainResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPeeringAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPeeringAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayVpcAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayVpcAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.CreateVolumeRequest;
import software.amazon.awssdk.services.ec2.model.CreateVolumeResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointConnectionNotificationRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointConnectionNotificationResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointServiceConfigurationRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointServiceConfigurationResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpcRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpcResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpnConnectionResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRouteRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRouteResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpnGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpnGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteClientVpnEndpointRequest;
import software.amazon.awssdk.services.ec2.model.DeleteClientVpnEndpointResponse;
import software.amazon.awssdk.services.ec2.model.DeleteClientVpnRouteRequest;
import software.amazon.awssdk.services.ec2.model.DeleteClientVpnRouteResponse;
import software.amazon.awssdk.services.ec2.model.DeleteCustomerGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteCustomerGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteDhcpOptionsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteDhcpOptionsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteEgressOnlyInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteEgressOnlyInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteFleetsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteFleetsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteFlowLogsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteFlowLogsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteFpgaImageRequest;
import software.amazon.awssdk.services.ec2.model.DeleteFpgaImageResponse;
import software.amazon.awssdk.services.ec2.model.DeleteInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteKeyPairRequest;
import software.amazon.awssdk.services.ec2.model.DeleteKeyPairResponse;
import software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateRequest;
import software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateResponse;
import software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteRequest;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteResponse;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableVpcAssociationRequest;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableVpcAssociationResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNatGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNatGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkAclEntryRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkAclEntryResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkAclRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkAclResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfacePermissionRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfacePermissionResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.DeletePlacementGroupRequest;
import software.amazon.awssdk.services.ec2.model.DeletePlacementGroupResponse;
import software.amazon.awssdk.services.ec2.model.DeleteQueuedReservedInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DeleteQueuedReservedInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DeleteRouteRequest;
import software.amazon.awssdk.services.ec2.model.DeleteRouteResponse;
import software.amazon.awssdk.services.ec2.model.DeleteRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.DeleteRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.DeleteSecurityGroupRequest;
import software.amazon.awssdk.services.ec2.model.DeleteSecurityGroupResponse;
import software.amazon.awssdk.services.ec2.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.ec2.model.DeleteSnapshotResponse;
import software.amazon.awssdk.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest;
import software.amazon.awssdk.services.ec2.model.DeleteSpotDatafeedSubscriptionResponse;
import software.amazon.awssdk.services.ec2.model.DeleteSubnetRequest;
import software.amazon.awssdk.services.ec2.model.DeleteSubnetResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTagsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTagsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRuleRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRuleResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorSessionRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorSessionResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorTargetRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorTargetResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayMulticastDomainRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayMulticastDomainResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPeeringAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPeeringAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayVpcAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayVpcAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVolumeRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVolumeResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointConnectionNotificationsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointConnectionNotificationsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointServiceConfigurationsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointServiceConfigurationsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpcRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpcResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionRouteRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionRouteResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpnGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpnGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeprovisionByoipCidrRequest;
import software.amazon.awssdk.services.ec2.model.DeprovisionByoipCidrResponse;
import software.amazon.awssdk.services.ec2.model.DeregisterImageRequest;
import software.amazon.awssdk.services.ec2.model.DeregisterImageResponse;
import software.amazon.awssdk.services.ec2.model.DeregisterInstanceEventNotificationAttributesRequest;
import software.amazon.awssdk.services.ec2.model.DeregisterInstanceEventNotificationAttributesResponse;
import software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupMembersRequest;
import software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupMembersResponse;
import software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesRequest;
import software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeAddressesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAddressesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeAggregateIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAggregateIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.DescribeAvailabilityZonesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAvailabilityZonesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeBundleTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeBundleTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeClassicLinkInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClassicLinkInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnAuthorizationRulesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnAuthorizationRulesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnEndpointsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnRoutesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnRoutesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnTargetNetworksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnTargetNetworksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCoipPoolsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCoipPoolsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeConversionTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeConversionTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeDhcpOptionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeDhcpOptionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeElasticGpusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeElasticGpusResponse;
import software.amazon.awssdk.services.ec2.model.DescribeExportImageTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeExportImageTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeExportTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeExportTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFastSnapshotRestoresRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFastSnapshotRestoresResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFleetHistoryRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFleetHistoryResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFleetInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFleetInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFleetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFleetsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFlowLogsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFlowLogsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFpgaImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFpgaImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationOfferingsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeHostsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeHostsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIdentityIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIdentityIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.DescribeImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImagesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceCreditSpecificationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceCreditSpecificationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceEventNotificationAttributesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceEventNotificationAttributesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypeOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypeOfferingsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIpv6PoolsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpv6PoolsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeKeyPairsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeKeyPairsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTablesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTablesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfacesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfacesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfaceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfaceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacePermissionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacePermissionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesResponse;
import software.amazon.awssdk.services.ec2.model.DescribePlacementGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribePlacementGroupsResponse;
import software.amazon.awssdk.services.ec2.model.DescribePrefixListsRequest;
import software.amazon.awssdk.services.ec2.model.DescribePrefixListsResponse;
import software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.DescribePublicIpv4PoolsRequest;
import software.amazon.awssdk.services.ec2.model.DescribePublicIpv4PoolsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeRegionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeRegionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesListingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesListingsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeRouteTablesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeRouteTablesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstanceAvailabilityRequest;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstanceAvailabilityResponse;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupReferencesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupReferencesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotDatafeedSubscriptionRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotDatafeedSubscriptionResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestHistoryRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestHistoryResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryResponse;
import software.amazon.awssdk.services.ec2.model.DescribeStaleSecurityGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeStaleSecurityGroupsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSubnetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSubnetsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTagsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTagsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorFiltersRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorFiltersResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorSessionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorSessionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorTargetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorTargetsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayAttachmentsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayAttachmentsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayMulticastDomainsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayMulticastDomainsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPeeringAttachmentsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPeeringAttachmentsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayRouteTablesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayRouteTablesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayVpcAttachmentsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayVpcAttachmentsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesModificationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesModificationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkDnsSupportRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkDnsSupportResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionNotificationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServiceConfigurationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServiceConfigurationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpnGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpnGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DetachClassicLinkVpcRequest;
import software.amazon.awssdk.services.ec2.model.DetachClassicLinkVpcResponse;
import software.amazon.awssdk.services.ec2.model.DetachInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DetachInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DetachNetworkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.DetachNetworkInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.DetachVolumeRequest;
import software.amazon.awssdk.services.ec2.model.DetachVolumeResponse;
import software.amazon.awssdk.services.ec2.model.DetachVpnGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DetachVpnGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DisableEbsEncryptionByDefaultRequest;
import software.amazon.awssdk.services.ec2.model.DisableEbsEncryptionByDefaultResponse;
import software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoresRequest;
import software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoresResponse;
import software.amazon.awssdk.services.ec2.model.DisableTransitGatewayRouteTablePropagationRequest;
import software.amazon.awssdk.services.ec2.model.DisableTransitGatewayRouteTablePropagationResponse;
import software.amazon.awssdk.services.ec2.model.DisableVgwRoutePropagationRequest;
import software.amazon.awssdk.services.ec2.model.DisableVgwRoutePropagationResponse;
import software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkDnsSupportRequest;
import software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkDnsSupportResponse;
import software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkRequest;
import software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateAddressRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateAddressResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateClientVpnTargetNetworkRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateClientVpnTargetNetworkResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateIamInstanceProfileRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateIamInstanceProfileResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateSubnetCidrBlockRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateSubnetCidrBlockResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayMulticastDomainRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayMulticastDomainResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateVpcCidrBlockRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateVpcCidrBlockResponse;
import software.amazon.awssdk.services.ec2.model.Ec2Exception;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.EnableEbsEncryptionByDefaultRequest;
import software.amazon.awssdk.services.ec2.model.EnableEbsEncryptionByDefaultResponse;
import software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoresRequest;
import software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoresResponse;
import software.amazon.awssdk.services.ec2.model.EnableTransitGatewayRouteTablePropagationRequest;
import software.amazon.awssdk.services.ec2.model.EnableTransitGatewayRouteTablePropagationResponse;
import software.amazon.awssdk.services.ec2.model.EnableVgwRoutePropagationRequest;
import software.amazon.awssdk.services.ec2.model.EnableVgwRoutePropagationResponse;
import software.amazon.awssdk.services.ec2.model.EnableVolumeIoRequest;
import software.amazon.awssdk.services.ec2.model.EnableVolumeIoResponse;
import software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkDnsSupportRequest;
import software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkDnsSupportResponse;
import software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkRequest;
import software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkResponse;
import software.amazon.awssdk.services.ec2.model.ExportClientVpnClientCertificateRevocationListRequest;
import software.amazon.awssdk.services.ec2.model.ExportClientVpnClientCertificateRevocationListResponse;
import software.amazon.awssdk.services.ec2.model.ExportClientVpnClientConfigurationRequest;
import software.amazon.awssdk.services.ec2.model.ExportClientVpnClientConfigurationResponse;
import software.amazon.awssdk.services.ec2.model.ExportImageRequest;
import software.amazon.awssdk.services.ec2.model.ExportImageResponse;
import software.amazon.awssdk.services.ec2.model.ExportTransitGatewayRoutesRequest;
import software.amazon.awssdk.services.ec2.model.ExportTransitGatewayRoutesResponse;
import software.amazon.awssdk.services.ec2.model.GetAssociatedIpv6PoolCidrsRequest;
import software.amazon.awssdk.services.ec2.model.GetAssociatedIpv6PoolCidrsResponse;
import software.amazon.awssdk.services.ec2.model.GetCapacityReservationUsageRequest;
import software.amazon.awssdk.services.ec2.model.GetCapacityReservationUsageResponse;
import software.amazon.awssdk.services.ec2.model.GetCoipPoolUsageRequest;
import software.amazon.awssdk.services.ec2.model.GetCoipPoolUsageResponse;
import software.amazon.awssdk.services.ec2.model.GetConsoleOutputRequest;
import software.amazon.awssdk.services.ec2.model.GetConsoleOutputResponse;
import software.amazon.awssdk.services.ec2.model.GetConsoleScreenshotRequest;
import software.amazon.awssdk.services.ec2.model.GetConsoleScreenshotResponse;
import software.amazon.awssdk.services.ec2.model.GetDefaultCreditSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.GetDefaultCreditSpecificationResponse;
import software.amazon.awssdk.services.ec2.model.GetEbsDefaultKmsKeyIdRequest;
import software.amazon.awssdk.services.ec2.model.GetEbsDefaultKmsKeyIdResponse;
import software.amazon.awssdk.services.ec2.model.GetEbsEncryptionByDefaultRequest;
import software.amazon.awssdk.services.ec2.model.GetEbsEncryptionByDefaultResponse;
import software.amazon.awssdk.services.ec2.model.GetHostReservationPurchasePreviewRequest;
import software.amazon.awssdk.services.ec2.model.GetHostReservationPurchasePreviewResponse;
import software.amazon.awssdk.services.ec2.model.GetLaunchTemplateDataRequest;
import software.amazon.awssdk.services.ec2.model.GetLaunchTemplateDataResponse;
import software.amazon.awssdk.services.ec2.model.GetPasswordDataRequest;
import software.amazon.awssdk.services.ec2.model.GetPasswordDataResponse;
import software.amazon.awssdk.services.ec2.model.GetReservedInstancesExchangeQuoteRequest;
import software.amazon.awssdk.services.ec2.model.GetReservedInstancesExchangeQuoteResponse;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayAttachmentPropagationsRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayAttachmentPropagationsResponse;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayMulticastDomainAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayMulticastDomainAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayRouteTableAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayRouteTableAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayRouteTablePropagationsRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayRouteTablePropagationsResponse;
import software.amazon.awssdk.services.ec2.model.ImportClientVpnClientCertificateRevocationListRequest;
import software.amazon.awssdk.services.ec2.model.ImportClientVpnClientCertificateRevocationListResponse;
import software.amazon.awssdk.services.ec2.model.ImportImageRequest;
import software.amazon.awssdk.services.ec2.model.ImportImageResponse;
import software.amazon.awssdk.services.ec2.model.ImportInstanceRequest;
import software.amazon.awssdk.services.ec2.model.ImportInstanceResponse;
import software.amazon.awssdk.services.ec2.model.ImportKeyPairRequest;
import software.amazon.awssdk.services.ec2.model.ImportKeyPairResponse;
import software.amazon.awssdk.services.ec2.model.ImportSnapshotRequest;
import software.amazon.awssdk.services.ec2.model.ImportSnapshotResponse;
import software.amazon.awssdk.services.ec2.model.ImportVolumeRequest;
import software.amazon.awssdk.services.ec2.model.ImportVolumeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyAvailabilityZoneGroupRequest;
import software.amazon.awssdk.services.ec2.model.ModifyAvailabilityZoneGroupResponse;
import software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationRequest;
import software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationResponse;
import software.amazon.awssdk.services.ec2.model.ModifyClientVpnEndpointRequest;
import software.amazon.awssdk.services.ec2.model.ModifyClientVpnEndpointResponse;
import software.amazon.awssdk.services.ec2.model.ModifyDefaultCreditSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.ModifyDefaultCreditSpecificationResponse;
import software.amazon.awssdk.services.ec2.model.ModifyEbsDefaultKmsKeyIdRequest;
import software.amazon.awssdk.services.ec2.model.ModifyEbsDefaultKmsKeyIdResponse;
import software.amazon.awssdk.services.ec2.model.ModifyFleetRequest;
import software.amazon.awssdk.services.ec2.model.ModifyFleetResponse;
import software.amazon.awssdk.services.ec2.model.ModifyFpgaImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyFpgaImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyHostsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyHostsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.ModifyIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.ModifyIdentityIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.ModifyIdentityIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.ModifyImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceCapacityReservationAttributesRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceCapacityReservationAttributesResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceCreditSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceCreditSpecificationResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceEventStartTimeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceEventStartTimeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceMetadataOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceMetadataOptionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstancePlacementRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstancePlacementResponse;
import software.amazon.awssdk.services.ec2.model.ModifyLaunchTemplateRequest;
import software.amazon.awssdk.services.ec2.model.ModifyLaunchTemplateResponse;
import software.amazon.awssdk.services.ec2.model.ModifyNetworkInterfaceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyNetworkInterfaceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyReservedInstancesRequest;
import software.amazon.awssdk.services.ec2.model.ModifyReservedInstancesResponse;
import software.amazon.awssdk.services.ec2.model.ModifySnapshotAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifySnapshotAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifySpotFleetRequestRequest;
import software.amazon.awssdk.services.ec2.model.ModifySpotFleetRequestResponse;
import software.amazon.awssdk.services.ec2.model.ModifySubnetAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifySubnetAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterNetworkServicesRequest;
import software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterNetworkServicesResponse;
import software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterRuleRequest;
import software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterRuleResponse;
import software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorSessionRequest;
import software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorSessionResponse;
import software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayVpcAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayVpcAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVolumeAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVolumeAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVolumeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVolumeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointConnectionNotificationRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointConnectionNotificationResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServiceConfigurationRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServiceConfigurationResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePermissionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePermissionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcPeeringConnectionOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcPeeringConnectionOptionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcTenancyRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcTenancyResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelCertificateRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelCertificateResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelOptionsResponse;
import software.amazon.awssdk.services.ec2.model.MonitorInstancesRequest;
import software.amazon.awssdk.services.ec2.model.MonitorInstancesResponse;
import software.amazon.awssdk.services.ec2.model.MoveAddressToVpcRequest;
import software.amazon.awssdk.services.ec2.model.MoveAddressToVpcResponse;
import software.amazon.awssdk.services.ec2.model.ProvisionByoipCidrRequest;
import software.amazon.awssdk.services.ec2.model.ProvisionByoipCidrResponse;
import software.amazon.awssdk.services.ec2.model.PurchaseHostReservationRequest;
import software.amazon.awssdk.services.ec2.model.PurchaseHostReservationResponse;
import software.amazon.awssdk.services.ec2.model.PurchaseReservedInstancesOfferingRequest;
import software.amazon.awssdk.services.ec2.model.PurchaseReservedInstancesOfferingResponse;
import software.amazon.awssdk.services.ec2.model.PurchaseScheduledInstancesRequest;
import software.amazon.awssdk.services.ec2.model.PurchaseScheduledInstancesResponse;
import software.amazon.awssdk.services.ec2.model.RebootInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RebootInstancesResponse;
import software.amazon.awssdk.services.ec2.model.RegisterImageRequest;
import software.amazon.awssdk.services.ec2.model.RegisterImageResponse;
import software.amazon.awssdk.services.ec2.model.RegisterInstanceEventNotificationAttributesRequest;
import software.amazon.awssdk.services.ec2.model.RegisterInstanceEventNotificationAttributesResponse;
import software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupMembersRequest;
import software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupMembersResponse;
import software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupSourcesRequest;
import software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupSourcesResponse;
import software.amazon.awssdk.services.ec2.model.RejectTransitGatewayPeeringAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.RejectTransitGatewayPeeringAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.RejectTransitGatewayVpcAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.RejectTransitGatewayVpcAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.RejectVpcEndpointConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.RejectVpcEndpointConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.RejectVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.ec2.model.RejectVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.ec2.model.ReleaseAddressRequest;
import software.amazon.awssdk.services.ec2.model.ReleaseAddressResponse;
import software.amazon.awssdk.services.ec2.model.ReleaseHostsRequest;
import software.amazon.awssdk.services.ec2.model.ReleaseHostsResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceIamInstanceProfileAssociationRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceIamInstanceProfileAssociationResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclAssociationRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclAssociationResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclEntryRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclEntryResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceRouteRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceRouteResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceRouteTableAssociationRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceRouteTableAssociationResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceTransitGatewayRouteRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceTransitGatewayRouteResponse;
import software.amazon.awssdk.services.ec2.model.ReportInstanceStatusRequest;
import software.amazon.awssdk.services.ec2.model.ReportInstanceStatusResponse;
import software.amazon.awssdk.services.ec2.model.RequestSpotFleetRequest;
import software.amazon.awssdk.services.ec2.model.RequestSpotFleetResponse;
import software.amazon.awssdk.services.ec2.model.RequestSpotInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RequestSpotInstancesResponse;
import software.amazon.awssdk.services.ec2.model.ResetEbsDefaultKmsKeyIdRequest;
import software.amazon.awssdk.services.ec2.model.ResetEbsDefaultKmsKeyIdResponse;
import software.amazon.awssdk.services.ec2.model.ResetFpgaImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetFpgaImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ResetImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ResetInstanceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetInstanceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ResetNetworkInterfaceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetNetworkInterfaceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ResetSnapshotAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetSnapshotAttributeResponse;
import software.amazon.awssdk.services.ec2.model.RestoreAddressToClassicRequest;
import software.amazon.awssdk.services.ec2.model.RestoreAddressToClassicResponse;
import software.amazon.awssdk.services.ec2.model.RevokeClientVpnIngressRequest;
import software.amazon.awssdk.services.ec2.model.RevokeClientVpnIngressResponse;
import software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupEgressRequest;
import software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupEgressResponse;
import software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupIngressRequest;
import software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupIngressResponse;
import software.amazon.awssdk.services.ec2.model.RunInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RunInstancesResponse;
import software.amazon.awssdk.services.ec2.model.RunScheduledInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RunScheduledInstancesResponse;
import software.amazon.awssdk.services.ec2.model.SearchLocalGatewayRoutesRequest;
import software.amazon.awssdk.services.ec2.model.SearchLocalGatewayRoutesResponse;
import software.amazon.awssdk.services.ec2.model.SearchTransitGatewayMulticastGroupsRequest;
import software.amazon.awssdk.services.ec2.model.SearchTransitGatewayMulticastGroupsResponse;
import software.amazon.awssdk.services.ec2.model.SearchTransitGatewayRoutesRequest;
import software.amazon.awssdk.services.ec2.model.SearchTransitGatewayRoutesResponse;
import software.amazon.awssdk.services.ec2.model.SendDiagnosticInterruptRequest;
import software.amazon.awssdk.services.ec2.model.SendDiagnosticInterruptResponse;
import software.amazon.awssdk.services.ec2.model.StartInstancesRequest;
import software.amazon.awssdk.services.ec2.model.StartInstancesResponse;
import software.amazon.awssdk.services.ec2.model.StartVpcEndpointServicePrivateDnsVerificationRequest;
import software.amazon.awssdk.services.ec2.model.StartVpcEndpointServicePrivateDnsVerificationResponse;
import software.amazon.awssdk.services.ec2.model.StopInstancesRequest;
import software.amazon.awssdk.services.ec2.model.StopInstancesResponse;
import software.amazon.awssdk.services.ec2.model.TerminateClientVpnConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.TerminateClientVpnConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.TerminateInstancesRequest;
import software.amazon.awssdk.services.ec2.model.TerminateInstancesResponse;
import software.amazon.awssdk.services.ec2.model.UnassignIpv6AddressesRequest;
import software.amazon.awssdk.services.ec2.model.UnassignIpv6AddressesResponse;
import software.amazon.awssdk.services.ec2.model.UnassignPrivateIpAddressesRequest;
import software.amazon.awssdk.services.ec2.model.UnassignPrivateIpAddressesResponse;
import software.amazon.awssdk.services.ec2.model.UnmonitorInstancesRequest;
import software.amazon.awssdk.services.ec2.model.UnmonitorInstancesResponse;
import software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressRequest;
import software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressResponse;
import software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsIngressRequest;
import software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsIngressResponse;
import software.amazon.awssdk.services.ec2.model.WithdrawByoipCidrRequest;
import software.amazon.awssdk.services.ec2.model.WithdrawByoipCidrResponse;
import software.amazon.awssdk.services.ec2.paginators.DescribeByoipCidrsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeCapacityReservationsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeClassicLinkInstancesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeClientVpnAuthorizationRulesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeClientVpnConnectionsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeClientVpnEndpointsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeClientVpnRoutesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeClientVpnTargetNetworksPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeCoipPoolsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeDhcpOptionsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeEgressOnlyInternetGatewaysPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeExportImageTasksPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeFastSnapshotRestoresPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeFleetsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeFlowLogsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeFpgaImagesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeHostReservationOfferingsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeHostReservationsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeHostsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeIamInstanceProfileAssociationsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeImportImageTasksPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeImportSnapshotTasksPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeInstanceCreditSpecificationsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeInstanceStatusPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeInstanceTypeOfferingsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeInstanceTypesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeInstancesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeInternetGatewaysPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeIpv6PoolsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeLaunchTemplateVersionsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeLaunchTemplatesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeLocalGatewayRouteTableVpcAssociationsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeLocalGatewayRouteTablesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeLocalGatewayVirtualInterfaceGroupsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeLocalGatewayVirtualInterfacesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeLocalGatewaysPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeMovingAddressesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeNatGatewaysPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeNetworkAclsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeNetworkInterfacePermissionsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeNetworkInterfacesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribePrefixListsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribePrincipalIdFormatPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribePublicIpv4PoolsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeReservedInstancesModificationsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeReservedInstancesOfferingsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeRouteTablesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeScheduledInstanceAvailabilityPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeScheduledInstancesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeSecurityGroupsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeSnapshotsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeSpotFleetRequestsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeSpotInstanceRequestsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeSpotPriceHistoryPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeStaleSecurityGroupsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeSubnetsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeTagsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeTrafficMirrorFiltersPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeTrafficMirrorSessionsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeTrafficMirrorTargetsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeTransitGatewayAttachmentsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeTransitGatewayMulticastDomainsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeTransitGatewayPeeringAttachmentsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeTransitGatewayRouteTablesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeTransitGatewayVpcAttachmentsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeTransitGatewaysPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeVolumeStatusPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeVolumesModificationsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeVolumesPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeVpcClassicLinkDnsSupportPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeVpcEndpointConnectionNotificationsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeVpcEndpointConnectionsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeVpcEndpointServiceConfigurationsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeVpcEndpointServicePermissionsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeVpcEndpointsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeVpcPeeringConnectionsPublisher;
import software.amazon.awssdk.services.ec2.paginators.DescribeVpcsPublisher;
import software.amazon.awssdk.services.ec2.paginators.GetAssociatedIpv6PoolCidrsPublisher;
import software.amazon.awssdk.services.ec2.paginators.GetTransitGatewayAttachmentPropagationsPublisher;
import software.amazon.awssdk.services.ec2.paginators.GetTransitGatewayMulticastDomainAssociationsPublisher;
import software.amazon.awssdk.services.ec2.paginators.GetTransitGatewayRouteTableAssociationsPublisher;
import software.amazon.awssdk.services.ec2.paginators.GetTransitGatewayRouteTablePropagationsPublisher;
import software.amazon.awssdk.services.ec2.paginators.SearchLocalGatewayRoutesPublisher;
import software.amazon.awssdk.services.ec2.paginators.SearchTransitGatewayMulticastGroupsPublisher;
import software.amazon.awssdk.services.ec2.transform.AcceptReservedInstancesExchangeQuoteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AcceptTransitGatewayPeeringAttachmentRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AcceptTransitGatewayVpcAttachmentRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AcceptVpcEndpointConnectionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AcceptVpcPeeringConnectionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AdvertiseByoipCidrRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AllocateAddressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AllocateHostsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ApplySecurityGroupsToClientVpnTargetNetworkRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssignIpv6AddressesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssignPrivateIpAddressesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateAddressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateClientVpnTargetNetworkRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateDhcpOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateIamInstanceProfileRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateRouteTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateSubnetCidrBlockRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateTransitGatewayMulticastDomainRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateTransitGatewayRouteTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateVpcCidrBlockRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AttachClassicLinkVpcRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AttachInternetGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AttachNetworkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AttachVolumeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AttachVpnGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AuthorizeClientVpnIngressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AuthorizeSecurityGroupEgressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AuthorizeSecurityGroupIngressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.BundleInstanceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelBundleTaskRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelConversionTaskRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelExportTaskRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelImportTaskRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelReservedInstancesListingRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelSpotFleetRequestsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelSpotInstanceRequestsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ConfirmProductInstanceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CopyFpgaImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CopyImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CopySnapshotRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateClientVpnEndpointRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateClientVpnRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateCustomerGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateDefaultSubnetRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateDefaultVpcRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateDhcpOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateEgressOnlyInternetGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateFleetRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateFlowLogsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateFpgaImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateInstanceExportTaskRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateInternetGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateKeyPairRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateLaunchTemplateRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateLaunchTemplateVersionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateLocalGatewayRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateLocalGatewayRouteTableVpcAssociationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateNatGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateNetworkAclEntryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateNetworkAclRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateNetworkInterfacePermissionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateNetworkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreatePlacementGroupRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateReservedInstancesListingRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateRouteTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateSpotDatafeedSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateSubnetRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTagsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTrafficMirrorFilterRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTrafficMirrorFilterRuleRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTrafficMirrorSessionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTrafficMirrorTargetRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTransitGatewayMulticastDomainRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTransitGatewayPeeringAttachmentRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTransitGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTransitGatewayRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTransitGatewayRouteTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTransitGatewayVpcAttachmentRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVolumeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpcEndpointConnectionNotificationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpcEndpointRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpcEndpointServiceConfigurationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpcPeeringConnectionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpcRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpnConnectionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpnConnectionRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpnGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteClientVpnEndpointRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteClientVpnRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteCustomerGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteDhcpOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteEgressOnlyInternetGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteFleetsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteFlowLogsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteFpgaImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteInternetGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteKeyPairRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteLaunchTemplateRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteLaunchTemplateVersionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteLocalGatewayRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteLocalGatewayRouteTableVpcAssociationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteNatGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteNetworkAclEntryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteNetworkAclRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteNetworkInterfacePermissionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteNetworkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeletePlacementGroupRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteQueuedReservedInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteRouteTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteSnapshotRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteSpotDatafeedSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteSubnetRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTrafficMirrorFilterRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTrafficMirrorFilterRuleRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTrafficMirrorSessionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTrafficMirrorTargetRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTransitGatewayMulticastDomainRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTransitGatewayPeeringAttachmentRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTransitGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTransitGatewayRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTransitGatewayRouteTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTransitGatewayVpcAttachmentRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVolumeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpcEndpointConnectionNotificationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpcEndpointServiceConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpcEndpointsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpcPeeringConnectionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpcRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpnConnectionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpnConnectionRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpnGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeprovisionByoipCidrRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeregisterImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeregisterInstanceEventNotificationAttributesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeregisterTransitGatewayMulticastGroupMembersRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeregisterTransitGatewayMulticastGroupSourcesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeAccountAttributesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeAddressesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeAggregateIdFormatRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeAvailabilityZonesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeBundleTasksRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeByoipCidrsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeCapacityReservationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeClassicLinkInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeClientVpnAuthorizationRulesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeClientVpnConnectionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeClientVpnEndpointsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeClientVpnRoutesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeClientVpnTargetNetworksRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeCoipPoolsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeConversionTasksRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeCustomerGatewaysRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeDhcpOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeEgressOnlyInternetGatewaysRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeElasticGpusRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeExportImageTasksRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeExportTasksRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeFastSnapshotRestoresRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeFleetHistoryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeFleetInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeFleetsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeFlowLogsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeFpgaImageAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeFpgaImagesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeHostReservationOfferingsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeHostReservationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeHostsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeIamInstanceProfileAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeIdFormatRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeIdentityIdFormatRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeImageAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeImagesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeImportImageTasksRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeImportSnapshotTasksRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstanceAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstanceCreditSpecificationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstanceEventNotificationAttributesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstanceStatusRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstanceTypeOfferingsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstanceTypesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInternetGatewaysRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeIpv6PoolsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeKeyPairsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeLaunchTemplateVersionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeLaunchTemplatesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeLocalGatewayRouteTableVpcAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeLocalGatewayRouteTablesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeLocalGatewayVirtualInterfaceGroupsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeLocalGatewayVirtualInterfacesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeLocalGatewaysRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeMovingAddressesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeNatGatewaysRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeNetworkAclsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeNetworkInterfaceAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeNetworkInterfacePermissionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeNetworkInterfacesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribePlacementGroupsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribePrefixListsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribePrincipalIdFormatRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribePublicIpv4PoolsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeRegionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeReservedInstancesListingsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeReservedInstancesModificationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeReservedInstancesOfferingsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeReservedInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeRouteTablesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeScheduledInstanceAvailabilityRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeScheduledInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSecurityGroupReferencesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSnapshotAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSpotDatafeedSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSpotFleetInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSpotFleetRequestHistoryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSpotFleetRequestsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSpotInstanceRequestsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSpotPriceHistoryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeStaleSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSubnetsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTrafficMirrorFiltersRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTrafficMirrorSessionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTrafficMirrorTargetsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTransitGatewayAttachmentsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTransitGatewayMulticastDomainsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTransitGatewayPeeringAttachmentsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTransitGatewayRouteTablesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTransitGatewayVpcAttachmentsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTransitGatewaysRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVolumeAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVolumeStatusRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVolumesModificationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVolumesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcClassicLinkDnsSupportRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcClassicLinkRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcEndpointConnectionNotificationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcEndpointConnectionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcEndpointServiceConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcEndpointServicePermissionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcEndpointServicesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcEndpointsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcPeeringConnectionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpnConnectionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpnGatewaysRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DetachClassicLinkVpcRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DetachInternetGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DetachNetworkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DetachVolumeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DetachVpnGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableEbsEncryptionByDefaultRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableFastSnapshotRestoresRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableTransitGatewayRouteTablePropagationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableVgwRoutePropagationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableVpcClassicLinkDnsSupportRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableVpcClassicLinkRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateAddressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateClientVpnTargetNetworkRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateIamInstanceProfileRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateRouteTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateSubnetCidrBlockRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateTransitGatewayMulticastDomainRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateTransitGatewayRouteTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateVpcCidrBlockRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableEbsEncryptionByDefaultRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableFastSnapshotRestoresRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableTransitGatewayRouteTablePropagationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableVgwRoutePropagationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableVolumeIoRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableVpcClassicLinkDnsSupportRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableVpcClassicLinkRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ExportClientVpnClientCertificateRevocationListRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ExportClientVpnClientConfigurationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ExportImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ExportTransitGatewayRoutesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetAssociatedIpv6PoolCidrsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetCapacityReservationUsageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetCoipPoolUsageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetConsoleOutputRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetConsoleScreenshotRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetDefaultCreditSpecificationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetEbsDefaultKmsKeyIdRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetEbsEncryptionByDefaultRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetHostReservationPurchasePreviewRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetLaunchTemplateDataRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetPasswordDataRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetReservedInstancesExchangeQuoteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetTransitGatewayAttachmentPropagationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetTransitGatewayMulticastDomainAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetTransitGatewayRouteTableAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetTransitGatewayRouteTablePropagationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ImportClientVpnClientCertificateRevocationListRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ImportImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ImportInstanceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ImportKeyPairRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ImportSnapshotRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ImportVolumeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyAvailabilityZoneGroupRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyClientVpnEndpointRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyDefaultCreditSpecificationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyEbsDefaultKmsKeyIdRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyFleetRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyFpgaImageAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyHostsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyIdFormatRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyIdentityIdFormatRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyImageAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyInstanceAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyInstanceCapacityReservationAttributesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyInstanceCreditSpecificationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyInstanceEventStartTimeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyInstanceMetadataOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyInstancePlacementRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyLaunchTemplateRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyNetworkInterfaceAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyReservedInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifySnapshotAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifySpotFleetRequestRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifySubnetAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyTrafficMirrorFilterNetworkServicesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyTrafficMirrorFilterRuleRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyTrafficMirrorSessionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyTransitGatewayVpcAttachmentRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVolumeAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVolumeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpcAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpcEndpointConnectionNotificationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpcEndpointRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpcEndpointServiceConfigurationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpcEndpointServicePermissionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpcPeeringConnectionOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpcTenancyRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpnConnectionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpnTunnelCertificateRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpnTunnelOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.MonitorInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.MoveAddressToVpcRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ProvisionByoipCidrRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.PurchaseHostReservationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.PurchaseReservedInstancesOfferingRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.PurchaseScheduledInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RebootInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RegisterImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RegisterInstanceEventNotificationAttributesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RegisterTransitGatewayMulticastGroupMembersRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RegisterTransitGatewayMulticastGroupSourcesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RejectTransitGatewayPeeringAttachmentRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RejectTransitGatewayVpcAttachmentRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RejectVpcEndpointConnectionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RejectVpcPeeringConnectionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReleaseAddressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReleaseHostsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReplaceIamInstanceProfileAssociationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReplaceNetworkAclAssociationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReplaceNetworkAclEntryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReplaceRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReplaceRouteTableAssociationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReplaceTransitGatewayRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReportInstanceStatusRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RequestSpotFleetRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RequestSpotInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ResetEbsDefaultKmsKeyIdRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ResetFpgaImageAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ResetImageAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ResetInstanceAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ResetNetworkInterfaceAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ResetSnapshotAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RestoreAddressToClassicRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RevokeClientVpnIngressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RevokeSecurityGroupEgressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RevokeSecurityGroupIngressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RunInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RunScheduledInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.SearchLocalGatewayRoutesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.SearchTransitGatewayMulticastGroupsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.SearchTransitGatewayRoutesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.SendDiagnosticInterruptRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.StartInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.StartVpcEndpointServicePrivateDnsVerificationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.StopInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.TerminateClientVpnConnectionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.TerminateInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.UnassignIpv6AddressesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.UnassignPrivateIpAddressesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.UnmonitorInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.UpdateSecurityGroupRuleDescriptionsEgressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.UpdateSecurityGroupRuleDescriptionsIngressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.WithdrawByoipCidrRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link Ec2AsyncClient}.
 *
 * @see Ec2AsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultEc2AsyncClient implements Ec2AsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultEc2AsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsEc2ProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultEc2AsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Accepts the Convertible Reserved Instance exchange quote described in the
     * <a>GetReservedInstancesExchangeQuote</a> call.
     * </p>
     *
     * @param acceptReservedInstancesExchangeQuoteRequest
     *        Contains the parameters for accepting the quote.
     * @return A Java Future containing the result of the AcceptReservedInstancesExchangeQuote operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AcceptReservedInstancesExchangeQuote
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptReservedInstancesExchangeQuote"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AcceptReservedInstancesExchangeQuoteResponse> acceptReservedInstancesExchangeQuote(
            AcceptReservedInstancesExchangeQuoteRequest acceptReservedInstancesExchangeQuoteRequest) {
        try {

            HttpResponseHandler<AcceptReservedInstancesExchangeQuoteResponse> responseHandler = protocolFactory
                    .createResponseHandler(AcceptReservedInstancesExchangeQuoteResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AcceptReservedInstancesExchangeQuoteResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AcceptReservedInstancesExchangeQuoteRequest, AcceptReservedInstancesExchangeQuoteResponse>()
                            .withOperationName("AcceptReservedInstancesExchangeQuote")
                            .withMarshaller(new AcceptReservedInstancesExchangeQuoteRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(acceptReservedInstancesExchangeQuoteRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Accepts a transit gateway peering attachment request. The peering attachment must be in the
     * <code>pendingAcceptance</code> state.
     * </p>
     *
     * @param acceptTransitGatewayPeeringAttachmentRequest
     * @return A Java Future containing the result of the AcceptTransitGatewayPeeringAttachment operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AcceptTransitGatewayPeeringAttachment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayPeeringAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AcceptTransitGatewayPeeringAttachmentResponse> acceptTransitGatewayPeeringAttachment(
            AcceptTransitGatewayPeeringAttachmentRequest acceptTransitGatewayPeeringAttachmentRequest) {
        try {

            HttpResponseHandler<AcceptTransitGatewayPeeringAttachmentResponse> responseHandler = protocolFactory
                    .createResponseHandler(AcceptTransitGatewayPeeringAttachmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AcceptTransitGatewayPeeringAttachmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AcceptTransitGatewayPeeringAttachmentRequest, AcceptTransitGatewayPeeringAttachmentResponse>()
                            .withOperationName("AcceptTransitGatewayPeeringAttachment")
                            .withMarshaller(new AcceptTransitGatewayPeeringAttachmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(acceptTransitGatewayPeeringAttachmentRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Accepts a request to attach a VPC to a transit gateway.
     * </p>
     * <p>
     * The VPC attachment must be in the <code>pendingAcceptance</code> state. Use
     * <a>DescribeTransitGatewayVpcAttachments</a> to view your pending VPC attachment requests. Use
     * <a>RejectTransitGatewayVpcAttachment</a> to reject a VPC attachment request.
     * </p>
     *
     * @param acceptTransitGatewayVpcAttachmentRequest
     * @return A Java Future containing the result of the AcceptTransitGatewayVpcAttachment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AcceptTransitGatewayVpcAttachment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AcceptTransitGatewayVpcAttachmentResponse> acceptTransitGatewayVpcAttachment(
            AcceptTransitGatewayVpcAttachmentRequest acceptTransitGatewayVpcAttachmentRequest) {
        try {

            HttpResponseHandler<AcceptTransitGatewayVpcAttachmentResponse> responseHandler = protocolFactory
                    .createResponseHandler(AcceptTransitGatewayVpcAttachmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AcceptTransitGatewayVpcAttachmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AcceptTransitGatewayVpcAttachmentRequest, AcceptTransitGatewayVpcAttachmentResponse>()
                            .withOperationName("AcceptTransitGatewayVpcAttachment")
                            .withMarshaller(new AcceptTransitGatewayVpcAttachmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(acceptTransitGatewayVpcAttachmentRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Accepts one or more interface VPC endpoint connection requests to your VPC endpoint service.
     * </p>
     *
     * @param acceptVpcEndpointConnectionsRequest
     * @return A Java Future containing the result of the AcceptVpcEndpointConnections operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AcceptVpcEndpointConnections
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcEndpointConnections"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AcceptVpcEndpointConnectionsResponse> acceptVpcEndpointConnections(
            AcceptVpcEndpointConnectionsRequest acceptVpcEndpointConnectionsRequest) {
        try {

            HttpResponseHandler<AcceptVpcEndpointConnectionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(AcceptVpcEndpointConnectionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AcceptVpcEndpointConnectionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AcceptVpcEndpointConnectionsRequest, AcceptVpcEndpointConnectionsResponse>()
                            .withOperationName("AcceptVpcEndpointConnections")
                            .withMarshaller(new AcceptVpcEndpointConnectionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(acceptVpcEndpointConnectionsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Accept a VPC peering connection request. To accept a request, the VPC peering connection must be in the
     * <code>pending-acceptance</code> state, and you must be the owner of the peer VPC. Use
     * <a>DescribeVpcPeeringConnections</a> to view your outstanding VPC peering connection requests.
     * </p>
     * <p>
     * For an inter-Region VPC peering connection request, you must accept the VPC peering connection in the Region of
     * the accepter VPC.
     * </p>
     *
     * @param acceptVpcPeeringConnectionRequest
     * @return A Java Future containing the result of the AcceptVpcPeeringConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AcceptVpcPeeringConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcPeeringConnection" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AcceptVpcPeeringConnectionResponse> acceptVpcPeeringConnection(
            AcceptVpcPeeringConnectionRequest acceptVpcPeeringConnectionRequest) {
        try {

            HttpResponseHandler<AcceptVpcPeeringConnectionResponse> responseHandler = protocolFactory
                    .createResponseHandler(AcceptVpcPeeringConnectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AcceptVpcPeeringConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AcceptVpcPeeringConnectionRequest, AcceptVpcPeeringConnectionResponse>()
                            .withOperationName("AcceptVpcPeeringConnection")
                            .withMarshaller(new AcceptVpcPeeringConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(acceptVpcPeeringConnectionRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Advertises an IPv4 or IPv6 address range that is provisioned for use with your AWS resources through bring your
     * own IP addresses (BYOIP).
     * </p>
     * <p>
     * You can perform this operation at most once every 10 seconds, even if you specify different address ranges each
     * time.
     * </p>
     * <p>
     * We recommend that you stop advertising the BYOIP CIDR from other locations when you advertise it from AWS. To
     * minimize down time, you can configure your AWS resources to use an address from a BYOIP CIDR before it is
     * advertised, and then simultaneously stop advertising it from the current location and start advertising it
     * through AWS.
     * </p>
     * <p>
     * It can take a few minutes before traffic to the specified addresses starts routing to AWS because of BGP
     * propagation delays.
     * </p>
     * <p>
     * To stop advertising the BYOIP CIDR, use <a>WithdrawByoipCidr</a>.
     * </p>
     *
     * @param advertiseByoipCidrRequest
     * @return A Java Future containing the result of the AdvertiseByoipCidr operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AdvertiseByoipCidr
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AdvertiseByoipCidr" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AdvertiseByoipCidrResponse> advertiseByoipCidr(AdvertiseByoipCidrRequest advertiseByoipCidrRequest) {
        try {

            HttpResponseHandler<AdvertiseByoipCidrResponse> responseHandler = protocolFactory
                    .createResponseHandler(AdvertiseByoipCidrResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AdvertiseByoipCidrResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AdvertiseByoipCidrRequest, AdvertiseByoipCidrResponse>()
                            .withOperationName("AdvertiseByoipCidr")
                            .withMarshaller(new AdvertiseByoipCidrRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(advertiseByoipCidrRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allocates an Elastic IP address to your AWS account. After you allocate the Elastic IP address you can associate
     * it with an instance or network interface. After you release an Elastic IP address, it is released to the IP
     * address pool and can be allocated to a different AWS account.
     * </p>
     * <p>
     * You can allocate an Elastic IP address from an address pool owned by AWS or from an address pool created from a
     * public IPv4 address range that you have brought to AWS for use with your AWS resources using bring your own IP
     * addresses (BYOIP). For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">Bring Your Own IP Addresses (BYOIP)</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * [EC2-VPC] If you release an Elastic IP address, you might be able to recover it. You cannot recover an Elastic IP
     * address that you released after it is allocated to another AWS account. You cannot recover an Elastic IP address
     * for EC2-Classic. To attempt to recover an Elastic IP address that you released, specify it in this operation.
     * </p>
     * <p>
     * An Elastic IP address is for use either in the EC2-Classic platform or in a VPC. By default, you can allocate 5
     * Elastic IP addresses for EC2-Classic per Region and 5 Elastic IP addresses for EC2-VPC per Region.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param allocateAddressRequest
     * @return A Java Future containing the result of the AllocateAddress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AllocateAddress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateAddress" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AllocateAddressResponse> allocateAddress(AllocateAddressRequest allocateAddressRequest) {
        try {

            HttpResponseHandler<AllocateAddressResponse> responseHandler = protocolFactory
                    .createResponseHandler(AllocateAddressResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AllocateAddressResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AllocateAddressRequest, AllocateAddressResponse>()
                            .withOperationName("AllocateAddress")
                            .withMarshaller(new AllocateAddressRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(allocateAddressRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allocates a Dedicated Host to your account. At a minimum, specify the supported instance type or instance family,
     * the Availability Zone in which to allocate the host, and the number of hosts to allocate.
     * </p>
     *
     * @param allocateHostsRequest
     * @return A Java Future containing the result of the AllocateHosts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AllocateHosts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateHosts" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AllocateHostsResponse> allocateHosts(AllocateHostsRequest allocateHostsRequest) {
        try {

            HttpResponseHandler<AllocateHostsResponse> responseHandler = protocolFactory
                    .createResponseHandler(AllocateHostsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AllocateHostsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AllocateHostsRequest, AllocateHostsResponse>()
                            .withOperationName("AllocateHosts")
                            .withMarshaller(new AllocateHostsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(allocateHostsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Applies a security group to the association between the target network and the Client VPN endpoint. This action
     * replaces the existing security groups with the specified security groups.
     * </p>
     *
     * @param applySecurityGroupsToClientVpnTargetNetworkRequest
     * @return A Java Future containing the result of the ApplySecurityGroupsToClientVpnTargetNetwork operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.ApplySecurityGroupsToClientVpnTargetNetwork
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ApplySecurityGroupsToClientVpnTargetNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ApplySecurityGroupsToClientVpnTargetNetworkResponse> applySecurityGroupsToClientVpnTargetNetwork(
            ApplySecurityGroupsToClientVpnTargetNetworkRequest applySecurityGroupsToClientVpnTargetNetworkRequest) {
        try {

            HttpResponseHandler<ApplySecurityGroupsToClientVpnTargetNetworkResponse> responseHandler = protocolFactory
                    .createResponseHandler(ApplySecurityGroupsToClientVpnTargetNetworkResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ApplySecurityGroupsToClientVpnTargetNetworkResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ApplySecurityGroupsToClientVpnTargetNetworkRequest, ApplySecurityGroupsToClientVpnTargetNetworkResponse>()
                            .withOperationName("ApplySecurityGroupsToClientVpnTargetNetwork")
                            .withMarshaller(new ApplySecurityGroupsToClientVpnTargetNetworkRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(applySecurityGroupsToClientVpnTargetNetworkRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Assigns one or more IPv6 addresses to the specified network interface. You can specify one or more specific IPv6
     * addresses, or you can specify the number of IPv6 addresses to be automatically assigned from within the subnet's
     * IPv6 CIDR block range. You can assign as many IPv6 addresses to a network interface as you can assign private
     * IPv4 addresses, and the limit varies per instance type. For information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI">IP Addresses Per
     * Network Interface Per Instance Type</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * You must specify either the IPv6 addresses or the IPv6 address count in the request.
     * </p>
     *
     * @param assignIpv6AddressesRequest
     * @return A Java Future containing the result of the AssignIpv6Addresses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssignIpv6Addresses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignIpv6Addresses" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AssignIpv6AddressesResponse> assignIpv6Addresses(
            AssignIpv6AddressesRequest assignIpv6AddressesRequest) {
        try {

            HttpResponseHandler<AssignIpv6AddressesResponse> responseHandler = protocolFactory
                    .createResponseHandler(AssignIpv6AddressesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AssignIpv6AddressesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssignIpv6AddressesRequest, AssignIpv6AddressesResponse>()
                            .withOperationName("AssignIpv6Addresses")
                            .withMarshaller(new AssignIpv6AddressesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(assignIpv6AddressesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Assigns one or more secondary private IP addresses to the specified network interface.
     * </p>
     * <p>
     * You can specify one or more specific secondary IP addresses, or you can specify the number of secondary IP
     * addresses to be automatically assigned within the subnet's CIDR block range. The number of secondary IP addresses
     * that you can assign to an instance varies by instance type. For information about instance types, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>. For more information about Elastic IP addresses, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * When you move a secondary private IP address to another network interface, any Elastic IP address that is
     * associated with the IP address is also moved.
     * </p>
     * <p>
     * Remapping an IP address is an asynchronous operation. When you move an IP address from one network interface to
     * another, check <code>network/interfaces/macs/mac/local-ipv4s</code> in the instance metadata to confirm that the
     * remapping is complete.
     * </p>
     * <p>
     * You must specify either the IP addresses or the IP address count in the request.
     * </p>
     *
     * @param assignPrivateIpAddressesRequest
     *        Contains the parameters for AssignPrivateIpAddresses.
     * @return A Java Future containing the result of the AssignPrivateIpAddresses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssignPrivateIpAddresses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateIpAddresses" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AssignPrivateIpAddressesResponse> assignPrivateIpAddresses(
            AssignPrivateIpAddressesRequest assignPrivateIpAddressesRequest) {
        try {

            HttpResponseHandler<AssignPrivateIpAddressesResponse> responseHandler = protocolFactory
                    .createResponseHandler(AssignPrivateIpAddressesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AssignPrivateIpAddressesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssignPrivateIpAddressesRequest, AssignPrivateIpAddressesResponse>()
                            .withOperationName("AssignPrivateIpAddresses")
                            .withMarshaller(new AssignPrivateIpAddressesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(assignPrivateIpAddressesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates an Elastic IP address with an instance or a network interface. Before you can use an Elastic IP
     * address, you must allocate it to your account.
     * </p>
     * <p>
     * An Elastic IP address is for use in either the EC2-Classic platform or in a VPC. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * [EC2-Classic, VPC in an EC2-VPC-only account] If the Elastic IP address is already associated with a different
     * instance, it is disassociated from that instance and associated with the specified instance. If you associate an
     * Elastic IP address with an instance that has an existing Elastic IP address, the existing address is
     * disassociated from the instance, but remains allocated to your account.
     * </p>
     * <p>
     * [VPC in an EC2-Classic account] If you don't specify a private IP address, the Elastic IP address is associated
     * with the primary IP address. If the Elastic IP address is already associated with a different instance or a
     * network interface, you get an error unless you allow reassociation. You cannot associate an Elastic IP address
     * with an instance or network interface that has an existing Elastic IP address.
     * </p>
     * <p>
     * You cannot associate an Elastic IP address with an interface in a different network border group.
     * </p>
     * <important>
     * <p>
     * This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error,
     * and you may be charged for each time the Elastic IP address is remapped to the same instance. For more
     * information, see the <i>Elastic IP Addresses</i> section of <a href="http://aws.amazon.com/ec2/pricing/">Amazon
     * EC2 Pricing</a>.
     * </p>
     * </important>
     *
     * @param associateAddressRequest
     * @return A Java Future containing the result of the AssociateAddress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateAddress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateAddress" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateAddressResponse> associateAddress(AssociateAddressRequest associateAddressRequest) {
        try {

            HttpResponseHandler<AssociateAddressResponse> responseHandler = protocolFactory
                    .createResponseHandler(AssociateAddressResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AssociateAddressResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateAddressRequest, AssociateAddressResponse>()
                            .withOperationName("AssociateAddress")
                            .withMarshaller(new AssociateAddressRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(associateAddressRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a target network with a Client VPN endpoint. A target network is a subnet in a VPC. You can associate
     * multiple subnets from the same VPC with a Client VPN endpoint. You can associate only one subnet in each
     * Availability Zone. We recommend that you associate at least two subnets to provide Availability Zone redundancy.
     * </p>
     * <p>
     * If you specified a VPC when you created the Client VPN endpoint or if you have previous subnet associations, the
     * specified subnet must be in the same VPC. To specify a subnet that's in a different VPC, you must first modify
     * the Client VPN endpoint (<a>ModifyClientVpnEndpoint</a>) and change the VPC that's associated with it.
     * </p>
     *
     * @param associateClientVpnTargetNetworkRequest
     * @return A Java Future containing the result of the AssociateClientVpnTargetNetwork operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateClientVpnTargetNetwork
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateClientVpnTargetNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateClientVpnTargetNetworkResponse> associateClientVpnTargetNetwork(
            AssociateClientVpnTargetNetworkRequest associateClientVpnTargetNetworkRequest) {
        try {

            HttpResponseHandler<AssociateClientVpnTargetNetworkResponse> responseHandler = protocolFactory
                    .createResponseHandler(AssociateClientVpnTargetNetworkResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AssociateClientVpnTargetNetworkResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateClientVpnTargetNetworkRequest, AssociateClientVpnTargetNetworkResponse>()
                            .withOperationName("AssociateClientVpnTargetNetwork")
                            .withMarshaller(new AssociateClientVpnTargetNetworkRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(associateClientVpnTargetNetworkRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a set of DHCP options (that you've previously created) with the specified VPC, or associates no DHCP
     * options with the VPC.
     * </p>
     * <p>
     * After you associate the options with the VPC, any existing instances and all new instances that you launch in
     * that VPC use the options. You don't need to restart or relaunch the instances. They automatically pick up the
     * changes within a few hours, depending on how frequently the instance renews its DHCP lease. You can explicitly
     * renew the lease using the operating system on the instance.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP
     * Options Sets</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param associateDhcpOptionsRequest
     * @return A Java Future containing the result of the AssociateDhcpOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateDhcpOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateDhcpOptionsResponse> associateDhcpOptions(
            AssociateDhcpOptionsRequest associateDhcpOptionsRequest) {
        try {

            HttpResponseHandler<AssociateDhcpOptionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(AssociateDhcpOptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AssociateDhcpOptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateDhcpOptionsRequest, AssociateDhcpOptionsResponse>()
                            .withOperationName("AssociateDhcpOptions")
                            .withMarshaller(new AssociateDhcpOptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(associateDhcpOptionsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates an IAM instance profile with a running or stopped instance. You cannot associate more than one IAM
     * instance profile with an instance.
     * </p>
     *
     * @param associateIamInstanceProfileRequest
     * @return A Java Future containing the result of the AssociateIamInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateIamInstanceProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIamInstanceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateIamInstanceProfileResponse> associateIamInstanceProfile(
            AssociateIamInstanceProfileRequest associateIamInstanceProfileRequest) {
        try {

            HttpResponseHandler<AssociateIamInstanceProfileResponse> responseHandler = protocolFactory
                    .createResponseHandler(AssociateIamInstanceProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AssociateIamInstanceProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateIamInstanceProfileRequest, AssociateIamInstanceProfileResponse>()
                            .withOperationName("AssociateIamInstanceProfile")
                            .withMarshaller(new AssociateIamInstanceProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(associateIamInstanceProfileRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a subnet in your VPC or an internet gateway or virtual private gateway attached to your VPC with a
     * route table in your VPC. This association causes traffic from the subnet or gateway to be routed according to the
     * routes in the route table. The action returns an association ID, which you need in order to disassociate the
     * route table later. A route table can be associated with multiple subnets.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route
     * Tables</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param associateRouteTableRequest
     * @return A Java Future containing the result of the AssociateRouteTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateRouteTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateRouteTable" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateRouteTableResponse> associateRouteTable(
            AssociateRouteTableRequest associateRouteTableRequest) {
        try {

            HttpResponseHandler<AssociateRouteTableResponse> responseHandler = protocolFactory
                    .createResponseHandler(AssociateRouteTableResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AssociateRouteTableResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateRouteTableRequest, AssociateRouteTableResponse>()
                            .withOperationName("AssociateRouteTable")
                            .withMarshaller(new AssociateRouteTableRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(associateRouteTableRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a CIDR block with your subnet. You can only associate a single IPv6 CIDR block with your subnet. An
     * IPv6 CIDR block must have a prefix length of /64.
     * </p>
     *
     * @param associateSubnetCidrBlockRequest
     * @return A Java Future containing the result of the AssociateSubnetCidrBlock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateSubnetCidrBlock
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateSubnetCidrBlock" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateSubnetCidrBlockResponse> associateSubnetCidrBlock(
            AssociateSubnetCidrBlockRequest associateSubnetCidrBlockRequest) {
        try {

            HttpResponseHandler<AssociateSubnetCidrBlockResponse> responseHandler = protocolFactory
                    .createResponseHandler(AssociateSubnetCidrBlockResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AssociateSubnetCidrBlockResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateSubnetCidrBlockRequest, AssociateSubnetCidrBlockResponse>()
                            .withOperationName("AssociateSubnetCidrBlock")
                            .withMarshaller(new AssociateSubnetCidrBlockRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(associateSubnetCidrBlockRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates the specified subnets and transit gateway attachments with the specified transit gateway multicast
     * domain.
     * </p>
     * <p>
     * The transit gateway attachment must be in the available state before you can add a resource. Use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayAttachments.html"
     * >DescribeTransitGatewayAttachments</a> to see the state of the attachment.
     * </p>
     *
     * @param associateTransitGatewayMulticastDomainRequest
     * @return A Java Future containing the result of the AssociateTransitGatewayMulticastDomain operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateTransitGatewayMulticastDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayMulticastDomain"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateTransitGatewayMulticastDomainResponse> associateTransitGatewayMulticastDomain(
            AssociateTransitGatewayMulticastDomainRequest associateTransitGatewayMulticastDomainRequest) {
        try {

            HttpResponseHandler<AssociateTransitGatewayMulticastDomainResponse> responseHandler = protocolFactory
                    .createResponseHandler(AssociateTransitGatewayMulticastDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AssociateTransitGatewayMulticastDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateTransitGatewayMulticastDomainRequest, AssociateTransitGatewayMulticastDomainResponse>()
                            .withOperationName("AssociateTransitGatewayMulticastDomain")
                            .withMarshaller(new AssociateTransitGatewayMulticastDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(associateTransitGatewayMulticastDomainRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates the specified attachment with the specified transit gateway route table. You can associate only one
     * route table with an attachment.
     * </p>
     *
     * @param associateTransitGatewayRouteTableRequest
     * @return A Java Future containing the result of the AssociateTransitGatewayRouteTable operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateTransitGatewayRouteTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateTransitGatewayRouteTableResponse> associateTransitGatewayRouteTable(
            AssociateTransitGatewayRouteTableRequest associateTransitGatewayRouteTableRequest) {
        try {

            HttpResponseHandler<AssociateTransitGatewayRouteTableResponse> responseHandler = protocolFactory
                    .createResponseHandler(AssociateTransitGatewayRouteTableResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AssociateTransitGatewayRouteTableResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateTransitGatewayRouteTableRequest, AssociateTransitGatewayRouteTableResponse>()
                            .withOperationName("AssociateTransitGatewayRouteTable")
                            .withMarshaller(new AssociateTransitGatewayRouteTableRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(associateTransitGatewayRouteTableRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a CIDR block with your VPC. You can associate a secondary IPv4 CIDR block, an Amazon-provided IPv6
     * CIDR block, or an IPv6 CIDR block from an IPv6 address pool that you provisioned through bring your own IP
     * addresses (<a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">BYOIP</a>). The IPv6 CIDR
     * block size is fixed at /56.
     * </p>
     * <p>
     * You must specify one of the following in the request: an IPv4 CIDR block, an IPv6 pool, or an Amazon-provided
     * IPv6 CIDR block.
     * </p>
     * <p>
     * For more information about associating CIDR blocks with your VPC and applicable restrictions, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html#VPC_Sizing">VPC and Subnet Sizing</a> in
     * the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param associateVpcCidrBlockRequest
     * @return A Java Future containing the result of the AssociateVpcCidrBlock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AssociateVpcCidrBlock
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateVpcCidrBlock" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateVpcCidrBlockResponse> associateVpcCidrBlock(
            AssociateVpcCidrBlockRequest associateVpcCidrBlockRequest) {
        try {

            HttpResponseHandler<AssociateVpcCidrBlockResponse> responseHandler = protocolFactory
                    .createResponseHandler(AssociateVpcCidrBlockResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AssociateVpcCidrBlockResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateVpcCidrBlockRequest, AssociateVpcCidrBlockResponse>()
                            .withOperationName("AssociateVpcCidrBlock")
                            .withMarshaller(new AssociateVpcCidrBlockRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(associateVpcCidrBlockRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Links an EC2-Classic instance to a ClassicLink-enabled VPC through one or more of the VPC's security groups. You
     * cannot link an EC2-Classic instance to more than one VPC at a time. You can only link an instance that's in the
     * <code>running</code> state. An instance is automatically unlinked from a VPC when it's stopped - you can link it
     * to the VPC again when you restart it.
     * </p>
     * <p>
     * After you've linked an instance, you cannot change the VPC security groups that are associated with it. To change
     * the security groups, you must first unlink the instance, and then link it again.
     * </p>
     * <p>
     * Linking your instance to a VPC is sometimes referred to as <i>attaching</i> your instance.
     * </p>
     *
     * @param attachClassicLinkVpcRequest
     * @return A Java Future containing the result of the AttachClassicLinkVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AttachClassicLinkVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachClassicLinkVpc" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AttachClassicLinkVpcResponse> attachClassicLinkVpc(
            AttachClassicLinkVpcRequest attachClassicLinkVpcRequest) {
        try {

            HttpResponseHandler<AttachClassicLinkVpcResponse> responseHandler = protocolFactory
                    .createResponseHandler(AttachClassicLinkVpcResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AttachClassicLinkVpcResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AttachClassicLinkVpcRequest, AttachClassicLinkVpcResponse>()
                            .withOperationName("AttachClassicLinkVpc")
                            .withMarshaller(new AttachClassicLinkVpcRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(attachClassicLinkVpcRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches an internet gateway or a virtual private gateway to a VPC, enabling connectivity between the internet
     * and the VPC. For more information about your VPC and internet gateway, see the <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/">Amazon Virtual Private Cloud User Guide</a>.
     * </p>
     *
     * @param attachInternetGatewayRequest
     * @return A Java Future containing the result of the AttachInternetGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AttachInternetGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AttachInternetGatewayResponse> attachInternetGateway(
            AttachInternetGatewayRequest attachInternetGatewayRequest) {
        try {

            HttpResponseHandler<AttachInternetGatewayResponse> responseHandler = protocolFactory
                    .createResponseHandler(AttachInternetGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AttachInternetGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AttachInternetGatewayRequest, AttachInternetGatewayResponse>()
                            .withOperationName("AttachInternetGateway")
                            .withMarshaller(new AttachInternetGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(attachInternetGatewayRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches a network interface to an instance.
     * </p>
     *
     * @param attachNetworkInterfaceRequest
     *        Contains the parameters for AttachNetworkInterface.
     * @return A Java Future containing the result of the AttachNetworkInterface operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AttachNetworkInterface
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachNetworkInterface" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AttachNetworkInterfaceResponse> attachNetworkInterface(
            AttachNetworkInterfaceRequest attachNetworkInterfaceRequest) {
        try {

            HttpResponseHandler<AttachNetworkInterfaceResponse> responseHandler = protocolFactory
                    .createResponseHandler(AttachNetworkInterfaceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AttachNetworkInterfaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AttachNetworkInterfaceRequest, AttachNetworkInterfaceResponse>()
                            .withOperationName("AttachNetworkInterface")
                            .withMarshaller(new AttachNetworkInterfaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(attachNetworkInterfaceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches an EBS volume to a running or stopped instance and exposes it to the instance with the specified device
     * name.
     * </p>
     * <p>
     * Encrypted EBS volumes must be attached to instances that support Amazon EBS encryption. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * After you attach an EBS volume, you must make it available. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-using-volumes.html">Making an EBS Volume Available
     * For Use</a>.
     * </p>
     * <p>
     * If a volume has an AWS Marketplace product code:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The volume can be attached only to a stopped instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * AWS Marketplace product codes are copied from the volume to the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must be subscribed to the product.
     * </p>
     * </li>
     * <li>
     * <p>
     * The instance type and operating system of the instance must support the product. For example, you can't detach a
     * volume from a Windows instance and attach it to a Linux instance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-attaching-volume.html">Attaching Amazon EBS
     * Volumes</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param attachVolumeRequest
     * @return A Java Future containing the result of the AttachVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AttachVolume
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVolume" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AttachVolumeResponse> attachVolume(AttachVolumeRequest attachVolumeRequest) {
        try {

            HttpResponseHandler<AttachVolumeResponse> responseHandler = protocolFactory
                    .createResponseHandler(AttachVolumeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AttachVolumeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AttachVolumeRequest, AttachVolumeResponse>()
                            .withOperationName("AttachVolume").withMarshaller(new AttachVolumeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(attachVolumeRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches a virtual private gateway to a VPC. You can attach one virtual private gateway to one VPC at a time.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">AWS Site-to-Site
     * VPN</a> in the <i>AWS Site-to-Site VPN User Guide</i>.
     * </p>
     *
     * @param attachVpnGatewayRequest
     *        Contains the parameters for AttachVpnGateway.
     * @return A Java Future containing the result of the AttachVpnGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AttachVpnGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVpnGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AttachVpnGatewayResponse> attachVpnGateway(AttachVpnGatewayRequest attachVpnGatewayRequest) {
        try {

            HttpResponseHandler<AttachVpnGatewayResponse> responseHandler = protocolFactory
                    .createResponseHandler(AttachVpnGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AttachVpnGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AttachVpnGatewayRequest, AttachVpnGatewayResponse>()
                            .withOperationName("AttachVpnGateway")
                            .withMarshaller(new AttachVpnGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(attachVpnGatewayRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds an ingress authorization rule to a Client VPN endpoint. Ingress authorization rules act as firewall rules
     * that grant access to networks. You must configure ingress authorization rules to enable clients to access
     * resources in AWS or on-premises networks.
     * </p>
     *
     * @param authorizeClientVpnIngressRequest
     * @return A Java Future containing the result of the AuthorizeClientVpnIngress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AuthorizeClientVpnIngress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeClientVpnIngress" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AuthorizeClientVpnIngressResponse> authorizeClientVpnIngress(
            AuthorizeClientVpnIngressRequest authorizeClientVpnIngressRequest) {
        try {

            HttpResponseHandler<AuthorizeClientVpnIngressResponse> responseHandler = protocolFactory
                    .createResponseHandler(AuthorizeClientVpnIngressResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AuthorizeClientVpnIngressResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AuthorizeClientVpnIngressRequest, AuthorizeClientVpnIngressResponse>()
                            .withOperationName("AuthorizeClientVpnIngress")
                            .withMarshaller(new AuthorizeClientVpnIngressRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(authorizeClientVpnIngressRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * [VPC only] Adds the specified egress rules to a security group for use with a VPC.
     * </p>
     * <p>
     * An outbound rule permits instances to send traffic to the specified IPv4 or IPv6 CIDR address ranges, or to the
     * instances associated with the specified destination security groups.
     * </p>
     * <p>
     * You specify a protocol for each rule (for example, TCP). For the TCP and UDP protocols, you must also specify the
     * destination port or port range. For the ICMP protocol, you must also specify the ICMP type and code. You can use
     * -1 for the type or code to mean all types or all codes.
     * </p>
     * <p>
     * Rule changes are propagated to affected instances as quickly as possible. However, a small delay might occur.
     * </p>
     * <p>
     * For more information about VPC security group limits, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC Limits</a>.
     * </p>
     *
     * @param authorizeSecurityGroupEgressRequest
     * @return A Java Future containing the result of the AuthorizeSecurityGroupEgress operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AuthorizeSecurityGroupEgress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupEgress"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AuthorizeSecurityGroupEgressResponse> authorizeSecurityGroupEgress(
            AuthorizeSecurityGroupEgressRequest authorizeSecurityGroupEgressRequest) {
        try {

            HttpResponseHandler<AuthorizeSecurityGroupEgressResponse> responseHandler = protocolFactory
                    .createResponseHandler(AuthorizeSecurityGroupEgressResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AuthorizeSecurityGroupEgressResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AuthorizeSecurityGroupEgressRequest, AuthorizeSecurityGroupEgressResponse>()
                            .withOperationName("AuthorizeSecurityGroupEgress")
                            .withMarshaller(new AuthorizeSecurityGroupEgressRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(authorizeSecurityGroupEgressRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds the specified ingress rules to a security group.
     * </p>
     * <p>
     * An inbound rule permits instances to receive traffic from the specified IPv4 or IPv6 CIDR address ranges, or from
     * the instances associated with the specified destination security groups.
     * </p>
     * <p>
     * You specify a protocol for each rule (for example, TCP). For TCP and UDP, you must also specify the destination
     * port or port range. For ICMP/ICMPv6, you must also specify the ICMP/ICMPv6 type and code. You can use -1 to mean
     * all types or all codes.
     * </p>
     * <p>
     * Rule changes are propagated to instances within the security group as quickly as possible. However, a small delay
     * might occur.
     * </p>
     * <p>
     * For more information about VPC security group limits, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC Limits</a>.
     * </p>
     *
     * @param authorizeSecurityGroupIngressRequest
     * @return A Java Future containing the result of the AuthorizeSecurityGroupIngress operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.AuthorizeSecurityGroupIngress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AuthorizeSecurityGroupIngressResponse> authorizeSecurityGroupIngress(
            AuthorizeSecurityGroupIngressRequest authorizeSecurityGroupIngressRequest) {
        try {

            HttpResponseHandler<AuthorizeSecurityGroupIngressResponse> responseHandler = protocolFactory
                    .createResponseHandler(AuthorizeSecurityGroupIngressResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AuthorizeSecurityGroupIngressResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AuthorizeSecurityGroupIngressRequest, AuthorizeSecurityGroupIngressResponse>()
                            .withOperationName("AuthorizeSecurityGroupIngress")
                            .withMarshaller(new AuthorizeSecurityGroupIngressRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(authorizeSecurityGroupIngressRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Bundles an Amazon instance store-backed Windows instance.
     * </p>
     * <p>
     * During bundling, only the root device volume (C:\) is bundled. Data on other instance store volumes is not
     * preserved.
     * </p>
     * <note>
     * <p>
     * This action is not applicable for Linux/Unix instances or Windows instances that are backed by Amazon EBS.
     * </p>
     * </note>
     *
     * @param bundleInstanceRequest
     *        Contains the parameters for BundleInstance.
     * @return A Java Future containing the result of the BundleInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.BundleInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<BundleInstanceResponse> bundleInstance(BundleInstanceRequest bundleInstanceRequest) {
        try {

            HttpResponseHandler<BundleInstanceResponse> responseHandler = protocolFactory
                    .createResponseHandler(BundleInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<BundleInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BundleInstanceRequest, BundleInstanceResponse>()
                            .withOperationName("BundleInstance")
                            .withMarshaller(new BundleInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(bundleInstanceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels a bundling operation for an instance store-backed Windows instance.
     * </p>
     *
     * @param cancelBundleTaskRequest
     *        Contains the parameters for CancelBundleTask.
     * @return A Java Future containing the result of the CancelBundleTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelBundleTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelBundleTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CancelBundleTaskResponse> cancelBundleTask(CancelBundleTaskRequest cancelBundleTaskRequest) {
        try {

            HttpResponseHandler<CancelBundleTaskResponse> responseHandler = protocolFactory
                    .createResponseHandler(CancelBundleTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CancelBundleTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelBundleTaskRequest, CancelBundleTaskResponse>()
                            .withOperationName("CancelBundleTask")
                            .withMarshaller(new CancelBundleTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(cancelBundleTaskRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels the specified Capacity Reservation, releases the reserved capacity, and changes the Capacity
     * Reservation's state to <code>cancelled</code>.
     * </p>
     * <p>
     * Instances running in the reserved capacity continue running until you stop them. Stopped instances that target
     * the Capacity Reservation can no longer launch. Modify these instances to either target a different Capacity
     * Reservation, launch On-Demand Instance capacity, or run in any open Capacity Reservation that has matching
     * attributes and sufficient capacity.
     * </p>
     *
     * @param cancelCapacityReservationRequest
     * @return A Java Future containing the result of the CancelCapacityReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelCapacityReservation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelCapacityReservationResponse> cancelCapacityReservation(
            CancelCapacityReservationRequest cancelCapacityReservationRequest) {
        try {

            HttpResponseHandler<CancelCapacityReservationResponse> responseHandler = protocolFactory
                    .createResponseHandler(CancelCapacityReservationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CancelCapacityReservationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelCapacityReservationRequest, CancelCapacityReservationResponse>()
                            .withOperationName("CancelCapacityReservation")
                            .withMarshaller(new CancelCapacityReservationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(cancelCapacityReservationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels an active conversion task. The task can be the import of an instance or volume. The action removes all
     * artifacts of the conversion, including a partially uploaded volume or instance. If the conversion is complete or
     * is in the process of transferring the final disk image, the command fails and returns an exception.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/CommandLineReference/ec2-cli-vmimport-export.html">Importing a
     * Virtual Machine Using the Amazon EC2 CLI</a>.
     * </p>
     *
     * @param cancelConversionTaskRequest
     * @return A Java Future containing the result of the CancelConversionTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelConversionTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelConversionTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CancelConversionTaskResponse> cancelConversionTask(
            CancelConversionTaskRequest cancelConversionTaskRequest) {
        try {

            HttpResponseHandler<CancelConversionTaskResponse> responseHandler = protocolFactory
                    .createResponseHandler(CancelConversionTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CancelConversionTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelConversionTaskRequest, CancelConversionTaskResponse>()
                            .withOperationName("CancelConversionTask")
                            .withMarshaller(new CancelConversionTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(cancelConversionTaskRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels an active export task. The request removes all artifacts of the export, including any partially-created
     * Amazon S3 objects. If the export task is complete or is in the process of transferring the final disk image, the
     * command fails and returns an error.
     * </p>
     *
     * @param cancelExportTaskRequest
     * @return A Java Future containing the result of the CancelExportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelExportTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelExportTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CancelExportTaskResponse> cancelExportTask(CancelExportTaskRequest cancelExportTaskRequest) {
        try {

            HttpResponseHandler<CancelExportTaskResponse> responseHandler = protocolFactory
                    .createResponseHandler(CancelExportTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CancelExportTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelExportTaskRequest, CancelExportTaskResponse>()
                            .withOperationName("CancelExportTask")
                            .withMarshaller(new CancelExportTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(cancelExportTaskRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels an in-process import virtual machine or import snapshot task.
     * </p>
     *
     * @param cancelImportTaskRequest
     * @return A Java Future containing the result of the CancelImportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelImportTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImportTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CancelImportTaskResponse> cancelImportTask(CancelImportTaskRequest cancelImportTaskRequest) {
        try {

            HttpResponseHandler<CancelImportTaskResponse> responseHandler = protocolFactory
                    .createResponseHandler(CancelImportTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CancelImportTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelImportTaskRequest, CancelImportTaskResponse>()
                            .withOperationName("CancelImportTask")
                            .withMarshaller(new CancelImportTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(cancelImportTaskRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels the specified Reserved Instance listing in the Reserved Instance Marketplace.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance
     * Marketplace</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param cancelReservedInstancesListingRequest
     *        Contains the parameters for CancelReservedInstancesListing.
     * @return A Java Future containing the result of the CancelReservedInstancesListing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelReservedInstancesListing
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelReservedInstancesListing"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelReservedInstancesListingResponse> cancelReservedInstancesListing(
            CancelReservedInstancesListingRequest cancelReservedInstancesListingRequest) {
        try {

            HttpResponseHandler<CancelReservedInstancesListingResponse> responseHandler = protocolFactory
                    .createResponseHandler(CancelReservedInstancesListingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CancelReservedInstancesListingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelReservedInstancesListingRequest, CancelReservedInstancesListingResponse>()
                            .withOperationName("CancelReservedInstancesListing")
                            .withMarshaller(new CancelReservedInstancesListingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(cancelReservedInstancesListingRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels the specified Spot Fleet requests.
     * </p>
     * <p>
     * After you cancel a Spot Fleet request, the Spot Fleet launches no new Spot Instances. You must specify whether
     * the Spot Fleet should also terminate its Spot Instances. If you terminate the instances, the Spot Fleet request
     * enters the <code>cancelled_terminating</code> state. Otherwise, the Spot Fleet request enters the
     * <code>cancelled_running</code> state and the instances continue to run until they are interrupted or you
     * terminate them manually.
     * </p>
     *
     * @param cancelSpotFleetRequestsRequest
     *        Contains the parameters for CancelSpotFleetRequests.
     * @return A Java Future containing the result of the CancelSpotFleetRequests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelSpotFleetRequests
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequests" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelSpotFleetRequestsResponse> cancelSpotFleetRequests(
            CancelSpotFleetRequestsRequest cancelSpotFleetRequestsRequest) {
        try {

            HttpResponseHandler<CancelSpotFleetRequestsResponse> responseHandler = protocolFactory
                    .createResponseHandler(CancelSpotFleetRequestsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CancelSpotFleetRequestsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelSpotFleetRequestsRequest, CancelSpotFleetRequestsResponse>()
                            .withOperationName("CancelSpotFleetRequests")
                            .withMarshaller(new CancelSpotFleetRequestsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(cancelSpotFleetRequestsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels one or more Spot Instance requests.
     * </p>
     * <important>
     * <p>
     * Canceling a Spot Instance request does not terminate running Spot Instances associated with the request.
     * </p>
     * </important>
     *
     * @param cancelSpotInstanceRequestsRequest
     *        Contains the parameters for CancelSpotInstanceRequests.
     * @return A Java Future containing the result of the CancelSpotInstanceRequests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CancelSpotInstanceRequests
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotInstanceRequests" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelSpotInstanceRequestsResponse> cancelSpotInstanceRequests(
            CancelSpotInstanceRequestsRequest cancelSpotInstanceRequestsRequest) {
        try {

            HttpResponseHandler<CancelSpotInstanceRequestsResponse> responseHandler = protocolFactory
                    .createResponseHandler(CancelSpotInstanceRequestsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CancelSpotInstanceRequestsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelSpotInstanceRequestsRequest, CancelSpotInstanceRequestsResponse>()
                            .withOperationName("CancelSpotInstanceRequests")
                            .withMarshaller(new CancelSpotInstanceRequestsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(cancelSpotInstanceRequestsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Determines whether a product code is associated with an instance. This action can only be used by the owner of
     * the product code. It is useful when a product code owner must verify whether another user's instance is eligible
     * for support.
     * </p>
     *
     * @param confirmProductInstanceRequest
     * @return A Java Future containing the result of the ConfirmProductInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.ConfirmProductInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConfirmProductInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ConfirmProductInstanceResponse> confirmProductInstance(
            ConfirmProductInstanceRequest confirmProductInstanceRequest) {
        try {

            HttpResponseHandler<ConfirmProductInstanceResponse> responseHandler = protocolFactory
                    .createResponseHandler(ConfirmProductInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ConfirmProductInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ConfirmProductInstanceRequest, ConfirmProductInstanceResponse>()
                            .withOperationName("ConfirmProductInstance")
                            .withMarshaller(new ConfirmProductInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(confirmProductInstanceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Copies the specified Amazon FPGA Image (AFI) to the current Region.
     * </p>
     *
     * @param copyFpgaImageRequest
     * @return A Java Future containing the result of the CopyFpgaImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CopyFpgaImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyFpgaImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CopyFpgaImageResponse> copyFpgaImage(CopyFpgaImageRequest copyFpgaImageRequest) {
        try {

            HttpResponseHandler<CopyFpgaImageResponse> responseHandler = protocolFactory
                    .createResponseHandler(CopyFpgaImageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CopyFpgaImageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CopyFpgaImageRequest, CopyFpgaImageResponse>()
                            .withOperationName("CopyFpgaImage")
                            .withMarshaller(new CopyFpgaImageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(copyFpgaImageRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Initiates the copy of an AMI from the specified source Region to the current Region. You specify the destination
     * Region by using its endpoint when making the request.
     * </p>
     * <p>
     * Copies of encrypted backing snapshots for the AMI are encrypted. Copies of unencrypted backing snapshots remain
     * unencrypted, unless you set <code>Encrypted</code> during the copy operation. You cannot create an unencrypted
     * copy of an encrypted backing snapshot.
     * </p>
     * <p>
     * For more information about the prerequisites and limits when copying an AMI, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/CopyingAMIs.html">Copying an AMI</a> in the <i>Amazon
     * Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param copyImageRequest
     *        Contains the parameters for CopyImage.
     * @return A Java Future containing the result of the CopyImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CopyImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CopyImageResponse> copyImage(CopyImageRequest copyImageRequest) {
        try {

            HttpResponseHandler<CopyImageResponse> responseHandler = protocolFactory
                    .createResponseHandler(CopyImageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CopyImageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CopyImageRequest, CopyImageResponse>().withOperationName("CopyImage")
                            .withMarshaller(new CopyImageRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(copyImageRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Copies a point-in-time snapshot of an EBS volume and stores it in Amazon S3. You can copy the snapshot within the
     * same Region or from one Region to another. You can use the snapshot to create EBS volumes or Amazon Machine
     * Images (AMIs).
     * </p>
     * <p>
     * Copies of encrypted EBS snapshots remain encrypted. Copies of unencrypted snapshots remain unencrypted, unless
     * you enable encryption for the snapshot copy operation. By default, encrypted snapshot copies use the default AWS
     * Key Management Service (AWS KMS) customer master key (CMK); however, you can specify a different CMK.
     * </p>
     * <p>
     * To copy an encrypted snapshot that has been shared from another account, you must have permissions for the CMK
     * used to encrypt the snapshot.
     * </p>
     * <p>
     * Snapshots created by copying another snapshot have an arbitrary volume ID that should not be used for any
     * purpose.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-copy-snapshot.html">Copying an Amazon EBS
     * Snapshot</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param copySnapshotRequest
     * @return A Java Future containing the result of the CopySnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CopySnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopySnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CopySnapshotResponse> copySnapshot(CopySnapshotRequest copySnapshotRequest) {
        try {

            HttpResponseHandler<CopySnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(CopySnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CopySnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CopySnapshotRequest, CopySnapshotResponse>()
                            .withOperationName("CopySnapshot").withMarshaller(new CopySnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(copySnapshotRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new Capacity Reservation with the specified attributes.
     * </p>
     * <p>
     * Capacity Reservations enable you to reserve capacity for your Amazon EC2 instances in a specific Availability
     * Zone for any duration. This gives you the flexibility to selectively add capacity reservations and still get the
     * Regional RI discounts for that usage. By creating Capacity Reservations, you ensure that you always have access
     * to Amazon EC2 capacity when you need it, for as long as you need it. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html">Capacity
     * Reservations</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * Your request to create a Capacity Reservation could fail if Amazon EC2 does not have sufficient capacity to
     * fulfill the request. If your request fails due to Amazon EC2 capacity constraints, either try again at a later
     * time, try in a different Availability Zone, or request a smaller capacity reservation. If your application is
     * flexible across instance types and sizes, try to create a Capacity Reservation with different instance
     * attributes.
     * </p>
     * <p>
     * Your request could also fail if the requested quantity exceeds your On-Demand Instance limit for the selected
     * instance type. If your request fails due to limit constraints, increase your On-Demand Instance limit for the
     * required instance type and try again. For more information about increasing your instance limits, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html">Amazon EC2 Service Limits</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createCapacityReservationRequest
     * @return A Java Future containing the result of the CreateCapacityReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateCapacityReservation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCapacityReservationResponse> createCapacityReservation(
            CreateCapacityReservationRequest createCapacityReservationRequest) {
        try {

            HttpResponseHandler<CreateCapacityReservationResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateCapacityReservationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateCapacityReservationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCapacityReservationRequest, CreateCapacityReservationResponse>()
                            .withOperationName("CreateCapacityReservation")
                            .withMarshaller(new CreateCapacityReservationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createCapacityReservationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Client VPN endpoint. A Client VPN endpoint is the resource you create and configure to enable and
     * manage client VPN sessions. It is the destination endpoint at which all client VPN sessions are terminated.
     * </p>
     *
     * @param createClientVpnEndpointRequest
     * @return A Java Future containing the result of the CreateClientVpnEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateClientVpnEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateClientVpnEndpointResponse> createClientVpnEndpoint(
            CreateClientVpnEndpointRequest createClientVpnEndpointRequest) {
        try {

            HttpResponseHandler<CreateClientVpnEndpointResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateClientVpnEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateClientVpnEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateClientVpnEndpointRequest, CreateClientVpnEndpointResponse>()
                            .withOperationName("CreateClientVpnEndpoint")
                            .withMarshaller(new CreateClientVpnEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createClientVpnEndpointRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds a route to a network to a Client VPN endpoint. Each Client VPN endpoint has a route table that describes the
     * available destination network routes. Each route in the route table specifies the path for traﬃc to speciﬁc
     * resources or networks.
     * </p>
     *
     * @param createClientVpnRouteRequest
     * @return A Java Future containing the result of the CreateClientVpnRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateClientVpnRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnRoute" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateClientVpnRouteResponse> createClientVpnRoute(
            CreateClientVpnRouteRequest createClientVpnRouteRequest) {
        try {

            HttpResponseHandler<CreateClientVpnRouteResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateClientVpnRouteResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateClientVpnRouteResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateClientVpnRouteRequest, CreateClientVpnRouteResponse>()
                            .withOperationName("CreateClientVpnRoute")
                            .withMarshaller(new CreateClientVpnRouteRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createClientVpnRouteRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides information to AWS about your VPN customer gateway device. The customer gateway is the appliance at your
     * end of the VPN connection. (The device on the AWS side of the VPN connection is the virtual private gateway.) You
     * must provide the Internet-routable IP address of the customer gateway's external interface. The IP address must
     * be static and can be behind a device performing network address translation (NAT).
     * </p>
     * <p>
     * For devices that use Border Gateway Protocol (BGP), you can also provide the device's BGP Autonomous System
     * Number (ASN). You can use an existing ASN assigned to your network. If you don't have an ASN already, you can use
     * a private ASN (in the 64512 - 65534 range).
     * </p>
     * <note>
     * <p>
     * Amazon EC2 supports all 2-byte ASN numbers in the range of 1 - 65534, with the exception of 7224, which is
     * reserved in the <code>us-east-1</code> Region, and 9059, which is reserved in the <code>eu-west-1</code> Region.
     * </p>
     * </note>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">AWS Site-to-Site
     * VPN</a> in the <i>AWS Site-to-Site VPN User Guide</i>.
     * </p>
     * <important>
     * <p>
     * To create more than one customer gateway with the same VPN type, IP address, and BGP ASN, specify a unique device
     * name for each customer gateway. Identical requests return information about the existing customer gateway and do
     * not create new customer gateways.
     * </p>
     * </important>
     *
     * @param createCustomerGatewayRequest
     *        Contains the parameters for CreateCustomerGateway.
     * @return A Java Future containing the result of the CreateCustomerGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateCustomerGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCustomerGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCustomerGatewayResponse> createCustomerGateway(
            CreateCustomerGatewayRequest createCustomerGatewayRequest) {
        try {

            HttpResponseHandler<CreateCustomerGatewayResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateCustomerGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateCustomerGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCustomerGatewayRequest, CreateCustomerGatewayResponse>()
                            .withOperationName("CreateCustomerGateway")
                            .withMarshaller(new CreateCustomerGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createCustomerGatewayRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a default subnet with a size <code>/20</code> IPv4 CIDR block in the specified Availability Zone in your
     * default VPC. You can have only one default subnet per Availability Zone. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html#create-default-subnet">Creating a Default
     * Subnet</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param createDefaultSubnetRequest
     * @return A Java Future containing the result of the CreateDefaultSubnet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateDefaultSubnet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultSubnet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDefaultSubnetResponse> createDefaultSubnet(
            CreateDefaultSubnetRequest createDefaultSubnetRequest) {
        try {

            HttpResponseHandler<CreateDefaultSubnetResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateDefaultSubnetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateDefaultSubnetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDefaultSubnetRequest, CreateDefaultSubnetResponse>()
                            .withOperationName("CreateDefaultSubnet")
                            .withMarshaller(new CreateDefaultSubnetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createDefaultSubnetRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a default VPC with a size <code>/16</code> IPv4 CIDR block and a default subnet in each Availability
     * Zone. For more information about the components of a default VPC, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html">Default VPC and Default Subnets</a> in
     * the <i>Amazon Virtual Private Cloud User Guide</i>. You cannot specify the components of the default VPC
     * yourself.
     * </p>
     * <p>
     * If you deleted your previous default VPC, you can create a default VPC. You cannot have more than one default VPC
     * per Region.
     * </p>
     * <p>
     * If your account supports EC2-Classic, you cannot use this action to create a default VPC in a Region that
     * supports EC2-Classic. If you want a default VPC in a Region that supports EC2-Classic, see
     * "I really want a default VPC for my existing EC2 account. Is that possible?" in the <a
     * href="http://aws.amazon.com/vpc/faqs/#Default_VPCs">Default VPCs FAQ</a>.
     * </p>
     *
     * @param createDefaultVpcRequest
     * @return A Java Future containing the result of the CreateDefaultVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateDefaultVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultVpc" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDefaultVpcResponse> createDefaultVpc(CreateDefaultVpcRequest createDefaultVpcRequest) {
        try {

            HttpResponseHandler<CreateDefaultVpcResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateDefaultVpcResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateDefaultVpcResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDefaultVpcRequest, CreateDefaultVpcResponse>()
                            .withOperationName("CreateDefaultVpc")
                            .withMarshaller(new CreateDefaultVpcRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createDefaultVpcRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a set of DHCP options for your VPC. After creating the set, you must associate it with the VPC, causing
     * all existing and new instances that you launch in the VPC to use this set of DHCP options. The following are the
     * individual DHCP options you can specify. For more information about the options, see <a
     * href="http://www.ietf.org/rfc/rfc2132.txt">RFC 2132</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>domain-name-servers</code> - The IP addresses of up to four domain name servers, or AmazonProvidedDNS. The
     * default DHCP option set specifies AmazonProvidedDNS. If specifying more than one domain name server, specify the
     * IP addresses in a single parameter, separated by commas. To have your instance receive a custom DNS hostname as
     * specified in <code>domain-name</code>, you must set <code>domain-name-servers</code> to a custom DNS server.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>domain-name</code> - If you're using AmazonProvidedDNS in <code>us-east-1</code>, specify
     * <code>ec2.internal</code>. If you're using AmazonProvidedDNS in another Region, specify
     * <code>region.compute.internal</code> (for example, <code>ap-northeast-1.compute.internal</code>). Otherwise,
     * specify a domain name (for example, <code>MyCompany.com</code>). This value is used to complete unqualified DNS
     * hostnames. <b>Important</b>: Some Linux operating systems accept multiple domain names separated by spaces.
     * However, Windows and other Linux operating systems treat the value as a single domain, which results in
     * unexpected behavior. If your DHCP options set is associated with a VPC that has instances with multiple operating
     * systems, specify only one domain name.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ntp-servers</code> - The IP addresses of up to four Network Time Protocol (NTP) servers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>netbios-name-servers</code> - The IP addresses of up to four NetBIOS name servers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>netbios-node-type</code> - The NetBIOS node type (1, 2, 4, or 8). We recommend that you specify 2
     * (broadcast and multicast are not currently supported). For more information about these node types, see <a
     * href="http://www.ietf.org/rfc/rfc2132.txt">RFC 2132</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Your VPC automatically starts out with a set of DHCP options that includes only a DNS server that we provide
     * (AmazonProvidedDNS). If you create a set of options, and if your VPC has an internet gateway, make sure to set
     * the <code>domain-name-servers</code> option either to <code>AmazonProvidedDNS</code> or to a domain name server
     * of your choice. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP Options Sets</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param createDhcpOptionsRequest
     * @return A Java Future containing the result of the CreateDhcpOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateDhcpOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDhcpOptionsResponse> createDhcpOptions(CreateDhcpOptionsRequest createDhcpOptionsRequest) {
        try {

            HttpResponseHandler<CreateDhcpOptionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateDhcpOptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateDhcpOptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDhcpOptionsRequest, CreateDhcpOptionsResponse>()
                            .withOperationName("CreateDhcpOptions")
                            .withMarshaller(new CreateDhcpOptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createDhcpOptionsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * [IPv6 only] Creates an egress-only internet gateway for your VPC. An egress-only internet gateway is used to
     * enable outbound communication over IPv6 from instances in your VPC to the internet, and prevents hosts outside of
     * your VPC from initiating an IPv6 connection with your instance.
     * </p>
     *
     * @param createEgressOnlyInternetGatewayRequest
     * @return A Java Future containing the result of the CreateEgressOnlyInternetGateway operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateEgressOnlyInternetGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateEgressOnlyInternetGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEgressOnlyInternetGatewayResponse> createEgressOnlyInternetGateway(
            CreateEgressOnlyInternetGatewayRequest createEgressOnlyInternetGatewayRequest) {
        try {

            HttpResponseHandler<CreateEgressOnlyInternetGatewayResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateEgressOnlyInternetGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateEgressOnlyInternetGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEgressOnlyInternetGatewayRequest, CreateEgressOnlyInternetGatewayResponse>()
                            .withOperationName("CreateEgressOnlyInternetGateway")
                            .withMarshaller(new CreateEgressOnlyInternetGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createEgressOnlyInternetGatewayRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Launches an EC2 Fleet.
     * </p>
     * <p>
     * You can create a single EC2 Fleet that includes multiple launch specifications that vary by instance type, AMI,
     * Availability Zone, or subnet.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html">Launching
     * an EC2 Fleet</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createFleetRequest
     * @return A Java Future containing the result of the CreateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFleetResponse> createFleet(CreateFleetRequest createFleetRequest) {
        try {

            HttpResponseHandler<CreateFleetResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateFleetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateFleetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFleetRequest, CreateFleetResponse>()
                            .withOperationName("CreateFleet").withMarshaller(new CreateFleetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createFleetRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates one or more flow logs to capture information about IP traffic for a specific network interface, subnet,
     * or VPC.
     * </p>
     * <p>
     * Flow log data for a monitored network interface is recorded as flow log records, which are log events consisting
     * of fields that describe the traffic flow. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records">Flow Log Records</a> in
     * the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <p>
     * When publishing to CloudWatch Logs, flow log records are published to a log group, and each network interface has
     * a unique log stream in the log group. When publishing to Amazon S3, flow log records for all of the monitored
     * network interfaces are published to a single log file object that is stored in the specified bucket.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html">VPC Flow
     * Logs</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param createFlowLogsRequest
     * @return A Java Future containing the result of the CreateFlowLogs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateFlowLogs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFlowLogs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFlowLogsResponse> createFlowLogs(CreateFlowLogsRequest createFlowLogsRequest) {
        try {

            HttpResponseHandler<CreateFlowLogsResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateFlowLogsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateFlowLogsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFlowLogsRequest, CreateFlowLogsResponse>()
                            .withOperationName("CreateFlowLogs")
                            .withMarshaller(new CreateFlowLogsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createFlowLogsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon FPGA Image (AFI) from the specified design checkpoint (DCP).
     * </p>
     * <p>
     * The create operation is asynchronous. To verify that the AFI is ready for use, check the output logs.
     * </p>
     * <p>
     * An AFI contains the FPGA bitstream that is ready to download to an FPGA. You can securely deploy an AFI on
     * multiple FPGA-accelerated instances. For more information, see the <a href="https://github.com/aws/aws-fpga/">AWS
     * FPGA Hardware Development Kit</a>.
     * </p>
     *
     * @param createFpgaImageRequest
     * @return A Java Future containing the result of the CreateFpgaImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateFpgaImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFpgaImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFpgaImageResponse> createFpgaImage(CreateFpgaImageRequest createFpgaImageRequest) {
        try {

            HttpResponseHandler<CreateFpgaImageResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateFpgaImageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateFpgaImageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFpgaImageRequest, CreateFpgaImageResponse>()
                            .withOperationName("CreateFpgaImage")
                            .withMarshaller(new CreateFpgaImageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createFpgaImageRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance that is either running or stopped.
     * </p>
     * <p>
     * If you customized your instance with instance store volumes or EBS volumes in addition to the root device volume,
     * the new AMI contains block device mapping information for those volumes. When you launch an instance from this
     * new AMI, the instance automatically launches with those additional volumes.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html">Creating Amazon EBS-Backed
     * Linux AMIs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createImageRequest
     * @return A Java Future containing the result of the CreateImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateImageResponse> createImage(CreateImageRequest createImageRequest) {
        try {

            HttpResponseHandler<CreateImageResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateImageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateImageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateImageRequest, CreateImageResponse>()
                            .withOperationName("CreateImage").withMarshaller(new CreateImageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createImageRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Exports a running or stopped instance to an Amazon S3 bucket.
     * </p>
     * <p>
     * For information about the supported operating systems, image formats, and known limitations for the types of
     * instances you can export, see <a
     * href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport.html">Exporting an Instance as a VM Using
     * VM Import/Export</a> in the <i>VM Import/Export User Guide</i>.
     * </p>
     *
     * @param createInstanceExportTaskRequest
     * @return A Java Future containing the result of the CreateInstanceExportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateInstanceExportTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceExportTask" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInstanceExportTaskResponse> createInstanceExportTask(
            CreateInstanceExportTaskRequest createInstanceExportTaskRequest) {
        try {

            HttpResponseHandler<CreateInstanceExportTaskResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateInstanceExportTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateInstanceExportTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateInstanceExportTaskRequest, CreateInstanceExportTaskResponse>()
                            .withOperationName("CreateInstanceExportTask")
                            .withMarshaller(new CreateInstanceExportTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createInstanceExportTaskRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an internet gateway for use with a VPC. After creating the internet gateway, you attach it to a VPC using
     * <a>AttachInternetGateway</a>.
     * </p>
     * <p>
     * For more information about your VPC and internet gateway, see the <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/">Amazon Virtual Private Cloud User Guide</a>.
     * </p>
     *
     * @param createInternetGatewayRequest
     * @return A Java Future containing the result of the CreateInternetGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateInternetGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInternetGatewayResponse> createInternetGateway(
            CreateInternetGatewayRequest createInternetGatewayRequest) {
        try {

            HttpResponseHandler<CreateInternetGatewayResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateInternetGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateInternetGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateInternetGatewayRequest, CreateInternetGatewayResponse>()
                            .withOperationName("CreateInternetGateway")
                            .withMarshaller(new CreateInternetGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createInternetGatewayRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a 2048-bit RSA key pair with the specified name. Amazon EC2 stores the public key and displays the
     * private key for you to save to a file. The private key is returned as an unencrypted PEM encoded PKCS#1 private
     * key. If a key with the specified name already exists, Amazon EC2 returns an error.
     * </p>
     * <p>
     * You can have up to five thousand key pairs per Region.
     * </p>
     * <p>
     * The key pair returned to you is available only in the Region in which you create it. If you prefer, you can
     * create your own key pair using a third-party tool and upload it to any Region using <a>ImportKeyPair</a>.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Key
     * Pairs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createKeyPairRequest
     * @return A Java Future containing the result of the CreateKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateKeyPairResponse> createKeyPair(CreateKeyPairRequest createKeyPairRequest) {
        try {

            HttpResponseHandler<CreateKeyPairResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateKeyPairResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateKeyPairResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateKeyPairRequest, CreateKeyPairResponse>()
                            .withOperationName("CreateKeyPair")
                            .withMarshaller(new CreateKeyPairRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createKeyPairRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a launch template. A launch template contains the parameters to launch an instance. When you launch an
     * instance using <a>RunInstances</a>, you can specify a launch template instead of providing the launch parameters
     * in the request. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">Launching an instance from a
     * launch template</a>in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createLaunchTemplateRequest
     * @return A Java Future containing the result of the CreateLaunchTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateLaunchTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLaunchTemplateResponse> createLaunchTemplate(
            CreateLaunchTemplateRequest createLaunchTemplateRequest) {
        try {

            HttpResponseHandler<CreateLaunchTemplateResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateLaunchTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateLaunchTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateLaunchTemplateRequest, CreateLaunchTemplateResponse>()
                            .withOperationName("CreateLaunchTemplate")
                            .withMarshaller(new CreateLaunchTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createLaunchTemplateRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new version for a launch template. You can specify an existing version of launch template from which to
     * base the new version.
     * </p>
     * <p>
     * Launch template versions are numbered in the order in which they are created. You cannot specify, change, or
     * replace the numbering of launch template versions.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#manage-launch-template-versions"
     * >Managing launch template versions</a>in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createLaunchTemplateVersionRequest
     * @return A Java Future containing the result of the CreateLaunchTemplateVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateLaunchTemplateVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplateVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLaunchTemplateVersionResponse> createLaunchTemplateVersion(
            CreateLaunchTemplateVersionRequest createLaunchTemplateVersionRequest) {
        try {

            HttpResponseHandler<CreateLaunchTemplateVersionResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateLaunchTemplateVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateLaunchTemplateVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateLaunchTemplateVersionRequest, CreateLaunchTemplateVersionResponse>()
                            .withOperationName("CreateLaunchTemplateVersion")
                            .withMarshaller(new CreateLaunchTemplateVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createLaunchTemplateVersionRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a static route for the specified local gateway route table.
     * </p>
     *
     * @param createLocalGatewayRouteRequest
     * @return A Java Future containing the result of the CreateLocalGatewayRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateLocalGatewayRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLocalGatewayRouteResponse> createLocalGatewayRoute(
            CreateLocalGatewayRouteRequest createLocalGatewayRouteRequest) {
        try {

            HttpResponseHandler<CreateLocalGatewayRouteResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateLocalGatewayRouteResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateLocalGatewayRouteResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateLocalGatewayRouteRequest, CreateLocalGatewayRouteResponse>()
                            .withOperationName("CreateLocalGatewayRoute")
                            .withMarshaller(new CreateLocalGatewayRouteRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createLocalGatewayRouteRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates the specified VPC with the specified local gateway route table.
     * </p>
     *
     * @param createLocalGatewayRouteTableVpcAssociationRequest
     * @return A Java Future containing the result of the CreateLocalGatewayRouteTableVpcAssociation operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateLocalGatewayRouteTableVpcAssociation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTableVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLocalGatewayRouteTableVpcAssociationResponse> createLocalGatewayRouteTableVpcAssociation(
            CreateLocalGatewayRouteTableVpcAssociationRequest createLocalGatewayRouteTableVpcAssociationRequest) {
        try {

            HttpResponseHandler<CreateLocalGatewayRouteTableVpcAssociationResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateLocalGatewayRouteTableVpcAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateLocalGatewayRouteTableVpcAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateLocalGatewayRouteTableVpcAssociationRequest, CreateLocalGatewayRouteTableVpcAssociationResponse>()
                            .withOperationName("CreateLocalGatewayRouteTableVpcAssociation")
                            .withMarshaller(new CreateLocalGatewayRouteTableVpcAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createLocalGatewayRouteTableVpcAssociationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a NAT gateway in the specified public subnet. This action creates a network interface in the specified
     * subnet with a private IP address from the IP address range of the subnet. Internet-bound traffic from a private
     * subnet can be routed to the NAT gateway, therefore enabling instances in the private subnet to connect to the
     * internet. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html">NAT Gateways</a> in the <i>Amazon
     * Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param createNatGatewayRequest
     * @return A Java Future containing the result of the CreateNatGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateNatGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNatGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNatGatewayResponse> createNatGateway(CreateNatGatewayRequest createNatGatewayRequest) {
        try {

            HttpResponseHandler<CreateNatGatewayResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateNatGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateNatGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateNatGatewayRequest, CreateNatGatewayResponse>()
                            .withOperationName("CreateNatGateway")
                            .withMarshaller(new CreateNatGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createNatGatewayRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a network ACL in a VPC. Network ACLs provide an optional layer of security (in addition to security
     * groups) for the instances in your VPC.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html">Network
     * ACLs</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param createNetworkAclRequest
     * @return A Java Future containing the result of the CreateNetworkAcl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateNetworkAcl
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAcl" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNetworkAclResponse> createNetworkAcl(CreateNetworkAclRequest createNetworkAclRequest) {
        try {

            HttpResponseHandler<CreateNetworkAclResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateNetworkAclResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateNetworkAclResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateNetworkAclRequest, CreateNetworkAclResponse>()
                            .withOperationName("CreateNetworkAcl")
                            .withMarshaller(new CreateNetworkAclRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createNetworkAclRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an entry (a rule) in a network ACL with the specified rule number. Each network ACL has a set of numbered
     * ingress rules and a separate set of numbered egress rules. When determining whether a packet should be allowed in
     * or out of a subnet associated with the ACL, we process the entries in the ACL according to the rule numbers, in
     * ascending order. Each network ACL has a set of ingress rules and a separate set of egress rules.
     * </p>
     * <p>
     * We recommend that you leave room between the rule numbers (for example, 100, 110, 120, ...), and not number them
     * one right after the other (for example, 101, 102, 103, ...). This makes it easier to add a rule between existing
     * ones without having to renumber the rules.
     * </p>
     * <p>
     * After you add an entry, you can't modify it; you must either replace it, or create an entry and delete the old
     * one.
     * </p>
     * <p>
     * For more information about network ACLs, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html">Network ACLs</a> in the <i>Amazon Virtual
     * Private Cloud User Guide</i>.
     * </p>
     *
     * @param createNetworkAclEntryRequest
     * @return A Java Future containing the result of the CreateNetworkAclEntry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateNetworkAclEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAclEntry" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNetworkAclEntryResponse> createNetworkAclEntry(
            CreateNetworkAclEntryRequest createNetworkAclEntryRequest) {
        try {

            HttpResponseHandler<CreateNetworkAclEntryResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateNetworkAclEntryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateNetworkAclEntryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateNetworkAclEntryRequest, CreateNetworkAclEntryResponse>()
                            .withOperationName("CreateNetworkAclEntry")
                            .withMarshaller(new CreateNetworkAclEntryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createNetworkAclEntryRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a network interface in the specified subnet.
     * </p>
     * <p>
     * For more information about network interfaces, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html">Elastic Network Interfaces</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param createNetworkInterfaceRequest
     *        Contains the parameters for CreateNetworkInterface.
     * @return A Java Future containing the result of the CreateNetworkInterface operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateNetworkInterface
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterface" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNetworkInterfaceResponse> createNetworkInterface(
            CreateNetworkInterfaceRequest createNetworkInterfaceRequest) {
        try {

            HttpResponseHandler<CreateNetworkInterfaceResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateNetworkInterfaceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateNetworkInterfaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateNetworkInterfaceRequest, CreateNetworkInterfaceResponse>()
                            .withOperationName("CreateNetworkInterface")
                            .withMarshaller(new CreateNetworkInterfaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createNetworkInterfaceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Grants an AWS-authorized account permission to attach the specified network interface to an instance in their
     * account.
     * </p>
     * <p>
     * You can grant permission to a single AWS account only, and only one account at a time.
     * </p>
     *
     * @param createNetworkInterfacePermissionRequest
     *        Contains the parameters for CreateNetworkInterfacePermission.
     * @return A Java Future containing the result of the CreateNetworkInterfacePermission operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateNetworkInterfacePermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterfacePermission"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNetworkInterfacePermissionResponse> createNetworkInterfacePermission(
            CreateNetworkInterfacePermissionRequest createNetworkInterfacePermissionRequest) {
        try {

            HttpResponseHandler<CreateNetworkInterfacePermissionResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateNetworkInterfacePermissionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateNetworkInterfacePermissionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateNetworkInterfacePermissionRequest, CreateNetworkInterfacePermissionResponse>()
                            .withOperationName("CreateNetworkInterfacePermission")
                            .withMarshaller(new CreateNetworkInterfacePermissionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createNetworkInterfacePermissionRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a placement group in which to launch instances. The strategy of the placement group determines how the
     * instances are organized within the group.
     * </p>
     * <p>
     * A <code>cluster</code> placement group is a logical grouping of instances within a single Availability Zone that
     * benefit from low network latency, high network throughput. A <code>spread</code> placement group places instances
     * on distinct hardware. A <code>partition</code> placement group places groups of instances in different
     * partitions, where instances in one partition do not share the same hardware with instances in another partition.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement Groups</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createPlacementGroupRequest
     * @return A Java Future containing the result of the CreatePlacementGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreatePlacementGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePlacementGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePlacementGroupResponse> createPlacementGroup(
            CreatePlacementGroupRequest createPlacementGroupRequest) {
        try {

            HttpResponseHandler<CreatePlacementGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreatePlacementGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreatePlacementGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePlacementGroupRequest, CreatePlacementGroupResponse>()
                            .withOperationName("CreatePlacementGroup")
                            .withMarshaller(new CreatePlacementGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createPlacementGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a listing for Amazon EC2 Standard Reserved Instances to be sold in the Reserved Instance Marketplace. You
     * can submit one Standard Reserved Instance listing at a time. To get a list of your Standard Reserved Instances,
     * you can use the <a>DescribeReservedInstances</a> operation.
     * </p>
     * <note>
     * <p>
     * Only Standard Reserved Instances can be sold in the Reserved Instance Marketplace. Convertible Reserved Instances
     * cannot be sold.
     * </p>
     * </note>
     * <p>
     * The Reserved Instance Marketplace matches sellers who want to resell Standard Reserved Instance capacity that
     * they no longer need with buyers who want to purchase additional capacity. Reserved Instances bought and sold
     * through the Reserved Instance Marketplace work like any other Reserved Instances.
     * </p>
     * <p>
     * To sell your Standard Reserved Instances, you must first register as a seller in the Reserved Instance
     * Marketplace. After completing the registration process, you can create a Reserved Instance Marketplace listing of
     * some or all of your Standard Reserved Instances, and specify the upfront price to receive for them. Your Standard
     * Reserved Instance listings then become available for purchase. To view the details of your Standard Reserved
     * Instance listing, you can use the <a>DescribeReservedInstancesListings</a> operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance
     * Marketplace</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createReservedInstancesListingRequest
     *        Contains the parameters for CreateReservedInstancesListing.
     * @return A Java Future containing the result of the CreateReservedInstancesListing operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateReservedInstancesListing
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReservedInstancesListing"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateReservedInstancesListingResponse> createReservedInstancesListing(
            CreateReservedInstancesListingRequest createReservedInstancesListingRequest) {
        try {

            HttpResponseHandler<CreateReservedInstancesListingResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateReservedInstancesListingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateReservedInstancesListingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateReservedInstancesListingRequest, CreateReservedInstancesListingResponse>()
                            .withOperationName("CreateReservedInstancesListing")
                            .withMarshaller(new CreateReservedInstancesListingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createReservedInstancesListingRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a route in a route table within a VPC.
     * </p>
     * <p>
     * You must specify one of the following targets: internet gateway or virtual private gateway, NAT instance, NAT
     * gateway, VPC peering connection, network interface, egress-only internet gateway, or transit gateway.
     * </p>
     * <p>
     * When determining how to route traffic, we use the route with the most specific match. For example, traffic is
     * destined for the IPv4 address <code>192.0.2.3</code>, and the route table includes the following two IPv4 routes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>192.0.2.0/24</code> (goes to some target A)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>192.0.2.0/28</code> (goes to some target B)
     * </p>
     * </li>
     * </ul>
     * <p>
     * Both routes apply to the traffic destined for <code>192.0.2.3</code>. However, the second route in the list
     * covers a smaller number of IP addresses and is therefore more specific, so we use that route to determine where
     * to target the traffic.
     * </p>
     * <p>
     * For more information about route tables, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route Tables</a> in the <i>Amazon
     * Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param createRouteRequest
     * @return A Java Future containing the result of the CreateRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRoute" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRouteResponse> createRoute(CreateRouteRequest createRouteRequest) {
        try {

            HttpResponseHandler<CreateRouteResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateRouteResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateRouteResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRouteRequest, CreateRouteResponse>()
                            .withOperationName("CreateRoute").withMarshaller(new CreateRouteRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createRouteRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a route table for the specified VPC. After you create a route table, you can add routes and associate the
     * table with a subnet.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route
     * Tables</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param createRouteTableRequest
     * @return A Java Future containing the result of the CreateRouteTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateRouteTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteTable" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRouteTableResponse> createRouteTable(CreateRouteTableRequest createRouteTableRequest) {
        try {

            HttpResponseHandler<CreateRouteTableResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateRouteTableResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateRouteTableResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRouteTableRequest, CreateRouteTableResponse>()
                            .withOperationName("CreateRouteTable")
                            .withMarshaller(new CreateRouteTableRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createRouteTableRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a security group.
     * </p>
     * <p>
     * A security group acts as a virtual firewall for your instance to control inbound and outbound traffic. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon
     * EC2 Security Groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for Your
     * VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <p>
     * When you create a security group, you specify a friendly name of your choice. You can have a security group for
     * use in EC2-Classic with the same name as a security group for use in a VPC. However, you can't have two security
     * groups for use in EC2-Classic with the same name or two security groups for use in a VPC with the same name.
     * </p>
     * <p>
     * You have a default security group for use in EC2-Classic and a default security group for use in your VPC. If you
     * don't specify a security group when you launch an instance, the instance is launched into the appropriate default
     * security group. A default security group includes a default rule that grants instances unrestricted network
     * access to each other.
     * </p>
     * <p>
     * You can add or remove rules from your security groups using <a>AuthorizeSecurityGroupIngress</a>,
     * <a>AuthorizeSecurityGroupEgress</a>, <a>RevokeSecurityGroupIngress</a>, and <a>RevokeSecurityGroupEgress</a>.
     * </p>
     * <p>
     * For more information about VPC security group limits, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC Limits</a>.
     * </p>
     *
     * @param createSecurityGroupRequest
     * @return A Java Future containing the result of the CreateSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateSecurityGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSecurityGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSecurityGroupResponse> createSecurityGroup(
            CreateSecurityGroupRequest createSecurityGroupRequest) {
        try {

            HttpResponseHandler<CreateSecurityGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateSecurityGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateSecurityGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSecurityGroupRequest, CreateSecurityGroupResponse>()
                            .withOperationName("CreateSecurityGroup")
                            .withMarshaller(new CreateSecurityGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createSecurityGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a snapshot of an EBS volume and stores it in Amazon S3. You can use snapshots for backups, to make copies
     * of EBS volumes, and to save data before shutting down an instance.
     * </p>
     * <p>
     * When a snapshot is created, any AWS Marketplace product codes that are associated with the source volume are
     * propagated to the snapshot.
     * </p>
     * <p>
     * You can take a snapshot of an attached volume that is in use. However, snapshots only capture data that has been
     * written to your EBS volume at the time the snapshot command is issued; this may exclude any data that has been
     * cached by any applications or the operating system. If you can pause any file systems on the volume long enough
     * to take a snapshot, your snapshot should be complete. However, if you cannot pause all file writes to the volume,
     * you should unmount the volume from within the instance, issue the snapshot command, and then remount the volume
     * to ensure a consistent and complete snapshot. You may remount and use your volume while the snapshot status is
     * <code>pending</code>.
     * </p>
     * <p>
     * To create a snapshot for EBS volumes that serve as root devices, you should stop the instance before taking the
     * snapshot.
     * </p>
     * <p>
     * Snapshots that are taken from encrypted volumes are automatically encrypted. Volumes that are created from
     * encrypted snapshots are also automatically encrypted. Your encrypted volumes and any associated snapshots always
     * remain protected.
     * </p>
     * <p>
     * You can tag your snapshots during creation. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Amazon EC2 Resources</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AmazonEBS.html">Amazon
     * Elastic Block Store</a> and <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createSnapshotRequest
     * @return A Java Future containing the result of the CreateSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSnapshotResponse> createSnapshot(CreateSnapshotRequest createSnapshotRequest) {
        try {

            HttpResponseHandler<CreateSnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSnapshotRequest, CreateSnapshotResponse>()
                            .withOperationName("CreateSnapshot")
                            .withMarshaller(new CreateSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createSnapshotRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates crash-consistent snapshots of multiple EBS volumes and stores the data in S3. Volumes are chosen by
     * specifying an instance. Any attached volumes will produce one snapshot each that is crash-consistent across the
     * instance. Boot volumes can be excluded by changing the parameters.
     * </p>
     *
     * @param createSnapshotsRequest
     * @return A Java Future containing the result of the CreateSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSnapshotsResponse> createSnapshots(CreateSnapshotsRequest createSnapshotsRequest) {
        try {

            HttpResponseHandler<CreateSnapshotsResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateSnapshotsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateSnapshotsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSnapshotsRequest, CreateSnapshotsResponse>()
                            .withOperationName("CreateSnapshots")
                            .withMarshaller(new CreateSnapshotsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createSnapshotsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a data feed for Spot Instances, enabling you to view Spot Instance usage logs. You can create one data
     * feed per AWS account. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html">Spot Instance Data Feed</a> in
     * the <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     *
     * @param createSpotDatafeedSubscriptionRequest
     *        Contains the parameters for CreateSpotDatafeedSubscription.
     * @return A Java Future containing the result of the CreateSpotDatafeedSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateSpotDatafeedSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSpotDatafeedSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSpotDatafeedSubscriptionResponse> createSpotDatafeedSubscription(
            CreateSpotDatafeedSubscriptionRequest createSpotDatafeedSubscriptionRequest) {
        try {

            HttpResponseHandler<CreateSpotDatafeedSubscriptionResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateSpotDatafeedSubscriptionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateSpotDatafeedSubscriptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSpotDatafeedSubscriptionRequest, CreateSpotDatafeedSubscriptionResponse>()
                            .withOperationName("CreateSpotDatafeedSubscription")
                            .withMarshaller(new CreateSpotDatafeedSubscriptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createSpotDatafeedSubscriptionRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a subnet in an existing VPC.
     * </p>
     * <p>
     * When you create each subnet, you provide the VPC ID and IPv4 CIDR block for the subnet. After you create a
     * subnet, you can't change its CIDR block. The size of the subnet's IPv4 CIDR block can be the same as a VPC's IPv4
     * CIDR block, or a subset of a VPC's IPv4 CIDR block. If you create more than one subnet in a VPC, the subnets'
     * CIDR blocks must not overlap. The smallest IPv4 subnet (and VPC) you can create uses a /28 netmask (16 IPv4
     * addresses), and the largest uses a /16 netmask (65,536 IPv4 addresses).
     * </p>
     * <p>
     * If you've associated an IPv6 CIDR block with your VPC, you can create a subnet with an IPv6 CIDR block that uses
     * a /64 prefix length.
     * </p>
     * <important>
     * <p>
     * AWS reserves both the first four and the last IPv4 address in each subnet's CIDR block. They're not available for
     * use.
     * </p>
     * </important>
     * <p>
     * If you add more than one subnet to a VPC, they're set up in a star topology with a logical router in the middle.
     * </p>
     * <p>
     * If you launch an instance in a VPC using an Amazon EBS-backed AMI, the IP address doesn't change if you stop and
     * restart the instance (unlike a similar instance launched outside a VPC, which gets a new IP address when
     * restarted). It's therefore possible to have a subnet with no running instances (they're all stopped), but no
     * remaining IP addresses available.
     * </p>
     * <p>
     * For more information about subnets, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Your VPC and Subnets</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param createSubnetRequest
     * @return A Java Future containing the result of the CreateSubnet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateSubnet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSubnetResponse> createSubnet(CreateSubnetRequest createSubnetRequest) {
        try {

            HttpResponseHandler<CreateSubnetResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateSubnetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateSubnetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSubnetRequest, CreateSubnetResponse>()
                            .withOperationName("CreateSubnet").withMarshaller(new CreateSubnetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createSubnetRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds or overwrites only the specified tags for the specified Amazon EC2 resource or resources. When you specify
     * an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of 50 tags.
     * Each tag consists of a key and optional value. Tag keys must be unique per resource.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Resources</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>. For more information about creating IAM policies that control
     * users' access to resources based on tags, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-iam-actions-resources.html">Supported
     * Resource-Level Permissions for Amazon EC2 API Actions</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createTagsRequest
     * @return A Java Future containing the result of the CreateTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTagsResponse> createTags(CreateTagsRequest createTagsRequest) {
        try {

            HttpResponseHandler<CreateTagsResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTagsRequest, CreateTagsResponse>().withOperationName("CreateTags")
                            .withMarshaller(new CreateTagsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createTagsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Traffic Mirror filter.
     * </p>
     * <p>
     * A Traffic Mirror filter is a set of rules that defines the traffic to mirror.
     * </p>
     * <p>
     * By default, no traffic is mirrored. To mirror traffic, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilterRule.htm"
     * >CreateTrafficMirrorFilterRule</a> to add Traffic Mirror rules to the filter. The rules you add define what
     * traffic gets mirrored. You can also use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTrafficMirrorFilterNetworkServices.html"
     * >ModifyTrafficMirrorFilterNetworkServices</a> to mirror supported network services.
     * </p>
     *
     * @param createTrafficMirrorFilterRequest
     * @return A Java Future containing the result of the CreateTrafficMirrorFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTrafficMirrorFilter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilter" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTrafficMirrorFilterResponse> createTrafficMirrorFilter(
            CreateTrafficMirrorFilterRequest createTrafficMirrorFilterRequest) {
        try {

            HttpResponseHandler<CreateTrafficMirrorFilterResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateTrafficMirrorFilterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateTrafficMirrorFilterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTrafficMirrorFilterRequest, CreateTrafficMirrorFilterResponse>()
                            .withOperationName("CreateTrafficMirrorFilter")
                            .withMarshaller(new CreateTrafficMirrorFilterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createTrafficMirrorFilterRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Traffic Mirror filter rule.
     * </p>
     * <p>
     * A Traffic Mirror rule defines the Traffic Mirror source traffic to mirror.
     * </p>
     * <p>
     * You need the Traffic Mirror filter ID when you create the rule.
     * </p>
     *
     * @param createTrafficMirrorFilterRuleRequest
     * @return A Java Future containing the result of the CreateTrafficMirrorFilterRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTrafficMirrorFilterRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilterRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTrafficMirrorFilterRuleResponse> createTrafficMirrorFilterRule(
            CreateTrafficMirrorFilterRuleRequest createTrafficMirrorFilterRuleRequest) {
        try {

            HttpResponseHandler<CreateTrafficMirrorFilterRuleResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateTrafficMirrorFilterRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateTrafficMirrorFilterRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTrafficMirrorFilterRuleRequest, CreateTrafficMirrorFilterRuleResponse>()
                            .withOperationName("CreateTrafficMirrorFilterRule")
                            .withMarshaller(new CreateTrafficMirrorFilterRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createTrafficMirrorFilterRuleRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Traffic Mirror session.
     * </p>
     * <p>
     * A Traffic Mirror session actively copies packets from a Traffic Mirror source to a Traffic Mirror target. Create
     * a filter, and then assign it to the session to define a subset of the traffic to mirror, for example all TCP
     * traffic.
     * </p>
     * <p>
     * The Traffic Mirror source and the Traffic Mirror target (monitoring appliances) can be in the same VPC, or in a
     * different VPC connected via VPC peering or a transit gateway.
     * </p>
     * <p>
     * By default, no traffic is mirrored. Use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilter.htm"
     * >CreateTrafficMirrorFilter</a> to create filter rules that specify the traffic to mirror.
     * </p>
     *
     * @param createTrafficMirrorSessionRequest
     * @return A Java Future containing the result of the CreateTrafficMirrorSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTrafficMirrorSession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorSession" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTrafficMirrorSessionResponse> createTrafficMirrorSession(
            CreateTrafficMirrorSessionRequest createTrafficMirrorSessionRequest) {
        try {

            HttpResponseHandler<CreateTrafficMirrorSessionResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateTrafficMirrorSessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateTrafficMirrorSessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTrafficMirrorSessionRequest, CreateTrafficMirrorSessionResponse>()
                            .withOperationName("CreateTrafficMirrorSession")
                            .withMarshaller(new CreateTrafficMirrorSessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createTrafficMirrorSessionRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a target for your Traffic Mirror session.
     * </p>
     * <p>
     * A Traffic Mirror target is the destination for mirrored traffic. The Traffic Mirror source and the Traffic Mirror
     * target (monitoring appliances) can be in the same VPC, or in different VPCs connected via VPC peering or a
     * transit gateway.
     * </p>
     * <p>
     * A Traffic Mirror target can be a network interface, or a Network Load Balancer.
     * </p>
     * <p>
     * To use the target in a Traffic Mirror session, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorSession.htm"
     * >CreateTrafficMirrorSession</a>.
     * </p>
     *
     * @param createTrafficMirrorTargetRequest
     * @return A Java Future containing the result of the CreateTrafficMirrorTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTrafficMirrorTarget
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorTarget" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTrafficMirrorTargetResponse> createTrafficMirrorTarget(
            CreateTrafficMirrorTargetRequest createTrafficMirrorTargetRequest) {
        try {

            HttpResponseHandler<CreateTrafficMirrorTargetResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateTrafficMirrorTargetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateTrafficMirrorTargetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTrafficMirrorTargetRequest, CreateTrafficMirrorTargetResponse>()
                            .withOperationName("CreateTrafficMirrorTarget")
                            .withMarshaller(new CreateTrafficMirrorTargetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createTrafficMirrorTargetRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a transit gateway.
     * </p>
     * <p>
     * You can use a transit gateway to interconnect your virtual private clouds (VPC) and on-premises networks. After
     * the transit gateway enters the <code>available</code> state, you can attach your VPCs and VPN connections to the
     * transit gateway.
     * </p>
     * <p>
     * To attach your VPCs, use <a>CreateTransitGatewayVpcAttachment</a>.
     * </p>
     * <p>
     * To attach a VPN connection, use <a>CreateCustomerGateway</a> to create a customer gateway and specify the ID of
     * the customer gateway and the ID of the transit gateway in a call to <a>CreateVpnConnection</a>.
     * </p>
     * <p>
     * When you create a transit gateway, we create a default transit gateway route table and use it as the default
     * association route table and the default propagation route table. You can use
     * <a>CreateTransitGatewayRouteTable</a> to create additional transit gateway route tables. If you disable automatic
     * route propagation, we do not create a default transit gateway route table. You can use
     * <a>EnableTransitGatewayRouteTablePropagation</a> to propagate routes from a resource attachment to a transit
     * gateway route table. If you disable automatic associations, you can use <a>AssociateTransitGatewayRouteTable</a>
     * to associate a resource attachment with a transit gateway route table.
     * </p>
     *
     * @param createTransitGatewayRequest
     * @return A Java Future containing the result of the CreateTransitGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTransitGatewayResponse> createTransitGateway(
            CreateTransitGatewayRequest createTransitGatewayRequest) {
        try {

            HttpResponseHandler<CreateTransitGatewayResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateTransitGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateTransitGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTransitGatewayRequest, CreateTransitGatewayResponse>()
                            .withOperationName("CreateTransitGateway")
                            .withMarshaller(new CreateTransitGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createTransitGatewayRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a multicast domain using the specified transit gateway.
     * </p>
     * <p>
     * The transit gateway must be in the available state before you create a domain. Use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGateways.html"
     * >DescribeTransitGateways</a> to see the state of transit gateway.
     * </p>
     *
     * @param createTransitGatewayMulticastDomainRequest
     * @return A Java Future containing the result of the CreateTransitGatewayMulticastDomain operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGatewayMulticastDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayMulticastDomain"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTransitGatewayMulticastDomainResponse> createTransitGatewayMulticastDomain(
            CreateTransitGatewayMulticastDomainRequest createTransitGatewayMulticastDomainRequest) {
        try {

            HttpResponseHandler<CreateTransitGatewayMulticastDomainResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateTransitGatewayMulticastDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateTransitGatewayMulticastDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTransitGatewayMulticastDomainRequest, CreateTransitGatewayMulticastDomainResponse>()
                            .withOperationName("CreateTransitGatewayMulticastDomain")
                            .withMarshaller(new CreateTransitGatewayMulticastDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createTransitGatewayMulticastDomainRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Requests a transit gateway peering attachment between the specified transit gateway (requester) and a peer
     * transit gateway (accepter). The transit gateways must be in different Regions. The peer transit gateway can be in
     * your account or a different AWS account.
     * </p>
     * <p>
     * After you create the peering attachment, the owner of the accepter transit gateway must accept the attachment
     * request.
     * </p>
     *
     * @param createTransitGatewayPeeringAttachmentRequest
     * @return A Java Future containing the result of the CreateTransitGatewayPeeringAttachment operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGatewayPeeringAttachment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPeeringAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTransitGatewayPeeringAttachmentResponse> createTransitGatewayPeeringAttachment(
            CreateTransitGatewayPeeringAttachmentRequest createTransitGatewayPeeringAttachmentRequest) {
        try {

            HttpResponseHandler<CreateTransitGatewayPeeringAttachmentResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateTransitGatewayPeeringAttachmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateTransitGatewayPeeringAttachmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTransitGatewayPeeringAttachmentRequest, CreateTransitGatewayPeeringAttachmentResponse>()
                            .withOperationName("CreateTransitGatewayPeeringAttachment")
                            .withMarshaller(new CreateTransitGatewayPeeringAttachmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createTransitGatewayPeeringAttachmentRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a static route for the specified transit gateway route table.
     * </p>
     *
     * @param createTransitGatewayRouteRequest
     * @return A Java Future containing the result of the CreateTransitGatewayRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGatewayRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTransitGatewayRouteResponse> createTransitGatewayRoute(
            CreateTransitGatewayRouteRequest createTransitGatewayRouteRequest) {
        try {

            HttpResponseHandler<CreateTransitGatewayRouteResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateTransitGatewayRouteResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateTransitGatewayRouteResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTransitGatewayRouteRequest, CreateTransitGatewayRouteResponse>()
                            .withOperationName("CreateTransitGatewayRoute")
                            .withMarshaller(new CreateTransitGatewayRouteRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createTransitGatewayRouteRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a route table for the specified transit gateway.
     * </p>
     *
     * @param createTransitGatewayRouteTableRequest
     * @return A Java Future containing the result of the CreateTransitGatewayRouteTable operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGatewayRouteTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTransitGatewayRouteTableResponse> createTransitGatewayRouteTable(
            CreateTransitGatewayRouteTableRequest createTransitGatewayRouteTableRequest) {
        try {

            HttpResponseHandler<CreateTransitGatewayRouteTableResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateTransitGatewayRouteTableResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateTransitGatewayRouteTableResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTransitGatewayRouteTableRequest, CreateTransitGatewayRouteTableResponse>()
                            .withOperationName("CreateTransitGatewayRouteTable")
                            .withMarshaller(new CreateTransitGatewayRouteTableRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createTransitGatewayRouteTableRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches the specified VPC to the specified transit gateway.
     * </p>
     * <p>
     * If you attach a VPC with a CIDR range that overlaps the CIDR range of a VPC that is already attached, the new VPC
     * CIDR range is not propagated to the default propagation route table.
     * </p>
     * <p>
     * To send VPC traffic to an attached transit gateway, add a route to the VPC route table using <a>CreateRoute</a>.
     * </p>
     *
     * @param createTransitGatewayVpcAttachmentRequest
     * @return A Java Future containing the result of the CreateTransitGatewayVpcAttachment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateTransitGatewayVpcAttachment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTransitGatewayVpcAttachmentResponse> createTransitGatewayVpcAttachment(
            CreateTransitGatewayVpcAttachmentRequest createTransitGatewayVpcAttachmentRequest) {
        try {

            HttpResponseHandler<CreateTransitGatewayVpcAttachmentResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateTransitGatewayVpcAttachmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateTransitGatewayVpcAttachmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTransitGatewayVpcAttachmentRequest, CreateTransitGatewayVpcAttachmentResponse>()
                            .withOperationName("CreateTransitGatewayVpcAttachment")
                            .withMarshaller(new CreateTransitGatewayVpcAttachmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createTransitGatewayVpcAttachmentRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an EBS volume that can be attached to an instance in the same Availability Zone. The volume is created in
     * the regional endpoint that you send the HTTP request to. For more information see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
     * </p>
     * <p>
     * You can create a new empty volume or restore a volume from an EBS snapshot. Any AWS Marketplace product codes
     * from the snapshot are propagated to the volume.
     * </p>
     * <p>
     * You can create encrypted volumes. Encrypted volumes must be attached to instances that support Amazon EBS
     * encryption. Volumes that are created from encrypted snapshots are also automatically encrypted. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS
     * Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * You can tag your volumes during creation. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Amazon EC2 Resources</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-creating-volume.html">Creating an Amazon EBS
     * Volume</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createVolumeRequest
     * @return A Java Future containing the result of the CreateVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVolume
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVolume" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVolumeResponse> createVolume(CreateVolumeRequest createVolumeRequest) {
        try {

            HttpResponseHandler<CreateVolumeResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateVolumeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateVolumeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVolumeRequest, CreateVolumeResponse>()
                            .withOperationName("CreateVolume").withMarshaller(new CreateVolumeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createVolumeRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a VPC with the specified IPv4 CIDR block. The smallest VPC you can create uses a /28 netmask (16 IPv4
     * addresses), and the largest uses a /16 netmask (65,536 IPv4 addresses). For more information about how large to
     * make your VPC, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Your VPC and
     * Subnets</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <p>
     * You can optionally request an IPv6 CIDR block for the VPC. You can request an Amazon-provided IPv6 CIDR block
     * from Amazon's pool of IPv6 addresses, or an IPv6 CIDR block from an IPv6 address pool that you provisioned
     * through bring your own IP addresses (<a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">BYOIP</a>).
     * </p>
     * <p>
     * By default, each instance you launch in the VPC has the default DHCP options, which include only a default DNS
     * server that we provide (AmazonProvidedDNS). For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP Options Sets</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <p>
     * You can specify the instance tenancy value for the VPC when you create it. You can't change this value for the
     * VPC after you create it. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-instance.html">Dedicated Instances</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createVpcRequest
     * @return A Java Future containing the result of the CreateVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpc" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVpcResponse> createVpc(CreateVpcRequest createVpcRequest) {
        try {

            HttpResponseHandler<CreateVpcResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateVpcResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateVpcResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVpcRequest, CreateVpcResponse>().withOperationName("CreateVpc")
                            .withMarshaller(new CreateVpcRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createVpcRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a VPC endpoint for a specified service. An endpoint enables you to create a private connection between
     * your VPC and the service. The service may be provided by AWS, an AWS Marketplace Partner, or another AWS account.
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints.html">VPC
     * Endpoints</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <p>
     * A <code>gateway</code> endpoint serves as a target for a route in your route table for traffic destined for the
     * AWS service. You can specify an endpoint policy to attach to the endpoint, which will control access to the
     * service from your VPC. You can also specify the VPC route tables that use the endpoint.
     * </p>
     * <p>
     * An <code>interface</code> endpoint is a network interface in your subnet that serves as an endpoint for
     * communicating with the specified service. You can specify the subnets in which to create an endpoint, and the
     * security groups to associate with the endpoint network interface.
     * </p>
     * <p>
     * Use <a>DescribeVpcEndpointServices</a> to get a list of supported services.
     * </p>
     *
     * @param createVpcEndpointRequest
     *        Contains the parameters for CreateVpcEndpoint.
     * @return A Java Future containing the result of the CreateVpcEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVpcEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVpcEndpointResponse> createVpcEndpoint(CreateVpcEndpointRequest createVpcEndpointRequest) {
        try {

            HttpResponseHandler<CreateVpcEndpointResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateVpcEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateVpcEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVpcEndpointRequest, CreateVpcEndpointResponse>()
                            .withOperationName("CreateVpcEndpoint")
                            .withMarshaller(new CreateVpcEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createVpcEndpointRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a connection notification for a specified VPC endpoint or VPC endpoint service. A connection notification
     * notifies you of specific endpoint events. You must create an SNS topic to receive notifications. For more
     * information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Create a Topic</a> in the
     * <i>Amazon Simple Notification Service Developer Guide</i>.
     * </p>
     * <p>
     * You can create a connection notification for interface endpoints only.
     * </p>
     *
     * @param createVpcEndpointConnectionNotificationRequest
     * @return A Java Future containing the result of the CreateVpcEndpointConnectionNotification operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVpcEndpointConnectionNotification
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointConnectionNotification"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVpcEndpointConnectionNotificationResponse> createVpcEndpointConnectionNotification(
            CreateVpcEndpointConnectionNotificationRequest createVpcEndpointConnectionNotificationRequest) {
        try {

            HttpResponseHandler<CreateVpcEndpointConnectionNotificationResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateVpcEndpointConnectionNotificationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateVpcEndpointConnectionNotificationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVpcEndpointConnectionNotificationRequest, CreateVpcEndpointConnectionNotificationResponse>()
                            .withOperationName("CreateVpcEndpointConnectionNotification")
                            .withMarshaller(new CreateVpcEndpointConnectionNotificationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createVpcEndpointConnectionNotificationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a VPC endpoint service configuration to which service consumers (AWS accounts, IAM users, and IAM roles)
     * can connect. Service consumers can create an interface VPC endpoint to connect to your service.
     * </p>
     * <p>
     * To create an endpoint service configuration, you must first create a Network Load Balancer for your service. For
     * more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html">VPC
     * Endpoint Services</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <p>
     * If you set the private DNS name, you must prove that you own the private DNS domain name. For more information,
     * see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-services-dns-validation.html">VPC Endpoint
     * Service Private DNS Name Verification</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param createVpcEndpointServiceConfigurationRequest
     * @return A Java Future containing the result of the CreateVpcEndpointServiceConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVpcEndpointServiceConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointServiceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVpcEndpointServiceConfigurationResponse> createVpcEndpointServiceConfiguration(
            CreateVpcEndpointServiceConfigurationRequest createVpcEndpointServiceConfigurationRequest) {
        try {

            HttpResponseHandler<CreateVpcEndpointServiceConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateVpcEndpointServiceConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateVpcEndpointServiceConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVpcEndpointServiceConfigurationRequest, CreateVpcEndpointServiceConfigurationResponse>()
                            .withOperationName("CreateVpcEndpointServiceConfiguration")
                            .withMarshaller(new CreateVpcEndpointServiceConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createVpcEndpointServiceConfigurationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Requests a VPC peering connection between two VPCs: a requester VPC that you own and an accepter VPC with which
     * to create the connection. The accepter VPC can belong to another AWS account and can be in a different Region to
     * the requester VPC. The requester VPC and accepter VPC cannot have overlapping CIDR blocks.
     * </p>
     * <note>
     * <p>
     * Limitations and rules apply to a VPC peering connection. For more information, see the <a
     * href="https://docs.aws.amazon.com/vpc/latest/peering/vpc-peering-basics.html#vpc-peering-limitations"
     * >limitations</a> section in the <i>VPC Peering Guide</i>.
     * </p>
     * </note>
     * <p>
     * The owner of the accepter VPC must accept the peering request to activate the peering connection. The VPC peering
     * connection request expires after 7 days, after which it cannot be accepted or rejected.
     * </p>
     * <p>
     * If you create a VPC peering connection request between VPCs with overlapping CIDR blocks, the VPC peering
     * connection has a status of <code>failed</code>.
     * </p>
     *
     * @param createVpcPeeringConnectionRequest
     * @return A Java Future containing the result of the CreateVpcPeeringConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVpcPeeringConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcPeeringConnection" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVpcPeeringConnectionResponse> createVpcPeeringConnection(
            CreateVpcPeeringConnectionRequest createVpcPeeringConnectionRequest) {
        try {

            HttpResponseHandler<CreateVpcPeeringConnectionResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateVpcPeeringConnectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateVpcPeeringConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVpcPeeringConnectionRequest, CreateVpcPeeringConnectionResponse>()
                            .withOperationName("CreateVpcPeeringConnection")
                            .withMarshaller(new CreateVpcPeeringConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createVpcPeeringConnectionRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a VPN connection between an existing virtual private gateway and a VPN customer gateway. The supported
     * connection type is <code>ipsec.1</code>.
     * </p>
     * <p>
     * The response includes information that you need to give to your network administrator to configure your customer
     * gateway.
     * </p>
     * <important>
     * <p>
     * We strongly recommend that you use HTTPS when calling this operation because the response contains sensitive
     * cryptographic information for configuring your customer gateway.
     * </p>
     * </important>
     * <p>
     * If you decide to shut down your VPN connection for any reason and later create a new VPN connection, you must
     * reconfigure your customer gateway with the new information returned from this call.
     * </p>
     * <p>
     * This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">AWS Site-to-Site
     * VPN</a> in the <i>AWS Site-to-Site VPN User Guide</i>.
     * </p>
     *
     * @param createVpnConnectionRequest
     *        Contains the parameters for CreateVpnConnection.
     * @return A Java Future containing the result of the CreateVpnConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVpnConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnection" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVpnConnectionResponse> createVpnConnection(
            CreateVpnConnectionRequest createVpnConnectionRequest) {
        try {

            HttpResponseHandler<CreateVpnConnectionResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateVpnConnectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateVpnConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVpnConnectionRequest, CreateVpnConnectionResponse>()
                            .withOperationName("CreateVpnConnection")
                            .withMarshaller(new CreateVpnConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createVpnConnectionRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a static route associated with a VPN connection between an existing virtual private gateway and a VPN
     * customer gateway. The static route allows traffic to be routed from the virtual private gateway to the VPN
     * customer gateway.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">AWS Site-to-Site
     * VPN</a> in the <i>AWS Site-to-Site VPN User Guide</i>.
     * </p>
     *
     * @param createVpnConnectionRouteRequest
     *        Contains the parameters for CreateVpnConnectionRoute.
     * @return A Java Future containing the result of the CreateVpnConnectionRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVpnConnectionRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnectionRoute" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVpnConnectionRouteResponse> createVpnConnectionRoute(
            CreateVpnConnectionRouteRequest createVpnConnectionRouteRequest) {
        try {

            HttpResponseHandler<CreateVpnConnectionRouteResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateVpnConnectionRouteResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateVpnConnectionRouteResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVpnConnectionRouteRequest, CreateVpnConnectionRouteResponse>()
                            .withOperationName("CreateVpnConnectionRoute")
                            .withMarshaller(new CreateVpnConnectionRouteRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createVpnConnectionRouteRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a virtual private gateway. A virtual private gateway is the endpoint on the VPC side of your VPN
     * connection. You can create a virtual private gateway before creating the VPC itself.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">AWS Site-to-Site
     * VPN</a> in the <i>AWS Site-to-Site VPN User Guide</i>.
     * </p>
     *
     * @param createVpnGatewayRequest
     *        Contains the parameters for CreateVpnGateway.
     * @return A Java Future containing the result of the CreateVpnGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.CreateVpnGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVpnGatewayResponse> createVpnGateway(CreateVpnGatewayRequest createVpnGatewayRequest) {
        try {

            HttpResponseHandler<CreateVpnGatewayResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateVpnGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateVpnGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVpnGatewayRequest, CreateVpnGatewayResponse>()
                            .withOperationName("CreateVpnGateway")
                            .withMarshaller(new CreateVpnGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createVpnGatewayRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified Client VPN endpoint. You must disassociate all target networks before you can delete a
     * Client VPN endpoint.
     * </p>
     *
     * @param deleteClientVpnEndpointRequest
     * @return A Java Future containing the result of the DeleteClientVpnEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteClientVpnEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteClientVpnEndpointResponse> deleteClientVpnEndpoint(
            DeleteClientVpnEndpointRequest deleteClientVpnEndpointRequest) {
        try {

            HttpResponseHandler<DeleteClientVpnEndpointResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteClientVpnEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteClientVpnEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteClientVpnEndpointRequest, DeleteClientVpnEndpointResponse>()
                            .withOperationName("DeleteClientVpnEndpoint")
                            .withMarshaller(new DeleteClientVpnEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteClientVpnEndpointRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a route from a Client VPN endpoint. You can only delete routes that you manually added using the
     * <b>CreateClientVpnRoute</b> action. You cannot delete routes that were automatically added when associating a
     * subnet. To remove routes that have been automatically added, disassociate the target subnet from the Client VPN
     * endpoint.
     * </p>
     *
     * @param deleteClientVpnRouteRequest
     * @return A Java Future containing the result of the DeleteClientVpnRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteClientVpnRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnRoute" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteClientVpnRouteResponse> deleteClientVpnRoute(
            DeleteClientVpnRouteRequest deleteClientVpnRouteRequest) {
        try {

            HttpResponseHandler<DeleteClientVpnRouteResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteClientVpnRouteResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteClientVpnRouteResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteClientVpnRouteRequest, DeleteClientVpnRouteResponse>()
                            .withOperationName("DeleteClientVpnRoute")
                            .withMarshaller(new DeleteClientVpnRouteRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteClientVpnRouteRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified customer gateway. You must delete the VPN connection before you can delete the customer
     * gateway.
     * </p>
     *
     * @param deleteCustomerGatewayRequest
     *        Contains the parameters for DeleteCustomerGateway.
     * @return A Java Future containing the result of the DeleteCustomerGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteCustomerGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCustomerGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCustomerGatewayResponse> deleteCustomerGateway(
            DeleteCustomerGatewayRequest deleteCustomerGatewayRequest) {
        try {

            HttpResponseHandler<DeleteCustomerGatewayResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteCustomerGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteCustomerGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCustomerGatewayRequest, DeleteCustomerGatewayResponse>()
                            .withOperationName("DeleteCustomerGateway")
                            .withMarshaller(new DeleteCustomerGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteCustomerGatewayRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified set of DHCP options. You must disassociate the set of DHCP options before you can delete
     * it. You can disassociate the set of DHCP options by associating either a new set of options or the default set of
     * options with the VPC.
     * </p>
     *
     * @param deleteDhcpOptionsRequest
     * @return A Java Future containing the result of the DeleteDhcpOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteDhcpOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDhcpOptionsResponse> deleteDhcpOptions(DeleteDhcpOptionsRequest deleteDhcpOptionsRequest) {
        try {

            HttpResponseHandler<DeleteDhcpOptionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteDhcpOptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteDhcpOptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDhcpOptionsRequest, DeleteDhcpOptionsResponse>()
                            .withOperationName("DeleteDhcpOptions")
                            .withMarshaller(new DeleteDhcpOptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteDhcpOptionsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an egress-only internet gateway.
     * </p>
     *
     * @param deleteEgressOnlyInternetGatewayRequest
     * @return A Java Future containing the result of the DeleteEgressOnlyInternetGateway operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteEgressOnlyInternetGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteEgressOnlyInternetGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEgressOnlyInternetGatewayResponse> deleteEgressOnlyInternetGateway(
            DeleteEgressOnlyInternetGatewayRequest deleteEgressOnlyInternetGatewayRequest) {
        try {

            HttpResponseHandler<DeleteEgressOnlyInternetGatewayResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteEgressOnlyInternetGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteEgressOnlyInternetGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEgressOnlyInternetGatewayRequest, DeleteEgressOnlyInternetGatewayResponse>()
                            .withOperationName("DeleteEgressOnlyInternetGateway")
                            .withMarshaller(new DeleteEgressOnlyInternetGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteEgressOnlyInternetGatewayRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified EC2 Fleet.
     * </p>
     * <p>
     * After you delete an EC2 Fleet, it launches no new instances. You must specify whether an EC2 Fleet should also
     * terminate its instances. If you terminate the instances, the EC2 Fleet enters the
     * <code>deleted_terminating</code> state. Otherwise, the EC2 Fleet enters the <code>deleted_running</code> state,
     * and the instances continue to run until they are interrupted or you terminate them manually.
     * </p>
     *
     * @param deleteFleetsRequest
     * @return A Java Future containing the result of the DeleteFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFleets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFleetsResponse> deleteFleets(DeleteFleetsRequest deleteFleetsRequest) {
        try {

            HttpResponseHandler<DeleteFleetsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteFleetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteFleetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFleetsRequest, DeleteFleetsResponse>()
                            .withOperationName("DeleteFleets").withMarshaller(new DeleteFleetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteFleetsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes one or more flow logs.
     * </p>
     *
     * @param deleteFlowLogsRequest
     * @return A Java Future containing the result of the DeleteFlowLogs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteFlowLogs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFlowLogs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFlowLogsResponse> deleteFlowLogs(DeleteFlowLogsRequest deleteFlowLogsRequest) {
        try {

            HttpResponseHandler<DeleteFlowLogsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteFlowLogsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteFlowLogsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFlowLogsRequest, DeleteFlowLogsResponse>()
                            .withOperationName("DeleteFlowLogs")
                            .withMarshaller(new DeleteFlowLogsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteFlowLogsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified Amazon FPGA Image (AFI).
     * </p>
     *
     * @param deleteFpgaImageRequest
     * @return A Java Future containing the result of the DeleteFpgaImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteFpgaImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFpgaImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFpgaImageResponse> deleteFpgaImage(DeleteFpgaImageRequest deleteFpgaImageRequest) {
        try {

            HttpResponseHandler<DeleteFpgaImageResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteFpgaImageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteFpgaImageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFpgaImageRequest, DeleteFpgaImageResponse>()
                            .withOperationName("DeleteFpgaImage")
                            .withMarshaller(new DeleteFpgaImageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteFpgaImageRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified internet gateway. You must detach the internet gateway from the VPC before you can delete
     * it.
     * </p>
     *
     * @param deleteInternetGatewayRequest
     * @return A Java Future containing the result of the DeleteInternetGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteInternetGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteInternetGatewayResponse> deleteInternetGateway(
            DeleteInternetGatewayRequest deleteInternetGatewayRequest) {
        try {

            HttpResponseHandler<DeleteInternetGatewayResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteInternetGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteInternetGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteInternetGatewayRequest, DeleteInternetGatewayResponse>()
                            .withOperationName("DeleteInternetGateway")
                            .withMarshaller(new DeleteInternetGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteInternetGatewayRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified key pair, by removing the public key from Amazon EC2.
     * </p>
     *
     * @param deleteKeyPairRequest
     * @return A Java Future containing the result of the DeleteKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteKeyPairResponse> deleteKeyPair(DeleteKeyPairRequest deleteKeyPairRequest) {
        try {

            HttpResponseHandler<DeleteKeyPairResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteKeyPairResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteKeyPairResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteKeyPairRequest, DeleteKeyPairResponse>()
                            .withOperationName("DeleteKeyPair")
                            .withMarshaller(new DeleteKeyPairRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteKeyPairRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a launch template. Deleting a launch template deletes all of its versions.
     * </p>
     *
     * @param deleteLaunchTemplateRequest
     * @return A Java Future containing the result of the DeleteLaunchTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteLaunchTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteLaunchTemplateResponse> deleteLaunchTemplate(
            DeleteLaunchTemplateRequest deleteLaunchTemplateRequest) {
        try {

            HttpResponseHandler<DeleteLaunchTemplateResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteLaunchTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteLaunchTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteLaunchTemplateRequest, DeleteLaunchTemplateResponse>()
                            .withOperationName("DeleteLaunchTemplate")
                            .withMarshaller(new DeleteLaunchTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteLaunchTemplateRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes one or more versions of a launch template. You cannot delete the default version of a launch template;
     * you must first assign a different version as the default. If the default version is the only version for the
     * launch template, you must delete the entire launch template using <a>DeleteLaunchTemplate</a>.
     * </p>
     *
     * @param deleteLaunchTemplateVersionsRequest
     * @return A Java Future containing the result of the DeleteLaunchTemplateVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteLaunchTemplateVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteLaunchTemplateVersionsResponse> deleteLaunchTemplateVersions(
            DeleteLaunchTemplateVersionsRequest deleteLaunchTemplateVersionsRequest) {
        try {

            HttpResponseHandler<DeleteLaunchTemplateVersionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteLaunchTemplateVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteLaunchTemplateVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteLaunchTemplateVersionsRequest, DeleteLaunchTemplateVersionsResponse>()
                            .withOperationName("DeleteLaunchTemplateVersions")
                            .withMarshaller(new DeleteLaunchTemplateVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteLaunchTemplateVersionsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified route from the specified local gateway route table.
     * </p>
     *
     * @param deleteLocalGatewayRouteRequest
     * @return A Java Future containing the result of the DeleteLocalGatewayRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteLocalGatewayRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteLocalGatewayRouteResponse> deleteLocalGatewayRoute(
            DeleteLocalGatewayRouteRequest deleteLocalGatewayRouteRequest) {
        try {

            HttpResponseHandler<DeleteLocalGatewayRouteResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteLocalGatewayRouteResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteLocalGatewayRouteResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteLocalGatewayRouteRequest, DeleteLocalGatewayRouteResponse>()
                            .withOperationName("DeleteLocalGatewayRoute")
                            .withMarshaller(new DeleteLocalGatewayRouteRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteLocalGatewayRouteRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified association between a VPC and local gateway route table.
     * </p>
     *
     * @param deleteLocalGatewayRouteTableVpcAssociationRequest
     * @return A Java Future containing the result of the DeleteLocalGatewayRouteTableVpcAssociation operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteLocalGatewayRouteTableVpcAssociation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTableVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteLocalGatewayRouteTableVpcAssociationResponse> deleteLocalGatewayRouteTableVpcAssociation(
            DeleteLocalGatewayRouteTableVpcAssociationRequest deleteLocalGatewayRouteTableVpcAssociationRequest) {
        try {

            HttpResponseHandler<DeleteLocalGatewayRouteTableVpcAssociationResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteLocalGatewayRouteTableVpcAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteLocalGatewayRouteTableVpcAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteLocalGatewayRouteTableVpcAssociationRequest, DeleteLocalGatewayRouteTableVpcAssociationResponse>()
                            .withOperationName("DeleteLocalGatewayRouteTableVpcAssociation")
                            .withMarshaller(new DeleteLocalGatewayRouteTableVpcAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteLocalGatewayRouteTableVpcAssociationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified NAT gateway. Deleting a NAT gateway disassociates its Elastic IP address, but does not
     * release the address from your account. Deleting a NAT gateway does not delete any NAT gateway routes in your
     * route tables.
     * </p>
     *
     * @param deleteNatGatewayRequest
     * @return A Java Future containing the result of the DeleteNatGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteNatGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNatGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNatGatewayResponse> deleteNatGateway(DeleteNatGatewayRequest deleteNatGatewayRequest) {
        try {

            HttpResponseHandler<DeleteNatGatewayResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteNatGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteNatGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteNatGatewayRequest, DeleteNatGatewayResponse>()
                            .withOperationName("DeleteNatGateway")
                            .withMarshaller(new DeleteNatGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteNatGatewayRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified network ACL. You can't delete the ACL if it's associated with any subnets. You can't delete
     * the default network ACL.
     * </p>
     *
     * @param deleteNetworkAclRequest
     * @return A Java Future containing the result of the DeleteNetworkAcl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteNetworkAcl
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAcl" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNetworkAclResponse> deleteNetworkAcl(DeleteNetworkAclRequest deleteNetworkAclRequest) {
        try {

            HttpResponseHandler<DeleteNetworkAclResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteNetworkAclResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteNetworkAclResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteNetworkAclRequest, DeleteNetworkAclResponse>()
                            .withOperationName("DeleteNetworkAcl")
                            .withMarshaller(new DeleteNetworkAclRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteNetworkAclRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified ingress or egress entry (rule) from the specified network ACL.
     * </p>
     *
     * @param deleteNetworkAclEntryRequest
     * @return A Java Future containing the result of the DeleteNetworkAclEntry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteNetworkAclEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAclEntry" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNetworkAclEntryResponse> deleteNetworkAclEntry(
            DeleteNetworkAclEntryRequest deleteNetworkAclEntryRequest) {
        try {

            HttpResponseHandler<DeleteNetworkAclEntryResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteNetworkAclEntryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteNetworkAclEntryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteNetworkAclEntryRequest, DeleteNetworkAclEntryResponse>()
                            .withOperationName("DeleteNetworkAclEntry")
                            .withMarshaller(new DeleteNetworkAclEntryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteNetworkAclEntryRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified network interface. You must detach the network interface before you can delete it.
     * </p>
     *
     * @param deleteNetworkInterfaceRequest
     *        Contains the parameters for DeleteNetworkInterface.
     * @return A Java Future containing the result of the DeleteNetworkInterface operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteNetworkInterface
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterface" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNetworkInterfaceResponse> deleteNetworkInterface(
            DeleteNetworkInterfaceRequest deleteNetworkInterfaceRequest) {
        try {

            HttpResponseHandler<DeleteNetworkInterfaceResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteNetworkInterfaceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteNetworkInterfaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteNetworkInterfaceRequest, DeleteNetworkInterfaceResponse>()
                            .withOperationName("DeleteNetworkInterface")
                            .withMarshaller(new DeleteNetworkInterfaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteNetworkInterfaceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a permission for a network interface. By default, you cannot delete the permission if the account for
     * which you're removing the permission has attached the network interface to an instance. However, you can force
     * delete the permission, regardless of any attachment.
     * </p>
     *
     * @param deleteNetworkInterfacePermissionRequest
     *        Contains the parameters for DeleteNetworkInterfacePermission.
     * @return A Java Future containing the result of the DeleteNetworkInterfacePermission operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteNetworkInterfacePermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterfacePermission"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNetworkInterfacePermissionResponse> deleteNetworkInterfacePermission(
            DeleteNetworkInterfacePermissionRequest deleteNetworkInterfacePermissionRequest) {
        try {

            HttpResponseHandler<DeleteNetworkInterfacePermissionResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteNetworkInterfacePermissionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteNetworkInterfacePermissionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteNetworkInterfacePermissionRequest, DeleteNetworkInterfacePermissionResponse>()
                            .withOperationName("DeleteNetworkInterfacePermission")
                            .withMarshaller(new DeleteNetworkInterfacePermissionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteNetworkInterfacePermissionRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified placement group. You must terminate all instances in the placement group before you can
     * delete the placement group. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement Groups</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param deletePlacementGroupRequest
     * @return A Java Future containing the result of the DeletePlacementGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeletePlacementGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePlacementGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePlacementGroupResponse> deletePlacementGroup(
            DeletePlacementGroupRequest deletePlacementGroupRequest) {
        try {

            HttpResponseHandler<DeletePlacementGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeletePlacementGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeletePlacementGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePlacementGroupRequest, DeletePlacementGroupResponse>()
                            .withOperationName("DeletePlacementGroup")
                            .withMarshaller(new DeletePlacementGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deletePlacementGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the queued purchases for the specified Reserved Instances.
     * </p>
     *
     * @param deleteQueuedReservedInstancesRequest
     * @return A Java Future containing the result of the DeleteQueuedReservedInstances operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteQueuedReservedInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteQueuedReservedInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteQueuedReservedInstancesResponse> deleteQueuedReservedInstances(
            DeleteQueuedReservedInstancesRequest deleteQueuedReservedInstancesRequest) {
        try {

            HttpResponseHandler<DeleteQueuedReservedInstancesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteQueuedReservedInstancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteQueuedReservedInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteQueuedReservedInstancesRequest, DeleteQueuedReservedInstancesResponse>()
                            .withOperationName("DeleteQueuedReservedInstances")
                            .withMarshaller(new DeleteQueuedReservedInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteQueuedReservedInstancesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified route from the specified route table.
     * </p>
     *
     * @param deleteRouteRequest
     * @return A Java Future containing the result of the DeleteRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRoute" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRouteResponse> deleteRoute(DeleteRouteRequest deleteRouteRequest) {
        try {

            HttpResponseHandler<DeleteRouteResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteRouteResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteRouteResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRouteRequest, DeleteRouteResponse>()
                            .withOperationName("DeleteRoute").withMarshaller(new DeleteRouteRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteRouteRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified route table. You must disassociate the route table from any subnets before you can delete
     * it. You can't delete the main route table.
     * </p>
     *
     * @param deleteRouteTableRequest
     * @return A Java Future containing the result of the DeleteRouteTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteRouteTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteTable" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRouteTableResponse> deleteRouteTable(DeleteRouteTableRequest deleteRouteTableRequest) {
        try {

            HttpResponseHandler<DeleteRouteTableResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteRouteTableResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteRouteTableResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRouteTableRequest, DeleteRouteTableResponse>()
                            .withOperationName("DeleteRouteTable")
                            .withMarshaller(new DeleteRouteTableRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteRouteTableRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a security group.
     * </p>
     * <p>
     * If you attempt to delete a security group that is associated with an instance, or is referenced by another
     * security group, the operation fails with <code>InvalidGroup.InUse</code> in EC2-Classic or
     * <code>DependencyViolation</code> in EC2-VPC.
     * </p>
     *
     * @param deleteSecurityGroupRequest
     * @return A Java Future containing the result of the DeleteSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteSecurityGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSecurityGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSecurityGroupResponse> deleteSecurityGroup(
            DeleteSecurityGroupRequest deleteSecurityGroupRequest) {
        try {

            HttpResponseHandler<DeleteSecurityGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteSecurityGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteSecurityGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSecurityGroupRequest, DeleteSecurityGroupResponse>()
                            .withOperationName("DeleteSecurityGroup")
                            .withMarshaller(new DeleteSecurityGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteSecurityGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified snapshot.
     * </p>
     * <p>
     * When you make periodic snapshots of a volume, the snapshots are incremental, and only the blocks on the device
     * that have changed since your last snapshot are saved in the new snapshot. When you delete a snapshot, only the
     * data not needed for any other snapshot is removed. So regardless of which prior snapshots have been deleted, all
     * active snapshots will have access to all the information needed to restore the volume.
     * </p>
     * <p>
     * You cannot delete a snapshot of the root device of an EBS volume used by a registered AMI. You must first
     * de-register the AMI before you can delete the snapshot.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-snapshot.html">Deleting an Amazon EBS
     * Snapshot</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param deleteSnapshotRequest
     * @return A Java Future containing the result of the DeleteSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSnapshotResponse> deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) {
        try {

            HttpResponseHandler<DeleteSnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSnapshotRequest, DeleteSnapshotResponse>()
                            .withOperationName("DeleteSnapshot")
                            .withMarshaller(new DeleteSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteSnapshotRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the data feed for Spot Instances.
     * </p>
     *
     * @param deleteSpotDatafeedSubscriptionRequest
     *        Contains the parameters for DeleteSpotDatafeedSubscription.
     * @return A Java Future containing the result of the DeleteSpotDatafeedSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteSpotDatafeedSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSpotDatafeedSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSpotDatafeedSubscriptionResponse> deleteSpotDatafeedSubscription(
            DeleteSpotDatafeedSubscriptionRequest deleteSpotDatafeedSubscriptionRequest) {
        try {

            HttpResponseHandler<DeleteSpotDatafeedSubscriptionResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteSpotDatafeedSubscriptionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteSpotDatafeedSubscriptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSpotDatafeedSubscriptionRequest, DeleteSpotDatafeedSubscriptionResponse>()
                            .withOperationName("DeleteSpotDatafeedSubscription")
                            .withMarshaller(new DeleteSpotDatafeedSubscriptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteSpotDatafeedSubscriptionRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified subnet. You must terminate all running instances in the subnet before you can delete the
     * subnet.
     * </p>
     *
     * @param deleteSubnetRequest
     * @return A Java Future containing the result of the DeleteSubnet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteSubnet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSubnetResponse> deleteSubnet(DeleteSubnetRequest deleteSubnetRequest) {
        try {

            HttpResponseHandler<DeleteSubnetResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteSubnetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteSubnetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSubnetRequest, DeleteSubnetResponse>()
                            .withOperationName("DeleteSubnet").withMarshaller(new DeleteSubnetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteSubnetRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified set of tags from the specified set of resources.
     * </p>
     * <p>
     * To list the current tags, use <a>DescribeTags</a>. For more information about tags, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Resources</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param deleteTagsRequest
     * @return A Java Future containing the result of the DeleteTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTagsResponse> deleteTags(DeleteTagsRequest deleteTagsRequest) {
        try {

            HttpResponseHandler<DeleteTagsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTagsRequest, DeleteTagsResponse>().withOperationName("DeleteTags")
                            .withMarshaller(new DeleteTagsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteTagsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified Traffic Mirror filter.
     * </p>
     * <p>
     * You cannot delete a Traffic Mirror filter that is in use by a Traffic Mirror session.
     * </p>
     *
     * @param deleteTrafficMirrorFilterRequest
     * @return A Java Future containing the result of the DeleteTrafficMirrorFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTrafficMirrorFilter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilter" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTrafficMirrorFilterResponse> deleteTrafficMirrorFilter(
            DeleteTrafficMirrorFilterRequest deleteTrafficMirrorFilterRequest) {
        try {

            HttpResponseHandler<DeleteTrafficMirrorFilterResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteTrafficMirrorFilterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteTrafficMirrorFilterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTrafficMirrorFilterRequest, DeleteTrafficMirrorFilterResponse>()
                            .withOperationName("DeleteTrafficMirrorFilter")
                            .withMarshaller(new DeleteTrafficMirrorFilterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteTrafficMirrorFilterRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified Traffic Mirror rule.
     * </p>
     *
     * @param deleteTrafficMirrorFilterRuleRequest
     * @return A Java Future containing the result of the DeleteTrafficMirrorFilterRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTrafficMirrorFilterRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilterRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTrafficMirrorFilterRuleResponse> deleteTrafficMirrorFilterRule(
            DeleteTrafficMirrorFilterRuleRequest deleteTrafficMirrorFilterRuleRequest) {
        try {

            HttpResponseHandler<DeleteTrafficMirrorFilterRuleResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteTrafficMirrorFilterRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteTrafficMirrorFilterRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTrafficMirrorFilterRuleRequest, DeleteTrafficMirrorFilterRuleResponse>()
                            .withOperationName("DeleteTrafficMirrorFilterRule")
                            .withMarshaller(new DeleteTrafficMirrorFilterRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteTrafficMirrorFilterRuleRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified Traffic Mirror session.
     * </p>
     *
     * @param deleteTrafficMirrorSessionRequest
     * @return A Java Future containing the result of the DeleteTrafficMirrorSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTrafficMirrorSession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorSession" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTrafficMirrorSessionResponse> deleteTrafficMirrorSession(
            DeleteTrafficMirrorSessionRequest deleteTrafficMirrorSessionRequest) {
        try {

            HttpResponseHandler<DeleteTrafficMirrorSessionResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteTrafficMirrorSessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteTrafficMirrorSessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTrafficMirrorSessionRequest, DeleteTrafficMirrorSessionResponse>()
                            .withOperationName("DeleteTrafficMirrorSession")
                            .withMarshaller(new DeleteTrafficMirrorSessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteTrafficMirrorSessionRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified Traffic Mirror target.
     * </p>
     * <p>
     * You cannot delete a Traffic Mirror target that is in use by a Traffic Mirror session.
     * </p>
     *
     * @param deleteTrafficMirrorTargetRequest
     * @return A Java Future containing the result of the DeleteTrafficMirrorTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTrafficMirrorTarget
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorTarget" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTrafficMirrorTargetResponse> deleteTrafficMirrorTarget(
            DeleteTrafficMirrorTargetRequest deleteTrafficMirrorTargetRequest) {
        try {

            HttpResponseHandler<DeleteTrafficMirrorTargetResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteTrafficMirrorTargetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteTrafficMirrorTargetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTrafficMirrorTargetRequest, DeleteTrafficMirrorTargetResponse>()
                            .withOperationName("DeleteTrafficMirrorTarget")
                            .withMarshaller(new DeleteTrafficMirrorTargetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteTrafficMirrorTargetRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified transit gateway.
     * </p>
     *
     * @param deleteTransitGatewayRequest
     * @return A Java Future containing the result of the DeleteTransitGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTransitGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTransitGatewayResponse> deleteTransitGateway(
            DeleteTransitGatewayRequest deleteTransitGatewayRequest) {
        try {

            HttpResponseHandler<DeleteTransitGatewayResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteTransitGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteTransitGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTransitGatewayRequest, DeleteTransitGatewayResponse>()
                            .withOperationName("DeleteTransitGateway")
                            .withMarshaller(new DeleteTransitGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteTransitGatewayRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified transit gateway multicast domain.
     * </p>
     *
     * @param deleteTransitGatewayMulticastDomainRequest
     * @return A Java Future containing the result of the DeleteTransitGatewayMulticastDomain operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTransitGatewayMulticastDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayMulticastDomain"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTransitGatewayMulticastDomainResponse> deleteTransitGatewayMulticastDomain(
            DeleteTransitGatewayMulticastDomainRequest deleteTransitGatewayMulticastDomainRequest) {
        try {

            HttpResponseHandler<DeleteTransitGatewayMulticastDomainResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteTransitGatewayMulticastDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteTransitGatewayMulticastDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTransitGatewayMulticastDomainRequest, DeleteTransitGatewayMulticastDomainResponse>()
                            .withOperationName("DeleteTransitGatewayMulticastDomain")
                            .withMarshaller(new DeleteTransitGatewayMulticastDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteTransitGatewayMulticastDomainRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a transit gateway peering attachment.
     * </p>
     *
     * @param deleteTransitGatewayPeeringAttachmentRequest
     * @return A Java Future containing the result of the DeleteTransitGatewayPeeringAttachment operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTransitGatewayPeeringAttachment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPeeringAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTransitGatewayPeeringAttachmentResponse> deleteTransitGatewayPeeringAttachment(
            DeleteTransitGatewayPeeringAttachmentRequest deleteTransitGatewayPeeringAttachmentRequest) {
        try {

            HttpResponseHandler<DeleteTransitGatewayPeeringAttachmentResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteTransitGatewayPeeringAttachmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteTransitGatewayPeeringAttachmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTransitGatewayPeeringAttachmentRequest, DeleteTransitGatewayPeeringAttachmentResponse>()
                            .withOperationName("DeleteTransitGatewayPeeringAttachment")
                            .withMarshaller(new DeleteTransitGatewayPeeringAttachmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteTransitGatewayPeeringAttachmentRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified route from the specified transit gateway route table.
     * </p>
     *
     * @param deleteTransitGatewayRouteRequest
     * @return A Java Future containing the result of the DeleteTransitGatewayRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTransitGatewayRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTransitGatewayRouteResponse> deleteTransitGatewayRoute(
            DeleteTransitGatewayRouteRequest deleteTransitGatewayRouteRequest) {
        try {

            HttpResponseHandler<DeleteTransitGatewayRouteResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteTransitGatewayRouteResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteTransitGatewayRouteResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTransitGatewayRouteRequest, DeleteTransitGatewayRouteResponse>()
                            .withOperationName("DeleteTransitGatewayRoute")
                            .withMarshaller(new DeleteTransitGatewayRouteRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteTransitGatewayRouteRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified transit gateway route table. You must disassociate the route table from any transit gateway
     * route tables before you can delete it.
     * </p>
     *
     * @param deleteTransitGatewayRouteTableRequest
     * @return A Java Future containing the result of the DeleteTransitGatewayRouteTable operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTransitGatewayRouteTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTransitGatewayRouteTableResponse> deleteTransitGatewayRouteTable(
            DeleteTransitGatewayRouteTableRequest deleteTransitGatewayRouteTableRequest) {
        try {

            HttpResponseHandler<DeleteTransitGatewayRouteTableResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteTransitGatewayRouteTableResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteTransitGatewayRouteTableResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTransitGatewayRouteTableRequest, DeleteTransitGatewayRouteTableResponse>()
                            .withOperationName("DeleteTransitGatewayRouteTable")
                            .withMarshaller(new DeleteTransitGatewayRouteTableRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteTransitGatewayRouteTableRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified VPC attachment.
     * </p>
     *
     * @param deleteTransitGatewayVpcAttachmentRequest
     * @return A Java Future containing the result of the DeleteTransitGatewayVpcAttachment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteTransitGatewayVpcAttachment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTransitGatewayVpcAttachmentResponse> deleteTransitGatewayVpcAttachment(
            DeleteTransitGatewayVpcAttachmentRequest deleteTransitGatewayVpcAttachmentRequest) {
        try {

            HttpResponseHandler<DeleteTransitGatewayVpcAttachmentResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteTransitGatewayVpcAttachmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteTransitGatewayVpcAttachmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTransitGatewayVpcAttachmentRequest, DeleteTransitGatewayVpcAttachmentResponse>()
                            .withOperationName("DeleteTransitGatewayVpcAttachment")
                            .withMarshaller(new DeleteTransitGatewayVpcAttachmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteTransitGatewayVpcAttachmentRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified EBS volume. The volume must be in the <code>available</code> state (not attached to an
     * instance).
     * </p>
     * <p>
     * The volume can remain in the <code>deleting</code> state for several minutes.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-volume.html">Deleting an Amazon EBS
     * Volume</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param deleteVolumeRequest
     * @return A Java Future containing the result of the DeleteVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteVolume
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVolume" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVolumeResponse> deleteVolume(DeleteVolumeRequest deleteVolumeRequest) {
        try {

            HttpResponseHandler<DeleteVolumeResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteVolumeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteVolumeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVolumeRequest, DeleteVolumeResponse>()
                            .withOperationName("DeleteVolume").withMarshaller(new DeleteVolumeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteVolumeRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified VPC. You must detach or delete all gateways and resources that are associated with the VPC
     * before you can delete it. For example, you must terminate all instances running in the VPC, delete all security
     * groups associated with the VPC (except the default one), delete all route tables associated with the VPC (except
     * the default one), and so on.
     * </p>
     *
     * @param deleteVpcRequest
     * @return A Java Future containing the result of the DeleteVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpc" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVpcResponse> deleteVpc(DeleteVpcRequest deleteVpcRequest) {
        try {

            HttpResponseHandler<DeleteVpcResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteVpcResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteVpcResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVpcRequest, DeleteVpcResponse>().withOperationName("DeleteVpc")
                            .withMarshaller(new DeleteVpcRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteVpcRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes one or more VPC endpoint connection notifications.
     * </p>
     *
     * @param deleteVpcEndpointConnectionNotificationsRequest
     * @return A Java Future containing the result of the DeleteVpcEndpointConnectionNotifications operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteVpcEndpointConnectionNotifications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointConnectionNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVpcEndpointConnectionNotificationsResponse> deleteVpcEndpointConnectionNotifications(
            DeleteVpcEndpointConnectionNotificationsRequest deleteVpcEndpointConnectionNotificationsRequest) {
        try {

            HttpResponseHandler<DeleteVpcEndpointConnectionNotificationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteVpcEndpointConnectionNotificationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteVpcEndpointConnectionNotificationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVpcEndpointConnectionNotificationsRequest, DeleteVpcEndpointConnectionNotificationsResponse>()
                            .withOperationName("DeleteVpcEndpointConnectionNotifications")
                            .withMarshaller(new DeleteVpcEndpointConnectionNotificationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteVpcEndpointConnectionNotificationsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes one or more VPC endpoint service configurations in your account. Before you delete the endpoint service
     * configuration, you must reject any <code>Available</code> or <code>PendingAcceptance</code> interface endpoint
     * connections that are attached to the service.
     * </p>
     *
     * @param deleteVpcEndpointServiceConfigurationsRequest
     * @return A Java Future containing the result of the DeleteVpcEndpointServiceConfigurations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteVpcEndpointServiceConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointServiceConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVpcEndpointServiceConfigurationsResponse> deleteVpcEndpointServiceConfigurations(
            DeleteVpcEndpointServiceConfigurationsRequest deleteVpcEndpointServiceConfigurationsRequest) {
        try {

            HttpResponseHandler<DeleteVpcEndpointServiceConfigurationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteVpcEndpointServiceConfigurationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteVpcEndpointServiceConfigurationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVpcEndpointServiceConfigurationsRequest, DeleteVpcEndpointServiceConfigurationsResponse>()
                            .withOperationName("DeleteVpcEndpointServiceConfigurations")
                            .withMarshaller(new DeleteVpcEndpointServiceConfigurationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteVpcEndpointServiceConfigurationsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes one or more specified VPC endpoints. Deleting a gateway endpoint also deletes the endpoint routes in the
     * route tables that were associated with the endpoint. Deleting an interface endpoint deletes the endpoint network
     * interfaces.
     * </p>
     *
     * @param deleteVpcEndpointsRequest
     *        Contains the parameters for DeleteVpcEndpoints.
     * @return A Java Future containing the result of the DeleteVpcEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteVpcEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVpcEndpointsResponse> deleteVpcEndpoints(DeleteVpcEndpointsRequest deleteVpcEndpointsRequest) {
        try {

            HttpResponseHandler<DeleteVpcEndpointsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteVpcEndpointsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteVpcEndpointsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVpcEndpointsRequest, DeleteVpcEndpointsResponse>()
                            .withOperationName("DeleteVpcEndpoints")
                            .withMarshaller(new DeleteVpcEndpointsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteVpcEndpointsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a VPC peering connection. Either the owner of the requester VPC or the owner of the accepter VPC can
     * delete the VPC peering connection if it's in the <code>active</code> state. The owner of the requester VPC can
     * delete a VPC peering connection in the <code>pending-acceptance</code> state. You cannot delete a VPC peering
     * connection that's in the <code>failed</code> state.
     * </p>
     *
     * @param deleteVpcPeeringConnectionRequest
     * @return A Java Future containing the result of the DeleteVpcPeeringConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteVpcPeeringConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcPeeringConnection" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVpcPeeringConnectionResponse> deleteVpcPeeringConnection(
            DeleteVpcPeeringConnectionRequest deleteVpcPeeringConnectionRequest) {
        try {

            HttpResponseHandler<DeleteVpcPeeringConnectionResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteVpcPeeringConnectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteVpcPeeringConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVpcPeeringConnectionRequest, DeleteVpcPeeringConnectionResponse>()
                            .withOperationName("DeleteVpcPeeringConnection")
                            .withMarshaller(new DeleteVpcPeeringConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteVpcPeeringConnectionRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified VPN connection.
     * </p>
     * <p>
     * If you're deleting the VPC and its associated components, we recommend that you detach the virtual private
     * gateway from the VPC and delete the VPC before deleting the VPN connection. If you believe that the tunnel
     * credentials for your VPN connection have been compromised, you can delete the VPN connection and create a new one
     * that has new keys, without needing to delete the VPC or virtual private gateway. If you create a new VPN
     * connection, you must reconfigure the customer gateway device using the new configuration information returned
     * with the new VPN connection ID.
     * </p>
     * <p>
     * For certificate-based authentication, delete all AWS Certificate Manager (ACM) private certificates used for the
     * AWS-side tunnel endpoints for the VPN connection before deleting the VPN connection.
     * </p>
     *
     * @param deleteVpnConnectionRequest
     *        Contains the parameters for DeleteVpnConnection.
     * @return A Java Future containing the result of the DeleteVpnConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteVpnConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnection" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVpnConnectionResponse> deleteVpnConnection(
            DeleteVpnConnectionRequest deleteVpnConnectionRequest) {
        try {

            HttpResponseHandler<DeleteVpnConnectionResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteVpnConnectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteVpnConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVpnConnectionRequest, DeleteVpnConnectionResponse>()
                            .withOperationName("DeleteVpnConnection")
                            .withMarshaller(new DeleteVpnConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteVpnConnectionRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified static route associated with a VPN connection between an existing virtual private gateway
     * and a VPN customer gateway. The static route allows traffic to be routed from the virtual private gateway to the
     * VPN customer gateway.
     * </p>
     *
     * @param deleteVpnConnectionRouteRequest
     *        Contains the parameters for DeleteVpnConnectionRoute.
     * @return A Java Future containing the result of the DeleteVpnConnectionRoute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteVpnConnectionRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnectionRoute" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVpnConnectionRouteResponse> deleteVpnConnectionRoute(
            DeleteVpnConnectionRouteRequest deleteVpnConnectionRouteRequest) {
        try {

            HttpResponseHandler<DeleteVpnConnectionRouteResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteVpnConnectionRouteResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteVpnConnectionRouteResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVpnConnectionRouteRequest, DeleteVpnConnectionRouteResponse>()
                            .withOperationName("DeleteVpnConnectionRoute")
                            .withMarshaller(new DeleteVpnConnectionRouteRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteVpnConnectionRouteRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified virtual private gateway. You must first detach the virtual private gateway from the VPC.
     * Note that you don't need to delete the virtual private gateway if you plan to delete and recreate the VPN
     * connection between your VPC and your network.
     * </p>
     *
     * @param deleteVpnGatewayRequest
     *        Contains the parameters for DeleteVpnGateway.
     * @return A Java Future containing the result of the DeleteVpnGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeleteVpnGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVpnGatewayResponse> deleteVpnGateway(DeleteVpnGatewayRequest deleteVpnGatewayRequest) {
        try {

            HttpResponseHandler<DeleteVpnGatewayResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteVpnGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteVpnGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVpnGatewayRequest, DeleteVpnGatewayResponse>()
                            .withOperationName("DeleteVpnGateway")
                            .withMarshaller(new DeleteVpnGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteVpnGatewayRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Releases the specified address range that you provisioned for use with your AWS resources through bring your own
     * IP addresses (BYOIP) and deletes the corresponding address pool.
     * </p>
     * <p>
     * Before you can release an address range, you must stop advertising it using <a>WithdrawByoipCidr</a> and you must
     * not have any IP addresses allocated from its address range.
     * </p>
     *
     * @param deprovisionByoipCidrRequest
     * @return A Java Future containing the result of the DeprovisionByoipCidr operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeprovisionByoipCidr
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionByoipCidr" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeprovisionByoipCidrResponse> deprovisionByoipCidr(
            DeprovisionByoipCidrRequest deprovisionByoipCidrRequest) {
        try {

            HttpResponseHandler<DeprovisionByoipCidrResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeprovisionByoipCidrResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeprovisionByoipCidrResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeprovisionByoipCidrRequest, DeprovisionByoipCidrResponse>()
                            .withOperationName("DeprovisionByoipCidr")
                            .withMarshaller(new DeprovisionByoipCidrRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deprovisionByoipCidrRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deregisters the specified AMI. After you deregister an AMI, it can't be used to launch new instances; however, it
     * doesn't affect any instances that you've already launched from the AMI. You'll continue to incur usage costs for
     * those instances until you terminate them.
     * </p>
     * <p>
     * When you deregister an Amazon EBS-backed AMI, it doesn't affect the snapshot that was created for the root volume
     * of the instance during the AMI creation process. When you deregister an instance store-backed AMI, it doesn't
     * affect the files that you uploaded to Amazon S3 when you created the AMI.
     * </p>
     *
     * @param deregisterImageRequest
     *        Contains the parameters for DeregisterImage.
     * @return A Java Future containing the result of the DeregisterImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeregisterImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterImageResponse> deregisterImage(DeregisterImageRequest deregisterImageRequest) {
        try {

            HttpResponseHandler<DeregisterImageResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeregisterImageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeregisterImageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeregisterImageRequest, DeregisterImageResponse>()
                            .withOperationName("DeregisterImage")
                            .withMarshaller(new DeregisterImageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deregisterImageRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deregisters tag keys to prevent tags that have the specified tag keys from being included in scheduled event
     * notifications for resources in the Region.
     * </p>
     *
     * @param deregisterInstanceEventNotificationAttributesRequest
     * @return A Java Future containing the result of the DeregisterInstanceEventNotificationAttributes operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeregisterInstanceEventNotificationAttributes
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterInstanceEventNotificationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterInstanceEventNotificationAttributesResponse> deregisterInstanceEventNotificationAttributes(
            DeregisterInstanceEventNotificationAttributesRequest deregisterInstanceEventNotificationAttributesRequest) {
        try {

            HttpResponseHandler<DeregisterInstanceEventNotificationAttributesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeregisterInstanceEventNotificationAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeregisterInstanceEventNotificationAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeregisterInstanceEventNotificationAttributesRequest, DeregisterInstanceEventNotificationAttributesResponse>()
                            .withOperationName("DeregisterInstanceEventNotificationAttributes")
                            .withMarshaller(new DeregisterInstanceEventNotificationAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deregisterInstanceEventNotificationAttributesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deregisters the specified members (network interfaces) from the transit gateway multicast group.
     * </p>
     *
     * @param deregisterTransitGatewayMulticastGroupMembersRequest
     * @return A Java Future containing the result of the DeregisterTransitGatewayMulticastGroupMembers operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeregisterTransitGatewayMulticastGroupMembers
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterTransitGatewayMulticastGroupMembers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterTransitGatewayMulticastGroupMembersResponse> deregisterTransitGatewayMulticastGroupMembers(
            DeregisterTransitGatewayMulticastGroupMembersRequest deregisterTransitGatewayMulticastGroupMembersRequest) {
        try {

            HttpResponseHandler<DeregisterTransitGatewayMulticastGroupMembersResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeregisterTransitGatewayMulticastGroupMembersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeregisterTransitGatewayMulticastGroupMembersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeregisterTransitGatewayMulticastGroupMembersRequest, DeregisterTransitGatewayMulticastGroupMembersResponse>()
                            .withOperationName("DeregisterTransitGatewayMulticastGroupMembers")
                            .withMarshaller(new DeregisterTransitGatewayMulticastGroupMembersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deregisterTransitGatewayMulticastGroupMembersRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deregisters the specified sources (network interfaces) from the transit gateway multicast group.
     * </p>
     *
     * @param deregisterTransitGatewayMulticastGroupSourcesRequest
     * @return A Java Future containing the result of the DeregisterTransitGatewayMulticastGroupSources operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DeregisterTransitGatewayMulticastGroupSources
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterTransitGatewayMulticastGroupSources"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterTransitGatewayMulticastGroupSourcesResponse> deregisterTransitGatewayMulticastGroupSources(
            DeregisterTransitGatewayMulticastGroupSourcesRequest deregisterTransitGatewayMulticastGroupSourcesRequest) {
        try {

            HttpResponseHandler<DeregisterTransitGatewayMulticastGroupSourcesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeregisterTransitGatewayMulticastGroupSourcesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeregisterTransitGatewayMulticastGroupSourcesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeregisterTransitGatewayMulticastGroupSourcesRequest, DeregisterTransitGatewayMulticastGroupSourcesResponse>()
                            .withOperationName("DeregisterTransitGatewayMulticastGroupSources")
                            .withMarshaller(new DeregisterTransitGatewayMulticastGroupSourcesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deregisterTransitGatewayMulticastGroupSourcesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes attributes of your AWS account. The following are the supported account attributes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>supported-platforms</code>: Indicates whether your account can launch instances into EC2-Classic and
     * EC2-VPC, or only into EC2-VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>default-vpc</code>: The ID of the default VPC for your account, or <code>none</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>max-instances</code>: This attribute is no longer supported. The returned value does not reflect your
     * actual vCPU limit for running On-Demand Instances. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-on-demand-instances.html#ec2-on-demand-instances-limits"
     * >On-Demand Instance Limits</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-max-security-groups-per-interface</code>: The maximum number of security groups that you can assign to
     * a network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>max-elastic-ips</code>: The maximum number of Elastic IP addresses that you can allocate for use with
     * EC2-Classic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-max-elastic-ips</code>: The maximum number of Elastic IP addresses that you can allocate for use with
     * EC2-VPC.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeAccountAttributesRequest
     * @return A Java Future containing the result of the DescribeAccountAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeAccountAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAccountAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAccountAttributesResponse> describeAccountAttributes(
            DescribeAccountAttributesRequest describeAccountAttributesRequest) {
        try {

            HttpResponseHandler<DescribeAccountAttributesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeAccountAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeAccountAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountAttributesRequest, DescribeAccountAttributesResponse>()
                            .withOperationName("DescribeAccountAttributes")
                            .withMarshaller(new DescribeAccountAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeAccountAttributesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified Elastic IP addresses or all of your Elastic IP addresses.
     * </p>
     * <p>
     * An Elastic IP address is for use in either the EC2-Classic platform or in a VPC. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param describeAddressesRequest
     * @return A Java Future containing the result of the DescribeAddresses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeAddresses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddresses" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAddressesResponse> describeAddresses(DescribeAddressesRequest describeAddressesRequest) {
        try {

            HttpResponseHandler<DescribeAddressesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeAddressesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeAddressesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAddressesRequest, DescribeAddressesResponse>()
                            .withOperationName("DescribeAddresses")
                            .withMarshaller(new DescribeAddressesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeAddressesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the longer ID format settings for all resource types in a specific Region. This request is useful for
     * performing a quick audit to determine whether a specific Region is fully opted in for longer IDs (17-character
     * IDs).
     * </p>
     * <p>
     * This request only returns information about resource types that support longer IDs.
     * </p>
     * <p>
     * The following resource types support longer IDs: <code>bundle</code> | <code>conversion-task</code> |
     * <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> |
     * <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> |
     * <code>import-task</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> |
     * <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code>
     * | <code>prefix-list</code> | <code>reservation</code> | <code>route-table</code> |
     * <code>route-table-association</code> | <code>security-group</code> | <code>snapshot</code> | <code>subnet</code>
     * | <code>subnet-cidr-block-association</code> | <code>volume</code> | <code>vpc</code> |
     * <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> |
     * <code>vpn-connection</code> | <code>vpn-gateway</code>.
     * </p>
     *
     * @param describeAggregateIdFormatRequest
     * @return A Java Future containing the result of the DescribeAggregateIdFormat operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeAggregateIdFormat
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAggregateIdFormat" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAggregateIdFormatResponse> describeAggregateIdFormat(
            DescribeAggregateIdFormatRequest describeAggregateIdFormatRequest) {
        try {

            HttpResponseHandler<DescribeAggregateIdFormatResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeAggregateIdFormatResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeAggregateIdFormatResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAggregateIdFormatRequest, DescribeAggregateIdFormatResponse>()
                            .withOperationName("DescribeAggregateIdFormat")
                            .withMarshaller(new DescribeAggregateIdFormatRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeAggregateIdFormatRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the Availability Zones and Local Zones that are available to you. If there is an event impacting an
     * Availability Zone or Local Zone, you can use this request to view the state and any provided messages for that
     * Availability Zone or Local Zone.
     * </p>
     * <p>
     * For more information about Availability Zones and Local Zones, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html">Regions and
     * Availability Zones</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param describeAvailabilityZonesRequest
     * @return A Java Future containing the result of the DescribeAvailabilityZones operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeAvailabilityZones
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAvailabilityZones" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAvailabilityZonesResponse> describeAvailabilityZones(
            DescribeAvailabilityZonesRequest describeAvailabilityZonesRequest) {
        try {

            HttpResponseHandler<DescribeAvailabilityZonesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeAvailabilityZonesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeAvailabilityZonesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAvailabilityZonesRequest, DescribeAvailabilityZonesResponse>()
                            .withOperationName("DescribeAvailabilityZones")
                            .withMarshaller(new DescribeAvailabilityZonesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeAvailabilityZonesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified bundle tasks or all of your bundle tasks.
     * </p>
     * <note>
     * <p>
     * Completed bundle tasks are listed for only a limited time. If your bundle task is no longer in the list, you can
     * still register an AMI from it. Just use <code>RegisterImage</code> with the Amazon S3 bucket name and image
     * manifest name you provided to the bundle task.
     * </p>
     * </note>
     *
     * @param describeBundleTasksRequest
     * @return A Java Future containing the result of the DescribeBundleTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeBundleTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeBundleTasks" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeBundleTasksResponse> describeBundleTasks(
            DescribeBundleTasksRequest describeBundleTasksRequest) {
        try {

            HttpResponseHandler<DescribeBundleTasksResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeBundleTasksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeBundleTasksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeBundleTasksRequest, DescribeBundleTasksResponse>()
                            .withOperationName("DescribeBundleTasks")
                            .withMarshaller(new DescribeBundleTasksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeBundleTasksRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the IP address ranges that were specified in calls to <a>ProvisionByoipCidr</a>.
     * </p>
     * <p>
     * To describe the address pools that were created when you provisioned the address ranges, use
     * <a>DescribePublicIpv4Pools</a> or <a>DescribeIpv6Pools</a>.
     * </p>
     *
     * @param describeByoipCidrsRequest
     * @return A Java Future containing the result of the DescribeByoipCidrs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeByoipCidrs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeByoipCidrs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeByoipCidrsResponse> describeByoipCidrs(DescribeByoipCidrsRequest describeByoipCidrsRequest) {
        try {

            HttpResponseHandler<DescribeByoipCidrsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeByoipCidrsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeByoipCidrsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeByoipCidrsRequest, DescribeByoipCidrsResponse>()
                            .withOperationName("DescribeByoipCidrs")
                            .withMarshaller(new DescribeByoipCidrsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeByoipCidrsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the IP address ranges that were specified in calls to <a>ProvisionByoipCidr</a>.
     * </p>
     * <p>
     * To describe the address pools that were created when you provisioned the address ranges, use
     * <a>DescribePublicIpv4Pools</a> or <a>DescribeIpv6Pools</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeByoipCidrs(software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeByoipCidrsPublisher publisher = client.describeByoipCidrsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeByoipCidrsPublisher publisher = client.describeByoipCidrsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeByoipCidrs(software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsRequest)} operation.</b>
     * </p>
     *
     * @param describeByoipCidrsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeByoipCidrs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeByoipCidrs" target="_top">AWS API
     *      Documentation</a>
     */
    public DescribeByoipCidrsPublisher describeByoipCidrsPaginator(DescribeByoipCidrsRequest describeByoipCidrsRequest) {
        return new DescribeByoipCidrsPublisher(this, applyPaginatorUserAgent(describeByoipCidrsRequest));
    }

    /**
     * <p>
     * Describes one or more of your Capacity Reservations. The results describe only the Capacity Reservations in the
     * AWS Region that you're currently using.
     * </p>
     *
     * @param describeCapacityReservationsRequest
     * @return A Java Future containing the result of the DescribeCapacityReservations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeCapacityReservations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCapacityReservationsResponse> describeCapacityReservations(
            DescribeCapacityReservationsRequest describeCapacityReservationsRequest) {
        try {

            HttpResponseHandler<DescribeCapacityReservationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeCapacityReservationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeCapacityReservationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCapacityReservationsRequest, DescribeCapacityReservationsResponse>()
                            .withOperationName("DescribeCapacityReservations")
                            .withMarshaller(new DescribeCapacityReservationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeCapacityReservationsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes one or more of your Capacity Reservations. The results describe only the Capacity Reservations in the
     * AWS Region that you're currently using.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCapacityReservations(software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeCapacityReservationsPublisher publisher = client.describeCapacityReservationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeCapacityReservationsPublisher publisher = client.describeCapacityReservationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCapacityReservations(software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeCapacityReservationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeCapacityReservations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservations"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeCapacityReservationsPublisher describeCapacityReservationsPaginator(
            DescribeCapacityReservationsRequest describeCapacityReservationsRequest) {
        return new DescribeCapacityReservationsPublisher(this, applyPaginatorUserAgent(describeCapacityReservationsRequest));
    }

    /**
     * <p>
     * Describes one or more of your linked EC2-Classic instances. This request only returns information about
     * EC2-Classic instances linked to a VPC through ClassicLink. You cannot use this request to return information
     * about other instances.
     * </p>
     *
     * @param describeClassicLinkInstancesRequest
     * @return A Java Future containing the result of the DescribeClassicLinkInstances operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeClassicLinkInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClassicLinkInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeClassicLinkInstancesResponse> describeClassicLinkInstances(
            DescribeClassicLinkInstancesRequest describeClassicLinkInstancesRequest) {
        try {

            HttpResponseHandler<DescribeClassicLinkInstancesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeClassicLinkInstancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeClassicLinkInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeClassicLinkInstancesRequest, DescribeClassicLinkInstancesResponse>()
                            .withOperationName("DescribeClassicLinkInstances")
                            .withMarshaller(new DescribeClassicLinkInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeClassicLinkInstancesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes one or more of your linked EC2-Classic instances. This request only returns information about
     * EC2-Classic instances linked to a VPC through ClassicLink. You cannot use this request to return information
     * about other instances.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClassicLinkInstances(software.amazon.awssdk.services.ec2.model.DescribeClassicLinkInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeClassicLinkInstancesPublisher publisher = client.describeClassicLinkInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeClassicLinkInstancesPublisher publisher = client.describeClassicLinkInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeClassicLinkInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeClassicLinkInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClassicLinkInstances(software.amazon.awssdk.services.ec2.model.DescribeClassicLinkInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeClassicLinkInstancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeClassicLinkInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClassicLinkInstances"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeClassicLinkInstancesPublisher describeClassicLinkInstancesPaginator(
            DescribeClassicLinkInstancesRequest describeClassicLinkInstancesRequest) {
        return new DescribeClassicLinkInstancesPublisher(this, applyPaginatorUserAgent(describeClassicLinkInstancesRequest));
    }

    /**
     * <p>
     * Describes the authorization rules for a specified Client VPN endpoint.
     * </p>
     *
     * @param describeClientVpnAuthorizationRulesRequest
     * @return A Java Future containing the result of the DescribeClientVpnAuthorizationRules operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeClientVpnAuthorizationRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnAuthorizationRules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeClientVpnAuthorizationRulesResponse> describeClientVpnAuthorizationRules(
            DescribeClientVpnAuthorizationRulesRequest describeClientVpnAuthorizationRulesRequest) {
        try {

            HttpResponseHandler<DescribeClientVpnAuthorizationRulesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeClientVpnAuthorizationRulesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeClientVpnAuthorizationRulesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeClientVpnAuthorizationRulesRequest, DescribeClientVpnAuthorizationRulesResponse>()
                            .withOperationName("DescribeClientVpnAuthorizationRules")
                            .withMarshaller(new DescribeClientVpnAuthorizationRulesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeClientVpnAuthorizationRulesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the authorization rules for a specified Client VPN endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClientVpnAuthorizationRules(software.amazon.awssdk.services.ec2.model.DescribeClientVpnAuthorizationRulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeClientVpnAuthorizationRulesPublisher publisher = client.describeClientVpnAuthorizationRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeClientVpnAuthorizationRulesPublisher publisher = client.describeClientVpnAuthorizationRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeClientVpnAuthorizationRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeClientVpnAuthorizationRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClientVpnAuthorizationRules(software.amazon.awssdk.services.ec2.model.DescribeClientVpnAuthorizationRulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeClientVpnAuthorizationRulesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeClientVpnAuthorizationRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnAuthorizationRules"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeClientVpnAuthorizationRulesPublisher describeClientVpnAuthorizationRulesPaginator(
            DescribeClientVpnAuthorizationRulesRequest describeClientVpnAuthorizationRulesRequest) {
        return new DescribeClientVpnAuthorizationRulesPublisher(this,
                applyPaginatorUserAgent(describeClientVpnAuthorizationRulesRequest));
    }

    /**
     * <p>
     * Describes active client connections and connections that have been terminated within the last 60 minutes for the
     * specified Client VPN endpoint.
     * </p>
     *
     * @param describeClientVpnConnectionsRequest
     * @return A Java Future containing the result of the DescribeClientVpnConnections operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeClientVpnConnections
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnConnections"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeClientVpnConnectionsResponse> describeClientVpnConnections(
            DescribeClientVpnConnectionsRequest describeClientVpnConnectionsRequest) {
        try {

            HttpResponseHandler<DescribeClientVpnConnectionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeClientVpnConnectionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeClientVpnConnectionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeClientVpnConnectionsRequest, DescribeClientVpnConnectionsResponse>()
                            .withOperationName("DescribeClientVpnConnections")
                            .withMarshaller(new DescribeClientVpnConnectionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeClientVpnConnectionsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes active client connections and connections that have been terminated within the last 60 minutes for the
     * specified Client VPN endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClientVpnConnections(software.amazon.awssdk.services.ec2.model.DescribeClientVpnConnectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeClientVpnConnectionsPublisher publisher = client.describeClientVpnConnectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeClientVpnConnectionsPublisher publisher = client.describeClientVpnConnectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeClientVpnConnectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeClientVpnConnectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClientVpnConnections(software.amazon.awssdk.services.ec2.model.DescribeClientVpnConnectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeClientVpnConnectionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeClientVpnConnections
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnConnections"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeClientVpnConnectionsPublisher describeClientVpnConnectionsPaginator(
            DescribeClientVpnConnectionsRequest describeClientVpnConnectionsRequest) {
        return new DescribeClientVpnConnectionsPublisher(this, applyPaginatorUserAgent(describeClientVpnConnectionsRequest));
    }

    /**
     * <p>
     * Describes one or more Client VPN endpoints in the account.
     * </p>
     *
     * @param describeClientVpnEndpointsRequest
     * @return A Java Future containing the result of the DescribeClientVpnEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeClientVpnEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeClientVpnEndpointsResponse> describeClientVpnEndpoints(
            DescribeClientVpnEndpointsRequest describeClientVpnEndpointsRequest) {
        try {

            HttpResponseHandler<DescribeClientVpnEndpointsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeClientVpnEndpointsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeClientVpnEndpointsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeClientVpnEndpointsRequest, DescribeClientVpnEndpointsResponse>()
                            .withOperationName("DescribeClientVpnEndpoints")
                            .withMarshaller(new DescribeClientVpnEndpointsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeClientVpnEndpointsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes one or more Client VPN endpoints in the account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClientVpnEndpoints(software.amazon.awssdk.services.ec2.model.DescribeClientVpnEndpointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeClientVpnEndpointsPublisher publisher = client.describeClientVpnEndpointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeClientVpnEndpointsPublisher publisher = client.describeClientVpnEndpointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeClientVpnEndpointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeClientVpnEndpointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClientVpnEndpoints(software.amazon.awssdk.services.ec2.model.DescribeClientVpnEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeClientVpnEndpointsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeClientVpnEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    public DescribeClientVpnEndpointsPublisher describeClientVpnEndpointsPaginator(
            DescribeClientVpnEndpointsRequest describeClientVpnEndpointsRequest) {
        return new DescribeClientVpnEndpointsPublisher(this, applyPaginatorUserAgent(describeClientVpnEndpointsRequest));
    }

    /**
     * <p>
     * Describes the routes for the specified Client VPN endpoint.
     * </p>
     *
     * @param describeClientVpnRoutesRequest
     * @return A Java Future containing the result of the DescribeClientVpnRoutes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeClientVpnRoutes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnRoutes" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeClientVpnRoutesResponse> describeClientVpnRoutes(
            DescribeClientVpnRoutesRequest describeClientVpnRoutesRequest) {
        try {

            HttpResponseHandler<DescribeClientVpnRoutesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeClientVpnRoutesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeClientVpnRoutesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeClientVpnRoutesRequest, DescribeClientVpnRoutesResponse>()
                            .withOperationName("DescribeClientVpnRoutes")
                            .withMarshaller(new DescribeClientVpnRoutesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeClientVpnRoutesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the routes for the specified Client VPN endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClientVpnRoutes(software.amazon.awssdk.services.ec2.model.DescribeClientVpnRoutesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeClientVpnRoutesPublisher publisher = client.describeClientVpnRoutesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeClientVpnRoutesPublisher publisher = client.describeClientVpnRoutesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeClientVpnRoutesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeClientVpnRoutesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClientVpnRoutes(software.amazon.awssdk.services.ec2.model.DescribeClientVpnRoutesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeClientVpnRoutesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeClientVpnRoutes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnRoutes" target="_top">AWS
     *      API Documentation</a>
     */
    public DescribeClientVpnRoutesPublisher describeClientVpnRoutesPaginator(
            DescribeClientVpnRoutesRequest describeClientVpnRoutesRequest) {
        return new DescribeClientVpnRoutesPublisher(this, applyPaginatorUserAgent(describeClientVpnRoutesRequest));
    }

    /**
     * <p>
     * Describes the target networks associated with the specified Client VPN endpoint.
     * </p>
     *
     * @param describeClientVpnTargetNetworksRequest
     * @return A Java Future containing the result of the DescribeClientVpnTargetNetworks operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeClientVpnTargetNetworks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnTargetNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeClientVpnTargetNetworksResponse> describeClientVpnTargetNetworks(
            DescribeClientVpnTargetNetworksRequest describeClientVpnTargetNetworksRequest) {
        try {

            HttpResponseHandler<DescribeClientVpnTargetNetworksResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeClientVpnTargetNetworksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeClientVpnTargetNetworksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeClientVpnTargetNetworksRequest, DescribeClientVpnTargetNetworksResponse>()
                            .withOperationName("DescribeClientVpnTargetNetworks")
                            .withMarshaller(new DescribeClientVpnTargetNetworksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeClientVpnTargetNetworksRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the target networks associated with the specified Client VPN endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClientVpnTargetNetworks(software.amazon.awssdk.services.ec2.model.DescribeClientVpnTargetNetworksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeClientVpnTargetNetworksPublisher publisher = client.describeClientVpnTargetNetworksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeClientVpnTargetNetworksPublisher publisher = client.describeClientVpnTargetNetworksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeClientVpnTargetNetworksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeClientVpnTargetNetworksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClientVpnTargetNetworks(software.amazon.awssdk.services.ec2.model.DescribeClientVpnTargetNetworksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeClientVpnTargetNetworksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeClientVpnTargetNetworks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnTargetNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeClientVpnTargetNetworksPublisher describeClientVpnTargetNetworksPaginator(
            DescribeClientVpnTargetNetworksRequest describeClientVpnTargetNetworksRequest) {
        return new DescribeClientVpnTargetNetworksPublisher(this, applyPaginatorUserAgent(describeClientVpnTargetNetworksRequest));
    }

    /**
     * <p>
     * Describes the specified customer-owned address pools or all of your customer-owned address pools.
     * </p>
     *
     * @param describeCoipPoolsRequest
     * @return A Java Future containing the result of the DescribeCoipPools operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeCoipPools
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCoipPools" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCoipPoolsResponse> describeCoipPools(DescribeCoipPoolsRequest describeCoipPoolsRequest) {
        try {

            HttpResponseHandler<DescribeCoipPoolsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeCoipPoolsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeCoipPoolsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCoipPoolsRequest, DescribeCoipPoolsResponse>()
                            .withOperationName("DescribeCoipPools")
                            .withMarshaller(new DescribeCoipPoolsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeCoipPoolsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified customer-owned address pools or all of your customer-owned address pools.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCoipPools(software.amazon.awssdk.services.ec2.model.DescribeCoipPoolsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeCoipPoolsPublisher publisher = client.describeCoipPoolsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeCoipPoolsPublisher publisher = client.describeCoipPoolsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeCoipPoolsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeCoipPoolsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCoipPools(software.amazon.awssdk.services.ec2.model.DescribeCoipPoolsRequest)} operation.</b>
     * </p>
     *
     * @param describeCoipPoolsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeCoipPools
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCoipPools" target="_top">AWS API
     *      Documentation</a>
     */
    public DescribeCoipPoolsPublisher describeCoipPoolsPaginator(DescribeCoipPoolsRequest describeCoipPoolsRequest) {
        return new DescribeCoipPoolsPublisher(this, applyPaginatorUserAgent(describeCoipPoolsRequest));
    }

    /**
     * <p>
     * Describes the specified conversion tasks or all your conversion tasks. For more information, see the <a
     * href="https://docs.aws.amazon.com/vm-import/latest/userguide/">VM Import/Export User Guide</a>.
     * </p>
     * <p>
     * For information about the import manifest referenced by this API action, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest</a>.
     * </p>
     *
     * @param describeConversionTasksRequest
     * @return A Java Future containing the result of the DescribeConversionTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeConversionTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeConversionTasks" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeConversionTasksResponse> describeConversionTasks(
            DescribeConversionTasksRequest describeConversionTasksRequest) {
        try {

            HttpResponseHandler<DescribeConversionTasksResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeConversionTasksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeConversionTasksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeConversionTasksRequest, DescribeConversionTasksResponse>()
                            .withOperationName("DescribeConversionTasks")
                            .withMarshaller(new DescribeConversionTasksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeConversionTasksRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes one or more of your VPN customer gateways.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">AWS Site-to-Site
     * VPN</a> in the <i>AWS Site-to-Site VPN User Guide</i>.
     * </p>
     *
     * @param describeCustomerGatewaysRequest
     *        Contains the parameters for DescribeCustomerGateways.
     * @return A Java Future containing the result of the DescribeCustomerGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeCustomerGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCustomerGateways" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCustomerGatewaysResponse> describeCustomerGateways(
            DescribeCustomerGatewaysRequest describeCustomerGatewaysRequest) {
        try {

            HttpResponseHandler<DescribeCustomerGatewaysResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeCustomerGatewaysResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeCustomerGatewaysResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCustomerGatewaysRequest, DescribeCustomerGatewaysResponse>()
                            .withOperationName("DescribeCustomerGateways")
                            .withMarshaller(new DescribeCustomerGatewaysRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeCustomerGatewaysRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes one or more of your DHCP options sets.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP
     * Options Sets</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param describeDhcpOptionsRequest
     * @return A Java Future containing the result of the DescribeDhcpOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeDhcpOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDhcpOptionsResponse> describeDhcpOptions(
            DescribeDhcpOptionsRequest describeDhcpOptionsRequest) {
        try {

            HttpResponseHandler<DescribeDhcpOptionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDhcpOptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDhcpOptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDhcpOptionsRequest, DescribeDhcpOptionsResponse>()
                            .withOperationName("DescribeDhcpOptions")
                            .withMarshaller(new DescribeDhcpOptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeDhcpOptionsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes one or more of your DHCP options sets.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP
     * Options Sets</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDhcpOptions(software.amazon.awssdk.services.ec2.model.DescribeDhcpOptionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeDhcpOptionsPublisher publisher = client.describeDhcpOptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeDhcpOptionsPublisher publisher = client.describeDhcpOptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeDhcpOptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeDhcpOptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDhcpOptions(software.amazon.awssdk.services.ec2.model.DescribeDhcpOptionsRequest)} operation.</b>
     * </p>
     *
     * @param describeDhcpOptionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeDhcpOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    public DescribeDhcpOptionsPublisher describeDhcpOptionsPaginator(DescribeDhcpOptionsRequest describeDhcpOptionsRequest) {
        return new DescribeDhcpOptionsPublisher(this, applyPaginatorUserAgent(describeDhcpOptionsRequest));
    }

    /**
     * <p>
     * Describes one or more of your egress-only internet gateways.
     * </p>
     *
     * @param describeEgressOnlyInternetGatewaysRequest
     * @return A Java Future containing the result of the DescribeEgressOnlyInternetGateways operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeEgressOnlyInternetGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeEgressOnlyInternetGateways"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEgressOnlyInternetGatewaysResponse> describeEgressOnlyInternetGateways(
            DescribeEgressOnlyInternetGatewaysRequest describeEgressOnlyInternetGatewaysRequest) {
        try {

            HttpResponseHandler<DescribeEgressOnlyInternetGatewaysResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeEgressOnlyInternetGatewaysResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeEgressOnlyInternetGatewaysResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEgressOnlyInternetGatewaysRequest, DescribeEgressOnlyInternetGatewaysResponse>()
                            .withOperationName("DescribeEgressOnlyInternetGateways")
                            .withMarshaller(new DescribeEgressOnlyInternetGatewaysRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeEgressOnlyInternetGatewaysRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes one or more of your egress-only internet gateways.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEgressOnlyInternetGateways(software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeEgressOnlyInternetGatewaysPublisher publisher = client.describeEgressOnlyInternetGatewaysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeEgressOnlyInternetGatewaysPublisher publisher = client.describeEgressOnlyInternetGatewaysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEgressOnlyInternetGateways(software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEgressOnlyInternetGatewaysRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeEgressOnlyInternetGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeEgressOnlyInternetGateways"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeEgressOnlyInternetGatewaysPublisher describeEgressOnlyInternetGatewaysPaginator(
            DescribeEgressOnlyInternetGatewaysRequest describeEgressOnlyInternetGatewaysRequest) {
        return new DescribeEgressOnlyInternetGatewaysPublisher(this,
                applyPaginatorUserAgent(describeEgressOnlyInternetGatewaysRequest));
    }

    /**
     * <p>
     * Describes the Elastic Graphics accelerator associated with your instances. For more information about Elastic
     * Graphics, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html">Amazon
     * Elastic Graphics</a>.
     * </p>
     *
     * @param describeElasticGpusRequest
     * @return A Java Future containing the result of the DescribeElasticGpus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeElasticGpus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeElasticGpus" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeElasticGpusResponse> describeElasticGpus(
            DescribeElasticGpusRequest describeElasticGpusRequest) {
        try {

            HttpResponseHandler<DescribeElasticGpusResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeElasticGpusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeElasticGpusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeElasticGpusRequest, DescribeElasticGpusResponse>()
                            .withOperationName("DescribeElasticGpus")
                            .withMarshaller(new DescribeElasticGpusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeElasticGpusRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified export image tasks or all of your export image tasks.
     * </p>
     *
     * @param describeExportImageTasksRequest
     * @return A Java Future containing the result of the DescribeExportImageTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeExportImageTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeExportImageTasks" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeExportImageTasksResponse> describeExportImageTasks(
            DescribeExportImageTasksRequest describeExportImageTasksRequest) {
        try {

            HttpResponseHandler<DescribeExportImageTasksResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeExportImageTasksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeExportImageTasksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeExportImageTasksRequest, DescribeExportImageTasksResponse>()
                            .withOperationName("DescribeExportImageTasks")
                            .withMarshaller(new DescribeExportImageTasksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeExportImageTasksRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified export image tasks or all of your export image tasks.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeExportImageTasks(software.amazon.awssdk.services.ec2.model.DescribeExportImageTasksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeExportImageTasksPublisher publisher = client.describeExportImageTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeExportImageTasksPublisher publisher = client.describeExportImageTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeExportImageTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeExportImageTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeExportImageTasks(software.amazon.awssdk.services.ec2.model.DescribeExportImageTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeExportImageTasksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeExportImageTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeExportImageTasks" target="_top">AWS
     *      API Documentation</a>
     */
    public DescribeExportImageTasksPublisher describeExportImageTasksPaginator(
            DescribeExportImageTasksRequest describeExportImageTasksRequest) {
        return new DescribeExportImageTasksPublisher(this, applyPaginatorUserAgent(describeExportImageTasksRequest));
    }

    /**
     * <p>
     * Describes the specified export instance tasks or all of your export instance tasks.
     * </p>
     *
     * @param describeExportTasksRequest
     * @return A Java Future containing the result of the DescribeExportTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeExportTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeExportTasks" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeExportTasksResponse> describeExportTasks(
            DescribeExportTasksRequest describeExportTasksRequest) {
        try {

            HttpResponseHandler<DescribeExportTasksResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeExportTasksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeExportTasksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeExportTasksRequest, DescribeExportTasksResponse>()
                            .withOperationName("DescribeExportTasks")
                            .withMarshaller(new DescribeExportTasksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeExportTasksRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the state of fast snapshot restores for your snapshots.
     * </p>
     *
     * @param describeFastSnapshotRestoresRequest
     * @return A Java Future containing the result of the DescribeFastSnapshotRestores operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeFastSnapshotRestores
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFastSnapshotRestores"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFastSnapshotRestoresResponse> describeFastSnapshotRestores(
            DescribeFastSnapshotRestoresRequest describeFastSnapshotRestoresRequest) {
        try {

            HttpResponseHandler<DescribeFastSnapshotRestoresResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeFastSnapshotRestoresResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeFastSnapshotRestoresResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFastSnapshotRestoresRequest, DescribeFastSnapshotRestoresResponse>()
                            .withOperationName("DescribeFastSnapshotRestores")
                            .withMarshaller(new DescribeFastSnapshotRestoresRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeFastSnapshotRestoresRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the state of fast snapshot restores for your snapshots.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeFastSnapshotRestores(software.amazon.awssdk.services.ec2.model.DescribeFastSnapshotRestoresRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeFastSnapshotRestoresPublisher publisher = client.describeFastSnapshotRestoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeFastSnapshotRestoresPublisher publisher = client.describeFastSnapshotRestoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeFastSnapshotRestoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeFastSnapshotRestoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFastSnapshotRestores(software.amazon.awssdk.services.ec2.model.DescribeFastSnapshotRestoresRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeFastSnapshotRestoresRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeFastSnapshotRestores
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFastSnapshotRestores"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeFastSnapshotRestoresPublisher describeFastSnapshotRestoresPaginator(
            DescribeFastSnapshotRestoresRequest describeFastSnapshotRestoresRequest) {
        return new DescribeFastSnapshotRestoresPublisher(this, applyPaginatorUserAgent(describeFastSnapshotRestoresRequest));
    }

    /**
     * <p>
     * Describes the events for the specified EC2 Fleet during the specified time.
     * </p>
     * <p>
     * EC2 Fleet events are delayed by up to 30 seconds before they can be described. This ensures that you can query by
     * the last evaluated time and not miss a recorded event. EC2 Fleet events are available for 48 hours.
     * </p>
     *
     * @param describeFleetHistoryRequest
     * @return A Java Future containing the result of the DescribeFleetHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeFleetHistory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetHistory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFleetHistoryResponse> describeFleetHistory(
            DescribeFleetHistoryRequest describeFleetHistoryRequest) {
        try {

            HttpResponseHandler<DescribeFleetHistoryResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeFleetHistoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeFleetHistoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFleetHistoryRequest, DescribeFleetHistoryResponse>()
                            .withOperationName("DescribeFleetHistory")
                            .withMarshaller(new DescribeFleetHistoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeFleetHistoryRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the running instances for the specified EC2 Fleet.
     * </p>
     *
     * @param describeFleetInstancesRequest
     * @return A Java Future containing the result of the DescribeFleetInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeFleetInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetInstances" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFleetInstancesResponse> describeFleetInstances(
            DescribeFleetInstancesRequest describeFleetInstancesRequest) {
        try {

            HttpResponseHandler<DescribeFleetInstancesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeFleetInstancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeFleetInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFleetInstancesRequest, DescribeFleetInstancesResponse>()
                            .withOperationName("DescribeFleetInstances")
                            .withMarshaller(new DescribeFleetInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeFleetInstancesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified EC2 Fleets or all of your EC2 Fleets.
     * </p>
     *
     * @param describeFleetsRequest
     * @return A Java Future containing the result of the DescribeFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFleetsResponse> describeFleets(DescribeFleetsRequest describeFleetsRequest) {
        try {

            HttpResponseHandler<DescribeFleetsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeFleetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeFleetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFleetsRequest, DescribeFleetsResponse>()
                            .withOperationName("DescribeFleets")
                            .withMarshaller(new DescribeFleetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeFleetsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified EC2 Fleets or all of your EC2 Fleets.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeFleets(software.amazon.awssdk.services.ec2.model.DescribeFleetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeFleetsPublisher publisher = client.describeFleetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeFleetsPublisher publisher = client.describeFleetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeFleetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeFleetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleets(software.amazon.awssdk.services.ec2.model.DescribeFleetsRequest)} operation.</b>
     * </p>
     *
     * @param describeFleetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleets" target="_top">AWS API
     *      Documentation</a>
     */
    public DescribeFleetsPublisher describeFleetsPaginator(DescribeFleetsRequest describeFleetsRequest) {
        return new DescribeFleetsPublisher(this, applyPaginatorUserAgent(describeFleetsRequest));
    }

    /**
     * <p>
     * Describes one or more flow logs. To view the information in your flow logs (the log streams for the network
     * interfaces), you must use the CloudWatch Logs console or the CloudWatch Logs API.
     * </p>
     *
     * @param describeFlowLogsRequest
     * @return A Java Future containing the result of the DescribeFlowLogs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeFlowLogs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFlowLogs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFlowLogsResponse> describeFlowLogs(DescribeFlowLogsRequest describeFlowLogsRequest) {
        try {

            HttpResponseHandler<DescribeFlowLogsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeFlowLogsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeFlowLogsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFlowLogsRequest, DescribeFlowLogsResponse>()
                            .withOperationName("DescribeFlowLogs")
                            .withMarshaller(new DescribeFlowLogsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeFlowLogsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes one or more flow logs. To view the information in your flow logs (the log streams for the network
     * interfaces), you must use the CloudWatch Logs console or the CloudWatch Logs API.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeFlowLogs(software.amazon.awssdk.services.ec2.model.DescribeFlowLogsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeFlowLogsPublisher publisher = client.describeFlowLogsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeFlowLogsPublisher publisher = client.describeFlowLogsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeFlowLogsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeFlowLogsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFlowLogs(software.amazon.awssdk.services.ec2.model.DescribeFlowLogsRequest)} operation.</b>
     * </p>
     *
     * @param describeFlowLogsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeFlowLogs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFlowLogs" target="_top">AWS API
     *      Documentation</a>
     */
    public DescribeFlowLogsPublisher describeFlowLogsPaginator(DescribeFlowLogsRequest describeFlowLogsRequest) {
        return new DescribeFlowLogsPublisher(this, applyPaginatorUserAgent(describeFlowLogsRequest));
    }

    /**
     * <p>
     * Describes the specified attribute of the specified Amazon FPGA Image (AFI).
     * </p>
     *
     * @param describeFpgaImageAttributeRequest
     * @return A Java Future containing the result of the DescribeFpgaImageAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeFpgaImageAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFpgaImageAttribute" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFpgaImageAttributeResponse> describeFpgaImageAttribute(
            DescribeFpgaImageAttributeRequest describeFpgaImageAttributeRequest) {
        try {

            HttpResponseHandler<DescribeFpgaImageAttributeResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeFpgaImageAttributeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeFpgaImageAttributeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFpgaImageAttributeRequest, DescribeFpgaImageAttributeResponse>()
                            .withOperationName("DescribeFpgaImageAttribute")
                            .withMarshaller(new DescribeFpgaImageAttributeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeFpgaImageAttributeRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the Amazon FPGA Images (AFIs) available to you. These include public AFIs, private AFIs that you own,
     * and AFIs owned by other AWS accounts for which you have load permissions.
     * </p>
     *
     * @param describeFpgaImagesRequest
     * @return A Java Future containing the result of the DescribeFpgaImages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeFpgaImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFpgaImages" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFpgaImagesResponse> describeFpgaImages(DescribeFpgaImagesRequest describeFpgaImagesRequest) {
        try {

            HttpResponseHandler<DescribeFpgaImagesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeFpgaImagesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeFpgaImagesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFpgaImagesRequest, DescribeFpgaImagesResponse>()
                            .withOperationName("DescribeFpgaImages")
                            .withMarshaller(new DescribeFpgaImagesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeFpgaImagesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the Amazon FPGA Images (AFIs) available to you. These include public AFIs, private AFIs that you own,
     * and AFIs owned by other AWS accounts for which you have load permissions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeFpgaImages(software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeFpgaImagesPublisher publisher = client.describeFpgaImagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeFpgaImagesPublisher publisher = client.describeFpgaImagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFpgaImages(software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesRequest)} operation.</b>
     * </p>
     *
     * @param describeFpgaImagesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeFpgaImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFpgaImages" target="_top">AWS API
     *      Documentation</a>
     */
    public DescribeFpgaImagesPublisher describeFpgaImagesPaginator(DescribeFpgaImagesRequest describeFpgaImagesRequest) {
        return new DescribeFpgaImagesPublisher(this, applyPaginatorUserAgent(describeFpgaImagesRequest));
    }

    /**
     * <p>
     * Describes the Dedicated Host reservations that are available to purchase.
     * </p>
     * <p>
     * The results describe all of the Dedicated Host reservation offerings, including offerings that might not match
     * the instance family and Region of your Dedicated Hosts. When purchasing an offering, ensure that the instance
     * family and Region of the offering matches that of the Dedicated Hosts with which it is to be associated. For more
     * information about supported instance types, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-overview.html">Dedicated Hosts
     * Overview</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param describeHostReservationOfferingsRequest
     * @return A Java Future containing the result of the DescribeHostReservationOfferings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeHostReservationOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservationOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeHostReservationOfferingsResponse> describeHostReservationOfferings(
            DescribeHostReservationOfferingsRequest describeHostReservationOfferingsRequest) {
        try {

            HttpResponseHandler<DescribeHostReservationOfferingsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeHostReservationOfferingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeHostReservationOfferingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeHostReservationOfferingsRequest, DescribeHostReservationOfferingsResponse>()
                            .withOperationName("DescribeHostReservationOfferings")
                            .withMarshaller(new DescribeHostReservationOfferingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeHostReservationOfferingsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the Dedicated Host reservations that are available to purchase.
     * </p>
     * <p>
     * The results describe all of the Dedicated Host reservation offerings, including offerings that might not match
     * the instance family and Region of your Dedicated Hosts. When purchasing an offering, ensure that the instance
     * family and Region of the offering matches that of the Dedicated Hosts with which it is to be associated. For more
     * information about supported instance types, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-overview.html">Dedicated Hosts
     * Overview</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeHostReservationOfferings(software.amazon.awssdk.services.ec2.model.DescribeHostReservationOfferingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeHostReservationOfferingsPublisher publisher = client.describeHostReservationOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeHostReservationOfferingsPublisher publisher = client.describeHostReservationOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeHostReservationOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeHostReservationOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeHostReservationOfferings(software.amazon.awssdk.services.ec2.model.DescribeHostReservationOfferingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeHostReservationOfferingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeHostReservationOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservationOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeHostReservationOfferingsPublisher describeHostReservationOfferingsPaginator(
            DescribeHostReservationOfferingsRequest describeHostReservationOfferingsRequest) {
        return new DescribeHostReservationOfferingsPublisher(this,
                applyPaginatorUserAgent(describeHostReservationOfferingsRequest));
    }

    /**
     * <p>
     * Describes reservations that are associated with Dedicated Hosts in your account.
     * </p>
     *
     * @param describeHostReservationsRequest
     * @return A Java Future containing the result of the DescribeHostReservations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeHostReservations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeHostReservationsResponse> describeHostReservations(
            DescribeHostReservationsRequest describeHostReservationsRequest) {
        try {

            HttpResponseHandler<DescribeHostReservationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeHostReservationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeHostReservationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeHostReservationsRequest, DescribeHostReservationsResponse>()
                            .withOperationName("DescribeHostReservations")
                            .withMarshaller(new DescribeHostReservationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeHostReservationsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes reservations that are associated with Dedicated Hosts in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeHostReservations(software.amazon.awssdk.services.ec2.model.DescribeHostReservationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeHostReservationsPublisher publisher = client.describeHostReservationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeHostReservationsPublisher publisher = client.describeHostReservationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeHostReservationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeHostReservationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeHostReservations(software.amazon.awssdk.services.ec2.model.DescribeHostReservationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeHostReservationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeHostReservations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservations" target="_top">AWS
     *      API Documentation</a>
     */
    public DescribeHostReservationsPublisher describeHostReservationsPaginator(
            DescribeHostReservationsRequest describeHostReservationsRequest) {
        return new DescribeHostReservationsPublisher(this, applyPaginatorUserAgent(describeHostReservationsRequest));
    }

    /**
     * <p>
     * Describes the specified Dedicated Hosts or all your Dedicated Hosts.
     * </p>
     * <p>
     * The results describe only the Dedicated Hosts in the Region you're currently using. All listed instances consume
     * capacity on your Dedicated Host. Dedicated Hosts that have recently been released are listed with the state
     * <code>released</code>.
     * </p>
     *
     * @param describeHostsRequest
     * @return A Java Future containing the result of the DescribeHosts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeHosts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHosts" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeHostsResponse> describeHosts(DescribeHostsRequest describeHostsRequest) {
        try {

            HttpResponseHandler<DescribeHostsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeHostsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeHostsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeHostsRequest, DescribeHostsResponse>()
                            .withOperationName("DescribeHosts")
                            .withMarshaller(new DescribeHostsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeHostsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified Dedicated Hosts or all your Dedicated Hosts.
     * </p>
     * <p>
     * The results describe only the Dedicated Hosts in the Region you're currently using. All listed instances consume
     * capacity on your Dedicated Host. Dedicated Hosts that have recently been released are listed with the state
     * <code>released</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeHosts(software.amazon.awssdk.services.ec2.model.DescribeHostsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeHostsPublisher publisher = client.describeHostsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeHostsPublisher publisher = client.describeHostsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeHostsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeHostsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeHosts(software.amazon.awssdk.services.ec2.model.DescribeHostsRequest)} operation.</b>
     * </p>
     *
     * @param describeHostsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeHosts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHosts" target="_top">AWS API
     *      Documentation</a>
     */
    public DescribeHostsPublisher describeHostsPaginator(DescribeHostsRequest describeHostsRequest) {
        return new DescribeHostsPublisher(this, applyPaginatorUserAgent(describeHostsRequest));
    }

    /**
     * <p>
     * Describes your IAM instance profile associations.
     * </p>
     *
     * @param describeIamInstanceProfileAssociationsRequest
     * @return A Java Future containing the result of the DescribeIamInstanceProfileAssociations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeIamInstanceProfileAssociations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIamInstanceProfileAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeIamInstanceProfileAssociationsResponse> describeIamInstanceProfileAssociations(
            DescribeIamInstanceProfileAssociationsRequest describeIamInstanceProfileAssociationsRequest) {
        try {

            HttpResponseHandler<DescribeIamInstanceProfileAssociationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeIamInstanceProfileAssociationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeIamInstanceProfileAssociationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeIamInstanceProfileAssociationsRequest, DescribeIamInstanceProfileAssociationsResponse>()
                            .withOperationName("DescribeIamInstanceProfileAssociations")
                            .withMarshaller(new DescribeIamInstanceProfileAssociationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeIamInstanceProfileAssociationsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes your IAM instance profile associations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeIamInstanceProfileAssociations(software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeIamInstanceProfileAssociationsPublisher publisher = client.describeIamInstanceProfileAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeIamInstanceProfileAssociationsPublisher publisher = client.describeIamInstanceProfileAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeIamInstanceProfileAssociations(software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeIamInstanceProfileAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeIamInstanceProfileAssociations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIamInstanceProfileAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeIamInstanceProfileAssociationsPublisher describeIamInstanceProfileAssociationsPaginator(
            DescribeIamInstanceProfileAssociationsRequest describeIamInstanceProfileAssociationsRequest) {
        return new DescribeIamInstanceProfileAssociationsPublisher(this,
                applyPaginatorUserAgent(describeIamInstanceProfileAssociationsRequest));
    }

    /**
     * <p>
     * Describes the ID format settings for your resources on a per-Region basis, for example, to view which resource
     * types are enabled for longer IDs. This request only returns information about resource types whose ID formats can
     * be modified; it does not return information about other resource types.
     * </p>
     * <p>
     * The following resource types support longer IDs: <code>bundle</code> | <code>conversion-task</code> |
     * <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> |
     * <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> |
     * <code>import-task</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> |
     * <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code>
     * | <code>prefix-list</code> | <code>reservation</code> | <code>route-table</code> |
     * <code>route-table-association</code> | <code>security-group</code> | <code>snapshot</code> | <code>subnet</code>
     * | <code>subnet-cidr-block-association</code> | <code>volume</code> | <code>vpc</code> |
     * <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> |
     * <code>vpn-connection</code> | <code>vpn-gateway</code>.
     * </p>
     * <p>
     * These settings apply to the IAM user who makes the request; they do not apply to the entire AWS account. By
     * default, an IAM user defaults to the same settings as the root user, unless they explicitly override the settings
     * by running the <a>ModifyIdFormat</a> command. Resources created with longer IDs are visible to all IAM users,
     * regardless of these settings and provided that they have permission to use the relevant <code>Describe</code>
     * command for the resource type.
     * </p>
     *
     * @param describeIdFormatRequest
     * @return A Java Future containing the result of the DescribeIdFormat operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeIdFormat
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdFormat" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeIdFormatResponse> describeIdFormat(DescribeIdFormatRequest describeIdFormatRequest) {
        try {

            HttpResponseHandler<DescribeIdFormatResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeIdFormatResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeIdFormatResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeIdFormatRequest, DescribeIdFormatResponse>()
                            .withOperationName("DescribeIdFormat")
                            .withMarshaller(new DescribeIdFormatRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeIdFormatRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the ID format settings for resources for the specified IAM user, IAM role, or root user. For example,
     * you can view the resource types that are enabled for longer IDs. This request only returns information about
     * resource types whose ID formats can be modified; it does not return information about other resource types. For
     * more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html">Resource
     * IDs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * The following resource types support longer IDs: <code>bundle</code> | <code>conversion-task</code> |
     * <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> |
     * <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> |
     * <code>import-task</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> |
     * <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code>
     * | <code>prefix-list</code> | <code>reservation</code> | <code>route-table</code> |
     * <code>route-table-association</code> | <code>security-group</code> | <code>snapshot</code> | <code>subnet</code>
     * | <code>subnet-cidr-block-association</code> | <code>volume</code> | <code>vpc</code> |
     * <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> |
     * <code>vpn-connection</code> | <code>vpn-gateway</code>.
     * </p>
     * <p>
     * These settings apply to the principal specified in the request. They do not apply to the principal that makes the
     * request.
     * </p>
     *
     * @param describeIdentityIdFormatRequest
     * @return A Java Future containing the result of the DescribeIdentityIdFormat operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeIdentityIdFormat
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdentityIdFormat" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeIdentityIdFormatResponse> describeIdentityIdFormat(
            DescribeIdentityIdFormatRequest describeIdentityIdFormatRequest) {
        try {

            HttpResponseHandler<DescribeIdentityIdFormatResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeIdentityIdFormatResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeIdentityIdFormatResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeIdentityIdFormatRequest, DescribeIdentityIdFormatResponse>()
                            .withOperationName("DescribeIdentityIdFormat")
                            .withMarshaller(new DescribeIdentityIdFormatRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeIdentityIdFormatRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified attribute of the specified AMI. You can specify only one attribute at a time.
     * </p>
     *
     * @param describeImageAttributeRequest
     *        Contains the parameters for DescribeImageAttribute.
     * @return A Java Future containing the result of the DescribeImageAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeImageAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImageAttribute" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeImageAttributeResponse> describeImageAttribute(
            DescribeImageAttributeRequest describeImageAttributeRequest) {
        try {

            HttpResponseHandler<DescribeImageAttributeResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeImageAttributeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeImageAttributeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeImageAttributeRequest, DescribeImageAttributeResponse>()
                            .withOperationName("DescribeImageAttribute")
                            .withMarshaller(new DescribeImageAttributeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeImageAttributeRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified images (AMIs, AKIs, and ARIs) available to you or all of the images available to you.
     * </p>
     * <p>
     * The images available to you include public images, private images that you own, and private images owned by other
     * AWS accounts for which you have explicit launch permissions.
     * </p>
     * <p>
     * Recently deregistered images appear in the returned results for a short interval and then return empty results.
     * After all instances that reference a deregistered AMI are terminated, specifying the ID of the image results in
     * an error indicating that the AMI ID cannot be found.
     * </p>
     *
     * @param describeImagesRequest
     * @return A Java Future containing the result of the DescribeImages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeImagesResponse> describeImages(DescribeImagesRequest describeImagesRequest) {
        try {

            HttpResponseHandler<DescribeImagesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeImagesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeImagesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeImagesRequest, DescribeImagesResponse>()
                            .withOperationName("DescribeImages")
                            .withMarshaller(new DescribeImagesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeImagesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Displays details about an import virtual machine or import snapshot tasks that are already created.
     * </p>
     *
     * @param describeImportImageTasksRequest
     * @return A Java Future containing the result of the DescribeImportImageTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeImportImageTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportImageTasks" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeImportImageTasksResponse> describeImportImageTasks(
            DescribeImportImageTasksRequest describeImportImageTasksRequest) {
        try {

            HttpResponseHandler<DescribeImportImageTasksResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeImportImageTasksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeImportImageTasksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeImportImageTasksRequest, DescribeImportImageTasksResponse>()
                            .withOperationName("DescribeImportImageTasks")
                            .withMarshaller(new DescribeImportImageTasksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeImportImageTasksRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Displays details about an import virtual machine or import snapshot tasks that are already created.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeImportImageTasks(software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeImportImageTasksPublisher publisher = client.describeImportImageTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeImportImageTasksPublisher publisher = client.describeImportImageTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeImportImageTasks(software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeImportImageTasksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeImportImageTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportImageTasks" target="_top">AWS
     *      API Documentation</a>
     */
    public DescribeImportImageTasksPublisher describeImportImageTasksPaginator(
            DescribeImportImageTasksRequest describeImportImageTasksRequest) {
        return new DescribeImportImageTasksPublisher(this, applyPaginatorUserAgent(describeImportImageTasksRequest));
    }

    /**
     * <p>
     * Describes your import snapshot tasks.
     * </p>
     *
     * @param describeImportSnapshotTasksRequest
     * @return A Java Future containing the result of the DescribeImportSnapshotTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeImportSnapshotTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportSnapshotTasks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeImportSnapshotTasksResponse> describeImportSnapshotTasks(
            DescribeImportSnapshotTasksRequest describeImportSnapshotTasksRequest) {
        try {

            HttpResponseHandler<DescribeImportSnapshotTasksResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeImportSnapshotTasksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeImportSnapshotTasksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeImportSnapshotTasksRequest, DescribeImportSnapshotTasksResponse>()
                            .withOperationName("DescribeImportSnapshotTasks")
                            .withMarshaller(new DescribeImportSnapshotTasksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeImportSnapshotTasksRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes your import snapshot tasks.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeImportSnapshotTasks(software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeImportSnapshotTasksPublisher publisher = client.describeImportSnapshotTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeImportSnapshotTasksPublisher publisher = client.describeImportSnapshotTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeImportSnapshotTasks(software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeImportSnapshotTasksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeImportSnapshotTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportSnapshotTasks"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeImportSnapshotTasksPublisher describeImportSnapshotTasksPaginator(
            DescribeImportSnapshotTasksRequest describeImportSnapshotTasksRequest) {
        return new DescribeImportSnapshotTasksPublisher(this, applyPaginatorUserAgent(describeImportSnapshotTasksRequest));
    }

    /**
     * <p>
     * Describes the specified attribute of the specified instance. You can specify only one attribute at a time. Valid
     * attribute values are: <code>instanceType</code> | <code>kernel</code> | <code>ramdisk</code> |
     * <code>userData</code> | <code>disableApiTermination</code> | <code>instanceInitiatedShutdownBehavior</code> |
     * <code>rootDeviceName</code> | <code>blockDeviceMapping</code> | <code>productCodes</code> |
     * <code>sourceDestCheck</code> | <code>groupSet</code> | <code>ebsOptimized</code> | <code>sriovNetSupport</code>
     * </p>
     *
     * @param describeInstanceAttributeRequest
     * @return A Java Future containing the result of the DescribeInstanceAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeInstanceAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceAttribute" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeInstanceAttributeResponse> describeInstanceAttribute(
            DescribeInstanceAttributeRequest describeInstanceAttributeRequest) {
        try {

            HttpResponseHandler<DescribeInstanceAttributeResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeInstanceAttributeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeInstanceAttributeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeInstanceAttributeRequest, DescribeInstanceAttributeResponse>()
                            .withOperationName("DescribeInstanceAttribute")
                            .withMarshaller(new DescribeInstanceAttributeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeInstanceAttributeRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the credit option for CPU usage of the specified burstable performance instances. The credit options
     * are <code>standard</code> and <code>unlimited</code>.
     * </p>
     * <p>
     * If you do not specify an instance ID, Amazon EC2 returns burstable performance instances with the
     * <code>unlimited</code> credit option, as well as instances that were previously configured as T2, T3, and T3a
     * with the <code>unlimited</code> credit option. For example, if you resize a T2 instance, while it is configured
     * as <code>unlimited</code>, to an M4 instance, Amazon EC2 returns the M4 instance.
     * </p>
     * <p>
     * If you specify one or more instance IDs, Amazon EC2 returns the credit option (<code>standard</code> or
     * <code>unlimited</code>) of those instances. If you specify an instance ID that is not valid, such as an instance
     * that is not a burstable performance instance, an error is returned.
     * </p>
     * <p>
     * Recently terminated instances might appear in the returned results. This interval is usually less than one hour.
     * </p>
     * <p>
     * If an Availability Zone is experiencing a service disruption and you specify instance IDs in the affected zone,
     * or do not specify any instance IDs at all, the call fails. If you specify only instance IDs in an unaffected
     * zone, the call works normally.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable
     * Performance Instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param describeInstanceCreditSpecificationsRequest
     * @return A Java Future containing the result of the DescribeInstanceCreditSpecifications operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeInstanceCreditSpecifications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceCreditSpecifications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeInstanceCreditSpecificationsResponse> describeInstanceCreditSpecifications(
            DescribeInstanceCreditSpecificationsRequest describeInstanceCreditSpecificationsRequest) {
        try {

            HttpResponseHandler<DescribeInstanceCreditSpecificationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeInstanceCreditSpecificationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeInstanceCreditSpecificationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeInstanceCreditSpecificationsRequest, DescribeInstanceCreditSpecificationsResponse>()
                            .withOperationName("DescribeInstanceCreditSpecifications")
                            .withMarshaller(new DescribeInstanceCreditSpecificationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeInstanceCreditSpecificationsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the credit option for CPU usage of the specified burstable performance instances. The credit options
     * are <code>standard</code> and <code>unlimited</code>.
     * </p>
     * <p>
     * If you do not specify an instance ID, Amazon EC2 returns burstable performance instances with the
     * <code>unlimited</code> credit option, as well as instances that were previously configured as T2, T3, and T3a
     * with the <code>unlimited</code> credit option. For example, if you resize a T2 instance, while it is configured
     * as <code>unlimited</code>, to an M4 instance, Amazon EC2 returns the M4 instance.
     * </p>
     * <p>
     * If you specify one or more instance IDs, Amazon EC2 returns the credit option (<code>standard</code> or
     * <code>unlimited</code>) of those instances. If you specify an instance ID that is not valid, such as an instance
     * that is not a burstable performance instance, an error is returned.
     * </p>
     * <p>
     * Recently terminated instances might appear in the returned results. This interval is usually less than one hour.
     * </p>
     * <p>
     * If an Availability Zone is experiencing a service disruption and you specify instance IDs in the affected zone,
     * or do not specify any instance IDs at all, the call fails. If you specify only instance IDs in an unaffected
     * zone, the call works normally.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable
     * Performance Instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInstanceCreditSpecifications(software.amazon.awssdk.services.ec2.model.DescribeInstanceCreditSpecificationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeInstanceCreditSpecificationsPublisher publisher = client.describeInstanceCreditSpecificationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeInstanceCreditSpecificationsPublisher publisher = client.describeInstanceCreditSpecificationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeInstanceCreditSpecificationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeInstanceCreditSpecificationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstanceCreditSpecifications(software.amazon.awssdk.services.ec2.model.DescribeInstanceCreditSpecificationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInstanceCreditSpecificationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeInstanceCreditSpecifications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceCreditSpecifications"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeInstanceCreditSpecificationsPublisher describeInstanceCreditSpecificationsPaginator(
            DescribeInstanceCreditSpecificationsRequest describeInstanceCreditSpecificationsRequest) {
        return new DescribeInstanceCreditSpecificationsPublisher(this,
                applyPaginatorUserAgent(describeInstanceCreditSpecificationsRequest));
    }

    /**
     * <p>
     * Describes the tag keys that are registered to appear in scheduled event notifications for resources in the
     * current Region.
     * </p>
     *
     * @param describeInstanceEventNotificationAttributesRequest
     * @return A Java Future containing the result of the DescribeInstanceEventNotificationAttributes operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeInstanceEventNotificationAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceEventNotificationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeInstanceEventNotificationAttributesResponse> describeInstanceEventNotificationAttributes(
            DescribeInstanceEventNotificationAttributesRequest describeInstanceEventNotificationAttributesRequest) {
        try {

            HttpResponseHandler<DescribeInstanceEventNotificationAttributesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeInstanceEventNotificationAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeInstanceEventNotificationAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeInstanceEventNotificationAttributesRequest, DescribeInstanceEventNotificationAttributesResponse>()
                            .withOperationName("DescribeInstanceEventNotificationAttributes")
                            .withMarshaller(new DescribeInstanceEventNotificationAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeInstanceEventNotificationAttributesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the status of the specified instances or all of your instances. By default, only running instances are
     * described, unless you specifically indicate to return the status of all instances.
     * </p>
     * <p>
     * Instance status includes the following components:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Status checks</b> - Amazon EC2 performs status checks on running EC2 instances to identify hardware and
     * software issues. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-system-instance-status-check.html">Status
     * Checks for Your Instances</a> and <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstances.html">Troubleshooting
     * Instances with Failed Status Checks</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Scheduled events</b> - Amazon EC2 can schedule events (such as reboot, stop, or terminate) for your instances
     * related to hardware issues, software updates, or system maintenance. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-instances-status-check_sched.html">Scheduled
     * Events for Your Instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Instance state</b> - You can manage your instances from the moment you launch them through their termination.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html">Instance Lifecycle</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeInstanceStatusRequest
     * @return A Java Future containing the result of the DescribeInstanceStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeInstanceStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceStatus" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeInstanceStatusResponse> describeInstanceStatus(
            DescribeInstanceStatusRequest describeInstanceStatusRequest) {
        try {

            HttpResponseHandler<DescribeInstanceStatusResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeInstanceStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeInstanceStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeInstanceStatusRequest, DescribeInstanceStatusResponse>()
                            .withOperationName("DescribeInstanceStatus")
                            .withMarshaller(new DescribeInstanceStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeInstanceStatusRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the status of the specified instances or all of your instances. By default, only running instances are
     * described, unless you specifically indicate to return the status of all instances.
     * </p>
     * <p>
     * Instance status includes the following components:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Status checks</b> - Amazon EC2 performs status checks on running EC2 instances to identify hardware and
     * software issues. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-system-instance-status-check.html">Status
     * Checks for Your Instances</a> and <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstances.html">Troubleshooting
     * Instances with Failed Status Checks</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Scheduled events</b> - Amazon EC2 can schedule events (such as reboot, stop, or terminate) for your instances
     * related to hardware issues, software updates, or system maintenance. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-instances-status-check_sched.html">Scheduled
     * Events for Your Instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Instance state</b> - You can manage your instances from the moment you launch them through their termination.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html">Instance Lifecycle</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInstanceStatus(software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeInstanceStatusPublisher publisher = client.describeInstanceStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeInstanceStatusPublisher publisher = client.describeInstanceStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstanceStatus(software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInstanceStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeInstanceStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceStatus" target="_top">AWS API
     *      Documentation</a>
     */
    public DescribeInstanceStatusPublisher describeInstanceStatusPaginator(
            DescribeInstanceStatusRequest describeInstanceStatusRequest) {
        return new DescribeInstanceStatusPublisher(this, applyPaginatorUserAgent(describeInstanceStatusRequest));
    }

    /**
     * <p>
     * Returns a list of all instance types offered. The results can be filtered by location (Region or Availability
     * Zone). If no location is specified, the instance types offered in the current Region are returned.
     * </p>
     *
     * @param describeInstanceTypeOfferingsRequest
     * @return A Java Future containing the result of the DescribeInstanceTypeOfferings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeInstanceTypeOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceTypeOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeInstanceTypeOfferingsResponse> describeInstanceTypeOfferings(
            DescribeInstanceTypeOfferingsRequest describeInstanceTypeOfferingsRequest) {
        try {

            HttpResponseHandler<DescribeInstanceTypeOfferingsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeInstanceTypeOfferingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeInstanceTypeOfferingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeInstanceTypeOfferingsRequest, DescribeInstanceTypeOfferingsResponse>()
                            .withOperationName("DescribeInstanceTypeOfferings")
                            .withMarshaller(new DescribeInstanceTypeOfferingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeInstanceTypeOfferingsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of all instance types offered. The results can be filtered by location (Region or Availability
     * Zone). If no location is specified, the instance types offered in the current Region are returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInstanceTypeOfferings(software.amazon.awssdk.services.ec2.model.DescribeInstanceTypeOfferingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeInstanceTypeOfferingsPublisher publisher = client.describeInstanceTypeOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeInstanceTypeOfferingsPublisher publisher = client.describeInstanceTypeOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeInstanceTypeOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeInstanceTypeOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstanceTypeOfferings(software.amazon.awssdk.services.ec2.model.DescribeInstanceTypeOfferingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInstanceTypeOfferingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeInstanceTypeOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceTypeOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeInstanceTypeOfferingsPublisher describeInstanceTypeOfferingsPaginator(
            DescribeInstanceTypeOfferingsRequest describeInstanceTypeOfferingsRequest) {
        return new DescribeInstanceTypeOfferingsPublisher(this, applyPaginatorUserAgent(describeInstanceTypeOfferingsRequest));
    }

    /**
     * <p>
     * Describes the details of the instance types that are offered in a location. The results can be filtered by the
     * attributes of the instance types.
     * </p>
     *
     * @param describeInstanceTypesRequest
     * @return A Java Future containing the result of the DescribeInstanceTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeInstanceTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceTypes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeInstanceTypesResponse> describeInstanceTypes(
            DescribeInstanceTypesRequest describeInstanceTypesRequest) {
        try {

            HttpResponseHandler<DescribeInstanceTypesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeInstanceTypesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeInstanceTypesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeInstanceTypesRequest, DescribeInstanceTypesResponse>()
                            .withOperationName("DescribeInstanceTypes")
                            .withMarshaller(new DescribeInstanceTypesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeInstanceTypesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the details of the instance types that are offered in a location. The results can be filtered by the
     * attributes of the instance types.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInstanceTypes(software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeInstanceTypesPublisher publisher = client.describeInstanceTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeInstanceTypesPublisher publisher = client.describeInstanceTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstanceTypes(software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInstanceTypesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeInstanceTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceTypes" target="_top">AWS API
     *      Documentation</a>
     */
    public DescribeInstanceTypesPublisher describeInstanceTypesPaginator(DescribeInstanceTypesRequest describeInstanceTypesRequest) {
        return new DescribeInstanceTypesPublisher(this, applyPaginatorUserAgent(describeInstanceTypesRequest));
    }

    /**
     * <p>
     * Describes the specified instances or all instances.
     * </p>
     * <p>
     * If you specify instance IDs, the output includes information for only the specified instances. If you specify
     * filters, the output includes information for only those instances that meet the filter criteria. If you do not
     * specify instance IDs or filters, the output includes information for all instances, which can affect performance.
     * We recommend that you use pagination to ensure that the operation returns quickly and successfully.
     * </p>
     * <p>
     * If you specify an instance ID that is not valid, an error is returned. If you specify an instance that you do not
     * own, it is not included in the output.
     * </p>
     * <p>
     * Recently terminated instances might appear in the returned results. This interval is usually less than one hour.
     * </p>
     * <p>
     * If you describe instances in the rare case where an Availability Zone is experiencing a service disruption and
     * you specify instance IDs that are in the affected zone, or do not specify any instance IDs at all, the call
     * fails. If you describe instances and specify only instance IDs that are in an unaffected zone, the call works
     * normally.
     * </p>
     *
     * @param describeInstancesRequest
     * @return A Java Future containing the result of the DescribeInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstances" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeInstancesResponse> describeInstances(DescribeInstancesRequest describeInstancesRequest) {
        try {

            HttpResponseHandler<DescribeInstancesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeInstancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeInstancesRequest, DescribeInstancesResponse>()
                            .withOperationName("DescribeInstances")
                            .withMarshaller(new DescribeInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeInstancesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified instances or all instances.
     * </p>
     * <p>
     * If you specify instance IDs, the output includes information for only the specified instances. If you specify
     * filters, the output includes information for only those instances that meet the filter criteria. If you do not
     * specify instance IDs or filters, the output includes information for all instances, which can affect performance.
     * We recommend that you use pagination to ensure that the operation returns quickly and successfully.
     * </p>
     * <p>
     * If you specify an instance ID that is not valid, an error is returned. If you specify an instance that you do not
     * own, it is not included in the output.
     * </p>
     * <p>
     * Recently terminated instances might appear in the returned results. This interval is usually less than one hour.
     * </p>
     * <p>
     * If you describe instances in the rare case where an Availability Zone is experiencing a service disruption and
     * you specify instance IDs that are in the affected zone, or do not specify any instance IDs at all, the call
     * fails. If you describe instances and specify only instance IDs that are in an unaffected zone, the call works
     * normally.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInstances(software.amazon.awssdk.services.ec2.model.DescribeInstancesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeInstancesPublisher publisher = client.describeInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeInstancesPublisher publisher = client.describeInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstances(software.amazon.awssdk.services.ec2.model.DescribeInstancesRequest)} operation.</b>
     * </p>
     *
     * @param describeInstancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstances" target="_top">AWS API
     *      Documentation</a>
     */
    public DescribeInstancesPublisher describeInstancesPaginator(DescribeInstancesRequest describeInstancesRequest) {
        return new DescribeInstancesPublisher(this, applyPaginatorUserAgent(describeInstancesRequest));
    }

    /**
     * <p>
     * Describes one or more of your internet gateways.
     * </p>
     *
     * @param describeInternetGatewaysRequest
     * @return A Java Future containing the result of the DescribeInternetGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeInternetGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInternetGateways" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeInternetGatewaysResponse> describeInternetGateways(
            DescribeInternetGatewaysRequest describeInternetGatewaysRequest) {
        try {

            HttpResponseHandler<DescribeInternetGatewaysResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeInternetGatewaysResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeInternetGatewaysResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeInternetGatewaysRequest, DescribeInternetGatewaysResponse>()
                            .withOperationName("DescribeInternetGateways")
                            .withMarshaller(new DescribeInternetGatewaysRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeInternetGatewaysRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes one or more of your internet gateways.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInternetGateways(software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeInternetGatewaysPublisher publisher = client.describeInternetGatewaysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeInternetGatewaysPublisher publisher = client.describeInternetGatewaysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInternetGateways(software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInternetGatewaysRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeInternetGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInternetGateways" target="_top">AWS
     *      API Documentation</a>
     */
    public DescribeInternetGatewaysPublisher describeInternetGatewaysPaginator(
            DescribeInternetGatewaysRequest describeInternetGatewaysRequest) {
        return new DescribeInternetGatewaysPublisher(this, applyPaginatorUserAgent(describeInternetGatewaysRequest));
    }

    /**
     * <p>
     * Describes your IPv6 address pools.
     * </p>
     *
     * @param describeIpv6PoolsRequest
     * @return A Java Future containing the result of the DescribeIpv6Pools operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeIpv6Pools
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIpv6Pools" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeIpv6PoolsResponse> describeIpv6Pools(DescribeIpv6PoolsRequest describeIpv6PoolsRequest) {
        try {

            HttpResponseHandler<DescribeIpv6PoolsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeIpv6PoolsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeIpv6PoolsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeIpv6PoolsRequest, DescribeIpv6PoolsResponse>()
                            .withOperationName("DescribeIpv6Pools")
                            .withMarshaller(new DescribeIpv6PoolsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeIpv6PoolsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes your IPv6 address pools.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeIpv6Pools(software.amazon.awssdk.services.ec2.model.DescribeIpv6PoolsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeIpv6PoolsPublisher publisher = client.describeIpv6PoolsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeIpv6PoolsPublisher publisher = client.describeIpv6PoolsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeIpv6PoolsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeIpv6PoolsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeIpv6Pools(software.amazon.awssdk.services.ec2.model.DescribeIpv6PoolsRequest)} operation.</b>
     * </p>
     *
     * @param describeIpv6PoolsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeIpv6Pools
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIpv6Pools" target="_top">AWS API
     *      Documentation</a>
     */
    public DescribeIpv6PoolsPublisher describeIpv6PoolsPaginator(DescribeIpv6PoolsRequest describeIpv6PoolsRequest) {
        return new DescribeIpv6PoolsPublisher(this, applyPaginatorUserAgent(describeIpv6PoolsRequest));
    }

    /**
     * <p>
     * Describes the specified key pairs or all of your key pairs.
     * </p>
     * <p>
     * For more information about key pairs, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Key Pairs</a> in the <i>Amazon
     * Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param describeKeyPairsRequest
     * @return A Java Future containing the result of the DescribeKeyPairs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeKeyPairs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeKeyPairs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeKeyPairsResponse> describeKeyPairs(DescribeKeyPairsRequest describeKeyPairsRequest) {
        try {

            HttpResponseHandler<DescribeKeyPairsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeKeyPairsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeKeyPairsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeKeyPairsRequest, DescribeKeyPairsResponse>()
                            .withOperationName("DescribeKeyPairs")
                            .withMarshaller(new DescribeKeyPairsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeKeyPairsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes one or more versions of a specified launch template. You can describe all versions, individual
     * versions, or a range of versions.
     * </p>
     *
     * @param describeLaunchTemplateVersionsRequest
     * @return A Java Future containing the result of the DescribeLaunchTemplateVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeLaunchTemplateVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLaunchTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeLaunchTemplateVersionsResponse> describeLaunchTemplateVersions(
            DescribeLaunchTemplateVersionsRequest describeLaunchTemplateVersionsRequest) {
        try {

            HttpResponseHandler<DescribeLaunchTemplateVersionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeLaunchTemplateVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeLaunchTemplateVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeLaunchTemplateVersionsRequest, DescribeLaunchTemplateVersionsResponse>()
                            .withOperationName("DescribeLaunchTemplateVersions")
                            .withMarshaller(new DescribeLaunchTemplateVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeLaunchTemplateVersionsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes one or more versions of a specified launch template. You can describe all versions, individual
     * versions, or a range of versions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeLaunchTemplateVersions(software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeLaunchTemplateVersionsPublisher publisher = client.describeLaunchTemplateVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeLaunchTemplateVersionsPublisher publisher = client.describeLaunchTemplateVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLaunchTemplateVersions(software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeLaunchTemplateVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeLaunchTemplateVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLaunchTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeLaunchTemplateVersionsPublisher describeLaunchTemplateVersionsPaginator(
            DescribeLaunchTemplateVersionsRequest describeLaunchTemplateVersionsRequest) {
        return new DescribeLaunchTemplateVersionsPublisher(this, applyPaginatorUserAgent(describeLaunchTemplateVersionsRequest));
    }

    /**
     * <p>
     * Describes one or more launch templates.
     * </p>
     *
     * @param describeLaunchTemplatesRequest
     * @return A Java Future containing the result of the DescribeLaunchTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeLaunchTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLaunchTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeLaunchTemplatesResponse> describeLaunchTemplates(
            DescribeLaunchTemplatesRequest describeLaunchTemplatesRequest) {
        try {

            HttpResponseHandler<DescribeLaunchTemplatesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeLaunchTemplatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeLaunchTemplatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeLaunchTemplatesRequest, DescribeLaunchTemplatesResponse>()
                            .withOperationName("DescribeLaunchTemplates")
                            .withMarshaller(new DescribeLaunchTemplatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeLaunchTemplatesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes one or more launch templates.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeLaunchTemplates(software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeLaunchTemplatesPublisher publisher = client.describeLaunchTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeLaunchTemplatesPublisher publisher = client.describeLaunchTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLaunchTemplates(software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeLaunchTemplatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeLaunchTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLaunchTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    public DescribeLaunchTemplatesPublisher describeLaunchTemplatesPaginator(
            DescribeLaunchTemplatesRequest describeLaunchTemplatesRequest) {
        return new DescribeLaunchTemplatesPublisher(this, applyPaginatorUserAgent(describeLaunchTemplatesRequest));
    }

    /**
     * <p>
     * Describes the associations between virtual interface groups and local gateway route tables.
     * </p>
     *
     * @param describeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest
     * @return A Java Future containing the result of the
     *         DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse> describeLocalGatewayRouteTableVirtualInterfaceGroupAssociations(
            DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest describeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest) {
        try {

            HttpResponseHandler<DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest, DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse>()
                            .withOperationName("DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations")
                            .withMarshaller(
                                    new DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequestMarshaller(
                                            protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the associations between virtual interface groups and local gateway route tables.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeLocalGatewayRouteTableVirtualInterfaceGroupAssociations(software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPublisher publisher = client.describeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPublisher publisher = client.describeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLocalGatewayRouteTableVirtualInterfaceGroupAssociations(software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPublisher describeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPaginator(
            DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest describeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest) {
        return new DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPublisher(this,
                applyPaginatorUserAgent(describeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest));
    }

    /**
     * <p>
     * Describes the specified associations between VPCs and local gateway route tables.
     * </p>
     *
     * @param describeLocalGatewayRouteTableVpcAssociationsRequest
     * @return A Java Future containing the result of the DescribeLocalGatewayRouteTableVpcAssociations operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeLocalGatewayRouteTableVpcAssociations
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayRouteTableVpcAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeLocalGatewayRouteTableVpcAssociationsResponse> describeLocalGatewayRouteTableVpcAssociations(
            DescribeLocalGatewayRouteTableVpcAssociationsRequest describeLocalGatewayRouteTableVpcAssociationsRequest) {
        try {

            HttpResponseHandler<DescribeLocalGatewayRouteTableVpcAssociationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeLocalGatewayRouteTableVpcAssociationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeLocalGatewayRouteTableVpcAssociationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeLocalGatewayRouteTableVpcAssociationsRequest, DescribeLocalGatewayRouteTableVpcAssociationsResponse>()
                            .withOperationName("DescribeLocalGatewayRouteTableVpcAssociations")
                            .withMarshaller(new DescribeLocalGatewayRouteTableVpcAssociationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeLocalGatewayRouteTableVpcAssociationsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified associations between VPCs and local gateway route tables.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeLocalGatewayRouteTableVpcAssociations(software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeLocalGatewayRouteTableVpcAssociationsPublisher publisher = client.describeLocalGatewayRouteTableVpcAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeLocalGatewayRouteTableVpcAssociationsPublisher publisher = client.describeLocalGatewayRouteTableVpcAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLocalGatewayRouteTableVpcAssociations(software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeLocalGatewayRouteTableVpcAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeLocalGatewayRouteTableVpcAssociations
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayRouteTableVpcAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeLocalGatewayRouteTableVpcAssociationsPublisher describeLocalGatewayRouteTableVpcAssociationsPaginator(
            DescribeLocalGatewayRouteTableVpcAssociationsRequest describeLocalGatewayRouteTableVpcAssociationsRequest) {
        return new DescribeLocalGatewayRouteTableVpcAssociationsPublisher(this,
                applyPaginatorUserAgent(describeLocalGatewayRouteTableVpcAssociationsRequest));
    }

    /**
     * <p>
     * Describes one or more local gateway route tables. By default, all local gateway route tables are described.
     * Alternatively, you can filter the results.
     * </p>
     *
     * @param describeLocalGatewayRouteTablesRequest
     * @return A Java Future containing the result of the DescribeLocalGatewayRouteTables operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeLocalGatewayRouteTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayRouteTables"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeLocalGatewayRouteTablesResponse> describeLocalGatewayRouteTables(
            DescribeLocalGatewayRouteTablesRequest describeLocalGatewayRouteTablesRequest) {
        try {

            HttpResponseHandler<DescribeLocalGatewayRouteTablesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeLocalGatewayRouteTablesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeLocalGatewayRouteTablesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeLocalGatewayRouteTablesRequest, DescribeLocalGatewayRouteTablesResponse>()
                            .withOperationName("DescribeLocalGatewayRouteTables")
                            .withMarshaller(new DescribeLocalGatewayRouteTablesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeLocalGatewayRouteTablesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes one or more local gateway route tables. By default, all local gateway route tables are described.
     * Alternatively, you can filter the results.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeLocalGatewayRouteTables(software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTablesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeLocalGatewayRouteTablesPublisher publisher = client.describeLocalGatewayRouteTablesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeLocalGatewayRouteTablesPublisher publisher = client.describeLocalGatewayRouteTablesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTablesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTablesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLocalGatewayRouteTables(software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTablesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeLocalGatewayRouteTablesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeLocalGatewayRouteTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayRouteTables"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeLocalGatewayRouteTablesPublisher describeLocalGatewayRouteTablesPaginator(
            DescribeLocalGatewayRouteTablesRequest describeLocalGatewayRouteTablesRequest) {
        return new DescribeLocalGatewayRouteTablesPublisher(this, applyPaginatorUserAgent(describeLocalGatewayRouteTablesRequest));
    }

    /**
     * <p>
     * Describes the specified local gateway virtual interface groups.
     * </p>
     *
     * @param describeLocalGatewayVirtualInterfaceGroupsRequest
     * @return A Java Future containing the result of the DescribeLocalGatewayVirtualInterfaceGroups operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeLocalGatewayVirtualInterfaceGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayVirtualInterfaceGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeLocalGatewayVirtualInterfaceGroupsResponse> describeLocalGatewayVirtualInterfaceGroups(
            DescribeLocalGatewayVirtualInterfaceGroupsRequest describeLocalGatewayVirtualInterfaceGroupsRequest) {
        try {

            HttpResponseHandler<DescribeLocalGatewayVirtualInterfaceGroupsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeLocalGatewayVirtualInterfaceGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeLocalGatewayVirtualInterfaceGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeLocalGatewayVirtualInterfaceGroupsRequest, DescribeLocalGatewayVirtualInterfaceGroupsResponse>()
                            .withOperationName("DescribeLocalGatewayVirtualInterfaceGroups")
                            .withMarshaller(new DescribeLocalGatewayVirtualInterfaceGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeLocalGatewayVirtualInterfaceGroupsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified local gateway virtual interface groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeLocalGatewayVirtualInterfaceGroups(software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeLocalGatewayVirtualInterfaceGroupsPublisher publisher = client.describeLocalGatewayVirtualInterfaceGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeLocalGatewayVirtualInterfaceGroupsPublisher publisher = client.describeLocalGatewayVirtualInterfaceGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLocalGatewayVirtualInterfaceGroups(software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeLocalGatewayVirtualInterfaceGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeLocalGatewayVirtualInterfaceGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayVirtualInterfaceGroups"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeLocalGatewayVirtualInterfaceGroupsPublisher describeLocalGatewayVirtualInterfaceGroupsPaginator(
            DescribeLocalGatewayVirtualInterfaceGroupsRequest describeLocalGatewayVirtualInterfaceGroupsRequest) {
        return new DescribeLocalGatewayVirtualInterfaceGroupsPublisher(this,
                applyPaginatorUserAgent(describeLocalGatewayVirtualInterfaceGroupsRequest));
    }

    /**
     * <p>
     * Describes the specified local gateway virtual interfaces.
     * </p>
     *
     * @param describeLocalGatewayVirtualInterfacesRequest
     * @return A Java Future containing the result of the DescribeLocalGatewayVirtualInterfaces operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeLocalGatewayVirtualInterfaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayVirtualInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeLocalGatewayVirtualInterfacesResponse> describeLocalGatewayVirtualInterfaces(
            DescribeLocalGatewayVirtualInterfacesRequest describeLocalGatewayVirtualInterfacesRequest) {
        try {

            HttpResponseHandler<DescribeLocalGatewayVirtualInterfacesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeLocalGatewayVirtualInterfacesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeLocalGatewayVirtualInterfacesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeLocalGatewayVirtualInterfacesRequest, DescribeLocalGatewayVirtualInterfacesResponse>()
                            .withOperationName("DescribeLocalGatewayVirtualInterfaces")
                            .withMarshaller(new DescribeLocalGatewayVirtualInterfacesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeLocalGatewayVirtualInterfacesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified local gateway virtual interfaces.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeLocalGatewayVirtualInterfaces(software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfacesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeLocalGatewayVirtualInterfacesPublisher publisher = client.describeLocalGatewayVirtualInterfacesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeLocalGatewayVirtualInterfacesPublisher publisher = client.describeLocalGatewayVirtualInterfacesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfacesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfacesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLocalGatewayVirtualInterfaces(software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfacesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeLocalGatewayVirtualInterfacesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeLocalGatewayVirtualInterfaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayVirtualInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeLocalGatewayVirtualInterfacesPublisher describeLocalGatewayVirtualInterfacesPaginator(
            DescribeLocalGatewayVirtualInterfacesRequest describeLocalGatewayVirtualInterfacesRequest) {
        return new DescribeLocalGatewayVirtualInterfacesPublisher(this,
                applyPaginatorUserAgent(describeLocalGatewayVirtualInterfacesRequest));
    }

    /**
     * <p>
     * Describes one or more local gateways. By default, all local gateways are described. Alternatively, you can filter
     * the results.
     * </p>
     *
     * @param describeLocalGatewaysRequest
     * @return A Java Future containing the result of the DescribeLocalGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeLocalGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGateways" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeLocalGatewaysResponse> describeLocalGateways(
            DescribeLocalGatewaysRequest describeLocalGatewaysRequest) {
        try {

            HttpResponseHandler<DescribeLocalGatewaysResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeLocalGatewaysResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeLocalGatewaysResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeLocalGatewaysRequest, DescribeLocalGatewaysResponse>()
                            .withOperationName("DescribeLocalGateways")
                            .withMarshaller(new DescribeLocalGatewaysRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeLocalGatewaysRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes one or more local gateways. By default, all local gateways are described. Alternatively, you can filter
     * the results.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeLocalGateways(software.amazon.awssdk.services.ec2.model.DescribeLocalGatewaysRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeLocalGatewaysPublisher publisher = client.describeLocalGatewaysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeLocalGatewaysPublisher publisher = client.describeLocalGatewaysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeLocalGatewaysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeLocalGatewaysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLocalGateways(software.amazon.awssdk.services.ec2.model.DescribeLocalGatewaysRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeLocalGatewaysRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeLocalGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGateways" target="_top">AWS API
     *      Documentation</a>
     */
    public DescribeLocalGatewaysPublisher describeLocalGatewaysPaginator(DescribeLocalGatewaysRequest describeLocalGatewaysRequest) {
        return new DescribeLocalGatewaysPublisher(this, applyPaginatorUserAgent(describeLocalGatewaysRequest));
    }

    /**
     * <p>
     * Describes your Elastic IP addresses that are being moved to the EC2-VPC platform, or that are being restored to
     * the EC2-Classic platform. This request does not return information about any other Elastic IP addresses in your
     * account.
     * </p>
     *
     * @param describeMovingAddressesRequest
     * @return A Java Future containing the result of the DescribeMovingAddresses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeMovingAddresses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeMovingAddresses" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMovingAddressesResponse> describeMovingAddresses(
            DescribeMovingAddressesRequest describeMovingAddressesRequest) {
        try {

            HttpResponseHandler<DescribeMovingAddressesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeMovingAddressesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeMovingAddressesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMovingAddressesRequest, DescribeMovingAddressesResponse>()
                            .withOperationName("DescribeMovingAddresses")
                            .withMarshaller(new DescribeMovingAddressesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeMovingAddressesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes your Elastic IP addresses that are being moved to the EC2-VPC platform, or that are being restored to
     * the EC2-Classic platform. This request does not return information about any other Elastic IP addresses in your
     * account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMovingAddresses(software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeMovingAddressesPublisher publisher = client.describeMovingAddressesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeMovingAddressesPublisher publisher = client.describeMovingAddressesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMovingAddresses(software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMovingAddressesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeMovingAddresses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeMovingAddresses" target="_top">AWS
     *      API Documentation</a>
     */
    public DescribeMovingAddressesPublisher describeMovingAddressesPaginator(
            DescribeMovingAddressesRequest describeMovingAddressesRequest) {
        return new DescribeMovingAddressesPublisher(this, applyPaginatorUserAgent(describeMovingAddressesRequest));
    }

    /**
     * <p>
     * Describes one or more of your NAT gateways.
     * </p>
     *
     * @param describeNatGatewaysRequest
     * @return A Java Future containing the result of the DescribeNatGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeNatGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNatGateways" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeNatGatewaysResponse> describeNatGateways(
            DescribeNatGatewaysRequest describeNatGatewaysRequest) {
        try {

            HttpResponseHandler<DescribeNatGatewaysResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeNatGatewaysResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeNatGatewaysResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeNatGatewaysRequest, DescribeNatGatewaysResponse>()
                            .withOperationName("DescribeNatGateways")
                            .withMarshaller(new DescribeNatGatewaysRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeNatGatewaysRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes one or more of your NAT gateways.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeNatGateways(software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeNatGatewaysPublisher publisher = client.describeNatGatewaysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeNatGatewaysPublisher publisher = client.describeNatGatewaysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeNatGateways(software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysRequest)} operation.</b>
     * </p>
     *
     * @param describeNatGatewaysRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeNatGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNatGateways" target="_top">AWS API
     *      Documentation</a>
     */
    public DescribeNatGatewaysPublisher describeNatGatewaysPaginator(DescribeNatGatewaysRequest describeNatGatewaysRequest) {
        return new DescribeNatGatewaysPublisher(this, applyPaginatorUserAgent(describeNatGatewaysRequest));
    }

    /**
     * <p>
     * Describes one or more of your network ACLs.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html">Network
     * ACLs</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param describeNetworkAclsRequest
     * @return A Java Future containing the result of the DescribeNetworkAcls operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeNetworkAcls
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkAcls" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeNetworkAclsResponse> describeNetworkAcls(
            DescribeNetworkAclsRequest describeNetworkAclsRequest) {
        try {

            HttpResponseHandler<DescribeNetworkAclsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeNetworkAclsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeNetworkAclsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeNetworkAclsRequest, DescribeNetworkAclsResponse>()
                            .withOperationName("DescribeNetworkAcls")
                            .withMarshaller(new DescribeNetworkAclsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeNetworkAclsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes one or more of your network ACLs.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html">Network
     * ACLs</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeNetworkAcls(software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeNetworkAclsPublisher publisher = client.describeNetworkAclsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeNetworkAclsPublisher publisher = client.describeNetworkAclsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeNetworkAcls(software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsRequest)} operation.</b>
     * </p>
     *
     * @param describeNetworkAclsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeNetworkAcls
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkAcls" target="_top">AWS API
     *      Documentation</a>
     */
    public DescribeNetworkAclsPublisher describeNetworkAclsPaginator(DescribeNetworkAclsRequest describeNetworkAclsRequest) {
        return new DescribeNetworkAclsPublisher(this, applyPaginatorUserAgent(describeNetworkAclsRequest));
    }

    /**
     * <p>
     * Describes a network interface attribute. You can specify only one attribute at a time.
     * </p>
     *
     * @param describeNetworkInterfaceAttributeRequest
     *        Contains the parameters for DescribeNetworkInterfaceAttribute.
     * @return A Java Future containing the result of the DescribeNetworkInterfaceAttribute operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeNetworkInterfaceAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInterfaceAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeNetworkInterfaceAttributeResponse> describeNetworkInterfaceAttribute(
            DescribeNetworkInterfaceAttributeRequest describeNetworkInterfaceAttributeRequest) {
        try {

            HttpResponseHandler<DescribeNetworkInterfaceAttributeResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeNetworkInterfaceAttributeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeNetworkInterfaceAttributeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeNetworkInterfaceAttributeRequest, DescribeNetworkInterfaceAttributeResponse>()
                            .withOperationName("DescribeNetworkInterfaceAttribute")
                            .withMarshaller(new DescribeNetworkInterfaceAttributeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeNetworkInterfaceAttributeRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the permissions for your network interfaces.
     * </p>
     *
     * @param describeNetworkInterfacePermissionsRequest
     *        Contains the parameters for DescribeNetworkInterfacePermissions.
     * @return A Java Future containing the result of the DescribeNetworkInterfacePermissions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeNetworkInterfacePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInterfacePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeNetworkInterfacePermissionsResponse> describeNetworkInterfacePermissions(
            DescribeNetworkInterfacePermissionsRequest describeNetworkInterfacePermissionsRequest) {
        try {

            HttpResponseHandler<DescribeNetworkInterfacePermissionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeNetworkInterfacePermissionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeNetworkInterfacePermissionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeNetworkInterfacePermissionsRequest, DescribeNetworkInterfacePermissionsResponse>()
                            .withOperationName("DescribeNetworkInterfacePermissions")
                            .withMarshaller(new DescribeNetworkInterfacePermissionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeNetworkInterfacePermissionsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the permissions for your network interfaces.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeNetworkInterfacePermissions(software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacePermissionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeNetworkInterfacePermissionsPublisher publisher = client.describeNetworkInterfacePermissionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeNetworkInterfacePermissionsPublisher publisher = client.describeNetworkInterfacePermissionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacePermissionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacePermissionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeNetworkInterfacePermissions(software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacePermissionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeNetworkInterfacePermissionsRequest
     *        Contains the parameters for DescribeNetworkInterfacePermissions.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeNetworkInterfacePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInterfacePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeNetworkInterfacePermissionsPublisher describeNetworkInterfacePermissionsPaginator(
            DescribeNetworkInterfacePermissionsRequest describeNetworkInterfacePermissionsRequest) {
        return new DescribeNetworkInterfacePermissionsPublisher(this,
                applyPaginatorUserAgent(describeNetworkInterfacePermissionsRequest));
    }

    /**
     * <p>
     * Describes one or more of your network interfaces.
     * </p>
     *
     * @param describeNetworkInterfacesRequest
     *        Contains the parameters for DescribeNetworkInterfaces.
     * @return A Java Future containing the result of the DescribeNetworkInterfaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeNetworkInterfaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInterfaces" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeNetworkInterfacesResponse> describeNetworkInterfaces(
            DescribeNetworkInterfacesRequest describeNetworkInterfacesRequest) {
        try {

            HttpResponseHandler<DescribeNetworkInterfacesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeNetworkInterfacesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeNetworkInterfacesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeNetworkInterfacesRequest, DescribeNetworkInterfacesResponse>()
                            .withOperationName("DescribeNetworkInterfaces")
                            .withMarshaller(new DescribeNetworkInterfacesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeNetworkInterfacesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes one or more of your network interfaces.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeNetworkInterfaces(software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeNetworkInterfacesPublisher publisher = client.describeNetworkInterfacesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeNetworkInterfacesPublisher publisher = client.describeNetworkInterfacesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeNetworkInterfaces(software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeNetworkInterfacesRequest
     *        Contains the parameters for DescribeNetworkInterfaces.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeNetworkInterfaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInterfaces" target="_top">AWS
     *      API Documentation</a>
     */
    public DescribeNetworkInterfacesPublisher describeNetworkInterfacesPaginator(
            DescribeNetworkInterfacesRequest describeNetworkInterfacesRequest) {
        return new DescribeNetworkInterfacesPublisher(this, applyPaginatorUserAgent(describeNetworkInterfacesRequest));
    }

    /**
     * <p>
     * Describes the specified placement groups or all of your placement groups. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement Groups</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param describePlacementGroupsRequest
     * @return A Java Future containing the result of the DescribePlacementGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribePlacementGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePlacementGroups" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePlacementGroupsResponse> describePlacementGroups(
            DescribePlacementGroupsRequest describePlacementGroupsRequest) {
        try {

            HttpResponseHandler<DescribePlacementGroupsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribePlacementGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribePlacementGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePlacementGroupsRequest, DescribePlacementGroupsResponse>()
                            .withOperationName("DescribePlacementGroups")
                            .withMarshaller(new DescribePlacementGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describePlacementGroupsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes available AWS services in a prefix list format, which includes the prefix list name and prefix list ID
     * of the service and the IP address range for the service. A prefix list ID is required for creating an outbound
     * security group rule that allows traffic from a VPC to access an AWS service through a gateway VPC endpoint.
     * Currently, the services that support this action are Amazon S3 and Amazon DynamoDB.
     * </p>
     *
     * @param describePrefixListsRequest
     * @return A Java Future containing the result of the DescribePrefixLists operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribePrefixLists
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePrefixLists" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePrefixListsResponse> describePrefixLists(
            DescribePrefixListsRequest describePrefixListsRequest) {
        try {

            HttpResponseHandler<DescribePrefixListsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribePrefixListsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribePrefixListsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePrefixListsRequest, DescribePrefixListsResponse>()
                            .withOperationName("DescribePrefixLists")
                            .withMarshaller(new DescribePrefixListsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describePrefixListsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes available AWS services in a prefix list format, which includes the prefix list name and prefix list ID
     * of the service and the IP address range for the service. A prefix list ID is required for creating an outbound
     * security group rule that allows traffic from a VPC to access an AWS service through a gateway VPC endpoint.
     * Currently, the services that support this action are Amazon S3 and Amazon DynamoDB.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePrefixLists(software.amazon.awssdk.services.ec2.model.DescribePrefixListsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribePrefixListsPublisher publisher = client.describePrefixListsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribePrefixListsPublisher publisher = client.describePrefixListsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribePrefixListsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribePrefixListsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePrefixLists(software.amazon.awssdk.services.ec2.model.DescribePrefixListsRequest)} operation.</b>
     * </p>
     *
     * @param describePrefixListsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribePrefixLists
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePrefixLists" target="_top">AWS API
     *      Documentation</a>
     */
    public DescribePrefixListsPublisher describePrefixListsPaginator(DescribePrefixListsRequest describePrefixListsRequest) {
        return new DescribePrefixListsPublisher(this, applyPaginatorUserAgent(describePrefixListsRequest));
    }

    /**
     * <p>
     * Describes the ID format settings for the root user and all IAM roles and IAM users that have explicitly specified
     * a longer ID (17-character ID) preference.
     * </p>
     * <p>
     * By default, all IAM roles and IAM users default to the same ID settings as the root user, unless they explicitly
     * override the settings. This request is useful for identifying those IAM users and IAM roles that have overridden
     * the default ID settings.
     * </p>
     * <p>
     * The following resource types support longer IDs: <code>bundle</code> | <code>conversion-task</code> |
     * <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> |
     * <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> |
     * <code>import-task</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> |
     * <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code>
     * | <code>prefix-list</code> | <code>reservation</code> | <code>route-table</code> |
     * <code>route-table-association</code> | <code>security-group</code> | <code>snapshot</code> | <code>subnet</code>
     * | <code>subnet-cidr-block-association</code> | <code>volume</code> | <code>vpc</code> |
     * <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> |
     * <code>vpn-connection</code> | <code>vpn-gateway</code>.
     * </p>
     *
     * @param describePrincipalIdFormatRequest
     * @return A Java Future containing the result of the DescribePrincipalIdFormat operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribePrincipalIdFormat
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePrincipalIdFormat" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePrincipalIdFormatResponse> describePrincipalIdFormat(
            DescribePrincipalIdFormatRequest describePrincipalIdFormatRequest) {
        try {

            HttpResponseHandler<DescribePrincipalIdFormatResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribePrincipalIdFormatResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribePrincipalIdFormatResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePrincipalIdFormatRequest, DescribePrincipalIdFormatResponse>()
                            .withOperationName("DescribePrincipalIdFormat")
                            .withMarshaller(new DescribePrincipalIdFormatRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describePrincipalIdFormatRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the ID format settings for the root user and all IAM roles and IAM users that have explicitly specified
     * a longer ID (17-character ID) preference.
     * </p>
     * <p>
     * By default, all IAM roles and IAM users default to the same ID settings as the root user, unless they explicitly
     * override the settings. This request is useful for identifying those IAM users and IAM roles that have overridden
     * the default ID settings.
     * </p>
     * <p>
     * The following resource types support longer IDs: <code>bundle</code> | <code>conversion-task</code> |
     * <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> |
     * <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> |
     * <code>import-task</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> |
     * <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code>
     * | <code>prefix-list</code> | <code>reservation</code> | <code>route-table</code> |
     * <code>route-table-association</code> | <code>security-group</code> | <code>snapshot</code> | <code>subnet</code>
     * | <code>subnet-cidr-block-association</code> | <code>volume</code> | <code>vpc</code> |
     * <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> |
     * <code>vpn-connection</code> | <code>vpn-gateway</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePrincipalIdFormat(software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribePrincipalIdFormatPublisher publisher = client.describePrincipalIdFormatPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribePrincipalIdFormatPublisher publisher = client.describePrincipalIdFormatPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePrincipalIdFormat(software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePrincipalIdFormatRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribePrincipalIdFormat
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePrincipalIdFormat" target="_top">AWS
     *      API Documentation</a>
     */
    public DescribePrincipalIdFormatPublisher describePrincipalIdFormatPaginator(
            DescribePrincipalIdFormatRequest describePrincipalIdFormatRequest) {
        return new DescribePrincipalIdFormatPublisher(this, applyPaginatorUserAgent(describePrincipalIdFormatRequest));
    }

    /**
     * <p>
     * Describes the specified IPv4 address pools.
     * </p>
     *
     * @param describePublicIpv4PoolsRequest
     * @return A Java Future containing the result of the DescribePublicIpv4Pools operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribePublicIpv4Pools
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePublicIpv4Pools" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePublicIpv4PoolsResponse> describePublicIpv4Pools(
            DescribePublicIpv4PoolsRequest describePublicIpv4PoolsRequest) {
        try {

            HttpResponseHandler<DescribePublicIpv4PoolsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribePublicIpv4PoolsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribePublicIpv4PoolsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePublicIpv4PoolsRequest, DescribePublicIpv4PoolsResponse>()
                            .withOperationName("DescribePublicIpv4Pools")
                            .withMarshaller(new DescribePublicIpv4PoolsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describePublicIpv4PoolsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified IPv4 address pools.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePublicIpv4Pools(software.amazon.awssdk.services.ec2.model.DescribePublicIpv4PoolsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribePublicIpv4PoolsPublisher publisher = client.describePublicIpv4PoolsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribePublicIpv4PoolsPublisher publisher = client.describePublicIpv4PoolsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribePublicIpv4PoolsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribePublicIpv4PoolsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePublicIpv4Pools(software.amazon.awssdk.services.ec2.model.DescribePublicIpv4PoolsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePublicIpv4PoolsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribePublicIpv4Pools
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePublicIpv4Pools" target="_top">AWS
     *      API Documentation</a>
     */
    public DescribePublicIpv4PoolsPublisher describePublicIpv4PoolsPaginator(
            DescribePublicIpv4PoolsRequest describePublicIpv4PoolsRequest) {
        return new DescribePublicIpv4PoolsPublisher(this, applyPaginatorUserAgent(describePublicIpv4PoolsRequest));
    }

    /**
     * <p>
     * Describes the Regions that are enabled for your account, or all Regions.
     * </p>
     * <p>
     * For a list of the Regions supported by Amazon EC2, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/rande.html#ec2_region"> Regions and Endpoints</a>.
     * </p>
     * <p>
     * For information about enabling and disabling Regions for your account, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html">Managing AWS Regions</a> in the <i>AWS
     * General Reference</i>.
     * </p>
     *
     * @param describeRegionsRequest
     * @return A Java Future containing the result of the DescribeRegions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeRegions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeRegions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRegionsResponse> describeRegions(DescribeRegionsRequest describeRegionsRequest) {
        try {

            HttpResponseHandler<DescribeRegionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeRegionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeRegionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRegionsRequest, DescribeRegionsResponse>()
                            .withOperationName("DescribeRegions")
                            .withMarshaller(new DescribeRegionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeRegionsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes one or more of the Reserved Instances that you purchased.
     * </p>
     * <p>
     * For more information about Reserved Instances, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/concepts-on-demand-reserved-instances.html">Reserved
     * Instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param describeReservedInstancesRequest
     *        Contains the parameters for DescribeReservedInstances.
     * @return A Java Future containing the result of the DescribeReservedInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeReservedInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstances" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeReservedInstancesResponse> describeReservedInstances(
            DescribeReservedInstancesRequest describeReservedInstancesRequest) {
        try {

            HttpResponseHandler<DescribeReservedInstancesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeReservedInstancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeReservedInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeReservedInstancesRequest, DescribeReservedInstancesResponse>()
                            .withOperationName("DescribeReservedInstances")
                            .withMarshaller(new DescribeReservedInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeReservedInstancesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes your account's Reserved Instance listings in the Reserved Instance Marketplace.
     * </p>
     * <p>
     * The Reserved Instance Marketplace matches sellers who want to resell Reserved Instance capacity that they no
     * longer need with buyers who want to purchase additional capacity. Reserved Instances bought and sold through the
     * Reserved Instance Marketplace work like any other Reserved Instances.
     * </p>
     * <p>
     * As a seller, you choose to list some or all of your Reserved Instances, and you specify the upfront price to
     * receive for them. Your Reserved Instances are then listed in the Reserved Instance Marketplace and are available
     * for purchase.
     * </p>
     * <p>
     * As a buyer, you specify the configuration of the Reserved Instance to purchase, and the Marketplace matches what
     * you're searching for with what's available. The Marketplace first sells the lowest priced Reserved Instances to
     * you, and continues to sell available Reserved Instance listings to you until your demand is met. You are charged
     * based on the total price of all of the listings that you purchase.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance
     * Marketplace</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param describeReservedInstancesListingsRequest
     *        Contains the parameters for DescribeReservedInstancesListings.
     * @return A Java Future containing the result of the DescribeReservedInstancesListings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeReservedInstancesListings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesListings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeReservedInstancesListingsResponse> describeReservedInstancesListings(
            DescribeReservedInstancesListingsRequest describeReservedInstancesListingsRequest) {
        try {

            HttpResponseHandler<DescribeReservedInstancesListingsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeReservedInstancesListingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeReservedInstancesListingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeReservedInstancesListingsRequest, DescribeReservedInstancesListingsResponse>()
                            .withOperationName("DescribeReservedInstancesListings")
                            .withMarshaller(new DescribeReservedInstancesListingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeReservedInstancesListingsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the modifications made to your Reserved Instances. If no parameter is specified, information about all
     * your Reserved Instances modification requests is returned. If a modification ID is specified, only information
     * about the specific modification is returned.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html">Modifying Reserved Instances</a> in
     * the Amazon Elastic Compute Cloud User Guide.
     * </p>
     *
     * @param describeReservedInstancesModificationsRequest
     *        Contains the parameters for DescribeReservedInstancesModifications.
     * @return A Java Future containing the result of the DescribeReservedInstancesModifications operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeReservedInstancesModifications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesModifications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeReservedInstancesModificationsResponse> describeReservedInstancesModifications(
            DescribeReservedInstancesModificationsRequest describeReservedInstancesModificationsRequest) {
        try {

            HttpResponseHandler<DescribeReservedInstancesModificationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeReservedInstancesModificationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeReservedInstancesModificationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeReservedInstancesModificationsRequest, DescribeReservedInstancesModificationsResponse>()
                            .withOperationName("DescribeReservedInstancesModifications")
                            .withMarshaller(new DescribeReservedInstancesModificationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeReservedInstancesModificationsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the modifications made to your Reserved Instances. If no parameter is specified, information about all
     * your Reserved Instances modification requests is returned. If a modification ID is specified, only information
     * about the specific modification is returned.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html">Modifying Reserved Instances</a> in
     * the Amazon Elastic Compute Cloud User Guide.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedInstancesModifications(software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeReservedInstancesModificationsPublisher publisher = client.describeReservedInstancesModificationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeReservedInstancesModificationsPublisher publisher = client.describeReservedInstancesModificationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedInstancesModifications(software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReservedInstancesModificationsRequest
     *        Contains the parameters for DescribeReservedInstancesModifications.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeReservedInstancesModifications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesModifications"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeReservedInstancesModificationsPublisher describeReservedInstancesModificationsPaginator(
            DescribeReservedInstancesModificationsRequest describeReservedInstancesModificationsRequest) {
        return new DescribeReservedInstancesModificationsPublisher(this,
                applyPaginatorUserAgent(describeReservedInstancesModificationsRequest));
    }

    /**
     * <p>
     * Describes Reserved Instance offerings that are available for purchase. With Reserved Instances, you purchase the
     * right to launch instances for a period of time. During that time period, you do not receive insufficient capacity
     * errors, and you pay a lower usage rate than the rate charged for On-Demand instances for the actual time used.
     * </p>
     * <p>
     * If you have listed your own Reserved Instances for sale in the Reserved Instance Marketplace, they will be
     * excluded from these results. This is to ensure that you do not purchase your own Reserved Instances.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance
     * Marketplace</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param describeReservedInstancesOfferingsRequest
     *        Contains the parameters for DescribeReservedInstancesOfferings.
     * @return A Java Future containing the result of the DescribeReservedInstancesOfferings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeReservedInstancesOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeReservedInstancesOfferingsResponse> describeReservedInstancesOfferings(
            DescribeReservedInstancesOfferingsRequest describeReservedInstancesOfferingsRequest) {
        try {

            HttpResponseHandler<DescribeReservedInstancesOfferingsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeReservedInstancesOfferingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeReservedInstancesOfferingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeReservedInstancesOfferingsRequest, DescribeReservedInstancesOfferingsResponse>()
                            .withOperationName("DescribeReservedInstancesOfferings")
                            .withMarshaller(new DescribeReservedInstancesOfferingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeReservedInstancesOfferingsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes Reserved Instance offerings that are available for purchase. With Reserved Instances, you purchase the
     * right to launch instances for a period of time. During that time period, you do not receive insufficient capacity
     * errors, and you pay a lower usage rate than the rate charged for On-Demand instances for the actual time used.
     * </p>
     * <p>
     * If you have listed your own Reserved Instances for sale in the Reserved Instance Marketplace, they will be
     * excluded from these results. This is to ensure that you do not purchase your own Reserved Instances.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance
     * Marketplace</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedInstancesOfferings(software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeReservedInstancesOfferingsPublisher publisher = client.describeReservedInstancesOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeReservedInstancesOfferingsPublisher publisher = client.describeReservedInstancesOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedInstancesOfferings(software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReservedInstancesOfferingsRequest
     *        Contains the parameters for DescribeReservedInstancesOfferings.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeReservedInstancesOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeReservedInstancesOfferingsPublisher describeReservedInstancesOfferingsPaginator(
            DescribeReservedInstancesOfferingsRequest describeReservedInstancesOfferingsRequest) {
        return new DescribeReservedInstancesOfferingsPublisher(this,
                applyPaginatorUserAgent(describeReservedInstancesOfferingsRequest));
    }

    /**
     * <p>
     * Describes one or more of your route tables.
     * </p>
     * <p>
     * Each subnet in your VPC must be associated with a route table. If a subnet is not explicitly associated with any
     * route table, it is implicitly associated with the main route table. This command does not return the subnet ID
     * for implicit associations.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route
     * Tables</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param describeRouteTablesRequest
     * @return A Java Future containing the result of the DescribeRouteTables operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeRouteTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeRouteTables" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRouteTablesResponse> describeRouteTables(
            DescribeRouteTablesRequest describeRouteTablesRequest) {
        try {

            HttpResponseHandler<DescribeRouteTablesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeRouteTablesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeRouteTablesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRouteTablesRequest, DescribeRouteTablesResponse>()
                            .withOperationName("DescribeRouteTables")
                            .withMarshaller(new DescribeRouteTablesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeRouteTablesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes one or more of your route tables.
     * </p>
     * <p>
     * Each subnet in your VPC must be associated with a route table. If a subnet is not explicitly associated with any
     * route table, it is implicitly associated with the main route table. This command does not return the subnet ID
     * for implicit associations.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route
     * Tables</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeRouteTables(software.amazon.awssdk.services.ec2.model.DescribeRouteTablesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeRouteTablesPublisher publisher = client.describeRouteTablesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeRouteTablesPublisher publisher = client.describeRouteTablesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeRouteTablesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeRouteTablesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRouteTables(software.amazon.awssdk.services.ec2.model.DescribeRouteTablesRequest)} operation.</b>
     * </p>
     *
     * @param describeRouteTablesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeRouteTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeRouteTables" target="_top">AWS API
     *      Documentation</a>
     */
    public DescribeRouteTablesPublisher describeRouteTablesPaginator(DescribeRouteTablesRequest describeRouteTablesRequest) {
        return new DescribeRouteTablesPublisher(this, applyPaginatorUserAgent(describeRouteTablesRequest));
    }

    /**
     * <p>
     * Finds available schedules that meet the specified criteria.
     * </p>
     * <p>
     * You can search for an available schedule no more than 3 months in advance. You must meet the minimum required
     * duration of 1,200 hours per year. For example, the minimum daily schedule is 4 hours, the minimum weekly schedule
     * is 24 hours, and the minimum monthly schedule is 100 hours.
     * </p>
     * <p>
     * After you find a schedule that meets your needs, call <a>PurchaseScheduledInstances</a> to purchase Scheduled
     * Instances with that schedule.
     * </p>
     *
     * @param describeScheduledInstanceAvailabilityRequest
     *        Contains the parameters for DescribeScheduledInstanceAvailability.
     * @return A Java Future containing the result of the DescribeScheduledInstanceAvailability operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeScheduledInstanceAvailability
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeScheduledInstanceAvailability"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeScheduledInstanceAvailabilityResponse> describeScheduledInstanceAvailability(
            DescribeScheduledInstanceAvailabilityRequest describeScheduledInstanceAvailabilityRequest) {
        try {

            HttpResponseHandler<DescribeScheduledInstanceAvailabilityResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeScheduledInstanceAvailabilityResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeScheduledInstanceAvailabilityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeScheduledInstanceAvailabilityRequest, DescribeScheduledInstanceAvailabilityResponse>()
                            .withOperationName("DescribeScheduledInstanceAvailability")
                            .withMarshaller(new DescribeScheduledInstanceAvailabilityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeScheduledInstanceAvailabilityRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Finds available schedules that meet the specified criteria.
     * </p>
     * <p>
     * You can search for an available schedule no more than 3 months in advance. You must meet the minimum required
     * duration of 1,200 hours per year. For example, the minimum daily schedule is 4 hours, the minimum weekly schedule
     * is 24 hours, and the minimum monthly schedule is 100 hours.
     * </p>
     * <p>
     * After you find a schedule that meets your needs, call <a>PurchaseScheduledInstances</a> to purchase Scheduled
     * Instances with that schedule.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeScheduledInstanceAvailability(software.amazon.awssdk.services.ec2.model.DescribeScheduledInstanceAvailabilityRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeScheduledInstanceAvailabilityPublisher publisher = client.describeScheduledInstanceAvailabilityPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeScheduledInstanceAvailabilityPublisher publisher = client.describeScheduledInstanceAvailabilityPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeScheduledInstanceAvailabilityResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeScheduledInstanceAvailabilityResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeScheduledInstanceAvailability(software.amazon.awssdk.services.ec2.model.DescribeScheduledInstanceAvailabilityRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeScheduledInstanceAvailabilityRequest
     *        Contains the parameters for DescribeScheduledInstanceAvailability.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeScheduledInstanceAvailability
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeScheduledInstanceAvailability"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeScheduledInstanceAvailabilityPublisher describeScheduledInstanceAvailabilityPaginator(
            DescribeScheduledInstanceAvailabilityRequest describeScheduledInstanceAvailabilityRequest) {
        return new DescribeScheduledInstanceAvailabilityPublisher(this,
                applyPaginatorUserAgent(describeScheduledInstanceAvailabilityRequest));
    }

    /**
     * <p>
     * Describes the specified Scheduled Instances or all your Scheduled Instances.
     * </p>
     *
     * @param describeScheduledInstancesRequest
     *        Contains the parameters for DescribeScheduledInstances.
     * @return A Java Future containing the result of the DescribeScheduledInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeScheduledInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeScheduledInstances" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeScheduledInstancesResponse> describeScheduledInstances(
            DescribeScheduledInstancesRequest describeScheduledInstancesRequest) {
        try {

            HttpResponseHandler<DescribeScheduledInstancesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeScheduledInstancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeScheduledInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeScheduledInstancesRequest, DescribeScheduledInstancesResponse>()
                            .withOperationName("DescribeScheduledInstances")
                            .withMarshaller(new DescribeScheduledInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeScheduledInstancesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified Scheduled Instances or all your Scheduled Instances.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeScheduledInstances(software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeScheduledInstancesPublisher publisher = client.describeScheduledInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeScheduledInstancesPublisher publisher = client.describeScheduledInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeScheduledInstances(software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeScheduledInstancesRequest
     *        Contains the parameters for DescribeScheduledInstances.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeScheduledInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeScheduledInstances" target="_top">AWS
     *      API Documentation</a>
     */
    public DescribeScheduledInstancesPublisher describeScheduledInstancesPaginator(
            DescribeScheduledInstancesRequest describeScheduledInstancesRequest) {
        return new DescribeScheduledInstancesPublisher(this, applyPaginatorUserAgent(describeScheduledInstancesRequest));
    }

    /**
     * <p>
     * [VPC only] Describes the VPCs on the other side of a VPC peering connection that are referencing the security
     * groups you've specified in this request.
     * </p>
     *
     * @param describeSecurityGroupReferencesRequest
     * @return A Java Future containing the result of the DescribeSecurityGroupReferences operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeSecurityGroupReferences
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSecurityGroupReferences"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSecurityGroupReferencesResponse> describeSecurityGroupReferences(
            DescribeSecurityGroupReferencesRequest describeSecurityGroupReferencesRequest) {
        try {

            HttpResponseHandler<DescribeSecurityGroupReferencesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeSecurityGroupReferencesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeSecurityGroupReferencesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSecurityGroupReferencesRequest, DescribeSecurityGroupReferencesResponse>()
                            .withOperationName("DescribeSecurityGroupReferences")
                            .withMarshaller(new DescribeSecurityGroupReferencesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeSecurityGroupReferencesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified security groups or all of your security groups.
     * </p>
     * <p>
     * A security group is for use with instances either in the EC2-Classic platform or in a specific VPC. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon
     * EC2 Security Groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for Your
     * VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     *
     * @param describeSecurityGroupsRequest
     * @return A Java Future containing the result of the DescribeSecurityGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeSecurityGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSecurityGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSecurityGroupsResponse> describeSecurityGroups(
            DescribeSecurityGroupsRequest describeSecurityGroupsRequest) {
        try {

            HttpResponseHandler<DescribeSecurityGroupsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeSecurityGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeSecurityGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSecurityGroupsRequest, DescribeSecurityGroupsResponse>()
                            .withOperationName("DescribeSecurityGroups")
                            .withMarshaller(new DescribeSecurityGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeSecurityGroupsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified security groups or all of your security groups.
     * </p>
     * <p>
     * A security group is for use with instances either in the EC2-Classic platform or in a specific VPC. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon
     * EC2 Security Groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for Your
     * VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSecurityGroups(software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeSecurityGroupsPublisher publisher = client.describeSecurityGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeSecurityGroupsPublisher publisher = client.describeSecurityGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSecurityGroups(software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSecurityGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeSecurityGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSecurityGroups" target="_top">AWS API
     *      Documentation</a>
     */
    public DescribeSecurityGroupsPublisher describeSecurityGroupsPaginator(
            DescribeSecurityGroupsRequest describeSecurityGroupsRequest) {
        return new DescribeSecurityGroupsPublisher(this, applyPaginatorUserAgent(describeSecurityGroupsRequest));
    }

    /**
     * <p>
     * Describes the specified attribute of the specified snapshot. You can specify only one attribute at a time.
     * </p>
     * <p>
     * For more information about EBS snapshots, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSSnapshots.html">Amazon EBS Snapshots</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param describeSnapshotAttributeRequest
     * @return A Java Future containing the result of the DescribeSnapshotAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeSnapshotAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSnapshotAttribute" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSnapshotAttributeResponse> describeSnapshotAttribute(
            DescribeSnapshotAttributeRequest describeSnapshotAttributeRequest) {
        try {

            HttpResponseHandler<DescribeSnapshotAttributeResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeSnapshotAttributeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeSnapshotAttributeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSnapshotAttributeRequest, DescribeSnapshotAttributeResponse>()
                            .withOperationName("DescribeSnapshotAttribute")
                            .withMarshaller(new DescribeSnapshotAttributeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeSnapshotAttributeRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified EBS snapshots available to you or all of the EBS snapshots available to you.
     * </p>
     * <p>
     * The snapshots available to you include public snapshots, private snapshots that you own, and private snapshots
     * owned by other AWS accounts for which you have explicit create volume permissions.
     * </p>
     * <p>
     * The create volume permissions fall into the following categories:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>public</i>: The owner of the snapshot granted create volume permissions for the snapshot to the
     * <code>all</code> group. All AWS accounts have create volume permissions for these snapshots.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>explicit</i>: The owner of the snapshot granted create volume permissions to a specific AWS account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>implicit</i>: An AWS account has implicit create volume permissions for all snapshots it owns.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The list of snapshots returned can be filtered by specifying snapshot IDs, snapshot owners, or AWS accounts with
     * create volume permissions. If no options are specified, Amazon EC2 returns all snapshots for which you have
     * create volume permissions.
     * </p>
     * <p>
     * If you specify one or more snapshot IDs, only snapshots that have the specified IDs are returned. If you specify
     * an invalid snapshot ID, an error is returned. If you specify a snapshot ID for which you do not have access, it
     * is not included in the returned results.
     * </p>
     * <p>
     * If you specify one or more snapshot owners using the <code>OwnerIds</code> option, only snapshots from the
     * specified owners and for which you have access are returned. The results can include the AWS account IDs of the
     * specified owners, <code>amazon</code> for snapshots owned by Amazon, or <code>self</code> for snapshots that you
     * own.
     * </p>
     * <p>
     * If you specify a list of restorable users, only snapshots with create snapshot permissions for those users are
     * returned. You can specify AWS account IDs (if you own the snapshots), <code>self</code> for snapshots for which
     * you own or have explicit permissions, or <code>all</code> for public snapshots.
     * </p>
     * <p>
     * If you are describing a long list of snapshots, we recommend that you paginate the output to make the list more
     * manageable. The <code>MaxResults</code> parameter sets the maximum number of results returned in a single page.
     * If the list of results exceeds your <code>MaxResults</code> value, then that number of results is returned along
     * with a <code>NextToken</code> value that can be passed to a subsequent <code>DescribeSnapshots</code> request to
     * retrieve the remaining results.
     * </p>
     * <p>
     * To get the state of fast snapshot restores for a snapshot, use <a>DescribeFastSnapshotRestores</a>.
     * </p>
     * <p>
     * For more information about EBS snapshots, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSSnapshots.html">Amazon EBS Snapshots</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param describeSnapshotsRequest
     * @return A Java Future containing the result of the DescribeSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSnapshotsResponse> describeSnapshots(DescribeSnapshotsRequest describeSnapshotsRequest) {
        try {

            HttpResponseHandler<DescribeSnapshotsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeSnapshotsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeSnapshotsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSnapshotsRequest, DescribeSnapshotsResponse>()
                            .withOperationName("DescribeSnapshots")
                            .withMarshaller(new DescribeSnapshotsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeSnapshotsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified EBS snapshots available to you or all of the EBS snapshots available to you.
     * </p>
     * <p>
     * The snapshots available to you include public snapshots, private snapshots that you own, and private snapshots
     * owned by other AWS accounts for which you have explicit create volume permissions.
     * </p>
     * <p>
     * The create volume permissions fall into the following categories:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>public</i>: The owner of the snapshot granted create volume permissions for the snapshot to the
     * <code>all</code> group. All AWS accounts have create volume permissions for these snapshots.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>explicit</i>: The owner of the snapshot granted create volume permissions to a specific AWS account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>implicit</i>: An AWS account has implicit create volume permissions for all snapshots it owns.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The list of snapshots returned can be filtered by specifying snapshot IDs, snapshot owners, or AWS accounts with
     * create volume permissions. If no options are specified, Amazon EC2 returns all snapshots for which you have
     * create volume permissions.
     * </p>
     * <p>
     * If you specify one or more snapshot IDs, only snapshots that have the specified IDs are returned. If you specify
     * an invalid snapshot ID, an error is returned. If you specify a snapshot ID for which you do not have access, it
     * is not included in the returned results.
     * </p>
     * <p>
     * If you specify one or more snapshot owners using the <code>OwnerIds</code> option, only snapshots from the
     * specified owners and for which you have access are returned. The results can include the AWS account IDs of the
     * specified owners, <code>amazon</code> for snapshots owned by Amazon, or <code>self</code> for snapshots that you
     * own.
     * </p>
     * <p>
     * If you specify a list of restorable users, only snapshots with create snapshot permissions for those users are
     * returned. You can specify AWS account IDs (if you own the snapshots), <code>self</code> for snapshots for which
     * you own or have explicit permissions, or <code>all</code> for public snapshots.
     * </p>
     * <p>
     * If you are describing a long list of snapshots, we recommend that you paginate the output to make the list more
     * manageable. The <code>MaxResults</code> parameter sets the maximum number of results returned in a single page.
     * If the list of results exceeds your <code>MaxResults</code> value, then that number of results is returned along
     * with a <code>NextToken</code> value that can be passed to a subsequent <code>DescribeSnapshots</code> request to
     * retrieve the remaining results.
     * </p>
     * <p>
     * To get the state of fast snapshot restores for a snapshot, use <a>DescribeFastSnapshotRestores</a>.
     * </p>
     * <p>
     * For more information about EBS snapshots, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSSnapshots.html">Amazon EBS Snapshots</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSnapshots(software.amazon.awssdk.services.ec2.model.DescribeSnapshotsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeSnapshotsPublisher publisher = client.describeSnapshotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeSnapshotsPublisher publisher = client.describeSnapshotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeSnapshotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeSnapshotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSnapshots(software.amazon.awssdk.services.ec2.model.DescribeSnapshotsRequest)} operation.</b>
     * </p>
     *
     * @param describeSnapshotsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    public DescribeSnapshotsPublisher describeSnapshotsPaginator(DescribeSnapshotsRequest describeSnapshotsRequest) {
        return new DescribeSnapshotsPublisher(this, applyPaginatorUserAgent(describeSnapshotsRequest));
    }

    /**
     * <p>
     * Describes the data feed for Spot Instances. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html">Spot Instance Data Feed</a> in
     * the <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     *
     * @param describeSpotDatafeedSubscriptionRequest
     *        Contains the parameters for DescribeSpotDatafeedSubscription.
     * @return A Java Future containing the result of the DescribeSpotDatafeedSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeSpotDatafeedSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotDatafeedSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSpotDatafeedSubscriptionResponse> describeSpotDatafeedSubscription(
            DescribeSpotDatafeedSubscriptionRequest describeSpotDatafeedSubscriptionRequest) {
        try {

            HttpResponseHandler<DescribeSpotDatafeedSubscriptionResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeSpotDatafeedSubscriptionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeSpotDatafeedSubscriptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSpotDatafeedSubscriptionRequest, DescribeSpotDatafeedSubscriptionResponse>()
                            .withOperationName("DescribeSpotDatafeedSubscription")
                            .withMarshaller(new DescribeSpotDatafeedSubscriptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeSpotDatafeedSubscriptionRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the running instances for the specified Spot Fleet.
     * </p>
     *
     * @param describeSpotFleetInstancesRequest
     *        Contains the parameters for DescribeSpotFleetInstances.
     * @return A Java Future containing the result of the DescribeSpotFleetInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeSpotFleetInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetInstances" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSpotFleetInstancesResponse> describeSpotFleetInstances(
            DescribeSpotFleetInstancesRequest describeSpotFleetInstancesRequest) {
        try {

            HttpResponseHandler<DescribeSpotFleetInstancesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeSpotFleetInstancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeSpotFleetInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSpotFleetInstancesRequest, DescribeSpotFleetInstancesResponse>()
                            .withOperationName("DescribeSpotFleetInstances")
                            .withMarshaller(new DescribeSpotFleetInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeSpotFleetInstancesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the events for the specified Spot Fleet request during the specified time.
     * </p>
     * <p>
     * Spot Fleet events are delayed by up to 30 seconds before they can be described. This ensures that you can query
     * by the last evaluated time and not miss a recorded event. Spot Fleet events are available for 48 hours.
     * </p>
     *
     * @param describeSpotFleetRequestHistoryRequest
     *        Contains the parameters for DescribeSpotFleetRequestHistory.
     * @return A Java Future containing the result of the DescribeSpotFleetRequestHistory operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeSpotFleetRequestHistory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetRequestHistory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSpotFleetRequestHistoryResponse> describeSpotFleetRequestHistory(
            DescribeSpotFleetRequestHistoryRequest describeSpotFleetRequestHistoryRequest) {
        try {

            HttpResponseHandler<DescribeSpotFleetRequestHistoryResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeSpotFleetRequestHistoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeSpotFleetRequestHistoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSpotFleetRequestHistoryRequest, DescribeSpotFleetRequestHistoryResponse>()
                            .withOperationName("DescribeSpotFleetRequestHistory")
                            .withMarshaller(new DescribeSpotFleetRequestHistoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeSpotFleetRequestHistoryRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes your Spot Fleet requests.
     * </p>
     * <p>
     * Spot Fleet requests are deleted 48 hours after they are canceled and their instances are terminated.
     * </p>
     *
     * @param describeSpotFleetRequestsRequest
     *        Contains the parameters for DescribeSpotFleetRequests.
     * @return A Java Future containing the result of the DescribeSpotFleetRequests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeSpotFleetRequests
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetRequests" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSpotFleetRequestsResponse> describeSpotFleetRequests(
            DescribeSpotFleetRequestsRequest describeSpotFleetRequestsRequest) {
        try {

            HttpResponseHandler<DescribeSpotFleetRequestsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeSpotFleetRequestsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeSpotFleetRequestsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSpotFleetRequestsRequest, DescribeSpotFleetRequestsResponse>()
                            .withOperationName("DescribeSpotFleetRequests")
                            .withMarshaller(new DescribeSpotFleetRequestsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeSpotFleetRequestsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes your Spot Fleet requests.
     * </p>
     * <p>
     * Spot Fleet requests are deleted 48 hours after they are canceled and their instances are terminated.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSpotFleetRequests(software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeSpotFleetRequestsPublisher publisher = client.describeSpotFleetRequestsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ec2.paginators.DescribeSpotFleetRequestsPublisher publisher = client.describeSpotFleetRequestsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSpotFleetRequests(software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSpotFleetRequestsRequest
     *        Contains the parameters for DescribeSpotFleetRequests.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeSpotFleetRequests
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetRequests" target="_top">AWS
     *      API Documentation</a>
     */
    public DescribeSpotFleetRequestsPublisher describeSpotFleetRequestsPaginator(
            DescribeSpotFleetRequestsRequest describeSpotFleetRequestsRequest) {
        return new DescribeSpotFleetRequestsPublisher(this, applyPaginatorUserAgent(describeSpotFleetRequestsRequest));
    }

    /**
     * <p>
     * Describes the specified Spot Instance requests.
     * </p>
     * <p>
     * You can use <code>DescribeSpotInstanceRequests</code> to find a running Spot Instance by examining the response.
     * If the status of the Spot Instance is <code>fulfilled</code>, the instance ID appears in the response and
     * contains the identifier of the instance. Alternatively, you can use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances">DescribeInstances</a> with a
     * filter to look for instances where the instance lifecycle is <code>spot</code>.
     * </p>
     * <p>
     * We recommend that you set <code>MaxResults</code> to a value between 5 and 1000 to limit the number of results
     * returned. This paginates the output, which makes the list more manageable and returns the results faster. If the
     * list of results exceeds your <code>MaxResults</code> value, then that number of results is returned along with a
     * <code>NextToken</code> value that can be passed to a subsequent <code>DescribeSpotInstanceRequests</code> request
     * to retrieve the remaining results.
     * </p>
     * <p>
     * Spot Instance requests are deleted four hours after they are canceled and their instances are terminated.
     * </p>
     *
     * @param describeSpotInstanceRequestsRequest
     *        Contains the parameters for DescribeSpotInstanceRequests.
     * @return A Java Future containing the result of the DescribeSpotInstanceRequests operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample Ec2AsyncClient.DescribeSpotInstanceRequests
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotInstanceRequests"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSpotInstanceRequestsResponse> describeSpotInstanceRequests(
            DescribeSpotInstanceRequestsRequest describeSpotInstanceRequestsRequest) {
        try {

            HttpResponseHandler<DescribeSpotInstanceRequestsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeSpotInstanceRequestsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeSpotInstanceRequestsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSpotInstanceRequestsRequest, DescribeSpotInstanceRequestsResponse>()
                            .withOperationName("DescribeSpotInstanceRequests")
                            .withMarshaller(new DescribeSpotInstanceRequestsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeSpotInstanceRequestsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified Spot Instance requests.
     * </p>
     * <p>
     * You can use <code>DescribeSpotInstanceRequests</code> to find a running Spot Instance by examining the response.
     * If the status of the Spot