/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a transit gateway route table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayRouteTable implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayRouteTable.Builder, TransitGatewayRouteTable> {
    private static final SdkField<String> TRANSIT_GATEWAY_ROUTE_TABLE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayRouteTable::transitGatewayRouteTableId))
            .setter(setter(Builder::transitGatewayRouteTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayRouteTableId")
                    .unmarshallLocationName("transitGatewayRouteTableId").build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayRouteTable::transitGatewayId))
            .setter(setter(Builder::transitGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId")
                    .unmarshallLocationName("transitGatewayId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayRouteTable::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<Boolean> DEFAULT_ASSOCIATION_ROUTE_TABLE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(TransitGatewayRouteTable::defaultAssociationRouteTable))
            .setter(setter(Builder::defaultAssociationRouteTable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultAssociationRouteTable")
                    .unmarshallLocationName("defaultAssociationRouteTable").build()).build();

    private static final SdkField<Boolean> DEFAULT_PROPAGATION_ROUTE_TABLE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(TransitGatewayRouteTable::defaultPropagationRouteTable))
            .setter(setter(Builder::defaultPropagationRouteTable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultPropagationRouteTable")
                    .unmarshallLocationName("defaultPropagationRouteTable").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(TransitGatewayRouteTable::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime")
                    .unmarshallLocationName("creationTime").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(TransitGatewayRouteTable::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSIT_GATEWAY_ROUTE_TABLE_ID_FIELD, TRANSIT_GATEWAY_ID_FIELD, STATE_FIELD, DEFAULT_ASSOCIATION_ROUTE_TABLE_FIELD,
            DEFAULT_PROPAGATION_ROUTE_TABLE_FIELD, CREATION_TIME_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String transitGatewayRouteTableId;

    private final String transitGatewayId;

    private final String state;

    private final Boolean defaultAssociationRouteTable;

    private final Boolean defaultPropagationRouteTable;

    private final Instant creationTime;

    private final List<Tag> tags;

    private TransitGatewayRouteTable(BuilderImpl builder) {
        this.transitGatewayRouteTableId = builder.transitGatewayRouteTableId;
        this.transitGatewayId = builder.transitGatewayId;
        this.state = builder.state;
        this.defaultAssociationRouteTable = builder.defaultAssociationRouteTable;
        this.defaultPropagationRouteTable = builder.defaultPropagationRouteTable;
        this.creationTime = builder.creationTime;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the transit gateway route table.
     * </p>
     * 
     * @return The ID of the transit gateway route table.
     */
    public String transitGatewayRouteTableId() {
        return transitGatewayRouteTableId;
    }

    /**
     * <p>
     * The ID of the transit gateway.
     * </p>
     * 
     * @return The ID of the transit gateway.
     */
    public String transitGatewayId() {
        return transitGatewayId;
    }

    /**
     * <p>
     * The state of the transit gateway route table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayRouteTableState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the transit gateway route table.
     * @see TransitGatewayRouteTableState
     */
    public TransitGatewayRouteTableState state() {
        return TransitGatewayRouteTableState.fromValue(state);
    }

    /**
     * <p>
     * The state of the transit gateway route table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayRouteTableState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the transit gateway route table.
     * @see TransitGatewayRouteTableState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * Indicates whether this is the default association route table for the transit gateway.
     * </p>
     * 
     * @return Indicates whether this is the default association route table for the transit gateway.
     */
    public Boolean defaultAssociationRouteTable() {
        return defaultAssociationRouteTable;
    }

    /**
     * <p>
     * Indicates whether this is the default propagation route table for the transit gateway.
     * </p>
     * 
     * @return Indicates whether this is the default propagation route table for the transit gateway.
     */
    public Boolean defaultPropagationRouteTable() {
        return defaultPropagationRouteTable;
    }

    /**
     * <p>
     * The creation time.
     * </p>
     * 
     * @return The creation time.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags assigned to the route table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Any tags assigned to the route table.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultAssociationRouteTable());
        hashCode = 31 * hashCode + Objects.hashCode(defaultPropagationRouteTable());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayRouteTable)) {
            return false;
        }
        TransitGatewayRouteTable other = (TransitGatewayRouteTable) obj;
        return Objects.equals(transitGatewayRouteTableId(), other.transitGatewayRouteTableId())
                && Objects.equals(transitGatewayId(), other.transitGatewayId())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(defaultAssociationRouteTable(), other.defaultAssociationRouteTable())
                && Objects.equals(defaultPropagationRouteTable(), other.defaultPropagationRouteTable())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TransitGatewayRouteTable").add("TransitGatewayRouteTableId", transitGatewayRouteTableId())
                .add("TransitGatewayId", transitGatewayId()).add("State", stateAsString())
                .add("DefaultAssociationRouteTable", defaultAssociationRouteTable())
                .add("DefaultPropagationRouteTable", defaultPropagationRouteTable()).add("CreationTime", creationTime())
                .add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayRouteTableId":
            return Optional.ofNullable(clazz.cast(transitGatewayRouteTableId()));
        case "TransitGatewayId":
            return Optional.ofNullable(clazz.cast(transitGatewayId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "DefaultAssociationRouteTable":
            return Optional.ofNullable(clazz.cast(defaultAssociationRouteTable()));
        case "DefaultPropagationRouteTable":
            return Optional.ofNullable(clazz.cast(defaultPropagationRouteTable()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayRouteTable, T> g) {
        return obj -> g.apply((TransitGatewayRouteTable) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayRouteTable> {
        /**
         * <p>
         * The ID of the transit gateway route table.
         * </p>
         * 
         * @param transitGatewayRouteTableId
         *        The ID of the transit gateway route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayRouteTableId(String transitGatewayRouteTableId);

        /**
         * <p>
         * The ID of the transit gateway.
         * </p>
         * 
         * @param transitGatewayId
         *        The ID of the transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayId(String transitGatewayId);

        /**
         * <p>
         * The state of the transit gateway route table.
         * </p>
         * 
         * @param state
         *        The state of the transit gateway route table.
         * @see TransitGatewayRouteTableState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayRouteTableState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the transit gateway route table.
         * </p>
         * 
         * @param state
         *        The state of the transit gateway route table.
         * @see TransitGatewayRouteTableState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayRouteTableState
         */
        Builder state(TransitGatewayRouteTableState state);

        /**
         * <p>
         * Indicates whether this is the default association route table for the transit gateway.
         * </p>
         * 
         * @param defaultAssociationRouteTable
         *        Indicates whether this is the default association route table for the transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultAssociationRouteTable(Boolean defaultAssociationRouteTable);

        /**
         * <p>
         * Indicates whether this is the default propagation route table for the transit gateway.
         * </p>
         * 
         * @param defaultPropagationRouteTable
         *        Indicates whether this is the default propagation route table for the transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultPropagationRouteTable(Boolean defaultPropagationRouteTable);

        /**
         * <p>
         * The creation time.
         * </p>
         * 
         * @param creationTime
         *        The creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Any tags assigned to the route table.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the route table.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the route table.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String transitGatewayRouteTableId;

        private String transitGatewayId;

        private String state;

        private Boolean defaultAssociationRouteTable;

        private Boolean defaultPropagationRouteTable;

        private Instant creationTime;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayRouteTable model) {
            transitGatewayRouteTableId(model.transitGatewayRouteTableId);
            transitGatewayId(model.transitGatewayId);
            state(model.state);
            defaultAssociationRouteTable(model.defaultAssociationRouteTable);
            defaultPropagationRouteTable(model.defaultPropagationRouteTable);
            creationTime(model.creationTime);
            tags(model.tags);
        }

        public final String getTransitGatewayRouteTableId() {
            return transitGatewayRouteTableId;
        }

        @Override
        public final Builder transitGatewayRouteTableId(String transitGatewayRouteTableId) {
            this.transitGatewayRouteTableId = transitGatewayRouteTableId;
            return this;
        }

        public final void setTransitGatewayRouteTableId(String transitGatewayRouteTableId) {
            this.transitGatewayRouteTableId = transitGatewayRouteTableId;
        }

        public final String getTransitGatewayId() {
            return transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TransitGatewayRouteTableState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Boolean getDefaultAssociationRouteTable() {
            return defaultAssociationRouteTable;
        }

        @Override
        public final Builder defaultAssociationRouteTable(Boolean defaultAssociationRouteTable) {
            this.defaultAssociationRouteTable = defaultAssociationRouteTable;
            return this;
        }

        public final void setDefaultAssociationRouteTable(Boolean defaultAssociationRouteTable) {
            this.defaultAssociationRouteTable = defaultAssociationRouteTable;
        }

        public final Boolean getDefaultPropagationRouteTable() {
            return defaultPropagationRouteTable;
        }

        @Override
        public final Builder defaultPropagationRouteTable(Boolean defaultPropagationRouteTable) {
            this.defaultPropagationRouteTable = defaultPropagationRouteTable;
            return this;
        }

        public final void setDefaultPropagationRouteTable(Boolean defaultPropagationRouteTable) {
            this.defaultPropagationRouteTable = defaultPropagationRouteTable;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public TransitGatewayRouteTable build() {
            return new TransitGatewayRouteTable(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
