/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeregisterTransitGatewayMulticastGroupMembersRequest extends Ec2Request
        implements
        ToCopyableBuilder<DeregisterTransitGatewayMulticastGroupMembersRequest.Builder, DeregisterTransitGatewayMulticastGroupMembersRequest> {
    private static final SdkField<String> TRANSIT_GATEWAY_MULTICAST_DOMAIN_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DeregisterTransitGatewayMulticastGroupMembersRequest::transitGatewayMulticastDomainId))
            .setter(setter(Builder::transitGatewayMulticastDomainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayMulticastDomainId")
                    .unmarshallLocationName("TransitGatewayMulticastDomainId").build()).build();

    private static final SdkField<String> GROUP_IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DeregisterTransitGatewayMulticastGroupMembersRequest::groupIpAddress))
            .setter(setter(Builder::groupIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupIpAddress")
                    .unmarshallLocationName("GroupIpAddress").build()).build();

    private static final SdkField<List<String>> NETWORK_INTERFACE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DeregisterTransitGatewayMulticastGroupMembersRequest::networkInterfaceIds))
            .setter(setter(Builder::networkInterfaceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceIds")
                    .unmarshallLocationName("NetworkInterfaceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSIT_GATEWAY_MULTICAST_DOMAIN_ID_FIELD, GROUP_IP_ADDRESS_FIELD, NETWORK_INTERFACE_IDS_FIELD));

    private final String transitGatewayMulticastDomainId;

    private final String groupIpAddress;

    private final List<String> networkInterfaceIds;

    private DeregisterTransitGatewayMulticastGroupMembersRequest(BuilderImpl builder) {
        super(builder);
        this.transitGatewayMulticastDomainId = builder.transitGatewayMulticastDomainId;
        this.groupIpAddress = builder.groupIpAddress;
        this.networkInterfaceIds = builder.networkInterfaceIds;
    }

    /**
     * <p>
     * The ID of the transit gateway multicast domain.
     * </p>
     * 
     * @return The ID of the transit gateway multicast domain.
     */
    public String transitGatewayMulticastDomainId() {
        return transitGatewayMulticastDomainId;
    }

    /**
     * <p>
     * The IP address assigned to the transit gateway multicast group.
     * </p>
     * 
     * @return The IP address assigned to the transit gateway multicast group.
     */
    public String groupIpAddress() {
        return groupIpAddress;
    }

    /**
     * Returns true if the NetworkInterfaceIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasNetworkInterfaceIds() {
        return networkInterfaceIds != null && !(networkInterfaceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the group members' network interfaces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNetworkInterfaceIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of the group members' network interfaces.
     */
    public List<String> networkInterfaceIds() {
        return networkInterfaceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayMulticastDomainId());
        hashCode = 31 * hashCode + Objects.hashCode(groupIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterTransitGatewayMulticastGroupMembersRequest)) {
            return false;
        }
        DeregisterTransitGatewayMulticastGroupMembersRequest other = (DeregisterTransitGatewayMulticastGroupMembersRequest) obj;
        return Objects.equals(transitGatewayMulticastDomainId(), other.transitGatewayMulticastDomainId())
                && Objects.equals(groupIpAddress(), other.groupIpAddress())
                && Objects.equals(networkInterfaceIds(), other.networkInterfaceIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeregisterTransitGatewayMulticastGroupMembersRequest")
                .add("TransitGatewayMulticastDomainId", transitGatewayMulticastDomainId())
                .add("GroupIpAddress", groupIpAddress()).add("NetworkInterfaceIds", networkInterfaceIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayMulticastDomainId":
            return Optional.ofNullable(clazz.cast(transitGatewayMulticastDomainId()));
        case "GroupIpAddress":
            return Optional.ofNullable(clazz.cast(groupIpAddress()));
        case "NetworkInterfaceIds":
            return Optional.ofNullable(clazz.cast(networkInterfaceIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeregisterTransitGatewayMulticastGroupMembersRequest, T> g) {
        return obj -> g.apply((DeregisterTransitGatewayMulticastGroupMembersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DeregisterTransitGatewayMulticastGroupMembersRequest> {
        /**
         * <p>
         * The ID of the transit gateway multicast domain.
         * </p>
         * 
         * @param transitGatewayMulticastDomainId
         *        The ID of the transit gateway multicast domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayMulticastDomainId(String transitGatewayMulticastDomainId);

        /**
         * <p>
         * The IP address assigned to the transit gateway multicast group.
         * </p>
         * 
         * @param groupIpAddress
         *        The IP address assigned to the transit gateway multicast group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupIpAddress(String groupIpAddress);

        /**
         * <p>
         * The IDs of the group members' network interfaces.
         * </p>
         * 
         * @param networkInterfaceIds
         *        The IDs of the group members' network interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceIds(Collection<String> networkInterfaceIds);

        /**
         * <p>
         * The IDs of the group members' network interfaces.
         * </p>
         * 
         * @param networkInterfaceIds
         *        The IDs of the group members' network interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceIds(String... networkInterfaceIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String transitGatewayMulticastDomainId;

        private String groupIpAddress;

        private List<String> networkInterfaceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterTransitGatewayMulticastGroupMembersRequest model) {
            super(model);
            transitGatewayMulticastDomainId(model.transitGatewayMulticastDomainId);
            groupIpAddress(model.groupIpAddress);
            networkInterfaceIds(model.networkInterfaceIds);
        }

        public final String getTransitGatewayMulticastDomainId() {
            return transitGatewayMulticastDomainId;
        }

        @Override
        public final Builder transitGatewayMulticastDomainId(String transitGatewayMulticastDomainId) {
            this.transitGatewayMulticastDomainId = transitGatewayMulticastDomainId;
            return this;
        }

        public final void setTransitGatewayMulticastDomainId(String transitGatewayMulticastDomainId) {
            this.transitGatewayMulticastDomainId = transitGatewayMulticastDomainId;
        }

        public final String getGroupIpAddress() {
            return groupIpAddress;
        }

        @Override
        public final Builder groupIpAddress(String groupIpAddress) {
            this.groupIpAddress = groupIpAddress;
            return this;
        }

        public final void setGroupIpAddress(String groupIpAddress) {
            this.groupIpAddress = groupIpAddress;
        }

        public final Collection<String> getNetworkInterfaceIds() {
            return networkInterfaceIds;
        }

        @Override
        public final Builder networkInterfaceIds(Collection<String> networkInterfaceIds) {
            this.networkInterfaceIds = TransitGatewayNetworkInterfaceIdListCopier.copy(networkInterfaceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaceIds(String... networkInterfaceIds) {
            networkInterfaceIds(Arrays.asList(networkInterfaceIds));
            return this;
        }

        public final void setNetworkInterfaceIds(Collection<String> networkInterfaceIds) {
            this.networkInterfaceIds = TransitGatewayNetworkInterfaceIdListCopier.copy(networkInterfaceIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeregisterTransitGatewayMulticastGroupMembersRequest build() {
            return new DeregisterTransitGatewayMulticastGroupMembersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
