/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the status of a volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VolumeStatusInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<VolumeStatusInfo.Builder, VolumeStatusInfo> {
    private static final SdkField<List<VolumeStatusDetails>> DETAILS_FIELD = SdkField
            .<List<VolumeStatusDetails>> builder(MarshallingType.LIST)
            .getter(getter(VolumeStatusInfo::details))
            .setter(setter(Builder::details))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details")
                    .unmarshallLocationName("details").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<VolumeStatusDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(VolumeStatusDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(VolumeStatusInfo::statusAsString))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAILS_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<VolumeStatusDetails> details;

    private final String status;

    private VolumeStatusInfo(BuilderImpl builder) {
        this.details = builder.details;
        this.status = builder.status;
    }

    /**
     * Returns true if the Details property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDetails() {
        return details != null && !(details instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details of the volume status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The details of the volume status.
     */
    public List<VolumeStatusDetails> details() {
        return details;
    }

    /**
     * <p>
     * The status of the volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VolumeStatusInfoStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the volume.
     * @see VolumeStatusInfoStatus
     */
    public VolumeStatusInfoStatus status() {
        return VolumeStatusInfoStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VolumeStatusInfoStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the volume.
     * @see VolumeStatusInfoStatus
     */
    public String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(details());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeStatusInfo)) {
            return false;
        }
        VolumeStatusInfo other = (VolumeStatusInfo) obj;
        return Objects.equals(details(), other.details()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VolumeStatusInfo").add("Details", details()).add("Status", statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Details":
            return Optional.ofNullable(clazz.cast(details()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VolumeStatusInfo, T> g) {
        return obj -> g.apply((VolumeStatusInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VolumeStatusInfo> {
        /**
         * <p>
         * The details of the volume status.
         * </p>
         * 
         * @param details
         *        The details of the volume status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(Collection<VolumeStatusDetails> details);

        /**
         * <p>
         * The details of the volume status.
         * </p>
         * 
         * @param details
         *        The details of the volume status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(VolumeStatusDetails... details);

        /**
         * <p>
         * The details of the volume status.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VolumeStatusDetails>.Builder} avoiding the
         * need to create one manually via {@link List<VolumeStatusDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VolumeStatusDetails>.Builder#build()} is called immediately
         * and its result is passed to {@link #details(List<VolumeStatusDetails>)}.
         * 
         * @param details
         *        a consumer that will call methods on {@link List<VolumeStatusDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #details(List<VolumeStatusDetails>)
         */
        Builder details(Consumer<VolumeStatusDetails.Builder>... details);

        /**
         * <p>
         * The status of the volume.
         * </p>
         * 
         * @param status
         *        The status of the volume.
         * @see VolumeStatusInfoStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeStatusInfoStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the volume.
         * </p>
         * 
         * @param status
         *        The status of the volume.
         * @see VolumeStatusInfoStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeStatusInfoStatus
         */
        Builder status(VolumeStatusInfoStatus status);
    }

    static final class BuilderImpl implements Builder {
        private List<VolumeStatusDetails> details = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeStatusInfo model) {
            details(model.details);
            status(model.status);
        }

        public final Collection<VolumeStatusDetails.Builder> getDetails() {
            return details != null ? details.stream().map(VolumeStatusDetails::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder details(Collection<VolumeStatusDetails> details) {
            this.details = VolumeStatusDetailsListCopier.copy(details);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(VolumeStatusDetails... details) {
            details(Arrays.asList(details));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(Consumer<VolumeStatusDetails.Builder>... details) {
            details(Stream.of(details).map(c -> VolumeStatusDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDetails(Collection<VolumeStatusDetails.BuilderImpl> details) {
            this.details = VolumeStatusDetailsListCopier.copyFromBuilder(details);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VolumeStatusInfoStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public VolumeStatusInfo build() {
            return new VolumeStatusInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
