/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisableTransitGatewayRouteTablePropagationResponse extends Ec2Response
        implements
        ToCopyableBuilder<DisableTransitGatewayRouteTablePropagationResponse.Builder, DisableTransitGatewayRouteTablePropagationResponse> {
    private static final SdkField<TransitGatewayPropagation> PROPAGATION_FIELD = SdkField
            .<TransitGatewayPropagation> builder(MarshallingType.SDK_POJO)
            .getter(getter(DisableTransitGatewayRouteTablePropagationResponse::propagation))
            .setter(setter(Builder::propagation))
            .constructor(TransitGatewayPropagation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Propagation")
                    .unmarshallLocationName("propagation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPAGATION_FIELD));

    private final TransitGatewayPropagation propagation;

    private DisableTransitGatewayRouteTablePropagationResponse(BuilderImpl builder) {
        super(builder);
        this.propagation = builder.propagation;
    }

    /**
     * <p>
     * Information about route propagation.
     * </p>
     * 
     * @return Information about route propagation.
     */
    public TransitGatewayPropagation propagation() {
        return propagation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(propagation());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableTransitGatewayRouteTablePropagationResponse)) {
            return false;
        }
        DisableTransitGatewayRouteTablePropagationResponse other = (DisableTransitGatewayRouteTablePropagationResponse) obj;
        return Objects.equals(propagation(), other.propagation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DisableTransitGatewayRouteTablePropagationResponse").add("Propagation", propagation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Propagation":
            return Optional.ofNullable(clazz.cast(propagation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisableTransitGatewayRouteTablePropagationResponse, T> g) {
        return obj -> g.apply((DisableTransitGatewayRouteTablePropagationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DisableTransitGatewayRouteTablePropagationResponse> {
        /**
         * <p>
         * Information about route propagation.
         * </p>
         * 
         * @param propagation
         *        Information about route propagation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propagation(TransitGatewayPropagation propagation);

        /**
         * <p>
         * Information about route propagation.
         * </p>
         * This is a convenience that creates an instance of the {@link TransitGatewayPropagation.Builder} avoiding the
         * need to create one manually via {@link TransitGatewayPropagation#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransitGatewayPropagation.Builder#build()} is called immediately
         * and its result is passed to {@link #propagation(TransitGatewayPropagation)}.
         * 
         * @param propagation
         *        a consumer that will call methods on {@link TransitGatewayPropagation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #propagation(TransitGatewayPropagation)
         */
        default Builder propagation(Consumer<TransitGatewayPropagation.Builder> propagation) {
            return propagation(TransitGatewayPropagation.builder().applyMutation(propagation).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private TransitGatewayPropagation propagation;

        private BuilderImpl() {
        }

        private BuilderImpl(DisableTransitGatewayRouteTablePropagationResponse model) {
            super(model);
            propagation(model.propagation);
        }

        public final TransitGatewayPropagation.Builder getPropagation() {
            return propagation != null ? propagation.toBuilder() : null;
        }

        @Override
        public final Builder propagation(TransitGatewayPropagation propagation) {
            this.propagation = propagation;
            return this;
        }

        public final void setPropagation(TransitGatewayPropagation.BuilderImpl propagation) {
            this.propagation = propagation != null ? propagation.build() : null;
        }

        @Override
        public DisableTransitGatewayRouteTablePropagationResponse build() {
            return new DisableTransitGatewayRouteTablePropagationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
