/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateManagedPrefixListRequest extends Ec2Request implements
        ToCopyableBuilder<CreateManagedPrefixListRequest.Builder, CreateManagedPrefixListRequest> {
    private static final SdkField<String> PREFIX_LIST_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateManagedPrefixListRequest::prefixListName))
            .setter(setter(Builder::prefixListName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListName")
                    .unmarshallLocationName("PrefixListName").build()).build();

    private static final SdkField<List<AddPrefixListEntry>> ENTRIES_FIELD = SdkField
            .<List<AddPrefixListEntry>> builder(MarshallingType.LIST)
            .getter(getter(CreateManagedPrefixListRequest::entries))
            .setter(setter(Builder::entries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entry")
                    .unmarshallLocationName("Entry").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AddPrefixListEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(AddPrefixListEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<Integer> MAX_ENTRIES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateManagedPrefixListRequest::maxEntries))
            .setter(setter(Builder::maxEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxEntries")
                    .unmarshallLocationName("MaxEntries").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .getter(getter(CreateManagedPrefixListRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> ADDRESS_FAMILY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateManagedPrefixListRequest::addressFamily))
            .setter(setter(Builder::addressFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressFamily")
                    .unmarshallLocationName("AddressFamily").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateManagedPrefixListRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFIX_LIST_NAME_FIELD,
            ENTRIES_FIELD, MAX_ENTRIES_FIELD, TAG_SPECIFICATIONS_FIELD, ADDRESS_FAMILY_FIELD, CLIENT_TOKEN_FIELD));

    private final String prefixListName;

    private final List<AddPrefixListEntry> entries;

    private final Integer maxEntries;

    private final List<TagSpecification> tagSpecifications;

    private final String addressFamily;

    private final String clientToken;

    private CreateManagedPrefixListRequest(BuilderImpl builder) {
        super(builder);
        this.prefixListName = builder.prefixListName;
        this.entries = builder.entries;
        this.maxEntries = builder.maxEntries;
        this.tagSpecifications = builder.tagSpecifications;
        this.addressFamily = builder.addressFamily;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * A name for the prefix list.
     * </p>
     * <p>
     * Constraints: Up to 255 characters in length. The name cannot start with <code>com.amazonaws</code>.
     * </p>
     * 
     * @return A name for the prefix list.</p>
     *         <p>
     *         Constraints: Up to 255 characters in length. The name cannot start with <code>com.amazonaws</code>.
     */
    public String prefixListName() {
        return prefixListName;
    }

    /**
     * Returns true if the Entries property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEntries() {
        return entries != null && !(entries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more entries for the prefix list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEntries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more entries for the prefix list.
     */
    public List<AddPrefixListEntry> entries() {
        return entries;
    }

    /**
     * <p>
     * The maximum number of entries for the prefix list.
     * </p>
     * 
     * @return The maximum number of entries for the prefix list.
     */
    public Integer maxEntries() {
        return maxEntries;
    }

    /**
     * Returns true if the TagSpecifications property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to the prefix list during creation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTagSpecifications()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags to apply to the prefix list during creation.
     */
    public List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * <p>
     * The IP address type.
     * </p>
     * <p>
     * Valid Values: <code>IPv4</code> | <code>IPv6</code>
     * </p>
     * 
     * @return The IP address type.</p>
     *         <p>
     *         Valid Values: <code>IPv4</code> | <code>IPv6</code>
     */
    public String addressFamily() {
        return addressFamily;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * <p>
     * Constraints: Up to 255 UTF-8 characters in length.
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.</p>
     *         <p>
     *         Constraints: Up to 255 UTF-8 characters in length.
     */
    public String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(prefixListName());
        hashCode = 31 * hashCode + Objects.hashCode(entries());
        hashCode = 31 * hashCode + Objects.hashCode(maxEntries());
        hashCode = 31 * hashCode + Objects.hashCode(tagSpecifications());
        hashCode = 31 * hashCode + Objects.hashCode(addressFamily());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateManagedPrefixListRequest)) {
            return false;
        }
        CreateManagedPrefixListRequest other = (CreateManagedPrefixListRequest) obj;
        return Objects.equals(prefixListName(), other.prefixListName()) && Objects.equals(entries(), other.entries())
                && Objects.equals(maxEntries(), other.maxEntries())
                && Objects.equals(tagSpecifications(), other.tagSpecifications())
                && Objects.equals(addressFamily(), other.addressFamily()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateManagedPrefixListRequest").add("PrefixListName", prefixListName())
                .add("Entries", entries()).add("MaxEntries", maxEntries()).add("TagSpecifications", tagSpecifications())
                .add("AddressFamily", addressFamily()).add("ClientToken", clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrefixListName":
            return Optional.ofNullable(clazz.cast(prefixListName()));
        case "Entries":
            return Optional.ofNullable(clazz.cast(entries()));
        case "MaxEntries":
            return Optional.ofNullable(clazz.cast(maxEntries()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "AddressFamily":
            return Optional.ofNullable(clazz.cast(addressFamily()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateManagedPrefixListRequest, T> g) {
        return obj -> g.apply((CreateManagedPrefixListRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateManagedPrefixListRequest> {
        /**
         * <p>
         * A name for the prefix list.
         * </p>
         * <p>
         * Constraints: Up to 255 characters in length. The name cannot start with <code>com.amazonaws</code>.
         * </p>
         * 
         * @param prefixListName
         *        A name for the prefix list.</p>
         *        <p>
         *        Constraints: Up to 255 characters in length. The name cannot start with <code>com.amazonaws</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListName(String prefixListName);

        /**
         * <p>
         * One or more entries for the prefix list.
         * </p>
         * 
         * @param entries
         *        One or more entries for the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(Collection<AddPrefixListEntry> entries);

        /**
         * <p>
         * One or more entries for the prefix list.
         * </p>
         * 
         * @param entries
         *        One or more entries for the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(AddPrefixListEntry... entries);

        /**
         * <p>
         * One or more entries for the prefix list.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AddPrefixListEntry>.Builder} avoiding the
         * need to create one manually via {@link List<AddPrefixListEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AddPrefixListEntry>.Builder#build()} is called immediately
         * and its result is passed to {@link #entries(List<AddPrefixListEntry>)}.
         * 
         * @param entries
         *        a consumer that will call methods on {@link List<AddPrefixListEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entries(List<AddPrefixListEntry>)
         */
        Builder entries(Consumer<AddPrefixListEntry.Builder>... entries);

        /**
         * <p>
         * The maximum number of entries for the prefix list.
         * </p>
         * 
         * @param maxEntries
         *        The maximum number of entries for the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxEntries(Integer maxEntries);

        /**
         * <p>
         * The tags to apply to the prefix list during creation.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the prefix list during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to apply to the prefix list during creation.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the prefix list during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to apply to the prefix list during creation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagSpecification>.Builder} avoiding the
         * need to create one manually via {@link List<TagSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagSpecification>.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on {@link List<TagSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(List<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        /**
         * <p>
         * The IP address type.
         * </p>
         * <p>
         * Valid Values: <code>IPv4</code> | <code>IPv6</code>
         * </p>
         * 
         * @param addressFamily
         *        The IP address type.</p>
         *        <p>
         *        Valid Values: <code>IPv4</code> | <code>IPv6</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressFamily(String addressFamily);

        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information,
         * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * <p>
         * Constraints: Up to 255 UTF-8 characters in length.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.</p>
         *        <p>
         *        Constraints: Up to 255 UTF-8 characters in length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String prefixListName;

        private List<AddPrefixListEntry> entries = DefaultSdkAutoConstructList.getInstance();

        private Integer maxEntries;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private String addressFamily;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateManagedPrefixListRequest model) {
            super(model);
            prefixListName(model.prefixListName);
            entries(model.entries);
            maxEntries(model.maxEntries);
            tagSpecifications(model.tagSpecifications);
            addressFamily(model.addressFamily);
            clientToken(model.clientToken);
        }

        public final String getPrefixListName() {
            return prefixListName;
        }

        @Override
        public final Builder prefixListName(String prefixListName) {
            this.prefixListName = prefixListName;
            return this;
        }

        public final void setPrefixListName(String prefixListName) {
            this.prefixListName = prefixListName;
        }

        public final Collection<AddPrefixListEntry.Builder> getEntries() {
            return entries != null ? entries.stream().map(AddPrefixListEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entries(Collection<AddPrefixListEntry> entries) {
            this.entries = AddPrefixListEntriesCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(AddPrefixListEntry... entries) {
            entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Consumer<AddPrefixListEntry.Builder>... entries) {
            entries(Stream.of(entries).map(c -> AddPrefixListEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEntries(Collection<AddPrefixListEntry.BuilderImpl> entries) {
            this.entries = AddPrefixListEntriesCopier.copyFromBuilder(entries);
        }

        public final Integer getMaxEntries() {
            return maxEntries;
        }

        @Override
        public final Builder maxEntries(Integer maxEntries) {
            this.maxEntries = maxEntries;
            return this;
        }

        public final void setMaxEntries(Integer maxEntries) {
            this.maxEntries = maxEntries;
        }

        public final Collection<TagSpecification.Builder> getTagSpecifications() {
            return tagSpecifications != null ? tagSpecifications.stream().map(TagSpecification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        public final String getAddressFamily() {
            return addressFamily;
        }

        @Override
        public final Builder addressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        public final void setAddressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateManagedPrefixListRequest build() {
            return new CreateManagedPrefixListRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
