/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an elastic inference accelerator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ElasticInferenceAccelerator implements SdkPojo, Serializable,
        ToCopyableBuilder<ElasticInferenceAccelerator.Builder, ElasticInferenceAccelerator> {
    private static final SdkField<String> TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ElasticInferenceAccelerator::type))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type")
                    .unmarshallLocationName("Type").build()).build();

    private static final SdkField<Integer> COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ElasticInferenceAccelerator::count))
            .setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count")
                    .unmarshallLocationName("Count").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final Integer count;

    private ElasticInferenceAccelerator(BuilderImpl builder) {
        this.type = builder.type;
        this.count = builder.count;
    }

    /**
     * <p>
     * The type of elastic inference accelerator. The possible values are <code>eia1.medium</code>,
     * <code>eia1.large</code>, <code>eia1.xlarge</code>, <code>eia2.medium</code>, <code>eia2.large</code>, and
     * <code>eia2.xlarge</code>.
     * </p>
     * 
     * @return The type of elastic inference accelerator. The possible values are <code>eia1.medium</code>,
     *         <code>eia1.large</code>, <code>eia1.xlarge</code>, <code>eia2.medium</code>, <code>eia2.large</code>, and
     *         <code>eia2.xlarge</code>.
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * The number of elastic inference accelerators to attach to the instance.
     * </p>
     * <p>
     * Default: 1
     * </p>
     * 
     * @return The number of elastic inference accelerators to attach to the instance. </p>
     *         <p>
     *         Default: 1
     */
    public Integer count() {
        return count;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticInferenceAccelerator)) {
            return false;
        }
        ElasticInferenceAccelerator other = (ElasticInferenceAccelerator) obj;
        return Objects.equals(type(), other.type()) && Objects.equals(count(), other.count());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ElasticInferenceAccelerator").add("Type", type()).add("Count", count()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ElasticInferenceAccelerator, T> g) {
        return obj -> g.apply((ElasticInferenceAccelerator) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ElasticInferenceAccelerator> {
        /**
         * <p>
         * The type of elastic inference accelerator. The possible values are <code>eia1.medium</code>,
         * <code>eia1.large</code>, <code>eia1.xlarge</code>, <code>eia2.medium</code>, <code>eia2.large</code>, and
         * <code>eia2.xlarge</code>.
         * </p>
         * 
         * @param type
         *        The type of elastic inference accelerator. The possible values are <code>eia1.medium</code>,
         *        <code>eia1.large</code>, <code>eia1.xlarge</code>, <code>eia2.medium</code>, <code>eia2.large</code>,
         *        and <code>eia2.xlarge</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The number of elastic inference accelerators to attach to the instance.
         * </p>
         * <p>
         * Default: 1
         * </p>
         * 
         * @param count
         *        The number of elastic inference accelerators to attach to the instance. </p>
         *        <p>
         *        Default: 1
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Integer count;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticInferenceAccelerator model) {
            type(model.type);
            count(model.count);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Integer getCount() {
            return count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public ElasticInferenceAccelerator build() {
            return new ElasticInferenceAccelerator(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
