/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConsoleOutputResponse extends Ec2Response implements
        ToCopyableBuilder<GetConsoleOutputResponse.Builder, GetConsoleOutputResponse> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(GetConsoleOutputResponse::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("instanceId").build()).build();

    private static final SdkField<String> OUTPUT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(GetConsoleOutputResponse::output))
            .setter(setter(Builder::output))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Output")
                    .unmarshallLocationName("output").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetConsoleOutputResponse::timestamp))
            .setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp")
                    .unmarshallLocationName("timestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            OUTPUT_FIELD, TIMESTAMP_FIELD));

    private final String instanceId;

    private final String output;

    private final Instant timestamp;

    private GetConsoleOutputResponse(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.output = builder.output;
        this.timestamp = builder.timestamp;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The console output, base64-encoded. If you are using a command line tool, the tool decodes the output for you.
     * </p>
     * 
     * @return The console output, base64-encoded. If you are using a command line tool, the tool decodes the output for
     *         you.
     */
    public String output() {
        return output;
    }

    /**
     * <p>
     * The time at which the output was last updated.
     * </p>
     * 
     * @return The time at which the output was last updated.
     */
    public Instant timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(output());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConsoleOutputResponse)) {
            return false;
        }
        GetConsoleOutputResponse other = (GetConsoleOutputResponse) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(output(), other.output())
                && Objects.equals(timestamp(), other.timestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetConsoleOutputResponse").add("InstanceId", instanceId()).add("Output", output())
                .add("Timestamp", timestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Output":
            return Optional.ofNullable(clazz.cast(output()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConsoleOutputResponse, T> g) {
        return obj -> g.apply((GetConsoleOutputResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetConsoleOutputResponse> {
        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The console output, base64-encoded. If you are using a command line tool, the tool decodes the output for
         * you.
         * </p>
         * 
         * @param output
         *        The console output, base64-encoded. If you are using a command line tool, the tool decodes the output
         *        for you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(String output);

        /**
         * <p>
         * The time at which the output was last updated.
         * </p>
         * 
         * @param timestamp
         *        The time at which the output was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String instanceId;

        private String output;

        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConsoleOutputResponse model) {
            super(model);
            instanceId(model.instanceId);
            output(model.output);
            timestamp(model.timestamp);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getOutput() {
            return output;
        }

        @Override
        public final Builder output(String output) {
            this.output = output;
            return this;
        }

        public final void setOutput(String output) {
            this.output = output;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public GetConsoleOutputResponse build() {
            return new GetConsoleOutputResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
