/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum LaunchTemplateErrorCode {
    LAUNCH_TEMPLATE_ID_DOES_NOT_EXIST("launchTemplateIdDoesNotExist"),
    LAUNCH_TEMPLATE_ID_MALFORMED("launchTemplateIdMalformed"),
    LAUNCH_TEMPLATE_NAME_DOES_NOT_EXIST("launchTemplateNameDoesNotExist"),
    LAUNCH_TEMPLATE_NAME_MALFORMED("launchTemplateNameMalformed"),
    LAUNCH_TEMPLATE_VERSION_DOES_NOT_EXIST("launchTemplateVersionDoesNotExist"),
    UNEXPECTED_ERROR("unexpectedError"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private LaunchTemplateErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LaunchTemplateErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(LaunchTemplateErrorCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LaunchTemplateErrorCode> knownValues() {
        return Stream.of(LaunchTemplateErrorCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

