/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AllocateAddressRequest extends Ec2Request implements
        ToCopyableBuilder<AllocateAddressRequest.Builder, AllocateAddressRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AllocateAddressRequest::domainAsString))
            .setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain")
                    .unmarshallLocationName("Domain").build()).build();

    private static final SdkField<String> ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AllocateAddressRequest::address))
            .setter(setter(Builder::address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address")
                    .unmarshallLocationName("Address").build()).build();

    private static final SdkField<String> PUBLIC_IPV4_POOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AllocateAddressRequest::publicIpv4Pool))
            .setter(setter(Builder::publicIpv4Pool))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIpv4Pool")
                    .unmarshallLocationName("PublicIpv4Pool").build()).build();

    private static final SdkField<String> NETWORK_BORDER_GROUP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AllocateAddressRequest::networkBorderGroup))
            .setter(setter(Builder::networkBorderGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkBorderGroup")
                    .unmarshallLocationName("NetworkBorderGroup").build()).build();

    private static final SdkField<String> CUSTOMER_OWNED_IPV4_POOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AllocateAddressRequest::customerOwnedIpv4Pool))
            .setter(setter(Builder::customerOwnedIpv4Pool))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerOwnedIpv4Pool")
                    .unmarshallLocationName("CustomerOwnedIpv4Pool").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, ADDRESS_FIELD,
            PUBLIC_IPV4_POOL_FIELD, NETWORK_BORDER_GROUP_FIELD, CUSTOMER_OWNED_IPV4_POOL_FIELD));

    private final String domain;

    private final String address;

    private final String publicIpv4Pool;

    private final String networkBorderGroup;

    private final String customerOwnedIpv4Pool;

    private AllocateAddressRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.address = builder.address;
        this.publicIpv4Pool = builder.publicIpv4Pool;
        this.networkBorderGroup = builder.networkBorderGroup;
        this.customerOwnedIpv4Pool = builder.customerOwnedIpv4Pool;
    }

    /**
     * <p>
     * Indicates whether the Elastic IP address is for use with instances in a VPC or instances in EC2-Classic.
     * </p>
     * <p>
     * Default: If the Region supports EC2-Classic, the default is <code>standard</code>. Otherwise, the default is
     * <code>vpc</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domain} will
     * return {@link DomainType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainAsString}.
     * </p>
     * 
     * @return Indicates whether the Elastic IP address is for use with instances in a VPC or instances in
     *         EC2-Classic.</p>
     *         <p>
     *         Default: If the Region supports EC2-Classic, the default is <code>standard</code>. Otherwise, the default
     *         is <code>vpc</code>.
     * @see DomainType
     */
    public DomainType domain() {
        return DomainType.fromValue(domain);
    }

    /**
     * <p>
     * Indicates whether the Elastic IP address is for use with instances in a VPC or instances in EC2-Classic.
     * </p>
     * <p>
     * Default: If the Region supports EC2-Classic, the default is <code>standard</code>. Otherwise, the default is
     * <code>vpc</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domain} will
     * return {@link DomainType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainAsString}.
     * </p>
     * 
     * @return Indicates whether the Elastic IP address is for use with instances in a VPC or instances in
     *         EC2-Classic.</p>
     *         <p>
     *         Default: If the Region supports EC2-Classic, the default is <code>standard</code>. Otherwise, the default
     *         is <code>vpc</code>.
     * @see DomainType
     */
    public String domainAsString() {
        return domain;
    }

    /**
     * <p>
     * [EC2-VPC] The Elastic IP address to recover or an IPv4 address from an address pool.
     * </p>
     * 
     * @return [EC2-VPC] The Elastic IP address to recover or an IPv4 address from an address pool.
     */
    public String address() {
        return address;
    }

    /**
     * <p>
     * The ID of an address pool that you own. Use this parameter to let Amazon EC2 select an address from the address
     * pool. To specify a specific address from the address pool, use the <code>Address</code> parameter instead.
     * </p>
     * 
     * @return The ID of an address pool that you own. Use this parameter to let Amazon EC2 select an address from the
     *         address pool. To specify a specific address from the address pool, use the <code>Address</code> parameter
     *         instead.
     */
    public String publicIpv4Pool() {
        return publicIpv4Pool;
    }

    /**
     * <p>
     * A unique set of Availability Zones, Local Zones, or Wavelength Zones from which AWS advertises IP addresses. Use
     * this parameter to limit the IP address to this location. IP addresses cannot move between network border groups.
     * </p>
     * <p>
     * Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAvailabilityZones.html">
     * DescribeAvailabilityZones</a> to view the network border groups.
     * </p>
     * <note>
     * <p>
     * You cannot use a network border group with EC2 Classic. If you attempt this operation on EC2 classic, you will
     * receive an <code>InvalidParameterCombination</code> error. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html">Error Codes</a>.
     * </p>
     * </note>
     * 
     * @return A unique set of Availability Zones, Local Zones, or Wavelength Zones from which AWS advertises IP
     *         addresses. Use this parameter to limit the IP address to this location. IP addresses cannot move between
     *         network border groups.</p>
     *         <p>
     *         Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAvailabilityZones.html">
     *         DescribeAvailabilityZones</a> to view the network border groups.
     *         </p>
     *         <note>
     *         <p>
     *         You cannot use a network border group with EC2 Classic. If you attempt this operation on EC2 classic, you
     *         will receive an <code>InvalidParameterCombination</code> error. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html">Error Codes</a>.
     *         </p>
     */
    public String networkBorderGroup() {
        return networkBorderGroup;
    }

    /**
     * <p>
     * The ID of a customer-owned address pool. Use this parameter to let Amazon EC2 select an address from the address
     * pool. Alternatively, specify a specific address from the address pool.
     * </p>
     * 
     * @return The ID of a customer-owned address pool. Use this parameter to let Amazon EC2 select an address from the
     *         address pool. Alternatively, specify a specific address from the address pool.
     */
    public String customerOwnedIpv4Pool() {
        return customerOwnedIpv4Pool;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(address());
        hashCode = 31 * hashCode + Objects.hashCode(publicIpv4Pool());
        hashCode = 31 * hashCode + Objects.hashCode(networkBorderGroup());
        hashCode = 31 * hashCode + Objects.hashCode(customerOwnedIpv4Pool());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateAddressRequest)) {
            return false;
        }
        AllocateAddressRequest other = (AllocateAddressRequest) obj;
        return Objects.equals(domainAsString(), other.domainAsString()) && Objects.equals(address(), other.address())
                && Objects.equals(publicIpv4Pool(), other.publicIpv4Pool())
                && Objects.equals(networkBorderGroup(), other.networkBorderGroup())
                && Objects.equals(customerOwnedIpv4Pool(), other.customerOwnedIpv4Pool());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AllocateAddressRequest").add("Domain", domainAsString()).add("Address", address())
                .add("PublicIpv4Pool", publicIpv4Pool()).add("NetworkBorderGroup", networkBorderGroup())
                .add("CustomerOwnedIpv4Pool", customerOwnedIpv4Pool()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Domain":
            return Optional.ofNullable(clazz.cast(domainAsString()));
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        case "PublicIpv4Pool":
            return Optional.ofNullable(clazz.cast(publicIpv4Pool()));
        case "NetworkBorderGroup":
            return Optional.ofNullable(clazz.cast(networkBorderGroup()));
        case "CustomerOwnedIpv4Pool":
            return Optional.ofNullable(clazz.cast(customerOwnedIpv4Pool()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AllocateAddressRequest, T> g) {
        return obj -> g.apply((AllocateAddressRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, AllocateAddressRequest> {
        /**
         * <p>
         * Indicates whether the Elastic IP address is for use with instances in a VPC or instances in EC2-Classic.
         * </p>
         * <p>
         * Default: If the Region supports EC2-Classic, the default is <code>standard</code>. Otherwise, the default is
         * <code>vpc</code>.
         * </p>
         * 
         * @param domain
         *        Indicates whether the Elastic IP address is for use with instances in a VPC or instances in
         *        EC2-Classic.</p>
         *        <p>
         *        Default: If the Region supports EC2-Classic, the default is <code>standard</code>. Otherwise, the
         *        default is <code>vpc</code>.
         * @see DomainType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainType
         */
        Builder domain(String domain);

        /**
         * <p>
         * Indicates whether the Elastic IP address is for use with instances in a VPC or instances in EC2-Classic.
         * </p>
         * <p>
         * Default: If the Region supports EC2-Classic, the default is <code>standard</code>. Otherwise, the default is
         * <code>vpc</code>.
         * </p>
         * 
         * @param domain
         *        Indicates whether the Elastic IP address is for use with instances in a VPC or instances in
         *        EC2-Classic.</p>
         *        <p>
         *        Default: If the Region supports EC2-Classic, the default is <code>standard</code>. Otherwise, the
         *        default is <code>vpc</code>.
         * @see DomainType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainType
         */
        Builder domain(DomainType domain);

        /**
         * <p>
         * [EC2-VPC] The Elastic IP address to recover or an IPv4 address from an address pool.
         * </p>
         * 
         * @param address
         *        [EC2-VPC] The Elastic IP address to recover or an IPv4 address from an address pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(String address);

        /**
         * <p>
         * The ID of an address pool that you own. Use this parameter to let Amazon EC2 select an address from the
         * address pool. To specify a specific address from the address pool, use the <code>Address</code> parameter
         * instead.
         * </p>
         * 
         * @param publicIpv4Pool
         *        The ID of an address pool that you own. Use this parameter to let Amazon EC2 select an address from
         *        the address pool. To specify a specific address from the address pool, use the <code>Address</code>
         *        parameter instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIpv4Pool(String publicIpv4Pool);

        /**
         * <p>
         * A unique set of Availability Zones, Local Zones, or Wavelength Zones from which AWS advertises IP addresses.
         * Use this parameter to limit the IP address to this location. IP addresses cannot move between network border
         * groups.
         * </p>
         * <p>
         * Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAvailabilityZones.html">
         * DescribeAvailabilityZones</a> to view the network border groups.
         * </p>
         * <note>
         * <p>
         * You cannot use a network border group with EC2 Classic. If you attempt this operation on EC2 classic, you
         * will receive an <code>InvalidParameterCombination</code> error. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html">Error Codes</a>.
         * </p>
         * </note>
         * 
         * @param networkBorderGroup
         *        A unique set of Availability Zones, Local Zones, or Wavelength Zones from which AWS advertises IP
         *        addresses. Use this parameter to limit the IP address to this location. IP addresses cannot move
         *        between network border groups.</p>
         *        <p>
         *        Use <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAvailabilityZones.html"
         *        >DescribeAvailabilityZones</a> to view the network border groups.
         *        </p>
         *        <note>
         *        <p>
         *        You cannot use a network border group with EC2 Classic. If you attempt this operation on EC2 classic,
         *        you will receive an <code>InvalidParameterCombination</code> error. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html">Error Codes</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkBorderGroup(String networkBorderGroup);

        /**
         * <p>
         * The ID of a customer-owned address pool. Use this parameter to let Amazon EC2 select an address from the
         * address pool. Alternatively, specify a specific address from the address pool.
         * </p>
         * 
         * @param customerOwnedIpv4Pool
         *        The ID of a customer-owned address pool. Use this parameter to let Amazon EC2 select an address from
         *        the address pool. Alternatively, specify a specific address from the address pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerOwnedIpv4Pool(String customerOwnedIpv4Pool);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String domain;

        private String address;

        private String publicIpv4Pool;

        private String networkBorderGroup;

        private String customerOwnedIpv4Pool;

        private BuilderImpl() {
        }

        private BuilderImpl(AllocateAddressRequest model) {
            super(model);
            domain(model.domain);
            address(model.address);
            publicIpv4Pool(model.publicIpv4Pool);
            networkBorderGroup(model.networkBorderGroup);
            customerOwnedIpv4Pool(model.customerOwnedIpv4Pool);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public final Builder domain(DomainType domain) {
            this.domain(domain == null ? null : domain.toString());
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getAddress() {
            return address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        public final String getPublicIpv4Pool() {
            return publicIpv4Pool;
        }

        @Override
        public final Builder publicIpv4Pool(String publicIpv4Pool) {
            this.publicIpv4Pool = publicIpv4Pool;
            return this;
        }

        public final void setPublicIpv4Pool(String publicIpv4Pool) {
            this.publicIpv4Pool = publicIpv4Pool;
        }

        public final String getNetworkBorderGroup() {
            return networkBorderGroup;
        }

        @Override
        public final Builder networkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
            return this;
        }

        public final void setNetworkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
        }

        public final String getCustomerOwnedIpv4Pool() {
            return customerOwnedIpv4Pool;
        }

        @Override
        public final Builder customerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
            this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
            return this;
        }

        public final void setCustomerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
            this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AllocateAddressRequest build() {
            return new AllocateAddressRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
