/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a carrier gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CarrierGateway implements SdkPojo, Serializable, ToCopyableBuilder<CarrierGateway.Builder, CarrierGateway> {
    private static final SdkField<String> CARRIER_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CarrierGateway::carrierGatewayId))
            .setter(setter(Builder::carrierGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CarrierGatewayId")
                    .unmarshallLocationName("carrierGatewayId").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CarrierGateway::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("vpcId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CarrierGateway::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CarrierGateway::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CarrierGateway::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CARRIER_GATEWAY_ID_FIELD,
            VPC_ID_FIELD, STATE_FIELD, OWNER_ID_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String carrierGatewayId;

    private final String vpcId;

    private final String state;

    private final String ownerId;

    private final List<Tag> tags;

    private CarrierGateway(BuilderImpl builder) {
        this.carrierGatewayId = builder.carrierGatewayId;
        this.vpcId = builder.vpcId;
        this.state = builder.state;
        this.ownerId = builder.ownerId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the carrier gateway.
     * </p>
     * 
     * @return The ID of the carrier gateway.
     */
    public String carrierGatewayId() {
        return carrierGatewayId;
    }

    /**
     * <p>
     * The ID of the VPC associated with the carrier gateway.
     * </p>
     * 
     * @return The ID of the VPC associated with the carrier gateway.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The state of the carrier gateway.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CarrierGatewayState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the carrier gateway.
     * @see CarrierGatewayState
     */
    public CarrierGatewayState state() {
        return CarrierGatewayState.fromValue(state);
    }

    /**
     * <p>
     * The state of the carrier gateway.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CarrierGatewayState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the carrier gateway.
     * @see CarrierGatewayState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The AWS account ID of the owner of the carrier gateway.
     * </p>
     * 
     * @return The AWS account ID of the owner of the carrier gateway.
     */
    public String ownerId() {
        return ownerId;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags assigned to the carrier gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags assigned to the carrier gateway.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(carrierGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CarrierGateway)) {
            return false;
        }
        CarrierGateway other = (CarrierGateway) obj;
        return Objects.equals(carrierGatewayId(), other.carrierGatewayId()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(ownerId(), other.ownerId())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CarrierGateway").add("CarrierGatewayId", carrierGatewayId()).add("VpcId", vpcId())
                .add("State", stateAsString()).add("OwnerId", ownerId()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CarrierGatewayId":
            return Optional.ofNullable(clazz.cast(carrierGatewayId()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CarrierGateway, T> g) {
        return obj -> g.apply((CarrierGateway) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CarrierGateway> {
        /**
         * <p>
         * The ID of the carrier gateway.
         * </p>
         * 
         * @param carrierGatewayId
         *        The ID of the carrier gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder carrierGatewayId(String carrierGatewayId);

        /**
         * <p>
         * The ID of the VPC associated with the carrier gateway.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC associated with the carrier gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The state of the carrier gateway.
         * </p>
         * 
         * @param state
         *        The state of the carrier gateway.
         * @see CarrierGatewayState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CarrierGatewayState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the carrier gateway.
         * </p>
         * 
         * @param state
         *        The state of the carrier gateway.
         * @see CarrierGatewayState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CarrierGatewayState
         */
        Builder state(CarrierGatewayState state);

        /**
         * <p>
         * The AWS account ID of the owner of the carrier gateway.
         * </p>
         * 
         * @param ownerId
         *        The AWS account ID of the owner of the carrier gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The tags assigned to the carrier gateway.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the carrier gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags assigned to the carrier gateway.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the carrier gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags assigned to the carrier gateway.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String carrierGatewayId;

        private String vpcId;

        private String state;

        private String ownerId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CarrierGateway model) {
            carrierGatewayId(model.carrierGatewayId);
            vpcId(model.vpcId);
            state(model.state);
            ownerId(model.ownerId);
            tags(model.tags);
        }

        public final String getCarrierGatewayId() {
            return carrierGatewayId;
        }

        @Override
        public final Builder carrierGatewayId(String carrierGatewayId) {
            this.carrierGatewayId = carrierGatewayId;
            return this;
        }

        public final void setCarrierGatewayId(String carrierGatewayId) {
            this.carrierGatewayId = carrierGatewayId;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CarrierGatewayState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public CarrierGateway build() {
            return new CarrierGateway(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
