/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyAvailabilityZoneGroupRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyAvailabilityZoneGroupRequest.Builder, ModifyAvailabilityZoneGroupRequest> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyAvailabilityZoneGroupRequest::groupName))
            .setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName")
                    .unmarshallLocationName("GroupName").build()).build();

    private static final SdkField<String> OPT_IN_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyAvailabilityZoneGroupRequest::optInStatusAsString))
            .setter(setter(Builder::optInStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptInStatus")
                    .unmarshallLocationName("OptInStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD,
            OPT_IN_STATUS_FIELD));

    private final String groupName;

    private final String optInStatus;

    private ModifyAvailabilityZoneGroupRequest(BuilderImpl builder) {
        super(builder);
        this.groupName = builder.groupName;
        this.optInStatus = builder.optInStatus;
    }

    /**
     * <p>
     * The name of the Availability Zone group, Local Zone group, or Wavelength Zone group.
     * </p>
     * 
     * @return The name of the Availability Zone group, Local Zone group, or Wavelength Zone group.
     */
    public String groupName() {
        return groupName;
    }

    /**
     * <p>
     * Indicates whether you are opted in to the Local Zone group or Wavelength Zone group. The only valid value is
     * <code>opted-in</code>. You must contact <a href=
     * "https://console.aws.amazon.com/support/home#/case/create%3FissueType=customer-service%26serviceCode=general-info%26getting-started%26categoryCode=using-aws%26services"
     * >AWS Support</a> to opt out of a Local Zone group, or Wavelength Zone group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #optInStatus} will
     * return {@link ModifyAvailabilityZoneOptInStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #optInStatusAsString}.
     * </p>
     * 
     * @return Indicates whether you are opted in to the Local Zone group or Wavelength Zone group. The only valid value
     *         is <code>opted-in</code>. You must contact <a href=
     *         "https://console.aws.amazon.com/support/home#/case/create%3FissueType=customer-service%26serviceCode=general-info%26getting-started%26categoryCode=using-aws%26services"
     *         >AWS Support</a> to opt out of a Local Zone group, or Wavelength Zone group.
     * @see ModifyAvailabilityZoneOptInStatus
     */
    public ModifyAvailabilityZoneOptInStatus optInStatus() {
        return ModifyAvailabilityZoneOptInStatus.fromValue(optInStatus);
    }

    /**
     * <p>
     * Indicates whether you are opted in to the Local Zone group or Wavelength Zone group. The only valid value is
     * <code>opted-in</code>. You must contact <a href=
     * "https://console.aws.amazon.com/support/home#/case/create%3FissueType=customer-service%26serviceCode=general-info%26getting-started%26categoryCode=using-aws%26services"
     * >AWS Support</a> to opt out of a Local Zone group, or Wavelength Zone group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #optInStatus} will
     * return {@link ModifyAvailabilityZoneOptInStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #optInStatusAsString}.
     * </p>
     * 
     * @return Indicates whether you are opted in to the Local Zone group or Wavelength Zone group. The only valid value
     *         is <code>opted-in</code>. You must contact <a href=
     *         "https://console.aws.amazon.com/support/home#/case/create%3FissueType=customer-service%26serviceCode=general-info%26getting-started%26categoryCode=using-aws%26services"
     *         >AWS Support</a> to opt out of a Local Zone group, or Wavelength Zone group.
     * @see ModifyAvailabilityZoneOptInStatus
     */
    public String optInStatusAsString() {
        return optInStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(optInStatusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyAvailabilityZoneGroupRequest)) {
            return false;
        }
        ModifyAvailabilityZoneGroupRequest other = (ModifyAvailabilityZoneGroupRequest) obj;
        return Objects.equals(groupName(), other.groupName())
                && Objects.equals(optInStatusAsString(), other.optInStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyAvailabilityZoneGroupRequest").add("GroupName", groupName())
                .add("OptInStatus", optInStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "OptInStatus":
            return Optional.ofNullable(clazz.cast(optInStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyAvailabilityZoneGroupRequest, T> g) {
        return obj -> g.apply((ModifyAvailabilityZoneGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyAvailabilityZoneGroupRequest> {
        /**
         * <p>
         * The name of the Availability Zone group, Local Zone group, or Wavelength Zone group.
         * </p>
         * 
         * @param groupName
         *        The name of the Availability Zone group, Local Zone group, or Wavelength Zone group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * Indicates whether you are opted in to the Local Zone group or Wavelength Zone group. The only valid value is
         * <code>opted-in</code>. You must contact <a href=
         * "https://console.aws.amazon.com/support/home#/case/create%3FissueType=customer-service%26serviceCode=general-info%26getting-started%26categoryCode=using-aws%26services"
         * >AWS Support</a> to opt out of a Local Zone group, or Wavelength Zone group.
         * </p>
         * 
         * @param optInStatus
         *        Indicates whether you are opted in to the Local Zone group or Wavelength Zone group. The only valid
         *        value is <code>opted-in</code>. You must contact <a href=
         *        "https://console.aws.amazon.com/support/home#/case/create%3FissueType=customer-service%26serviceCode=general-info%26getting-started%26categoryCode=using-aws%26services"
         *        >AWS Support</a> to opt out of a Local Zone group, or Wavelength Zone group.
         * @see ModifyAvailabilityZoneOptInStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModifyAvailabilityZoneOptInStatus
         */
        Builder optInStatus(String optInStatus);

        /**
         * <p>
         * Indicates whether you are opted in to the Local Zone group or Wavelength Zone group. The only valid value is
         * <code>opted-in</code>. You must contact <a href=
         * "https://console.aws.amazon.com/support/home#/case/create%3FissueType=customer-service%26serviceCode=general-info%26getting-started%26categoryCode=using-aws%26services"
         * >AWS Support</a> to opt out of a Local Zone group, or Wavelength Zone group.
         * </p>
         * 
         * @param optInStatus
         *        Indicates whether you are opted in to the Local Zone group or Wavelength Zone group. The only valid
         *        value is <code>opted-in</code>. You must contact <a href=
         *        "https://console.aws.amazon.com/support/home#/case/create%3FissueType=customer-service%26serviceCode=general-info%26getting-started%26categoryCode=using-aws%26services"
         *        >AWS Support</a> to opt out of a Local Zone group, or Wavelength Zone group.
         * @see ModifyAvailabilityZoneOptInStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModifyAvailabilityZoneOptInStatus
         */
        Builder optInStatus(ModifyAvailabilityZoneOptInStatus optInStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String groupName;

        private String optInStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyAvailabilityZoneGroupRequest model) {
            super(model);
            groupName(model.groupName);
            optInStatus(model.optInStatus);
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getOptInStatus() {
            return optInStatus;
        }

        @Override
        public final Builder optInStatus(String optInStatus) {
            this.optInStatus = optInStatus;
            return this;
        }

        @Override
        public final Builder optInStatus(ModifyAvailabilityZoneOptInStatus optInStatus) {
            this.optInStatus(optInStatus == null ? null : optInStatus.toString());
            return this;
        }

        public final void setOptInStatus(String optInStatus) {
            this.optInStatus = optInStatus;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyAvailabilityZoneGroupRequest build() {
            return new ModifyAvailabilityZoneGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
