/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes association information for an Elastic IP address (IPv4).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceNetworkInterfaceAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceNetworkInterfaceAssociation.Builder, InstanceNetworkInterfaceAssociation> {
    private static final SdkField<String> CARRIER_IP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(InstanceNetworkInterfaceAssociation::carrierIp))
            .setter(setter(Builder::carrierIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CarrierIp")
                    .unmarshallLocationName("carrierIp").build()).build();

    private static final SdkField<String> IP_OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(InstanceNetworkInterfaceAssociation::ipOwnerId))
            .setter(setter(Builder::ipOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpOwnerId")
                    .unmarshallLocationName("ipOwnerId").build()).build();

    private static final SdkField<String> PUBLIC_DNS_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(InstanceNetworkInterfaceAssociation::publicDnsName))
            .setter(setter(Builder::publicDnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicDnsName")
                    .unmarshallLocationName("publicDnsName").build()).build();

    private static final SdkField<String> PUBLIC_IP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(InstanceNetworkInterfaceAssociation::publicIp))
            .setter(setter(Builder::publicIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIp")
                    .unmarshallLocationName("publicIp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CARRIER_IP_FIELD,
            IP_OWNER_ID_FIELD, PUBLIC_DNS_NAME_FIELD, PUBLIC_IP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String carrierIp;

    private final String ipOwnerId;

    private final String publicDnsName;

    private final String publicIp;

    private InstanceNetworkInterfaceAssociation(BuilderImpl builder) {
        this.carrierIp = builder.carrierIp;
        this.ipOwnerId = builder.ipOwnerId;
        this.publicDnsName = builder.publicDnsName;
        this.publicIp = builder.publicIp;
    }

    /**
     * <p>
     * The carrier IP address associated with the network interface.
     * </p>
     * 
     * @return The carrier IP address associated with the network interface.
     */
    public String carrierIp() {
        return carrierIp;
    }

    /**
     * <p>
     * The ID of the owner of the Elastic IP address.
     * </p>
     * 
     * @return The ID of the owner of the Elastic IP address.
     */
    public String ipOwnerId() {
        return ipOwnerId;
    }

    /**
     * <p>
     * The public DNS name.
     * </p>
     * 
     * @return The public DNS name.
     */
    public String publicDnsName() {
        return publicDnsName;
    }

    /**
     * <p>
     * The public IP address or Elastic IP address bound to the network interface.
     * </p>
     * 
     * @return The public IP address or Elastic IP address bound to the network interface.
     */
    public String publicIp() {
        return publicIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(carrierIp());
        hashCode = 31 * hashCode + Objects.hashCode(ipOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(publicDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(publicIp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceNetworkInterfaceAssociation)) {
            return false;
        }
        InstanceNetworkInterfaceAssociation other = (InstanceNetworkInterfaceAssociation) obj;
        return Objects.equals(carrierIp(), other.carrierIp()) && Objects.equals(ipOwnerId(), other.ipOwnerId())
                && Objects.equals(publicDnsName(), other.publicDnsName()) && Objects.equals(publicIp(), other.publicIp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InstanceNetworkInterfaceAssociation").add("CarrierIp", carrierIp())
                .add("IpOwnerId", ipOwnerId()).add("PublicDnsName", publicDnsName()).add("PublicIp", publicIp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CarrierIp":
            return Optional.ofNullable(clazz.cast(carrierIp()));
        case "IpOwnerId":
            return Optional.ofNullable(clazz.cast(ipOwnerId()));
        case "PublicDnsName":
            return Optional.ofNullable(clazz.cast(publicDnsName()));
        case "PublicIp":
            return Optional.ofNullable(clazz.cast(publicIp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceNetworkInterfaceAssociation, T> g) {
        return obj -> g.apply((InstanceNetworkInterfaceAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceNetworkInterfaceAssociation> {
        /**
         * <p>
         * The carrier IP address associated with the network interface.
         * </p>
         * 
         * @param carrierIp
         *        The carrier IP address associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder carrierIp(String carrierIp);

        /**
         * <p>
         * The ID of the owner of the Elastic IP address.
         * </p>
         * 
         * @param ipOwnerId
         *        The ID of the owner of the Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipOwnerId(String ipOwnerId);

        /**
         * <p>
         * The public DNS name.
         * </p>
         * 
         * @param publicDnsName
         *        The public DNS name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicDnsName(String publicDnsName);

        /**
         * <p>
         * The public IP address or Elastic IP address bound to the network interface.
         * </p>
         * 
         * @param publicIp
         *        The public IP address or Elastic IP address bound to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIp(String publicIp);
    }

    static final class BuilderImpl implements Builder {
        private String carrierIp;

        private String ipOwnerId;

        private String publicDnsName;

        private String publicIp;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceNetworkInterfaceAssociation model) {
            carrierIp(model.carrierIp);
            ipOwnerId(model.ipOwnerId);
            publicDnsName(model.publicDnsName);
            publicIp(model.publicIp);
        }

        public final String getCarrierIp() {
            return carrierIp;
        }

        @Override
        public final Builder carrierIp(String carrierIp) {
            this.carrierIp = carrierIp;
            return this;
        }

        public final void setCarrierIp(String carrierIp) {
            this.carrierIp = carrierIp;
        }

        public final String getIpOwnerId() {
            return ipOwnerId;
        }

        @Override
        public final Builder ipOwnerId(String ipOwnerId) {
            this.ipOwnerId = ipOwnerId;
            return this;
        }

        public final void setIpOwnerId(String ipOwnerId) {
            this.ipOwnerId = ipOwnerId;
        }

        public final String getPublicDnsName() {
            return publicDnsName;
        }

        @Override
        public final Builder publicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
            return this;
        }

        public final void setPublicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
        }

        public final String getPublicIp() {
            return publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        @Override
        public InstanceNetworkInterfaceAssociation build() {
            return new InstanceNetworkInterfaceAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
