/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyVpnTunnelCertificateRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyVpnTunnelCertificateRequest.Builder, ModifyVpnTunnelCertificateRequest> {
    private static final SdkField<String> VPN_CONNECTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyVpnTunnelCertificateRequest::vpnConnectionId))
            .setter(setter(Builder::vpnConnectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnConnectionId")
                    .unmarshallLocationName("VpnConnectionId").build()).build();

    private static final SdkField<String> VPN_TUNNEL_OUTSIDE_IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyVpnTunnelCertificateRequest::vpnTunnelOutsideIpAddress))
            .setter(setter(Builder::vpnTunnelOutsideIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnTunnelOutsideIpAddress")
                    .unmarshallLocationName("VpnTunnelOutsideIpAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPN_CONNECTION_ID_FIELD,
            VPN_TUNNEL_OUTSIDE_IP_ADDRESS_FIELD));

    private final String vpnConnectionId;

    private final String vpnTunnelOutsideIpAddress;

    private ModifyVpnTunnelCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.vpnConnectionId = builder.vpnConnectionId;
        this.vpnTunnelOutsideIpAddress = builder.vpnTunnelOutsideIpAddress;
    }

    /**
     * <p>
     * The ID of the AWS Site-to-Site VPN connection.
     * </p>
     * 
     * @return The ID of the AWS Site-to-Site VPN connection.
     */
    public String vpnConnectionId() {
        return vpnConnectionId;
    }

    /**
     * <p>
     * The external IP address of the VPN tunnel.
     * </p>
     * 
     * @return The external IP address of the VPN tunnel.
     */
    public String vpnTunnelOutsideIpAddress() {
        return vpnTunnelOutsideIpAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpnConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(vpnTunnelOutsideIpAddress());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpnTunnelCertificateRequest)) {
            return false;
        }
        ModifyVpnTunnelCertificateRequest other = (ModifyVpnTunnelCertificateRequest) obj;
        return Objects.equals(vpnConnectionId(), other.vpnConnectionId())
                && Objects.equals(vpnTunnelOutsideIpAddress(), other.vpnTunnelOutsideIpAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyVpnTunnelCertificateRequest").add("VpnConnectionId", vpnConnectionId())
                .add("VpnTunnelOutsideIpAddress", vpnTunnelOutsideIpAddress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpnConnectionId":
            return Optional.ofNullable(clazz.cast(vpnConnectionId()));
        case "VpnTunnelOutsideIpAddress":
            return Optional.ofNullable(clazz.cast(vpnTunnelOutsideIpAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpnTunnelCertificateRequest, T> g) {
        return obj -> g.apply((ModifyVpnTunnelCertificateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyVpnTunnelCertificateRequest> {
        /**
         * <p>
         * The ID of the AWS Site-to-Site VPN connection.
         * </p>
         * 
         * @param vpnConnectionId
         *        The ID of the AWS Site-to-Site VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnConnectionId(String vpnConnectionId);

        /**
         * <p>
         * The external IP address of the VPN tunnel.
         * </p>
         * 
         * @param vpnTunnelOutsideIpAddress
         *        The external IP address of the VPN tunnel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnTunnelOutsideIpAddress(String vpnTunnelOutsideIpAddress);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String vpnConnectionId;

        private String vpnTunnelOutsideIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpnTunnelCertificateRequest model) {
            super(model);
            vpnConnectionId(model.vpnConnectionId);
            vpnTunnelOutsideIpAddress(model.vpnTunnelOutsideIpAddress);
        }

        public final String getVpnConnectionId() {
            return vpnConnectionId;
        }

        @Override
        public final Builder vpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
            return this;
        }

        public final void setVpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
        }

        public final String getVpnTunnelOutsideIpAddress() {
            return vpnTunnelOutsideIpAddress;
        }

        @Override
        public final Builder vpnTunnelOutsideIpAddress(String vpnTunnelOutsideIpAddress) {
            this.vpnTunnelOutsideIpAddress = vpnTunnelOutsideIpAddress;
            return this;
        }

        public final void setVpnTunnelOutsideIpAddress(String vpnTunnelOutsideIpAddress) {
            this.vpnTunnelOutsideIpAddress = vpnTunnelOutsideIpAddress;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpnTunnelCertificateRequest build() {
            return new ModifyVpnTunnelCertificateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
