/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an EC2 Fleet that was successfully deleted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteFleetSuccessItem implements SdkPojo, Serializable,
        ToCopyableBuilder<DeleteFleetSuccessItem.Builder, DeleteFleetSuccessItem> {
    private static final SdkField<String> CURRENT_FLEET_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CurrentFleetState")
            .getter(getter(DeleteFleetSuccessItem::currentFleetStateAsString))
            .setter(setter(Builder::currentFleetState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentFleetState")
                    .unmarshallLocationName("currentFleetState").build()).build();

    private static final SdkField<String> PREVIOUS_FLEET_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreviousFleetState")
            .getter(getter(DeleteFleetSuccessItem::previousFleetStateAsString))
            .setter(setter(Builder::previousFleetState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousFleetState")
                    .unmarshallLocationName("previousFleetState").build()).build();

    private static final SdkField<String> FLEET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FleetId")
            .getter(getter(DeleteFleetSuccessItem::fleetId))
            .setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId")
                    .unmarshallLocationName("fleetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENT_FLEET_STATE_FIELD,
            PREVIOUS_FLEET_STATE_FIELD, FLEET_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String currentFleetState;

    private final String previousFleetState;

    private final String fleetId;

    private DeleteFleetSuccessItem(BuilderImpl builder) {
        this.currentFleetState = builder.currentFleetState;
        this.previousFleetState = builder.previousFleetState;
        this.fleetId = builder.fleetId;
    }

    /**
     * <p>
     * The current state of the EC2 Fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currentFleetState}
     * will return {@link FleetStateCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #currentFleetStateAsString}.
     * </p>
     * 
     * @return The current state of the EC2 Fleet.
     * @see FleetStateCode
     */
    public FleetStateCode currentFleetState() {
        return FleetStateCode.fromValue(currentFleetState);
    }

    /**
     * <p>
     * The current state of the EC2 Fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currentFleetState}
     * will return {@link FleetStateCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #currentFleetStateAsString}.
     * </p>
     * 
     * @return The current state of the EC2 Fleet.
     * @see FleetStateCode
     */
    public String currentFleetStateAsString() {
        return currentFleetState;
    }

    /**
     * <p>
     * The previous state of the EC2 Fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #previousFleetState} will return {@link FleetStateCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #previousFleetStateAsString}.
     * </p>
     * 
     * @return The previous state of the EC2 Fleet.
     * @see FleetStateCode
     */
    public FleetStateCode previousFleetState() {
        return FleetStateCode.fromValue(previousFleetState);
    }

    /**
     * <p>
     * The previous state of the EC2 Fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #previousFleetState} will return {@link FleetStateCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #previousFleetStateAsString}.
     * </p>
     * 
     * @return The previous state of the EC2 Fleet.
     * @see FleetStateCode
     */
    public String previousFleetStateAsString() {
        return previousFleetState;
    }

    /**
     * <p>
     * The ID of the EC2 Fleet.
     * </p>
     * 
     * @return The ID of the EC2 Fleet.
     */
    public String fleetId() {
        return fleetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(currentFleetStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(previousFleetStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFleetSuccessItem)) {
            return false;
        }
        DeleteFleetSuccessItem other = (DeleteFleetSuccessItem) obj;
        return Objects.equals(currentFleetStateAsString(), other.currentFleetStateAsString())
                && Objects.equals(previousFleetStateAsString(), other.previousFleetStateAsString())
                && Objects.equals(fleetId(), other.fleetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteFleetSuccessItem").add("CurrentFleetState", currentFleetStateAsString())
                .add("PreviousFleetState", previousFleetStateAsString()).add("FleetId", fleetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CurrentFleetState":
            return Optional.ofNullable(clazz.cast(currentFleetStateAsString()));
        case "PreviousFleetState":
            return Optional.ofNullable(clazz.cast(previousFleetStateAsString()));
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteFleetSuccessItem, T> g) {
        return obj -> g.apply((DeleteFleetSuccessItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeleteFleetSuccessItem> {
        /**
         * <p>
         * The current state of the EC2 Fleet.
         * </p>
         * 
         * @param currentFleetState
         *        The current state of the EC2 Fleet.
         * @see FleetStateCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetStateCode
         */
        Builder currentFleetState(String currentFleetState);

        /**
         * <p>
         * The current state of the EC2 Fleet.
         * </p>
         * 
         * @param currentFleetState
         *        The current state of the EC2 Fleet.
         * @see FleetStateCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetStateCode
         */
        Builder currentFleetState(FleetStateCode currentFleetState);

        /**
         * <p>
         * The previous state of the EC2 Fleet.
         * </p>
         * 
         * @param previousFleetState
         *        The previous state of the EC2 Fleet.
         * @see FleetStateCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetStateCode
         */
        Builder previousFleetState(String previousFleetState);

        /**
         * <p>
         * The previous state of the EC2 Fleet.
         * </p>
         * 
         * @param previousFleetState
         *        The previous state of the EC2 Fleet.
         * @see FleetStateCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetStateCode
         */
        Builder previousFleetState(FleetStateCode previousFleetState);

        /**
         * <p>
         * The ID of the EC2 Fleet.
         * </p>
         * 
         * @param fleetId
         *        The ID of the EC2 Fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);
    }

    static final class BuilderImpl implements Builder {
        private String currentFleetState;

        private String previousFleetState;

        private String fleetId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFleetSuccessItem model) {
            currentFleetState(model.currentFleetState);
            previousFleetState(model.previousFleetState);
            fleetId(model.fleetId);
        }

        public final String getCurrentFleetState() {
            return currentFleetState;
        }

        @Override
        public final Builder currentFleetState(String currentFleetState) {
            this.currentFleetState = currentFleetState;
            return this;
        }

        @Override
        public final Builder currentFleetState(FleetStateCode currentFleetState) {
            this.currentFleetState(currentFleetState == null ? null : currentFleetState.toString());
            return this;
        }

        public final void setCurrentFleetState(String currentFleetState) {
            this.currentFleetState = currentFleetState;
        }

        public final String getPreviousFleetState() {
            return previousFleetState;
        }

        @Override
        public final Builder previousFleetState(String previousFleetState) {
            this.previousFleetState = previousFleetState;
            return this;
        }

        @Override
        public final Builder previousFleetState(FleetStateCode previousFleetState) {
            this.previousFleetState(previousFleetState == null ? null : previousFleetState.toString());
            return this;
        }

        public final void setPreviousFleetState(String previousFleetState) {
            this.previousFleetState = previousFleetState;
        }

        public final String getFleetId() {
            return fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public DeleteFleetSuccessItem build() {
            return new DeleteFleetSuccessItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
