/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the optimized EBS performance for supported instance types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EbsOptimizedInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<EbsOptimizedInfo.Builder, EbsOptimizedInfo> {
    private static final SdkField<Integer> BASELINE_BANDWIDTH_IN_MBPS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("BaselineBandwidthInMbps")
            .getter(getter(EbsOptimizedInfo::baselineBandwidthInMbps))
            .setter(setter(Builder::baselineBandwidthInMbps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineBandwidthInMbps")
                    .unmarshallLocationName("baselineBandwidthInMbps").build()).build();

    private static final SdkField<Double> BASELINE_THROUGHPUT_IN_M_BPS_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("BaselineThroughputInMBps")
            .getter(getter(EbsOptimizedInfo::baselineThroughputInMBps))
            .setter(setter(Builder::baselineThroughputInMBps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineThroughputInMBps")
                    .unmarshallLocationName("baselineThroughputInMBps").build()).build();

    private static final SdkField<Integer> BASELINE_IOPS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("BaselineIops")
            .getter(getter(EbsOptimizedInfo::baselineIops))
            .setter(setter(Builder::baselineIops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineIops")
                    .unmarshallLocationName("baselineIops").build()).build();

    private static final SdkField<Integer> MAXIMUM_BANDWIDTH_IN_MBPS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumBandwidthInMbps")
            .getter(getter(EbsOptimizedInfo::maximumBandwidthInMbps))
            .setter(setter(Builder::maximumBandwidthInMbps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumBandwidthInMbps")
                    .unmarshallLocationName("maximumBandwidthInMbps").build()).build();

    private static final SdkField<Double> MAXIMUM_THROUGHPUT_IN_M_BPS_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("MaximumThroughputInMBps")
            .getter(getter(EbsOptimizedInfo::maximumThroughputInMBps))
            .setter(setter(Builder::maximumThroughputInMBps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumThroughputInMBps")
                    .unmarshallLocationName("maximumThroughputInMBps").build()).build();

    private static final SdkField<Integer> MAXIMUM_IOPS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumIops")
            .getter(getter(EbsOptimizedInfo::maximumIops))
            .setter(setter(Builder::maximumIops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumIops")
                    .unmarshallLocationName("maximumIops").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BASELINE_BANDWIDTH_IN_MBPS_FIELD, BASELINE_THROUGHPUT_IN_M_BPS_FIELD, BASELINE_IOPS_FIELD,
            MAXIMUM_BANDWIDTH_IN_MBPS_FIELD, MAXIMUM_THROUGHPUT_IN_M_BPS_FIELD, MAXIMUM_IOPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer baselineBandwidthInMbps;

    private final Double baselineThroughputInMBps;

    private final Integer baselineIops;

    private final Integer maximumBandwidthInMbps;

    private final Double maximumThroughputInMBps;

    private final Integer maximumIops;

    private EbsOptimizedInfo(BuilderImpl builder) {
        this.baselineBandwidthInMbps = builder.baselineBandwidthInMbps;
        this.baselineThroughputInMBps = builder.baselineThroughputInMBps;
        this.baselineIops = builder.baselineIops;
        this.maximumBandwidthInMbps = builder.maximumBandwidthInMbps;
        this.maximumThroughputInMBps = builder.maximumThroughputInMBps;
        this.maximumIops = builder.maximumIops;
    }

    /**
     * <p>
     * The baseline bandwidth performance for an EBS-optimized instance type, in Mbps.
     * </p>
     * 
     * @return The baseline bandwidth performance for an EBS-optimized instance type, in Mbps.
     */
    public Integer baselineBandwidthInMbps() {
        return baselineBandwidthInMbps;
    }

    /**
     * <p>
     * The baseline throughput performance for an EBS-optimized instance type, in MB/s.
     * </p>
     * 
     * @return The baseline throughput performance for an EBS-optimized instance type, in MB/s.
     */
    public Double baselineThroughputInMBps() {
        return baselineThroughputInMBps;
    }

    /**
     * <p>
     * The baseline input/output storage operations per seconds for an EBS-optimized instance type.
     * </p>
     * 
     * @return The baseline input/output storage operations per seconds for an EBS-optimized instance type.
     */
    public Integer baselineIops() {
        return baselineIops;
    }

    /**
     * <p>
     * The maximum bandwidth performance for an EBS-optimized instance type, in Mbps.
     * </p>
     * 
     * @return The maximum bandwidth performance for an EBS-optimized instance type, in Mbps.
     */
    public Integer maximumBandwidthInMbps() {
        return maximumBandwidthInMbps;
    }

    /**
     * <p>
     * The maximum throughput performance for an EBS-optimized instance type, in MB/s.
     * </p>
     * 
     * @return The maximum throughput performance for an EBS-optimized instance type, in MB/s.
     */
    public Double maximumThroughputInMBps() {
        return maximumThroughputInMBps;
    }

    /**
     * <p>
     * The maximum input/output storage operations per second for an EBS-optimized instance type.
     * </p>
     * 
     * @return The maximum input/output storage operations per second for an EBS-optimized instance type.
     */
    public Integer maximumIops() {
        return maximumIops;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(baselineBandwidthInMbps());
        hashCode = 31 * hashCode + Objects.hashCode(baselineThroughputInMBps());
        hashCode = 31 * hashCode + Objects.hashCode(baselineIops());
        hashCode = 31 * hashCode + Objects.hashCode(maximumBandwidthInMbps());
        hashCode = 31 * hashCode + Objects.hashCode(maximumThroughputInMBps());
        hashCode = 31 * hashCode + Objects.hashCode(maximumIops());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsOptimizedInfo)) {
            return false;
        }
        EbsOptimizedInfo other = (EbsOptimizedInfo) obj;
        return Objects.equals(baselineBandwidthInMbps(), other.baselineBandwidthInMbps())
                && Objects.equals(baselineThroughputInMBps(), other.baselineThroughputInMBps())
                && Objects.equals(baselineIops(), other.baselineIops())
                && Objects.equals(maximumBandwidthInMbps(), other.maximumBandwidthInMbps())
                && Objects.equals(maximumThroughputInMBps(), other.maximumThroughputInMBps())
                && Objects.equals(maximumIops(), other.maximumIops());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EbsOptimizedInfo").add("BaselineBandwidthInMbps", baselineBandwidthInMbps())
                .add("BaselineThroughputInMBps", baselineThroughputInMBps()).add("BaselineIops", baselineIops())
                .add("MaximumBandwidthInMbps", maximumBandwidthInMbps())
                .add("MaximumThroughputInMBps", maximumThroughputInMBps()).add("MaximumIops", maximumIops()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaselineBandwidthInMbps":
            return Optional.ofNullable(clazz.cast(baselineBandwidthInMbps()));
        case "BaselineThroughputInMBps":
            return Optional.ofNullable(clazz.cast(baselineThroughputInMBps()));
        case "BaselineIops":
            return Optional.ofNullable(clazz.cast(baselineIops()));
        case "MaximumBandwidthInMbps":
            return Optional.ofNullable(clazz.cast(maximumBandwidthInMbps()));
        case "MaximumThroughputInMBps":
            return Optional.ofNullable(clazz.cast(maximumThroughputInMBps()));
        case "MaximumIops":
            return Optional.ofNullable(clazz.cast(maximumIops()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EbsOptimizedInfo, T> g) {
        return obj -> g.apply((EbsOptimizedInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EbsOptimizedInfo> {
        /**
         * <p>
         * The baseline bandwidth performance for an EBS-optimized instance type, in Mbps.
         * </p>
         * 
         * @param baselineBandwidthInMbps
         *        The baseline bandwidth performance for an EBS-optimized instance type, in Mbps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineBandwidthInMbps(Integer baselineBandwidthInMbps);

        /**
         * <p>
         * The baseline throughput performance for an EBS-optimized instance type, in MB/s.
         * </p>
         * 
         * @param baselineThroughputInMBps
         *        The baseline throughput performance for an EBS-optimized instance type, in MB/s.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineThroughputInMBps(Double baselineThroughputInMBps);

        /**
         * <p>
         * The baseline input/output storage operations per seconds for an EBS-optimized instance type.
         * </p>
         * 
         * @param baselineIops
         *        The baseline input/output storage operations per seconds for an EBS-optimized instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineIops(Integer baselineIops);

        /**
         * <p>
         * The maximum bandwidth performance for an EBS-optimized instance type, in Mbps.
         * </p>
         * 
         * @param maximumBandwidthInMbps
         *        The maximum bandwidth performance for an EBS-optimized instance type, in Mbps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumBandwidthInMbps(Integer maximumBandwidthInMbps);

        /**
         * <p>
         * The maximum throughput performance for an EBS-optimized instance type, in MB/s.
         * </p>
         * 
         * @param maximumThroughputInMBps
         *        The maximum throughput performance for an EBS-optimized instance type, in MB/s.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumThroughputInMBps(Double maximumThroughputInMBps);

        /**
         * <p>
         * The maximum input/output storage operations per second for an EBS-optimized instance type.
         * </p>
         * 
         * @param maximumIops
         *        The maximum input/output storage operations per second for an EBS-optimized instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumIops(Integer maximumIops);
    }

    static final class BuilderImpl implements Builder {
        private Integer baselineBandwidthInMbps;

        private Double baselineThroughputInMBps;

        private Integer baselineIops;

        private Integer maximumBandwidthInMbps;

        private Double maximumThroughputInMBps;

        private Integer maximumIops;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsOptimizedInfo model) {
            baselineBandwidthInMbps(model.baselineBandwidthInMbps);
            baselineThroughputInMBps(model.baselineThroughputInMBps);
            baselineIops(model.baselineIops);
            maximumBandwidthInMbps(model.maximumBandwidthInMbps);
            maximumThroughputInMBps(model.maximumThroughputInMBps);
            maximumIops(model.maximumIops);
        }

        public final Integer getBaselineBandwidthInMbps() {
            return baselineBandwidthInMbps;
        }

        @Override
        public final Builder baselineBandwidthInMbps(Integer baselineBandwidthInMbps) {
            this.baselineBandwidthInMbps = baselineBandwidthInMbps;
            return this;
        }

        public final void setBaselineBandwidthInMbps(Integer baselineBandwidthInMbps) {
            this.baselineBandwidthInMbps = baselineBandwidthInMbps;
        }

        public final Double getBaselineThroughputInMBps() {
            return baselineThroughputInMBps;
        }

        @Override
        public final Builder baselineThroughputInMBps(Double baselineThroughputInMBps) {
            this.baselineThroughputInMBps = baselineThroughputInMBps;
            return this;
        }

        public final void setBaselineThroughputInMBps(Double baselineThroughputInMBps) {
            this.baselineThroughputInMBps = baselineThroughputInMBps;
        }

        public final Integer getBaselineIops() {
            return baselineIops;
        }

        @Override
        public final Builder baselineIops(Integer baselineIops) {
            this.baselineIops = baselineIops;
            return this;
        }

        public final void setBaselineIops(Integer baselineIops) {
            this.baselineIops = baselineIops;
        }

        public final Integer getMaximumBandwidthInMbps() {
            return maximumBandwidthInMbps;
        }

        @Override
        public final Builder maximumBandwidthInMbps(Integer maximumBandwidthInMbps) {
            this.maximumBandwidthInMbps = maximumBandwidthInMbps;
            return this;
        }

        public final void setMaximumBandwidthInMbps(Integer maximumBandwidthInMbps) {
            this.maximumBandwidthInMbps = maximumBandwidthInMbps;
        }

        public final Double getMaximumThroughputInMBps() {
            return maximumThroughputInMBps;
        }

        @Override
        public final Builder maximumThroughputInMBps(Double maximumThroughputInMBps) {
            this.maximumThroughputInMBps = maximumThroughputInMBps;
            return this;
        }

        public final void setMaximumThroughputInMBps(Double maximumThroughputInMBps) {
            this.maximumThroughputInMBps = maximumThroughputInMBps;
        }

        public final Integer getMaximumIops() {
            return maximumIops;
        }

        @Override
        public final Builder maximumIops(Integer maximumIops) {
            this.maximumIops = maximumIops;
            return this;
        }

        public final void setMaximumIops(Integer maximumIops) {
            this.maximumIops = maximumIops;
        }

        @Override
        public EbsOptimizedInfo build() {
            return new EbsOptimizedInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
