/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum PrefixListState {
    CREATE_IN_PROGRESS("create-in-progress"),

    CREATE_COMPLETE("create-complete"),

    CREATE_FAILED("create-failed"),

    MODIFY_IN_PROGRESS("modify-in-progress"),

    MODIFY_COMPLETE("modify-complete"),

    MODIFY_FAILED("modify-failed"),

    RESTORE_IN_PROGRESS("restore-in-progress"),

    RESTORE_COMPLETE("restore-complete"),

    RESTORE_FAILED("restore-failed"),

    DELETE_IN_PROGRESS("delete-in-progress"),

    DELETE_COMPLETE("delete-complete"),

    DELETE_FAILED("delete-failed"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private PrefixListState(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return PrefixListState corresponding to the value
     */
    public static PrefixListState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(PrefixListState.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link PrefixListState}s
     */
    public static Set<PrefixListState> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
