/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorSessionField;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorSessionFieldListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyTrafficMirrorSessionRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyTrafficMirrorSessionRequest> {
    private static final SdkField<String> TRAFFIC_MIRROR_SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficMirrorSessionId").getter(ModifyTrafficMirrorSessionRequest.getter(ModifyTrafficMirrorSessionRequest::trafficMirrorSessionId)).setter(ModifyTrafficMirrorSessionRequest.setter(Builder::trafficMirrorSessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorSessionId").unmarshallLocationName("TrafficMirrorSessionId").build()}).build();
    private static final SdkField<String> TRAFFIC_MIRROR_TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficMirrorTargetId").getter(ModifyTrafficMirrorSessionRequest.getter(ModifyTrafficMirrorSessionRequest::trafficMirrorTargetId)).setter(ModifyTrafficMirrorSessionRequest.setter(Builder::trafficMirrorTargetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorTargetId").unmarshallLocationName("TrafficMirrorTargetId").build()}).build();
    private static final SdkField<String> TRAFFIC_MIRROR_FILTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficMirrorFilterId").getter(ModifyTrafficMirrorSessionRequest.getter(ModifyTrafficMirrorSessionRequest::trafficMirrorFilterId)).setter(ModifyTrafficMirrorSessionRequest.setter(Builder::trafficMirrorFilterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorFilterId").unmarshallLocationName("TrafficMirrorFilterId").build()}).build();
    private static final SdkField<Integer> PACKET_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PacketLength").getter(ModifyTrafficMirrorSessionRequest.getter(ModifyTrafficMirrorSessionRequest::packetLength)).setter(ModifyTrafficMirrorSessionRequest.setter(Builder::packetLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PacketLength").unmarshallLocationName("PacketLength").build()}).build();
    private static final SdkField<Integer> SESSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SessionNumber").getter(ModifyTrafficMirrorSessionRequest.getter(ModifyTrafficMirrorSessionRequest::sessionNumber)).setter(ModifyTrafficMirrorSessionRequest.setter(Builder::sessionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionNumber").unmarshallLocationName("SessionNumber").build()}).build();
    private static final SdkField<Integer> VIRTUAL_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VirtualNetworkId").getter(ModifyTrafficMirrorSessionRequest.getter(ModifyTrafficMirrorSessionRequest::virtualNetworkId)).setter(ModifyTrafficMirrorSessionRequest.setter(Builder::virtualNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualNetworkId").unmarshallLocationName("VirtualNetworkId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ModifyTrafficMirrorSessionRequest.getter(ModifyTrafficMirrorSessionRequest::description)).setter(ModifyTrafficMirrorSessionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<List<String>> REMOVE_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveFields").getter(ModifyTrafficMirrorSessionRequest.getter(ModifyTrafficMirrorSessionRequest::removeFieldsAsStrings)).setter(ModifyTrafficMirrorSessionRequest.setter(Builder::removeFieldsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveField").unmarshallLocationName("RemoveField").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_MIRROR_SESSION_ID_FIELD, TRAFFIC_MIRROR_TARGET_ID_FIELD, TRAFFIC_MIRROR_FILTER_ID_FIELD, PACKET_LENGTH_FIELD, SESSION_NUMBER_FIELD, VIRTUAL_NETWORK_ID_FIELD, DESCRIPTION_FIELD, REMOVE_FIELDS_FIELD));
    private final String trafficMirrorSessionId;
    private final String trafficMirrorTargetId;
    private final String trafficMirrorFilterId;
    private final Integer packetLength;
    private final Integer sessionNumber;
    private final Integer virtualNetworkId;
    private final String description;
    private final List<String> removeFields;

    private ModifyTrafficMirrorSessionRequest(BuilderImpl builder) {
        super(builder);
        this.trafficMirrorSessionId = builder.trafficMirrorSessionId;
        this.trafficMirrorTargetId = builder.trafficMirrorTargetId;
        this.trafficMirrorFilterId = builder.trafficMirrorFilterId;
        this.packetLength = builder.packetLength;
        this.sessionNumber = builder.sessionNumber;
        this.virtualNetworkId = builder.virtualNetworkId;
        this.description = builder.description;
        this.removeFields = builder.removeFields;
    }

    public String trafficMirrorSessionId() {
        return this.trafficMirrorSessionId;
    }

    public String trafficMirrorTargetId() {
        return this.trafficMirrorTargetId;
    }

    public String trafficMirrorFilterId() {
        return this.trafficMirrorFilterId;
    }

    public Integer packetLength() {
        return this.packetLength;
    }

    public Integer sessionNumber() {
        return this.sessionNumber;
    }

    public Integer virtualNetworkId() {
        return this.virtualNetworkId;
    }

    public String description() {
        return this.description;
    }

    public List<TrafficMirrorSessionField> removeFields() {
        return TrafficMirrorSessionFieldListCopier.copyStringToEnum(this.removeFields);
    }

    public boolean hasRemoveFields() {
        return this.removeFields != null && !(this.removeFields instanceof SdkAutoConstructList);
    }

    public List<String> removeFieldsAsStrings() {
        return this.removeFields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficMirrorSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficMirrorTargetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficMirrorFilterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.packetLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveFields() ? this.removeFieldsAsStrings() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyTrafficMirrorSessionRequest)) {
            return false;
        }
        ModifyTrafficMirrorSessionRequest other = (ModifyTrafficMirrorSessionRequest)((Object)obj);
        return Objects.equals(this.trafficMirrorSessionId(), other.trafficMirrorSessionId()) && Objects.equals(this.trafficMirrorTargetId(), other.trafficMirrorTargetId()) && Objects.equals(this.trafficMirrorFilterId(), other.trafficMirrorFilterId()) && Objects.equals(this.packetLength(), other.packetLength()) && Objects.equals(this.sessionNumber(), other.sessionNumber()) && Objects.equals(this.virtualNetworkId(), other.virtualNetworkId()) && Objects.equals(this.description(), other.description()) && this.hasRemoveFields() == other.hasRemoveFields() && Objects.equals(this.removeFieldsAsStrings(), other.removeFieldsAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"ModifyTrafficMirrorSessionRequest").add("TrafficMirrorSessionId", (Object)this.trafficMirrorSessionId()).add("TrafficMirrorTargetId", (Object)this.trafficMirrorTargetId()).add("TrafficMirrorFilterId", (Object)this.trafficMirrorFilterId()).add("PacketLength", (Object)this.packetLength()).add("SessionNumber", (Object)this.sessionNumber()).add("VirtualNetworkId", (Object)this.virtualNetworkId()).add("Description", (Object)this.description()).add("RemoveFields", this.hasRemoveFields() ? this.removeFieldsAsStrings() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrafficMirrorSessionId": {
                return Optional.ofNullable(clazz.cast(this.trafficMirrorSessionId()));
            }
            case "TrafficMirrorTargetId": {
                return Optional.ofNullable(clazz.cast(this.trafficMirrorTargetId()));
            }
            case "TrafficMirrorFilterId": {
                return Optional.ofNullable(clazz.cast(this.trafficMirrorFilterId()));
            }
            case "PacketLength": {
                return Optional.ofNullable(clazz.cast(this.packetLength()));
            }
            case "SessionNumber": {
                return Optional.ofNullable(clazz.cast(this.sessionNumber()));
            }
            case "VirtualNetworkId": {
                return Optional.ofNullable(clazz.cast(this.virtualNetworkId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RemoveFields": {
                return Optional.ofNullable(clazz.cast(this.removeFieldsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyTrafficMirrorSessionRequest, T> g) {
        return obj -> g.apply((ModifyTrafficMirrorSessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String trafficMirrorSessionId;
        private String trafficMirrorTargetId;
        private String trafficMirrorFilterId;
        private Integer packetLength;
        private Integer sessionNumber;
        private Integer virtualNetworkId;
        private String description;
        private List<String> removeFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyTrafficMirrorSessionRequest model) {
            super(model);
            this.trafficMirrorSessionId(model.trafficMirrorSessionId);
            this.trafficMirrorTargetId(model.trafficMirrorTargetId);
            this.trafficMirrorFilterId(model.trafficMirrorFilterId);
            this.packetLength(model.packetLength);
            this.sessionNumber(model.sessionNumber);
            this.virtualNetworkId(model.virtualNetworkId);
            this.description(model.description);
            this.removeFieldsWithStrings(model.removeFields);
        }

        public final String getTrafficMirrorSessionId() {
            return this.trafficMirrorSessionId;
        }

        @Override
        public final Builder trafficMirrorSessionId(String trafficMirrorSessionId) {
            this.trafficMirrorSessionId = trafficMirrorSessionId;
            return this;
        }

        public final void setTrafficMirrorSessionId(String trafficMirrorSessionId) {
            this.trafficMirrorSessionId = trafficMirrorSessionId;
        }

        public final String getTrafficMirrorTargetId() {
            return this.trafficMirrorTargetId;
        }

        @Override
        public final Builder trafficMirrorTargetId(String trafficMirrorTargetId) {
            this.trafficMirrorTargetId = trafficMirrorTargetId;
            return this;
        }

        public final void setTrafficMirrorTargetId(String trafficMirrorTargetId) {
            this.trafficMirrorTargetId = trafficMirrorTargetId;
        }

        public final String getTrafficMirrorFilterId() {
            return this.trafficMirrorFilterId;
        }

        @Override
        public final Builder trafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
            return this;
        }

        public final void setTrafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
        }

        public final Integer getPacketLength() {
            return this.packetLength;
        }

        @Override
        public final Builder packetLength(Integer packetLength) {
            this.packetLength = packetLength;
            return this;
        }

        public final void setPacketLength(Integer packetLength) {
            this.packetLength = packetLength;
        }

        public final Integer getSessionNumber() {
            return this.sessionNumber;
        }

        @Override
        public final Builder sessionNumber(Integer sessionNumber) {
            this.sessionNumber = sessionNumber;
            return this;
        }

        public final void setSessionNumber(Integer sessionNumber) {
            this.sessionNumber = sessionNumber;
        }

        public final Integer getVirtualNetworkId() {
            return this.virtualNetworkId;
        }

        @Override
        public final Builder virtualNetworkId(Integer virtualNetworkId) {
            this.virtualNetworkId = virtualNetworkId;
            return this;
        }

        public final void setVirtualNetworkId(Integer virtualNetworkId) {
            this.virtualNetworkId = virtualNetworkId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getRemoveFields() {
            if (this.removeFields instanceof SdkAutoConstructList) {
                return null;
            }
            return this.removeFields;
        }

        @Override
        public final Builder removeFieldsWithStrings(Collection<String> removeFields) {
            this.removeFields = TrafficMirrorSessionFieldListCopier.copy(removeFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeFieldsWithStrings(String ... removeFields) {
            this.removeFieldsWithStrings(Arrays.asList(removeFields));
            return this;
        }

        @Override
        public final Builder removeFields(Collection<TrafficMirrorSessionField> removeFields) {
            this.removeFields = TrafficMirrorSessionFieldListCopier.copyEnumToString(removeFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeFields(TrafficMirrorSessionField ... removeFields) {
            this.removeFields(Arrays.asList(removeFields));
            return this;
        }

        public final void setRemoveFields(Collection<String> removeFields) {
            this.removeFields = TrafficMirrorSessionFieldListCopier.copy(removeFields);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyTrafficMirrorSessionRequest build() {
            return new ModifyTrafficMirrorSessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyTrafficMirrorSessionRequest> {
        public Builder trafficMirrorSessionId(String var1);

        public Builder trafficMirrorTargetId(String var1);

        public Builder trafficMirrorFilterId(String var1);

        public Builder packetLength(Integer var1);

        public Builder sessionNumber(Integer var1);

        public Builder virtualNetworkId(Integer var1);

        public Builder description(String var1);

        public Builder removeFieldsWithStrings(Collection<String> var1);

        public Builder removeFieldsWithStrings(String ... var1);

        public Builder removeFields(Collection<TrafficMirrorSessionField> var1);

        public Builder removeFields(TrafficMirrorSessionField ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

