/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CreateVpnGateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVpnGatewayResponse extends Ec2Response implements
        ToCopyableBuilder<CreateVpnGatewayResponse.Builder, CreateVpnGatewayResponse> {
    private static final SdkField<VpnGateway> VPN_GATEWAY_FIELD = SdkField
            .<VpnGateway> builder(MarshallingType.SDK_POJO)
            .memberName("VpnGateway")
            .getter(getter(CreateVpnGatewayResponse::vpnGateway))
            .setter(setter(Builder::vpnGateway))
            .constructor(VpnGateway::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnGateway")
                    .unmarshallLocationName("vpnGateway").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPN_GATEWAY_FIELD));

    private final VpnGateway vpnGateway;

    private CreateVpnGatewayResponse(BuilderImpl builder) {
        super(builder);
        this.vpnGateway = builder.vpnGateway;
    }

    /**
     * <p>
     * Information about the virtual private gateway.
     * </p>
     * 
     * @return Information about the virtual private gateway.
     */
    public VpnGateway vpnGateway() {
        return vpnGateway;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpnGateway());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpnGatewayResponse)) {
            return false;
        }
        CreateVpnGatewayResponse other = (CreateVpnGatewayResponse) obj;
        return Objects.equals(vpnGateway(), other.vpnGateway());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateVpnGatewayResponse").add("VpnGateway", vpnGateway()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpnGateway":
            return Optional.ofNullable(clazz.cast(vpnGateway()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVpnGatewayResponse, T> g) {
        return obj -> g.apply((CreateVpnGatewayResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateVpnGatewayResponse> {
        /**
         * <p>
         * Information about the virtual private gateway.
         * </p>
         * 
         * @param vpnGateway
         *        Information about the virtual private gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnGateway(VpnGateway vpnGateway);

        /**
         * <p>
         * Information about the virtual private gateway.
         * </p>
         * This is a convenience that creates an instance of the {@link VpnGateway.Builder} avoiding the need to create
         * one manually via {@link VpnGateway#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpnGateway.Builder#build()} is called immediately and its result
         * is passed to {@link #vpnGateway(VpnGateway)}.
         * 
         * @param vpnGateway
         *        a consumer that will call methods on {@link VpnGateway.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpnGateway(VpnGateway)
         */
        default Builder vpnGateway(Consumer<VpnGateway.Builder> vpnGateway) {
            return vpnGateway(VpnGateway.builder().applyMutation(vpnGateway).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private VpnGateway vpnGateway;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpnGatewayResponse model) {
            super(model);
            vpnGateway(model.vpnGateway);
        }

        public final VpnGateway.Builder getVpnGateway() {
            return vpnGateway != null ? vpnGateway.toBuilder() : null;
        }

        @Override
        public final Builder vpnGateway(VpnGateway vpnGateway) {
            this.vpnGateway = vpnGateway;
            return this;
        }

        public final void setVpnGateway(VpnGateway.BuilderImpl vpnGateway) {
            this.vpnGateway = vpnGateway != null ? vpnGateway.build() : null;
        }

        @Override
        public CreateVpnGatewayResponse build() {
            return new CreateVpnGatewayResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
