/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the credit option for CPU usage of a burstable performance instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceCreditSpecificationRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceCreditSpecificationRequest.Builder, InstanceCreditSpecificationRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(InstanceCreditSpecificationRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("InstanceId").build()).build();

    private static final SdkField<String> CPU_CREDITS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CpuCredits")
            .getter(getter(InstanceCreditSpecificationRequest::cpuCredits))
            .setter(setter(Builder::cpuCredits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CpuCredits")
                    .unmarshallLocationName("CpuCredits").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            CPU_CREDITS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceId;

    private final String cpuCredits;

    private InstanceCreditSpecificationRequest(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.cpuCredits = builder.cpuCredits;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The credit option for CPU usage of the instance. Valid values are <code>standard</code> and
     * <code>unlimited</code>.
     * </p>
     * 
     * @return The credit option for CPU usage of the instance. Valid values are <code>standard</code> and
     *         <code>unlimited</code>.
     */
    public String cpuCredits() {
        return cpuCredits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(cpuCredits());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceCreditSpecificationRequest)) {
            return false;
        }
        InstanceCreditSpecificationRequest other = (InstanceCreditSpecificationRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(cpuCredits(), other.cpuCredits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InstanceCreditSpecificationRequest").add("InstanceId", instanceId())
                .add("CpuCredits", cpuCredits()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "CpuCredits":
            return Optional.ofNullable(clazz.cast(cpuCredits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceCreditSpecificationRequest, T> g) {
        return obj -> g.apply((InstanceCreditSpecificationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceCreditSpecificationRequest> {
        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The credit option for CPU usage of the instance. Valid values are <code>standard</code> and
         * <code>unlimited</code>.
         * </p>
         * 
         * @param cpuCredits
         *        The credit option for CPU usage of the instance. Valid values are <code>standard</code> and
         *        <code>unlimited</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuCredits(String cpuCredits);
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private String cpuCredits;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceCreditSpecificationRequest model) {
            instanceId(model.instanceId);
            cpuCredits(model.cpuCredits);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getCpuCredits() {
            return cpuCredits;
        }

        @Override
        public final Builder cpuCredits(String cpuCredits) {
            this.cpuCredits = cpuCredits;
            return this;
        }

        public final void setCpuCredits(String cpuCredits) {
            this.cpuCredits = cpuCredits;
        }

        @Override
        public InstanceCreditSpecificationRequest build() {
            return new InstanceCreditSpecificationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
