/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The instance details to specify which volumes should be snapshotted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceSpecification.Builder, InstanceSpecification> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(InstanceSpecification::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("InstanceId").build()).build();

    private static final SdkField<Boolean> EXCLUDE_BOOT_VOLUME_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ExcludeBootVolume")
            .getter(getter(InstanceSpecification::excludeBootVolume))
            .setter(setter(Builder::excludeBootVolume))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeBootVolume")
                    .unmarshallLocationName("ExcludeBootVolume").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            EXCLUDE_BOOT_VOLUME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceId;

    private final Boolean excludeBootVolume;

    private InstanceSpecification(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.excludeBootVolume = builder.excludeBootVolume;
    }

    /**
     * <p>
     * The instance to specify which volumes should be snapshotted.
     * </p>
     * 
     * @return The instance to specify which volumes should be snapshotted.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * Excludes the root volume from being snapshotted.
     * </p>
     * 
     * @return Excludes the root volume from being snapshotted.
     */
    public Boolean excludeBootVolume() {
        return excludeBootVolume;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(excludeBootVolume());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceSpecification)) {
            return false;
        }
        InstanceSpecification other = (InstanceSpecification) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(excludeBootVolume(), other.excludeBootVolume());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InstanceSpecification").add("InstanceId", instanceId())
                .add("ExcludeBootVolume", excludeBootVolume()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ExcludeBootVolume":
            return Optional.ofNullable(clazz.cast(excludeBootVolume()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceSpecification, T> g) {
        return obj -> g.apply((InstanceSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceSpecification> {
        /**
         * <p>
         * The instance to specify which volumes should be snapshotted.
         * </p>
         * 
         * @param instanceId
         *        The instance to specify which volumes should be snapshotted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * Excludes the root volume from being snapshotted.
         * </p>
         * 
         * @param excludeBootVolume
         *        Excludes the root volume from being snapshotted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeBootVolume(Boolean excludeBootVolume);
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private Boolean excludeBootVolume;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceSpecification model) {
            instanceId(model.instanceId);
            excludeBootVolume(model.excludeBootVolume);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Boolean getExcludeBootVolume() {
            return excludeBootVolume;
        }

        @Override
        public final Builder excludeBootVolume(Boolean excludeBootVolume) {
            this.excludeBootVolume = excludeBootVolume;
            return this;
        }

        public final void setExcludeBootVolume(Boolean excludeBootVolume) {
            this.excludeBootVolume = excludeBootVolume;
        }

        @Override
        public InstanceSpecification build() {
            return new InstanceSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
