/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a target Capacity Reservation or Capacity Reservation group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityReservationTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<CapacityReservationTarget.Builder, CapacityReservationTarget> {
    private static final SdkField<String> CAPACITY_RESERVATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityReservationId")
            .getter(getter(CapacityReservationTarget::capacityReservationId))
            .setter(setter(Builder::capacityReservationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationId")
                    .unmarshallLocationName("CapacityReservationId").build()).build();

    private static final SdkField<String> CAPACITY_RESERVATION_RESOURCE_GROUP_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityReservationResourceGroupArn")
            .getter(getter(CapacityReservationTarget::capacityReservationResourceGroupArn))
            .setter(setter(Builder::capacityReservationResourceGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CapacityReservationResourceGroupArn")
                    .unmarshallLocationName("CapacityReservationResourceGroupArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_RESERVATION_ID_FIELD,
            CAPACITY_RESERVATION_RESOURCE_GROUP_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String capacityReservationId;

    private final String capacityReservationResourceGroupArn;

    private CapacityReservationTarget(BuilderImpl builder) {
        this.capacityReservationId = builder.capacityReservationId;
        this.capacityReservationResourceGroupArn = builder.capacityReservationResourceGroupArn;
    }

    /**
     * <p>
     * The ID of the Capacity Reservation in which to run the instance.
     * </p>
     * 
     * @return The ID of the Capacity Reservation in which to run the instance.
     */
    public String capacityReservationId() {
        return capacityReservationId;
    }

    /**
     * <p>
     * The ARN of the Capacity Reservation resource group in which to run the instance.
     * </p>
     * 
     * @return The ARN of the Capacity Reservation resource group in which to run the instance.
     */
    public String capacityReservationResourceGroupArn() {
        return capacityReservationResourceGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationResourceGroupArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityReservationTarget)) {
            return false;
        }
        CapacityReservationTarget other = (CapacityReservationTarget) obj;
        return Objects.equals(capacityReservationId(), other.capacityReservationId())
                && Objects.equals(capacityReservationResourceGroupArn(), other.capacityReservationResourceGroupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CapacityReservationTarget").add("CapacityReservationId", capacityReservationId())
                .add("CapacityReservationResourceGroupArn", capacityReservationResourceGroupArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityReservationId":
            return Optional.ofNullable(clazz.cast(capacityReservationId()));
        case "CapacityReservationResourceGroupArn":
            return Optional.ofNullable(clazz.cast(capacityReservationResourceGroupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CapacityReservationTarget, T> g) {
        return obj -> g.apply((CapacityReservationTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityReservationTarget> {
        /**
         * <p>
         * The ID of the Capacity Reservation in which to run the instance.
         * </p>
         * 
         * @param capacityReservationId
         *        The ID of the Capacity Reservation in which to run the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationId(String capacityReservationId);

        /**
         * <p>
         * The ARN of the Capacity Reservation resource group in which to run the instance.
         * </p>
         * 
         * @param capacityReservationResourceGroupArn
         *        The ARN of the Capacity Reservation resource group in which to run the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationResourceGroupArn(String capacityReservationResourceGroupArn);
    }

    static final class BuilderImpl implements Builder {
        private String capacityReservationId;

        private String capacityReservationResourceGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityReservationTarget model) {
            capacityReservationId(model.capacityReservationId);
            capacityReservationResourceGroupArn(model.capacityReservationResourceGroupArn);
        }

        public final String getCapacityReservationId() {
            return capacityReservationId;
        }

        @Override
        public final Builder capacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
            return this;
        }

        public final void setCapacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
        }

        public final String getCapacityReservationResourceGroupArn() {
            return capacityReservationResourceGroupArn;
        }

        @Override
        public final Builder capacityReservationResourceGroupArn(String capacityReservationResourceGroupArn) {
            this.capacityReservationResourceGroupArn = capacityReservationResourceGroupArn;
            return this;
        }

        public final void setCapacityReservationResourceGroupArn(String capacityReservationResourceGroupArn) {
            this.capacityReservationResourceGroupArn = capacityReservationResourceGroupArn;
        }

        @Override
        public CapacityReservationTarget build() {
            return new CapacityReservationTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
