/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a Client VPN endpoint route.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClientVpnRoute implements SdkPojo, Serializable, ToCopyableBuilder<ClientVpnRoute.Builder, ClientVpnRoute> {
    private static final SdkField<String> CLIENT_VPN_ENDPOINT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientVpnEndpointId")
            .getter(getter(ClientVpnRoute::clientVpnEndpointId))
            .setter(setter(Builder::clientVpnEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVpnEndpointId")
                    .unmarshallLocationName("clientVpnEndpointId").build()).build();

    private static final SdkField<String> DESTINATION_CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationCidr")
            .getter(getter(ClientVpnRoute::destinationCidr))
            .setter(setter(Builder::destinationCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidr")
                    .unmarshallLocationName("destinationCidr").build()).build();

    private static final SdkField<String> TARGET_SUBNET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TargetSubnet")
            .getter(getter(ClientVpnRoute::targetSubnet))
            .setter(setter(Builder::targetSubnet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetSubnet")
                    .unmarshallLocationName("targetSubnet").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Type")
            .getter(getter(ClientVpnRoute::type))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type")
                    .unmarshallLocationName("type").build()).build();

    private static final SdkField<String> ORIGIN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Origin")
            .getter(getter(ClientVpnRoute::origin))
            .setter(setter(Builder::origin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origin")
                    .unmarshallLocationName("origin").build()).build();

    private static final SdkField<ClientVpnRouteStatus> STATUS_FIELD = SdkField
            .<ClientVpnRouteStatus> builder(MarshallingType.SDK_POJO)
            .memberName("Status")
            .getter(getter(ClientVpnRoute::status))
            .setter(setter(Builder::status))
            .constructor(ClientVpnRouteStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(ClientVpnRoute::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VPN_ENDPOINT_ID_FIELD,
            DESTINATION_CIDR_FIELD, TARGET_SUBNET_FIELD, TYPE_FIELD, ORIGIN_FIELD, STATUS_FIELD, DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clientVpnEndpointId;

    private final String destinationCidr;

    private final String targetSubnet;

    private final String type;

    private final String origin;

    private final ClientVpnRouteStatus status;

    private final String description;

    private ClientVpnRoute(BuilderImpl builder) {
        this.clientVpnEndpointId = builder.clientVpnEndpointId;
        this.destinationCidr = builder.destinationCidr;
        this.targetSubnet = builder.targetSubnet;
        this.type = builder.type;
        this.origin = builder.origin;
        this.status = builder.status;
        this.description = builder.description;
    }

    /**
     * <p>
     * The ID of the Client VPN endpoint with which the route is associated.
     * </p>
     * 
     * @return The ID of the Client VPN endpoint with which the route is associated.
     */
    public String clientVpnEndpointId() {
        return clientVpnEndpointId;
    }

    /**
     * <p>
     * The IPv4 address range, in CIDR notation, of the route destination.
     * </p>
     * 
     * @return The IPv4 address range, in CIDR notation, of the route destination.
     */
    public String destinationCidr() {
        return destinationCidr;
    }

    /**
     * <p>
     * The ID of the subnet through which traffic is routed.
     * </p>
     * 
     * @return The ID of the subnet through which traffic is routed.
     */
    public String targetSubnet() {
        return targetSubnet;
    }

    /**
     * <p>
     * The route type.
     * </p>
     * 
     * @return The route type.
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * Indicates how the route was associated with the Client VPN endpoint. <code>associate</code> indicates that the
     * route was automatically added when the target network was associated with the Client VPN endpoint.
     * <code>add-route</code> indicates that the route was manually added using the <b>CreateClientVpnRoute</b> action.
     * </p>
     * 
     * @return Indicates how the route was associated with the Client VPN endpoint. <code>associate</code> indicates
     *         that the route was automatically added when the target network was associated with the Client VPN
     *         endpoint. <code>add-route</code> indicates that the route was manually added using the
     *         <b>CreateClientVpnRoute</b> action.
     */
    public String origin() {
        return origin;
    }

    /**
     * <p>
     * The current state of the route.
     * </p>
     * 
     * @return The current state of the route.
     */
    public ClientVpnRouteStatus status() {
        return status;
    }

    /**
     * <p>
     * A brief description of the route.
     * </p>
     * 
     * @return A brief description of the route.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientVpnEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationCidr());
        hashCode = 31 * hashCode + Objects.hashCode(targetSubnet());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(origin());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientVpnRoute)) {
            return false;
        }
        ClientVpnRoute other = (ClientVpnRoute) obj;
        return Objects.equals(clientVpnEndpointId(), other.clientVpnEndpointId())
                && Objects.equals(destinationCidr(), other.destinationCidr())
                && Objects.equals(targetSubnet(), other.targetSubnet()) && Objects.equals(type(), other.type())
                && Objects.equals(origin(), other.origin()) && Objects.equals(status(), other.status())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ClientVpnRoute").add("ClientVpnEndpointId", clientVpnEndpointId())
                .add("DestinationCidr", destinationCidr()).add("TargetSubnet", targetSubnet()).add("Type", type())
                .add("Origin", origin()).add("Status", status()).add("Description", description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientVpnEndpointId":
            return Optional.ofNullable(clazz.cast(clientVpnEndpointId()));
        case "DestinationCidr":
            return Optional.ofNullable(clazz.cast(destinationCidr()));
        case "TargetSubnet":
            return Optional.ofNullable(clazz.cast(targetSubnet()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "Origin":
            return Optional.ofNullable(clazz.cast(origin()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClientVpnRoute, T> g) {
        return obj -> g.apply((ClientVpnRoute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClientVpnRoute> {
        /**
         * <p>
         * The ID of the Client VPN endpoint with which the route is associated.
         * </p>
         * 
         * @param clientVpnEndpointId
         *        The ID of the Client VPN endpoint with which the route is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientVpnEndpointId(String clientVpnEndpointId);

        /**
         * <p>
         * The IPv4 address range, in CIDR notation, of the route destination.
         * </p>
         * 
         * @param destinationCidr
         *        The IPv4 address range, in CIDR notation, of the route destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCidr(String destinationCidr);

        /**
         * <p>
         * The ID of the subnet through which traffic is routed.
         * </p>
         * 
         * @param targetSubnet
         *        The ID of the subnet through which traffic is routed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetSubnet(String targetSubnet);

        /**
         * <p>
         * The route type.
         * </p>
         * 
         * @param type
         *        The route type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * Indicates how the route was associated with the Client VPN endpoint. <code>associate</code> indicates that
         * the route was automatically added when the target network was associated with the Client VPN endpoint.
         * <code>add-route</code> indicates that the route was manually added using the <b>CreateClientVpnRoute</b>
         * action.
         * </p>
         * 
         * @param origin
         *        Indicates how the route was associated with the Client VPN endpoint. <code>associate</code> indicates
         *        that the route was automatically added when the target network was associated with the Client VPN
         *        endpoint. <code>add-route</code> indicates that the route was manually added using the
         *        <b>CreateClientVpnRoute</b> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder origin(String origin);

        /**
         * <p>
         * The current state of the route.
         * </p>
         * 
         * @param status
         *        The current state of the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(ClientVpnRouteStatus status);

        /**
         * <p>
         * The current state of the route.
         * </p>
         * This is a convenience that creates an instance of the {@link ClientVpnRouteStatus.Builder} avoiding the need
         * to create one manually via {@link ClientVpnRouteStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClientVpnRouteStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #status(ClientVpnRouteStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link ClientVpnRouteStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(ClientVpnRouteStatus)
         */
        default Builder status(Consumer<ClientVpnRouteStatus.Builder> status) {
            return status(ClientVpnRouteStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * A brief description of the route.
         * </p>
         * 
         * @param description
         *        A brief description of the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String clientVpnEndpointId;

        private String destinationCidr;

        private String targetSubnet;

        private String type;

        private String origin;

        private ClientVpnRouteStatus status;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientVpnRoute model) {
            clientVpnEndpointId(model.clientVpnEndpointId);
            destinationCidr(model.destinationCidr);
            targetSubnet(model.targetSubnet);
            type(model.type);
            origin(model.origin);
            status(model.status);
            description(model.description);
        }

        public final String getClientVpnEndpointId() {
            return clientVpnEndpointId;
        }

        @Override
        public final Builder clientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
            return this;
        }

        public final void setClientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
        }

        public final String getDestinationCidr() {
            return destinationCidr;
        }

        @Override
        public final Builder destinationCidr(String destinationCidr) {
            this.destinationCidr = destinationCidr;
            return this;
        }

        public final void setDestinationCidr(String destinationCidr) {
            this.destinationCidr = destinationCidr;
        }

        public final String getTargetSubnet() {
            return targetSubnet;
        }

        @Override
        public final Builder targetSubnet(String targetSubnet) {
            this.targetSubnet = targetSubnet;
            return this;
        }

        public final void setTargetSubnet(String targetSubnet) {
            this.targetSubnet = targetSubnet;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getOrigin() {
            return origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        public final ClientVpnRouteStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        @Override
        public final Builder status(ClientVpnRouteStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(ClientVpnRouteStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public ClientVpnRoute build() {
            return new ClientVpnRoute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
