/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CreateNetworkInterfacePermission.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateNetworkInterfacePermissionResponse extends Ec2Response implements
        ToCopyableBuilder<CreateNetworkInterfacePermissionResponse.Builder, CreateNetworkInterfacePermissionResponse> {
    private static final SdkField<NetworkInterfacePermission> INTERFACE_PERMISSION_FIELD = SdkField
            .<NetworkInterfacePermission> builder(MarshallingType.SDK_POJO)
            .memberName("InterfacePermission")
            .getter(getter(CreateNetworkInterfacePermissionResponse::interfacePermission))
            .setter(setter(Builder::interfacePermission))
            .constructor(NetworkInterfacePermission::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterfacePermission")
                    .unmarshallLocationName("interfacePermission").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERFACE_PERMISSION_FIELD));

    private final NetworkInterfacePermission interfacePermission;

    private CreateNetworkInterfacePermissionResponse(BuilderImpl builder) {
        super(builder);
        this.interfacePermission = builder.interfacePermission;
    }

    /**
     * <p>
     * Information about the permission for the network interface.
     * </p>
     * 
     * @return Information about the permission for the network interface.
     */
    public NetworkInterfacePermission interfacePermission() {
        return interfacePermission;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(interfacePermission());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkInterfacePermissionResponse)) {
            return false;
        }
        CreateNetworkInterfacePermissionResponse other = (CreateNetworkInterfacePermissionResponse) obj;
        return Objects.equals(interfacePermission(), other.interfacePermission());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateNetworkInterfacePermissionResponse").add("InterfacePermission", interfacePermission())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InterfacePermission":
            return Optional.ofNullable(clazz.cast(interfacePermission()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNetworkInterfacePermissionResponse, T> g) {
        return obj -> g.apply((CreateNetworkInterfacePermissionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateNetworkInterfacePermissionResponse> {
        /**
         * <p>
         * Information about the permission for the network interface.
         * </p>
         * 
         * @param interfacePermission
         *        Information about the permission for the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interfacePermission(NetworkInterfacePermission interfacePermission);

        /**
         * <p>
         * Information about the permission for the network interface.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkInterfacePermission.Builder} avoiding the
         * need to create one manually via {@link NetworkInterfacePermission#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkInterfacePermission.Builder#build()} is called immediately
         * and its result is passed to {@link #interfacePermission(NetworkInterfacePermission)}.
         * 
         * @param interfacePermission
         *        a consumer that will call methods on {@link NetworkInterfacePermission.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interfacePermission(NetworkInterfacePermission)
         */
        default Builder interfacePermission(Consumer<NetworkInterfacePermission.Builder> interfacePermission) {
            return interfacePermission(NetworkInterfacePermission.builder().applyMutation(interfacePermission).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private NetworkInterfacePermission interfacePermission;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkInterfacePermissionResponse model) {
            super(model);
            interfacePermission(model.interfacePermission);
        }

        public final NetworkInterfacePermission.Builder getInterfacePermission() {
            return interfacePermission != null ? interfacePermission.toBuilder() : null;
        }

        @Override
        public final Builder interfacePermission(NetworkInterfacePermission interfacePermission) {
            this.interfacePermission = interfacePermission;
            return this;
        }

        public final void setInterfacePermission(NetworkInterfacePermission.BuilderImpl interfacePermission) {
            this.interfacePermission = interfacePermission != null ? interfacePermission.build() : null;
        }

        @Override
        public CreateNetworkInterfacePermissionResponse build() {
            return new CreateNetworkInterfacePermissionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
