/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeCustomerGateways.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCustomerGatewaysRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeCustomerGatewaysRequest.Builder, DescribeCustomerGatewaysRequest> {
    private static final SdkField<List<String>> CUSTOMER_GATEWAY_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CustomerGatewayIds")
            .getter(getter(DescribeCustomerGatewaysRequest::customerGatewayIds))
            .setter(setter(Builder::customerGatewayIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerGatewayId")
                    .unmarshallLocationName("CustomerGatewayId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("CustomerGatewayId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("CustomerGatewayId")
                                                    .unmarshallLocationName("CustomerGatewayId").build()).build()).build())
            .build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeCustomerGatewaysRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_GATEWAY_IDS_FIELD,
            FILTERS_FIELD));

    private final List<String> customerGatewayIds;

    private final List<Filter> filters;

    private DescribeCustomerGatewaysRequest(BuilderImpl builder) {
        super(builder);
        this.customerGatewayIds = builder.customerGatewayIds;
        this.filters = builder.filters;
    }

    /**
     * Returns true if the CustomerGatewayIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCustomerGatewayIds() {
        return customerGatewayIds != null && !(customerGatewayIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more customer gateway IDs.
     * </p>
     * <p>
     * Default: Describes all your customer gateways.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCustomerGatewayIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more customer gateway IDs.</p>
     *         <p>
     *         Default: Describes all your customer gateways.
     */
    public List<String> customerGatewayIds() {
        return customerGatewayIds;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>bgp-asn</code> - The customer gateway's Border Gateway Protocol (BGP) Autonomous System Number (ASN).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>customer-gateway-id</code> - The ID of the customer gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip-address</code> - The IP address of the customer gateway's Internet-routable external interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state</code> - The state of the customer gateway (<code>pending</code> | <code>available</code> |
     * <code>deleting</code> | <code>deleted</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>type</code> - The type of customer gateway. Currently, the only supported type is <code>ipsec.1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in
     * the filter name and the tag value as the filter value. For example, to find all resources that have a tag with
     * the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name
     * and <code>TeamA</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned
     * a tag with a specific key, regardless of the tag value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>bgp-asn</code> - The customer gateway's Border Gateway Protocol (BGP) Autonomous System Number
     *         (ASN).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>customer-gateway-id</code> - The ID of the customer gateway.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip-address</code> - The IP address of the customer gateway's Internet-routable external interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state</code> - The state of the customer gateway (<code>pending</code> | <code>available</code> |
     *         <code>deleting</code> | <code>deleted</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>type</code> - The type of customer gateway. Currently, the only supported type is
     *         <code>ipsec.1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag
     *         key in the filter name and the tag value as the filter value. For example, to find all resources that
     *         have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
     *         <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
     *         assigned a tag with a specific key, regardless of the tag value.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomerGatewayIds() ? customerGatewayIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCustomerGatewaysRequest)) {
            return false;
        }
        DescribeCustomerGatewaysRequest other = (DescribeCustomerGatewaysRequest) obj;
        return hasCustomerGatewayIds() == other.hasCustomerGatewayIds()
                && Objects.equals(customerGatewayIds(), other.customerGatewayIds()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeCustomerGatewaysRequest")
                .add("CustomerGatewayIds", hasCustomerGatewayIds() ? customerGatewayIds() : null)
                .add("Filters", hasFilters() ? filters() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomerGatewayIds":
            return Optional.ofNullable(clazz.cast(customerGatewayIds()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCustomerGatewaysRequest, T> g) {
        return obj -> g.apply((DescribeCustomerGatewaysRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCustomerGatewaysRequest> {
        /**
         * <p>
         * One or more customer gateway IDs.
         * </p>
         * <p>
         * Default: Describes all your customer gateways.
         * </p>
         * 
         * @param customerGatewayIds
         *        One or more customer gateway IDs.</p>
         *        <p>
         *        Default: Describes all your customer gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerGatewayIds(Collection<String> customerGatewayIds);

        /**
         * <p>
         * One or more customer gateway IDs.
         * </p>
         * <p>
         * Default: Describes all your customer gateways.
         * </p>
         * 
         * @param customerGatewayIds
         *        One or more customer gateway IDs.</p>
         *        <p>
         *        Default: Describes all your customer gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerGatewayIds(String... customerGatewayIds);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>bgp-asn</code> - The customer gateway's Border Gateway Protocol (BGP) Autonomous System Number (ASN).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>customer-gateway-id</code> - The ID of the customer gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-address</code> - The IP address of the customer gateway's Internet-routable external interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the customer gateway (<code>pending</code> | <code>available</code> |
         * <code>deleting</code> | <code>deleted</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>type</code> - The type of customer gateway. Currently, the only supported type is <code>ipsec.1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>bgp-asn</code> - The customer gateway's Border Gateway Protocol (BGP) Autonomous System Number
         *        (ASN).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>customer-gateway-id</code> - The ID of the customer gateway.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-address</code> - The IP address of the customer gateway's Internet-routable external
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the customer gateway (<code>pending</code> | <code>available</code>
         *        | <code>deleting</code> | <code>deleted</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>type</code> - The type of customer gateway. Currently, the only supported type is
         *        <code>ipsec.1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>bgp-asn</code> - The customer gateway's Border Gateway Protocol (BGP) Autonomous System Number (ASN).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>customer-gateway-id</code> - The ID of the customer gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-address</code> - The IP address of the customer gateway's Internet-routable external interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the customer gateway (<code>pending</code> | <code>available</code> |
         * <code>deleting</code> | <code>deleted</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>type</code> - The type of customer gateway. Currently, the only supported type is <code>ipsec.1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>bgp-asn</code> - The customer gateway's Border Gateway Protocol (BGP) Autonomous System Number
         *        (ASN).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>customer-gateway-id</code> - The ID of the customer gateway.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-address</code> - The IP address of the customer gateway's Internet-routable external
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the customer gateway (<code>pending</code> | <code>available</code>
         *        | <code>deleting</code> | <code>deleted</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>type</code> - The type of customer gateway. Currently, the only supported type is
         *        <code>ipsec.1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>bgp-asn</code> - The customer gateway's Border Gateway Protocol (BGP) Autonomous System Number (ASN).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>customer-gateway-id</code> - The ID of the customer gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-address</code> - The IP address of the customer gateway's Internet-routable external interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the customer gateway (<code>pending</code> | <code>available</code> |
         * <code>deleting</code> | <code>deleted</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>type</code> - The type of customer gateway. Currently, the only supported type is <code>ipsec.1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> customerGatewayIds = DefaultSdkAutoConstructList.getInstance();

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCustomerGatewaysRequest model) {
            super(model);
            customerGatewayIds(model.customerGatewayIds);
            filters(model.filters);
        }

        public final Collection<String> getCustomerGatewayIds() {
            if (customerGatewayIds instanceof SdkAutoConstructList) {
                return null;
            }
            return customerGatewayIds;
        }

        @Override
        public final Builder customerGatewayIds(Collection<String> customerGatewayIds) {
            this.customerGatewayIds = CustomerGatewayIdStringListCopier.copy(customerGatewayIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerGatewayIds(String... customerGatewayIds) {
            customerGatewayIds(Arrays.asList(customerGatewayIds));
            return this;
        }

        public final void setCustomerGatewayIds(Collection<String> customerGatewayIds) {
            this.customerGatewayIds = CustomerGatewayIdStringListCopier.copy(customerGatewayIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            if (filters instanceof SdkAutoConstructList) {
                return null;
            }
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeCustomerGatewaysRequest build() {
            return new DescribeCustomerGatewaysRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
