/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeCustomerGateways.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCustomerGatewaysResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeCustomerGatewaysResponse.Builder, DescribeCustomerGatewaysResponse> {
    private static final SdkField<List<CustomerGateway>> CUSTOMER_GATEWAYS_FIELD = SdkField
            .<List<CustomerGateway>> builder(MarshallingType.LIST)
            .memberName("CustomerGateways")
            .getter(getter(DescribeCustomerGatewaysResponse::customerGateways))
            .setter(setter(Builder::customerGateways))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerGatewaySet")
                    .unmarshallLocationName("customerGatewaySet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<CustomerGateway> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomerGateway::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_GATEWAYS_FIELD));

    private final List<CustomerGateway> customerGateways;

    private DescribeCustomerGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.customerGateways = builder.customerGateways;
    }

    /**
     * Returns true if the CustomerGateways property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCustomerGateways() {
        return customerGateways != null && !(customerGateways instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about one or more customer gateways.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCustomerGateways()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about one or more customer gateways.
     */
    public List<CustomerGateway> customerGateways() {
        return customerGateways;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomerGateways() ? customerGateways() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCustomerGatewaysResponse)) {
            return false;
        }
        DescribeCustomerGatewaysResponse other = (DescribeCustomerGatewaysResponse) obj;
        return hasCustomerGateways() == other.hasCustomerGateways()
                && Objects.equals(customerGateways(), other.customerGateways());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeCustomerGatewaysResponse")
                .add("CustomerGateways", hasCustomerGateways() ? customerGateways() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomerGateways":
            return Optional.ofNullable(clazz.cast(customerGateways()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCustomerGatewaysResponse, T> g) {
        return obj -> g.apply((DescribeCustomerGatewaysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCustomerGatewaysResponse> {
        /**
         * <p>
         * Information about one or more customer gateways.
         * </p>
         * 
         * @param customerGateways
         *        Information about one or more customer gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerGateways(Collection<CustomerGateway> customerGateways);

        /**
         * <p>
         * Information about one or more customer gateways.
         * </p>
         * 
         * @param customerGateways
         *        Information about one or more customer gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerGateways(CustomerGateway... customerGateways);

        /**
         * <p>
         * Information about one or more customer gateways.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CustomerGateway>.Builder} avoiding the need
         * to create one manually via {@link List<CustomerGateway>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CustomerGateway>.Builder#build()} is called immediately and
         * its result is passed to {@link #customerGateways(List<CustomerGateway>)}.
         * 
         * @param customerGateways
         *        a consumer that will call methods on {@link List<CustomerGateway>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerGateways(List<CustomerGateway>)
         */
        Builder customerGateways(Consumer<CustomerGateway.Builder>... customerGateways);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<CustomerGateway> customerGateways = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCustomerGatewaysResponse model) {
            super(model);
            customerGateways(model.customerGateways);
        }

        public final Collection<CustomerGateway.Builder> getCustomerGateways() {
            if (customerGateways instanceof SdkAutoConstructList) {
                return null;
            }
            return customerGateways != null ? customerGateways.stream().map(CustomerGateway::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder customerGateways(Collection<CustomerGateway> customerGateways) {
            this.customerGateways = CustomerGatewayListCopier.copy(customerGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerGateways(CustomerGateway... customerGateways) {
            customerGateways(Arrays.asList(customerGateways));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerGateways(Consumer<CustomerGateway.Builder>... customerGateways) {
            customerGateways(Stream.of(customerGateways).map(c -> CustomerGateway.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCustomerGateways(Collection<CustomerGateway.BuilderImpl> customerGateways) {
            this.customerGateways = CustomerGatewayListCopier.copyFromBuilder(customerGateways);
        }

        @Override
        public DescribeCustomerGatewaysResponse build() {
            return new DescribeCustomerGatewaysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
