/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeImageAttribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeImageAttributeRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeImageAttributeRequest.Builder, DescribeImageAttributeRequest> {
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Attribute")
            .getter(getter(DescribeImageAttributeRequest::attributeAsString))
            .setter(setter(Builder::attribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute")
                    .unmarshallLocationName("Attribute").build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImageId")
            .getter(getter(DescribeImageAttributeRequest::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId")
                    .unmarshallLocationName("ImageId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD,
            IMAGE_ID_FIELD));

    private final String attribute;

    private final String imageId;

    private DescribeImageAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.attribute = builder.attribute;
        this.imageId = builder.imageId;
    }

    /**
     * <p>
     * The AMI attribute.
     * </p>
     * <p>
     * <b>Note</b>: Depending on your account privileges, the <code>blockDeviceMapping</code> attribute may return a
     * <code>Client.AuthFailure</code> error. If this happens, use <a>DescribeImages</a> to get information about the
     * block device mapping for the AMI.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link ImageAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #attributeAsString}.
     * </p>
     * 
     * @return The AMI attribute.</p>
     *         <p>
     *         <b>Note</b>: Depending on your account privileges, the <code>blockDeviceMapping</code> attribute may
     *         return a <code>Client.AuthFailure</code> error. If this happens, use <a>DescribeImages</a> to get
     *         information about the block device mapping for the AMI.
     * @see ImageAttributeName
     */
    public ImageAttributeName attribute() {
        return ImageAttributeName.fromValue(attribute);
    }

    /**
     * <p>
     * The AMI attribute.
     * </p>
     * <p>
     * <b>Note</b>: Depending on your account privileges, the <code>blockDeviceMapping</code> attribute may return a
     * <code>Client.AuthFailure</code> error. If this happens, use <a>DescribeImages</a> to get information about the
     * block device mapping for the AMI.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link ImageAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #attributeAsString}.
     * </p>
     * 
     * @return The AMI attribute.</p>
     *         <p>
     *         <b>Note</b>: Depending on your account privileges, the <code>blockDeviceMapping</code> attribute may
     *         return a <code>Client.AuthFailure</code> error. If this happens, use <a>DescribeImages</a> to get
     *         information about the block device mapping for the AMI.
     * @see ImageAttributeName
     */
    public String attributeAsString() {
        return attribute;
    }

    /**
     * <p>
     * The ID of the AMI.
     * </p>
     * 
     * @return The ID of the AMI.
     */
    public String imageId() {
        return imageId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageAttributeRequest)) {
            return false;
        }
        DescribeImageAttributeRequest other = (DescribeImageAttributeRequest) obj;
        return Objects.equals(attributeAsString(), other.attributeAsString()) && Objects.equals(imageId(), other.imageId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeImageAttributeRequest").add("Attribute", attributeAsString()).add("ImageId", imageId())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attribute":
            return Optional.ofNullable(clazz.cast(attributeAsString()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImageAttributeRequest, T> g) {
        return obj -> g.apply((DescribeImageAttributeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeImageAttributeRequest> {
        /**
         * <p>
         * The AMI attribute.
         * </p>
         * <p>
         * <b>Note</b>: Depending on your account privileges, the <code>blockDeviceMapping</code> attribute may return a
         * <code>Client.AuthFailure</code> error. If this happens, use <a>DescribeImages</a> to get information about
         * the block device mapping for the AMI.
         * </p>
         * 
         * @param attribute
         *        The AMI attribute.</p>
         *        <p>
         *        <b>Note</b>: Depending on your account privileges, the <code>blockDeviceMapping</code> attribute may
         *        return a <code>Client.AuthFailure</code> error. If this happens, use <a>DescribeImages</a> to get
         *        information about the block device mapping for the AMI.
         * @see ImageAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageAttributeName
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The AMI attribute.
         * </p>
         * <p>
         * <b>Note</b>: Depending on your account privileges, the <code>blockDeviceMapping</code> attribute may return a
         * <code>Client.AuthFailure</code> error. If this happens, use <a>DescribeImages</a> to get information about
         * the block device mapping for the AMI.
         * </p>
         * 
         * @param attribute
         *        The AMI attribute.</p>
         *        <p>
         *        <b>Note</b>: Depending on your account privileges, the <code>blockDeviceMapping</code> attribute may
         *        return a <code>Client.AuthFailure</code> error. If this happens, use <a>DescribeImages</a> to get
         *        information about the block device mapping for the AMI.
         * @see ImageAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageAttributeName
         */
        Builder attribute(ImageAttributeName attribute);

        /**
         * <p>
         * The ID of the AMI.
         * </p>
         * 
         * @param imageId
         *        The ID of the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String attribute;

        private String imageId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageAttributeRequest model) {
            super(model);
            attribute(model.attribute);
            imageId(model.imageId);
        }

        public final String getAttribute() {
            return attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(ImageAttributeName attribute) {
            this.attribute(attribute == null ? null : attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeImageAttributeRequest build() {
            return new DescribeImageAttributeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
