/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetGroupsForCapacityReservationResponse extends Ec2Response implements
        ToCopyableBuilder<GetGroupsForCapacityReservationResponse.Builder, GetGroupsForCapacityReservationResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(GetGroupsForCapacityReservationResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final SdkField<List<CapacityReservationGroup>> CAPACITY_RESERVATION_GROUPS_FIELD = SdkField
            .<List<CapacityReservationGroup>> builder(MarshallingType.LIST)
            .memberName("CapacityReservationGroups")
            .getter(getter(GetGroupsForCapacityReservationResponse::capacityReservationGroups))
            .setter(setter(Builder::capacityReservationGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationGroupSet")
                    .unmarshallLocationName("capacityReservationGroupSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<CapacityReservationGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(CapacityReservationGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            CAPACITY_RESERVATION_GROUPS_FIELD));

    private final String nextToken;

    private final List<CapacityReservationGroup> capacityReservationGroups;

    private GetGroupsForCapacityReservationResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.capacityReservationGroups = builder.capacityReservationGroups;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the CapacityReservationGroups property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCapacityReservationGroups() {
        return capacityReservationGroups != null && !(capacityReservationGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the resource groups to which the Capacity Reservation has been added.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCapacityReservationGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the resource groups to which the Capacity Reservation has been added.
     */
    public List<CapacityReservationGroup> capacityReservationGroups() {
        return capacityReservationGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasCapacityReservationGroups() ? capacityReservationGroups() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGroupsForCapacityReservationResponse)) {
            return false;
        }
        GetGroupsForCapacityReservationResponse other = (GetGroupsForCapacityReservationResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasCapacityReservationGroups() == other.hasCapacityReservationGroups()
                && Objects.equals(capacityReservationGroups(), other.capacityReservationGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetGroupsForCapacityReservationResponse").add("NextToken", nextToken())
                .add("CapacityReservationGroups", hasCapacityReservationGroups() ? capacityReservationGroups() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "CapacityReservationGroups":
            return Optional.ofNullable(clazz.cast(capacityReservationGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetGroupsForCapacityReservationResponse, T> g) {
        return obj -> g.apply((GetGroupsForCapacityReservationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetGroupsForCapacityReservationResponse> {
        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Information about the resource groups to which the Capacity Reservation has been added.
         * </p>
         * 
         * @param capacityReservationGroups
         *        Information about the resource groups to which the Capacity Reservation has been added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationGroups(Collection<CapacityReservationGroup> capacityReservationGroups);

        /**
         * <p>
         * Information about the resource groups to which the Capacity Reservation has been added.
         * </p>
         * 
         * @param capacityReservationGroups
         *        Information about the resource groups to which the Capacity Reservation has been added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationGroups(CapacityReservationGroup... capacityReservationGroups);

        /**
         * <p>
         * Information about the resource groups to which the Capacity Reservation has been added.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CapacityReservationGroup>.Builder} avoiding
         * the need to create one manually via {@link List<CapacityReservationGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CapacityReservationGroup>.Builder#build()} is called
         * immediately and its result is passed to {@link #capacityReservationGroups(List<CapacityReservationGroup>)}.
         * 
         * @param capacityReservationGroups
         *        a consumer that will call methods on {@link List<CapacityReservationGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityReservationGroups(List<CapacityReservationGroup>)
         */
        Builder capacityReservationGroups(Consumer<CapacityReservationGroup.Builder>... capacityReservationGroups);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<CapacityReservationGroup> capacityReservationGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetGroupsForCapacityReservationResponse model) {
            super(model);
            nextToken(model.nextToken);
            capacityReservationGroups(model.capacityReservationGroups);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<CapacityReservationGroup.Builder> getCapacityReservationGroups() {
            if (capacityReservationGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return capacityReservationGroups != null ? capacityReservationGroups.stream()
                    .map(CapacityReservationGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder capacityReservationGroups(Collection<CapacityReservationGroup> capacityReservationGroups) {
            this.capacityReservationGroups = CapacityReservationGroupSetCopier.copy(capacityReservationGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityReservationGroups(CapacityReservationGroup... capacityReservationGroups) {
            capacityReservationGroups(Arrays.asList(capacityReservationGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityReservationGroups(Consumer<CapacityReservationGroup.Builder>... capacityReservationGroups) {
            capacityReservationGroups(Stream.of(capacityReservationGroups)
                    .map(c -> CapacityReservationGroup.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCapacityReservationGroups(Collection<CapacityReservationGroup.BuilderImpl> capacityReservationGroups) {
            this.capacityReservationGroups = CapacityReservationGroupSetCopier.copyFromBuilder(capacityReservationGroups);
        }

        @Override
        public GetGroupsForCapacityReservationResponse build() {
            return new GetGroupsForCapacityReservationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
