/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyManagedPrefixListRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyManagedPrefixListRequest.Builder, ModifyManagedPrefixListRequest> {
    private static final SdkField<String> PREFIX_LIST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrefixListId")
            .getter(getter(ModifyManagedPrefixListRequest::prefixListId))
            .setter(setter(Builder::prefixListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListId")
                    .unmarshallLocationName("PrefixListId").build()).build();

    private static final SdkField<Long> CURRENT_VERSION_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("CurrentVersion")
            .getter(getter(ModifyManagedPrefixListRequest::currentVersion))
            .setter(setter(Builder::currentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentVersion")
                    .unmarshallLocationName("CurrentVersion").build()).build();

    private static final SdkField<String> PREFIX_LIST_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrefixListName")
            .getter(getter(ModifyManagedPrefixListRequest::prefixListName))
            .setter(setter(Builder::prefixListName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListName")
                    .unmarshallLocationName("PrefixListName").build()).build();

    private static final SdkField<List<AddPrefixListEntry>> ADD_ENTRIES_FIELD = SdkField
            .<List<AddPrefixListEntry>> builder(MarshallingType.LIST)
            .memberName("AddEntries")
            .getter(getter(ModifyManagedPrefixListRequest::addEntries))
            .setter(setter(Builder::addEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddEntry")
                    .unmarshallLocationName("AddEntry").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AddPrefixListEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(AddPrefixListEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<List<RemovePrefixListEntry>> REMOVE_ENTRIES_FIELD = SdkField
            .<List<RemovePrefixListEntry>> builder(MarshallingType.LIST)
            .memberName("RemoveEntries")
            .getter(getter(ModifyManagedPrefixListRequest::removeEntries))
            .setter(setter(Builder::removeEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveEntry")
                    .unmarshallLocationName("RemoveEntry").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RemovePrefixListEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(RemovePrefixListEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFIX_LIST_ID_FIELD,
            CURRENT_VERSION_FIELD, PREFIX_LIST_NAME_FIELD, ADD_ENTRIES_FIELD, REMOVE_ENTRIES_FIELD));

    private final String prefixListId;

    private final Long currentVersion;

    private final String prefixListName;

    private final List<AddPrefixListEntry> addEntries;

    private final List<RemovePrefixListEntry> removeEntries;

    private ModifyManagedPrefixListRequest(BuilderImpl builder) {
        super(builder);
        this.prefixListId = builder.prefixListId;
        this.currentVersion = builder.currentVersion;
        this.prefixListName = builder.prefixListName;
        this.addEntries = builder.addEntries;
        this.removeEntries = builder.removeEntries;
    }

    /**
     * <p>
     * The ID of the prefix list.
     * </p>
     * 
     * @return The ID of the prefix list.
     */
    public String prefixListId() {
        return prefixListId;
    }

    /**
     * <p>
     * The current version of the prefix list.
     * </p>
     * 
     * @return The current version of the prefix list.
     */
    public Long currentVersion() {
        return currentVersion;
    }

    /**
     * <p>
     * A name for the prefix list.
     * </p>
     * 
     * @return A name for the prefix list.
     */
    public String prefixListName() {
        return prefixListName;
    }

    /**
     * Returns true if the AddEntries property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAddEntries() {
        return addEntries != null && !(addEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more entries to add to the prefix list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAddEntries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more entries to add to the prefix list.
     */
    public List<AddPrefixListEntry> addEntries() {
        return addEntries;
    }

    /**
     * Returns true if the RemoveEntries property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRemoveEntries() {
        return removeEntries != null && !(removeEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more entries to remove from the prefix list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRemoveEntries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more entries to remove from the prefix list.
     */
    public List<RemovePrefixListEntry> removeEntries() {
        return removeEntries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(prefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(prefixListName());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddEntries() ? addEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveEntries() ? removeEntries() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyManagedPrefixListRequest)) {
            return false;
        }
        ModifyManagedPrefixListRequest other = (ModifyManagedPrefixListRequest) obj;
        return Objects.equals(prefixListId(), other.prefixListId()) && Objects.equals(currentVersion(), other.currentVersion())
                && Objects.equals(prefixListName(), other.prefixListName()) && hasAddEntries() == other.hasAddEntries()
                && Objects.equals(addEntries(), other.addEntries()) && hasRemoveEntries() == other.hasRemoveEntries()
                && Objects.equals(removeEntries(), other.removeEntries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyManagedPrefixListRequest").add("PrefixListId", prefixListId())
                .add("CurrentVersion", currentVersion()).add("PrefixListName", prefixListName())
                .add("AddEntries", hasAddEntries() ? addEntries() : null)
                .add("RemoveEntries", hasRemoveEntries() ? removeEntries() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrefixListId":
            return Optional.ofNullable(clazz.cast(prefixListId()));
        case "CurrentVersion":
            return Optional.ofNullable(clazz.cast(currentVersion()));
        case "PrefixListName":
            return Optional.ofNullable(clazz.cast(prefixListName()));
        case "AddEntries":
            return Optional.ofNullable(clazz.cast(addEntries()));
        case "RemoveEntries":
            return Optional.ofNullable(clazz.cast(removeEntries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyManagedPrefixListRequest, T> g) {
        return obj -> g.apply((ModifyManagedPrefixListRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyManagedPrefixListRequest> {
        /**
         * <p>
         * The ID of the prefix list.
         * </p>
         * 
         * @param prefixListId
         *        The ID of the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListId(String prefixListId);

        /**
         * <p>
         * The current version of the prefix list.
         * </p>
         * 
         * @param currentVersion
         *        The current version of the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentVersion(Long currentVersion);

        /**
         * <p>
         * A name for the prefix list.
         * </p>
         * 
         * @param prefixListName
         *        A name for the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListName(String prefixListName);

        /**
         * <p>
         * One or more entries to add to the prefix list.
         * </p>
         * 
         * @param addEntries
         *        One or more entries to add to the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addEntries(Collection<AddPrefixListEntry> addEntries);

        /**
         * <p>
         * One or more entries to add to the prefix list.
         * </p>
         * 
         * @param addEntries
         *        One or more entries to add to the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addEntries(AddPrefixListEntry... addEntries);

        /**
         * <p>
         * One or more entries to add to the prefix list.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AddPrefixListEntry>.Builder} avoiding the
         * need to create one manually via {@link List<AddPrefixListEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AddPrefixListEntry>.Builder#build()} is called immediately
         * and its result is passed to {@link #addEntries(List<AddPrefixListEntry>)}.
         * 
         * @param addEntries
         *        a consumer that will call methods on {@link List<AddPrefixListEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addEntries(List<AddPrefixListEntry>)
         */
        Builder addEntries(Consumer<AddPrefixListEntry.Builder>... addEntries);

        /**
         * <p>
         * One or more entries to remove from the prefix list.
         * </p>
         * 
         * @param removeEntries
         *        One or more entries to remove from the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeEntries(Collection<RemovePrefixListEntry> removeEntries);

        /**
         * <p>
         * One or more entries to remove from the prefix list.
         * </p>
         * 
         * @param removeEntries
         *        One or more entries to remove from the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeEntries(RemovePrefixListEntry... removeEntries);

        /**
         * <p>
         * One or more entries to remove from the prefix list.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RemovePrefixListEntry>.Builder} avoiding
         * the need to create one manually via {@link List<RemovePrefixListEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RemovePrefixListEntry>.Builder#build()} is called
         * immediately and its result is passed to {@link #removeEntries(List<RemovePrefixListEntry>)}.
         * 
         * @param removeEntries
         *        a consumer that will call methods on {@link List<RemovePrefixListEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #removeEntries(List<RemovePrefixListEntry>)
         */
        Builder removeEntries(Consumer<RemovePrefixListEntry.Builder>... removeEntries);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String prefixListId;

        private Long currentVersion;

        private String prefixListName;

        private List<AddPrefixListEntry> addEntries = DefaultSdkAutoConstructList.getInstance();

        private List<RemovePrefixListEntry> removeEntries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyManagedPrefixListRequest model) {
            super(model);
            prefixListId(model.prefixListId);
            currentVersion(model.currentVersion);
            prefixListName(model.prefixListName);
            addEntries(model.addEntries);
            removeEntries(model.removeEntries);
        }

        public final String getPrefixListId() {
            return prefixListId;
        }

        @Override
        public final Builder prefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public final void setPrefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
        }

        public final Long getCurrentVersion() {
            return currentVersion;
        }

        @Override
        public final Builder currentVersion(Long currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final void setCurrentVersion(Long currentVersion) {
            this.currentVersion = currentVersion;
        }

        public final String getPrefixListName() {
            return prefixListName;
        }

        @Override
        public final Builder prefixListName(String prefixListName) {
            this.prefixListName = prefixListName;
            return this;
        }

        public final void setPrefixListName(String prefixListName) {
            this.prefixListName = prefixListName;
        }

        public final Collection<AddPrefixListEntry.Builder> getAddEntries() {
            if (addEntries instanceof SdkAutoConstructList) {
                return null;
            }
            return addEntries != null ? addEntries.stream().map(AddPrefixListEntry::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder addEntries(Collection<AddPrefixListEntry> addEntries) {
            this.addEntries = AddPrefixListEntriesCopier.copy(addEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addEntries(AddPrefixListEntry... addEntries) {
            addEntries(Arrays.asList(addEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addEntries(Consumer<AddPrefixListEntry.Builder>... addEntries) {
            addEntries(Stream.of(addEntries).map(c -> AddPrefixListEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAddEntries(Collection<AddPrefixListEntry.BuilderImpl> addEntries) {
            this.addEntries = AddPrefixListEntriesCopier.copyFromBuilder(addEntries);
        }

        public final Collection<RemovePrefixListEntry.Builder> getRemoveEntries() {
            if (removeEntries instanceof SdkAutoConstructList) {
                return null;
            }
            return removeEntries != null ? removeEntries.stream().map(RemovePrefixListEntry::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder removeEntries(Collection<RemovePrefixListEntry> removeEntries) {
            this.removeEntries = RemovePrefixListEntriesCopier.copy(removeEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeEntries(RemovePrefixListEntry... removeEntries) {
            removeEntries(Arrays.asList(removeEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeEntries(Consumer<RemovePrefixListEntry.Builder>... removeEntries) {
            removeEntries(Stream.of(removeEntries).map(c -> RemovePrefixListEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRemoveEntries(Collection<RemovePrefixListEntry.BuilderImpl> removeEntries) {
            this.removeEntries = RemovePrefixListEntriesCopier.copyFromBuilder(removeEntries);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyManagedPrefixListRequest build() {
            return new ModifyManagedPrefixListRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
