/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The information for a launch template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResponseLaunchTemplateData implements SdkPojo, Serializable,
        ToCopyableBuilder<ResponseLaunchTemplateData.Builder, ResponseLaunchTemplateData> {
    private static final SdkField<String> KERNEL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KernelId")
            .getter(getter(ResponseLaunchTemplateData::kernelId))
            .setter(setter(Builder::kernelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelId")
                    .unmarshallLocationName("kernelId").build()).build();

    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EbsOptimized")
            .getter(getter(ResponseLaunchTemplateData::ebsOptimized))
            .setter(setter(Builder::ebsOptimized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized")
                    .unmarshallLocationName("ebsOptimized").build()).build();

    private static final SdkField<LaunchTemplateIamInstanceProfileSpecification> IAM_INSTANCE_PROFILE_FIELD = SdkField
            .<LaunchTemplateIamInstanceProfileSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("IamInstanceProfile")
            .getter(getter(ResponseLaunchTemplateData::iamInstanceProfile))
            .setter(setter(Builder::iamInstanceProfile))
            .constructor(LaunchTemplateIamInstanceProfileSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfile")
                    .unmarshallLocationName("iamInstanceProfile").build()).build();

    private static final SdkField<List<LaunchTemplateBlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField
            .<List<LaunchTemplateBlockDeviceMapping>> builder(MarshallingType.LIST)
            .memberName("BlockDeviceMappings")
            .getter(getter(ResponseLaunchTemplateData::blockDeviceMappings))
            .setter(setter(Builder::blockDeviceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMappingSet")
                    .unmarshallLocationName("blockDeviceMappingSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<LaunchTemplateBlockDeviceMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchTemplateBlockDeviceMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<LaunchTemplateInstanceNetworkInterfaceSpecification>> NETWORK_INTERFACES_FIELD = SdkField
            .<List<LaunchTemplateInstanceNetworkInterfaceSpecification>> builder(MarshallingType.LIST)
            .memberName("NetworkInterfaces")
            .getter(getter(ResponseLaunchTemplateData::networkInterfaces))
            .setter(setter(Builder::networkInterfaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceSet")
                    .unmarshallLocationName("networkInterfaceSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<LaunchTemplateInstanceNetworkInterfaceSpecification> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(LaunchTemplateInstanceNetworkInterfaceSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImageId")
            .getter(getter(ResponseLaunchTemplateData::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId")
                    .unmarshallLocationName("imageId").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceType")
            .getter(getter(ResponseLaunchTemplateData::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("instanceType").build()).build();

    private static final SdkField<String> KEY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KeyName")
            .getter(getter(ResponseLaunchTemplateData::keyName))
            .setter(setter(Builder::keyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName")
                    .unmarshallLocationName("keyName").build()).build();

    private static final SdkField<LaunchTemplatesMonitoring> MONITORING_FIELD = SdkField
            .<LaunchTemplatesMonitoring> builder(MarshallingType.SDK_POJO)
            .memberName("Monitoring")
            .getter(getter(ResponseLaunchTemplateData::monitoring))
            .setter(setter(Builder::monitoring))
            .constructor(LaunchTemplatesMonitoring::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitoring")
                    .unmarshallLocationName("monitoring").build()).build();

    private static final SdkField<LaunchTemplatePlacement> PLACEMENT_FIELD = SdkField
            .<LaunchTemplatePlacement> builder(MarshallingType.SDK_POJO)
            .memberName("Placement")
            .getter(getter(ResponseLaunchTemplateData::placement))
            .setter(setter(Builder::placement))
            .constructor(LaunchTemplatePlacement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement")
                    .unmarshallLocationName("placement").build()).build();

    private static final SdkField<String> RAM_DISK_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RamDiskId")
            .getter(getter(ResponseLaunchTemplateData::ramDiskId))
            .setter(setter(Builder::ramDiskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RamDiskId")
                    .unmarshallLocationName("ramDiskId").build()).build();

    private static final SdkField<Boolean> DISABLE_API_TERMINATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DisableApiTermination")
            .getter(getter(ResponseLaunchTemplateData::disableApiTermination))
            .setter(setter(Builder::disableApiTermination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableApiTermination")
                    .unmarshallLocationName("disableApiTermination").build()).build();

    private static final SdkField<String> INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceInitiatedShutdownBehavior")
            .getter(getter(ResponseLaunchTemplateData::instanceInitiatedShutdownBehaviorAsString))
            .setter(setter(Builder::instanceInitiatedShutdownBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInitiatedShutdownBehavior")
                    .unmarshallLocationName("instanceInitiatedShutdownBehavior").build()).build();

    private static final SdkField<String> USER_DATA_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UserData")
            .getter(getter(ResponseLaunchTemplateData::userData))
            .setter(setter(Builder::userData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserData")
                    .unmarshallLocationName("userData").build()).build();

    private static final SdkField<List<LaunchTemplateTagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<LaunchTemplateTagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(ResponseLaunchTemplateData::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecificationSet")
                    .unmarshallLocationName("tagSpecificationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<LaunchTemplateTagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchTemplateTagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<ElasticGpuSpecificationResponse>> ELASTIC_GPU_SPECIFICATIONS_FIELD = SdkField
            .<List<ElasticGpuSpecificationResponse>> builder(MarshallingType.LIST)
            .memberName("ElasticGpuSpecifications")
            .getter(getter(ResponseLaunchTemplateData::elasticGpuSpecifications))
            .setter(setter(Builder::elasticGpuSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticGpuSpecificationSet")
                    .unmarshallLocationName("elasticGpuSpecificationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ElasticGpuSpecificationResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(ElasticGpuSpecificationResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<LaunchTemplateElasticInferenceAcceleratorResponse>> ELASTIC_INFERENCE_ACCELERATORS_FIELD = SdkField
            .<List<LaunchTemplateElasticInferenceAcceleratorResponse>> builder(MarshallingType.LIST)
            .memberName("ElasticInferenceAccelerators")
            .getter(getter(ResponseLaunchTemplateData::elasticInferenceAccelerators))
            .setter(setter(Builder::elasticInferenceAccelerators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticInferenceAcceleratorSet")
                    .unmarshallLocationName("elasticInferenceAcceleratorSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<LaunchTemplateElasticInferenceAcceleratorResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchTemplateElasticInferenceAcceleratorResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(ResponseLaunchTemplateData::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIdSet")
                    .unmarshallLocationName("securityGroupIdSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroups")
            .getter(getter(ResponseLaunchTemplateData::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupSet")
                    .unmarshallLocationName("securityGroupSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<LaunchTemplateInstanceMarketOptions> INSTANCE_MARKET_OPTIONS_FIELD = SdkField
            .<LaunchTemplateInstanceMarketOptions> builder(MarshallingType.SDK_POJO)
            .memberName("InstanceMarketOptions")
            .getter(getter(ResponseLaunchTemplateData::instanceMarketOptions))
            .setter(setter(Builder::instanceMarketOptions))
            .constructor(LaunchTemplateInstanceMarketOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMarketOptions")
                    .unmarshallLocationName("instanceMarketOptions").build()).build();

    private static final SdkField<CreditSpecification> CREDIT_SPECIFICATION_FIELD = SdkField
            .<CreditSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("CreditSpecification")
            .getter(getter(ResponseLaunchTemplateData::creditSpecification))
            .setter(setter(Builder::creditSpecification))
            .constructor(CreditSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreditSpecification")
                    .unmarshallLocationName("creditSpecification").build()).build();

    private static final SdkField<LaunchTemplateCpuOptions> CPU_OPTIONS_FIELD = SdkField
            .<LaunchTemplateCpuOptions> builder(MarshallingType.SDK_POJO)
            .memberName("CpuOptions")
            .getter(getter(ResponseLaunchTemplateData::cpuOptions))
            .setter(setter(Builder::cpuOptions))
            .constructor(LaunchTemplateCpuOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CpuOptions")
                    .unmarshallLocationName("cpuOptions").build()).build();

    private static final SdkField<LaunchTemplateCapacityReservationSpecificationResponse> CAPACITY_RESERVATION_SPECIFICATION_FIELD = SdkField
            .<LaunchTemplateCapacityReservationSpecificationResponse> builder(MarshallingType.SDK_POJO)
            .memberName("CapacityReservationSpecification")
            .getter(getter(ResponseLaunchTemplateData::capacityReservationSpecification))
            .setter(setter(Builder::capacityReservationSpecification))
            .constructor(LaunchTemplateCapacityReservationSpecificationResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationSpecification")
                    .unmarshallLocationName("capacityReservationSpecification").build()).build();

    private static final SdkField<List<LaunchTemplateLicenseConfiguration>> LICENSE_SPECIFICATIONS_FIELD = SdkField
            .<List<LaunchTemplateLicenseConfiguration>> builder(MarshallingType.LIST)
            .memberName("LicenseSpecifications")
            .getter(getter(ResponseLaunchTemplateData::licenseSpecifications))
            .setter(setter(Builder::licenseSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseSet")
                    .unmarshallLocationName("licenseSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<LaunchTemplateLicenseConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchTemplateLicenseConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<LaunchTemplateHibernationOptions> HIBERNATION_OPTIONS_FIELD = SdkField
            .<LaunchTemplateHibernationOptions> builder(MarshallingType.SDK_POJO)
            .memberName("HibernationOptions")
            .getter(getter(ResponseLaunchTemplateData::hibernationOptions))
            .setter(setter(Builder::hibernationOptions))
            .constructor(LaunchTemplateHibernationOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HibernationOptions")
                    .unmarshallLocationName("hibernationOptions").build()).build();

    private static final SdkField<LaunchTemplateInstanceMetadataOptions> METADATA_OPTIONS_FIELD = SdkField
            .<LaunchTemplateInstanceMetadataOptions> builder(MarshallingType.SDK_POJO)
            .memberName("MetadataOptions")
            .getter(getter(ResponseLaunchTemplateData::metadataOptions))
            .setter(setter(Builder::metadataOptions))
            .constructor(LaunchTemplateInstanceMetadataOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataOptions")
                    .unmarshallLocationName("metadataOptions").build()).build();

    private static final SdkField<LaunchTemplateEnclaveOptions> ENCLAVE_OPTIONS_FIELD = SdkField
            .<LaunchTemplateEnclaveOptions> builder(MarshallingType.SDK_POJO)
            .memberName("EnclaveOptions")
            .getter(getter(ResponseLaunchTemplateData::enclaveOptions))
            .setter(setter(Builder::enclaveOptions))
            .constructor(LaunchTemplateEnclaveOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnclaveOptions")
                    .unmarshallLocationName("enclaveOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KERNEL_ID_FIELD,
            EBS_OPTIMIZED_FIELD, IAM_INSTANCE_PROFILE_FIELD, BLOCK_DEVICE_MAPPINGS_FIELD, NETWORK_INTERFACES_FIELD,
            IMAGE_ID_FIELD, INSTANCE_TYPE_FIELD, KEY_NAME_FIELD, MONITORING_FIELD, PLACEMENT_FIELD, RAM_DISK_ID_FIELD,
            DISABLE_API_TERMINATION_FIELD, INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_FIELD, USER_DATA_FIELD, TAG_SPECIFICATIONS_FIELD,
            ELASTIC_GPU_SPECIFICATIONS_FIELD, ELASTIC_INFERENCE_ACCELERATORS_FIELD, SECURITY_GROUP_IDS_FIELD,
            SECURITY_GROUPS_FIELD, INSTANCE_MARKET_OPTIONS_FIELD, CREDIT_SPECIFICATION_FIELD, CPU_OPTIONS_FIELD,
            CAPACITY_RESERVATION_SPECIFICATION_FIELD, LICENSE_SPECIFICATIONS_FIELD, HIBERNATION_OPTIONS_FIELD,
            METADATA_OPTIONS_FIELD, ENCLAVE_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String kernelId;

    private final Boolean ebsOptimized;

    private final LaunchTemplateIamInstanceProfileSpecification iamInstanceProfile;

    private final List<LaunchTemplateBlockDeviceMapping> blockDeviceMappings;

    private final List<LaunchTemplateInstanceNetworkInterfaceSpecification> networkInterfaces;

    private final String imageId;

    private final String instanceType;

    private final String keyName;

    private final LaunchTemplatesMonitoring monitoring;

    private final LaunchTemplatePlacement placement;

    private final String ramDiskId;

    private final Boolean disableApiTermination;

    private final String instanceInitiatedShutdownBehavior;

    private final String userData;

    private final List<LaunchTemplateTagSpecification> tagSpecifications;

    private final List<ElasticGpuSpecificationResponse> elasticGpuSpecifications;

    private final List<LaunchTemplateElasticInferenceAcceleratorResponse> elasticInferenceAccelerators;

    private final List<String> securityGroupIds;

    private final List<String> securityGroups;

    private final LaunchTemplateInstanceMarketOptions instanceMarketOptions;

    private final CreditSpecification creditSpecification;

    private final LaunchTemplateCpuOptions cpuOptions;

    private final LaunchTemplateCapacityReservationSpecificationResponse capacityReservationSpecification;

    private final List<LaunchTemplateLicenseConfiguration> licenseSpecifications;

    private final LaunchTemplateHibernationOptions hibernationOptions;

    private final LaunchTemplateInstanceMetadataOptions metadataOptions;

    private final LaunchTemplateEnclaveOptions enclaveOptions;

    private ResponseLaunchTemplateData(BuilderImpl builder) {
        this.kernelId = builder.kernelId;
        this.ebsOptimized = builder.ebsOptimized;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.networkInterfaces = builder.networkInterfaces;
        this.imageId = builder.imageId;
        this.instanceType = builder.instanceType;
        this.keyName = builder.keyName;
        this.monitoring = builder.monitoring;
        this.placement = builder.placement;
        this.ramDiskId = builder.ramDiskId;
        this.disableApiTermination = builder.disableApiTermination;
        this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
        this.userData = builder.userData;
        this.tagSpecifications = builder.tagSpecifications;
        this.elasticGpuSpecifications = builder.elasticGpuSpecifications;
        this.elasticInferenceAccelerators = builder.elasticInferenceAccelerators;
        this.securityGroupIds = builder.securityGroupIds;
        this.securityGroups = builder.securityGroups;
        this.instanceMarketOptions = builder.instanceMarketOptions;
        this.creditSpecification = builder.creditSpecification;
        this.cpuOptions = builder.cpuOptions;
        this.capacityReservationSpecification = builder.capacityReservationSpecification;
        this.licenseSpecifications = builder.licenseSpecifications;
        this.hibernationOptions = builder.hibernationOptions;
        this.metadataOptions = builder.metadataOptions;
        this.enclaveOptions = builder.enclaveOptions;
    }

    /**
     * <p>
     * The ID of the kernel, if applicable.
     * </p>
     * 
     * @return The ID of the kernel, if applicable.
     */
    public String kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * Indicates whether the instance is optimized for Amazon EBS I/O.
     * </p>
     * 
     * @return Indicates whether the instance is optimized for Amazon EBS I/O.
     */
    public Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * The IAM instance profile.
     * </p>
     * 
     * @return The IAM instance profile.
     */
    public LaunchTemplateIamInstanceProfileSpecification iamInstanceProfile() {
        return iamInstanceProfile;
    }

    /**
     * Returns true if the BlockDeviceMappings property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasBlockDeviceMappings() {
        return blockDeviceMappings != null && !(blockDeviceMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The block device mappings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBlockDeviceMappings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The block device mappings.
     */
    public List<LaunchTemplateBlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * Returns true if the NetworkInterfaces property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasNetworkInterfaces() {
        return networkInterfaces != null && !(networkInterfaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The network interfaces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNetworkInterfaces()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The network interfaces.
     */
    public List<LaunchTemplateInstanceNetworkInterfaceSpecification> networkInterfaces() {
        return networkInterfaces;
    }

    /**
     * <p>
     * The ID of the AMI that was used to launch the instance.
     * </p>
     * 
     * @return The ID of the AMI that was used to launch the instance.
     */
    public String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type.
     * @see InstanceType
     */
    public InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type.
     * @see InstanceType
     */
    public String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The name of the key pair.
     * </p>
     * 
     * @return The name of the key pair.
     */
    public String keyName() {
        return keyName;
    }

    /**
     * <p>
     * The monitoring for the instance.
     * </p>
     * 
     * @return The monitoring for the instance.
     */
    public LaunchTemplatesMonitoring monitoring() {
        return monitoring;
    }

    /**
     * <p>
     * The placement of the instance.
     * </p>
     * 
     * @return The placement of the instance.
     */
    public LaunchTemplatePlacement placement() {
        return placement;
    }

    /**
     * <p>
     * The ID of the RAM disk, if applicable.
     * </p>
     * 
     * @return The ID of the RAM disk, if applicable.
     */
    public String ramDiskId() {
        return ramDiskId;
    }

    /**
     * <p>
     * If set to <code>true</code>, indicates that the instance cannot be terminated using the Amazon EC2 console,
     * command line tool, or API.
     * </p>
     * 
     * @return If set to <code>true</code>, indicates that the instance cannot be terminated using the Amazon EC2
     *         console, command line tool, or API.
     */
    public Boolean disableApiTermination() {
        return disableApiTermination;
    }

    /**
     * <p>
     * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     * operating system command for system shutdown).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceInitiatedShutdownBehavior} will return {@link ShutdownBehavior#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #instanceInitiatedShutdownBehaviorAsString}.
     * </p>
     * 
     * @return Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     *         operating system command for system shutdown).
     * @see ShutdownBehavior
     */
    public ShutdownBehavior instanceInitiatedShutdownBehavior() {
        return ShutdownBehavior.fromValue(instanceInitiatedShutdownBehavior);
    }

    /**
     * <p>
     * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     * operating system command for system shutdown).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceInitiatedShutdownBehavior} will return {@link ShutdownBehavior#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #instanceInitiatedShutdownBehaviorAsString}.
     * </p>
     * 
     * @return Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     *         operating system command for system shutdown).
     * @see ShutdownBehavior
     */
    public String instanceInitiatedShutdownBehaviorAsString() {
        return instanceInitiatedShutdownBehavior;
    }

    /**
     * <p>
     * The user data for the instance.
     * </p>
     * 
     * @return The user data for the instance.
     */
    public String userData() {
        return userData;
    }

    /**
     * Returns true if the TagSpecifications property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTagSpecifications()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags.
     */
    public List<LaunchTemplateTagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * Returns true if the ElasticGpuSpecifications property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasElasticGpuSpecifications() {
        return elasticGpuSpecifications != null && !(elasticGpuSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The elastic GPU specification.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasElasticGpuSpecifications()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The elastic GPU specification.
     */
    public List<ElasticGpuSpecificationResponse> elasticGpuSpecifications() {
        return elasticGpuSpecifications;
    }

    /**
     * Returns true if the ElasticInferenceAccelerators property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasElasticInferenceAccelerators() {
        return elasticInferenceAccelerators != null && !(elasticInferenceAccelerators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The elastic inference accelerator for the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasElasticInferenceAccelerators()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The elastic inference accelerator for the instance.
     */
    public List<LaunchTemplateElasticInferenceAcceleratorResponse> elasticInferenceAccelerators() {
        return elasticInferenceAccelerators;
    }

    /**
     * Returns true if the SecurityGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security group IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The security group IDs.
     */
    public List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * Returns true if the SecurityGroups property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security group names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The security group names.
     */
    public List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * The market (purchasing) option for the instances.
     * </p>
     * 
     * @return The market (purchasing) option for the instances.
     */
    public LaunchTemplateInstanceMarketOptions instanceMarketOptions() {
        return instanceMarketOptions;
    }

    /**
     * <p>
     * The credit option for CPU usage of the instance.
     * </p>
     * 
     * @return The credit option for CPU usage of the instance.
     */
    public CreditSpecification creditSpecification() {
        return creditSpecification;
    }

    /**
     * <p>
     * The CPU options for the instance. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimizing CPU Options</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return The CPU options for the instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimizing CPU
     *         Options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public LaunchTemplateCpuOptions cpuOptions() {
        return cpuOptions;
    }

    /**
     * <p>
     * Information about the Capacity Reservation targeting option.
     * </p>
     * 
     * @return Information about the Capacity Reservation targeting option.
     */
    public LaunchTemplateCapacityReservationSpecificationResponse capacityReservationSpecification() {
        return capacityReservationSpecification;
    }

    /**
     * Returns true if the LicenseSpecifications property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasLicenseSpecifications() {
        return licenseSpecifications != null && !(licenseSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The license configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLicenseSpecifications()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The license configurations.
     */
    public List<LaunchTemplateLicenseConfiguration> licenseSpecifications() {
        return licenseSpecifications;
    }

    /**
     * <p>
     * Indicates whether an instance is configured for hibernation. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate Your Instance</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return Indicates whether an instance is configured for hibernation. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate Your Instance</a> in
     *         the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public LaunchTemplateHibernationOptions hibernationOptions() {
        return hibernationOptions;
    }

    /**
     * <p>
     * The metadata options for the instance. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance Metadata and User
     * Data</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return The metadata options for the instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance Metadata
     *         and User Data</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public LaunchTemplateInstanceMetadataOptions metadataOptions() {
        return metadataOptions;
    }

    /**
     * <p>
     * Indicates whether the instance is enabled for AWS Nitro Enclaves.
     * </p>
     * 
     * @return Indicates whether the instance is enabled for AWS Nitro Enclaves.
     */
    public LaunchTemplateEnclaveOptions enclaveOptions() {
        return enclaveOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockDeviceMappings() ? blockDeviceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkInterfaces() ? networkInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        hashCode = 31 * hashCode + Objects.hashCode(monitoring());
        hashCode = 31 * hashCode + Objects.hashCode(placement());
        hashCode = 31 * hashCode + Objects.hashCode(ramDiskId());
        hashCode = 31 * hashCode + Objects.hashCode(disableApiTermination());
        hashCode = 31 * hashCode + Objects.hashCode(instanceInitiatedShutdownBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userData());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasElasticGpuSpecifications() ? elasticGpuSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasElasticInferenceAccelerators() ? elasticInferenceAccelerators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(instanceMarketOptions());
        hashCode = 31 * hashCode + Objects.hashCode(creditSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(cpuOptions());
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(hasLicenseSpecifications() ? licenseSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hibernationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(metadataOptions());
        hashCode = 31 * hashCode + Objects.hashCode(enclaveOptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseLaunchTemplateData)) {
            return false;
        }
        ResponseLaunchTemplateData other = (ResponseLaunchTemplateData) obj;
        return Objects.equals(kernelId(), other.kernelId()) && Objects.equals(ebsOptimized(), other.ebsOptimized())
                && Objects.equals(iamInstanceProfile(), other.iamInstanceProfile())
                && hasBlockDeviceMappings() == other.hasBlockDeviceMappings()
                && Objects.equals(blockDeviceMappings(), other.blockDeviceMappings())
                && hasNetworkInterfaces() == other.hasNetworkInterfaces()
                && Objects.equals(networkInterfaces(), other.networkInterfaces()) && Objects.equals(imageId(), other.imageId())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(keyName(), other.keyName()) && Objects.equals(monitoring(), other.monitoring())
                && Objects.equals(placement(), other.placement()) && Objects.equals(ramDiskId(), other.ramDiskId())
                && Objects.equals(disableApiTermination(), other.disableApiTermination())
                && Objects.equals(instanceInitiatedShutdownBehaviorAsString(), other.instanceInitiatedShutdownBehaviorAsString())
                && Objects.equals(userData(), other.userData()) && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications())
                && hasElasticGpuSpecifications() == other.hasElasticGpuSpecifications()
                && Objects.equals(elasticGpuSpecifications(), other.elasticGpuSpecifications())
                && hasElasticInferenceAccelerators() == other.hasElasticInferenceAccelerators()
                && Objects.equals(elasticInferenceAccelerators(), other.elasticInferenceAccelerators())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(instanceMarketOptions(), other.instanceMarketOptions())
                && Objects.equals(creditSpecification(), other.creditSpecification())
                && Objects.equals(cpuOptions(), other.cpuOptions())
                && Objects.equals(capacityReservationSpecification(), other.capacityReservationSpecification())
                && hasLicenseSpecifications() == other.hasLicenseSpecifications()
                && Objects.equals(licenseSpecifications(), other.licenseSpecifications())
                && Objects.equals(hibernationOptions(), other.hibernationOptions())
                && Objects.equals(metadataOptions(), other.metadataOptions())
                && Objects.equals(enclaveOptions(), other.enclaveOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResponseLaunchTemplateData").add("KernelId", kernelId()).add("EbsOptimized", ebsOptimized())
                .add("IamInstanceProfile", iamInstanceProfile())
                .add("BlockDeviceMappings", hasBlockDeviceMappings() ? blockDeviceMappings() : null)
                .add("NetworkInterfaces", hasNetworkInterfaces() ? networkInterfaces() : null).add("ImageId", imageId())
                .add("InstanceType", instanceTypeAsString()).add("KeyName", keyName()).add("Monitoring", monitoring())
                .add("Placement", placement()).add("RamDiskId", ramDiskId())
                .add("DisableApiTermination", disableApiTermination())
                .add("InstanceInitiatedShutdownBehavior", instanceInitiatedShutdownBehaviorAsString())
                .add("UserData", userData()).add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null)
                .add("ElasticGpuSpecifications", hasElasticGpuSpecifications() ? elasticGpuSpecifications() : null)
                .add("ElasticInferenceAccelerators", hasElasticInferenceAccelerators() ? elasticInferenceAccelerators() : null)
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null)
                .add("InstanceMarketOptions", instanceMarketOptions()).add("CreditSpecification", creditSpecification())
                .add("CpuOptions", cpuOptions()).add("CapacityReservationSpecification", capacityReservationSpecification())
                .add("LicenseSpecifications", hasLicenseSpecifications() ? licenseSpecifications() : null)
                .add("HibernationOptions", hibernationOptions()).add("MetadataOptions", metadataOptions())
                .add("EnclaveOptions", enclaveOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KernelId":
            return Optional.ofNullable(clazz.cast(kernelId()));
        case "EbsOptimized":
            return Optional.ofNullable(clazz.cast(ebsOptimized()));
        case "IamInstanceProfile":
            return Optional.ofNullable(clazz.cast(iamInstanceProfile()));
        case "BlockDeviceMappings":
            return Optional.ofNullable(clazz.cast(blockDeviceMappings()));
        case "NetworkInterfaces":
            return Optional.ofNullable(clazz.cast(networkInterfaces()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "KeyName":
            return Optional.ofNullable(clazz.cast(keyName()));
        case "Monitoring":
            return Optional.ofNullable(clazz.cast(monitoring()));
        case "Placement":
            return Optional.ofNullable(clazz.cast(placement()));
        case "RamDiskId":
            return Optional.ofNullable(clazz.cast(ramDiskId()));
        case "DisableApiTermination":
            return Optional.ofNullable(clazz.cast(disableApiTermination()));
        case "InstanceInitiatedShutdownBehavior":
            return Optional.ofNullable(clazz.cast(instanceInitiatedShutdownBehaviorAsString()));
        case "UserData":
            return Optional.ofNullable(clazz.cast(userData()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "ElasticGpuSpecifications":
            return Optional.ofNullable(clazz.cast(elasticGpuSpecifications()));
        case "ElasticInferenceAccelerators":
            return Optional.ofNullable(clazz.cast(elasticInferenceAccelerators()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "InstanceMarketOptions":
            return Optional.ofNullable(clazz.cast(instanceMarketOptions()));
        case "CreditSpecification":
            return Optional.ofNullable(clazz.cast(creditSpecification()));
        case "CpuOptions":
            return Optional.ofNullable(clazz.cast(cpuOptions()));
        case "CapacityReservationSpecification":
            return Optional.ofNullable(clazz.cast(capacityReservationSpecification()));
        case "LicenseSpecifications":
            return Optional.ofNullable(clazz.cast(licenseSpecifications()));
        case "HibernationOptions":
            return Optional.ofNullable(clazz.cast(hibernationOptions()));
        case "MetadataOptions":
            return Optional.ofNullable(clazz.cast(metadataOptions()));
        case "EnclaveOptions":
            return Optional.ofNullable(clazz.cast(enclaveOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResponseLaunchTemplateData, T> g) {
        return obj -> g.apply((ResponseLaunchTemplateData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResponseLaunchTemplateData> {
        /**
         * <p>
         * The ID of the kernel, if applicable.
         * </p>
         * 
         * @param kernelId
         *        The ID of the kernel, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(String kernelId);

        /**
         * <p>
         * Indicates whether the instance is optimized for Amazon EBS I/O.
         * </p>
         * 
         * @param ebsOptimized
         *        Indicates whether the instance is optimized for Amazon EBS I/O.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * The IAM instance profile.
         * </p>
         * 
         * @param iamInstanceProfile
         *        The IAM instance profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfile(LaunchTemplateIamInstanceProfileSpecification iamInstanceProfile);

        /**
         * <p>
         * The IAM instance profile.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link LaunchTemplateIamInstanceProfileSpecification.Builder} avoiding the need to create one manually via
         * {@link LaunchTemplateIamInstanceProfileSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchTemplateIamInstanceProfileSpecification.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #iamInstanceProfile(LaunchTemplateIamInstanceProfileSpecification)}.
         * 
         * @param iamInstanceProfile
         *        a consumer that will call methods on {@link LaunchTemplateIamInstanceProfileSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamInstanceProfile(LaunchTemplateIamInstanceProfileSpecification)
         */
        default Builder iamInstanceProfile(Consumer<LaunchTemplateIamInstanceProfileSpecification.Builder> iamInstanceProfile) {
            return iamInstanceProfile(LaunchTemplateIamInstanceProfileSpecification.builder().applyMutation(iamInstanceProfile)
                    .build());
        }

        /**
         * <p>
         * The block device mappings.
         * </p>
         * 
         * @param blockDeviceMappings
         *        The block device mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<LaunchTemplateBlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * The block device mappings.
         * </p>
         * 
         * @param blockDeviceMappings
         *        The block device mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(LaunchTemplateBlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * The block device mappings.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LaunchTemplateBlockDeviceMapping>.Builder}
         * avoiding the need to create one manually via {@link List<LaunchTemplateBlockDeviceMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LaunchTemplateBlockDeviceMapping>.Builder#build()} is called
         * immediately and its result is passed to {@link #blockDeviceMappings(List<LaunchTemplateBlockDeviceMapping>)}.
         * 
         * @param blockDeviceMappings
         *        a consumer that will call methods on {@link List<LaunchTemplateBlockDeviceMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockDeviceMappings(List<LaunchTemplateBlockDeviceMapping>)
         */
        Builder blockDeviceMappings(Consumer<LaunchTemplateBlockDeviceMapping.Builder>... blockDeviceMappings);

        /**
         * <p>
         * The network interfaces.
         * </p>
         * 
         * @param networkInterfaces
         *        The network interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(Collection<LaunchTemplateInstanceNetworkInterfaceSpecification> networkInterfaces);

        /**
         * <p>
         * The network interfaces.
         * </p>
         * 
         * @param networkInterfaces
         *        The network interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(LaunchTemplateInstanceNetworkInterfaceSpecification... networkInterfaces);

        /**
         * <p>
         * The network interfaces.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <LaunchTemplateInstanceNetworkInterfaceSpecification>.Builder} avoiding the need to create one manually via
         * {@link List<LaunchTemplateInstanceNetworkInterfaceSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <LaunchTemplateInstanceNetworkInterfaceSpecification>.Builder#build()} is called immediately and its result
         * is passed to {@link #networkInterfaces(List<LaunchTemplateInstanceNetworkInterfaceSpecification>)}.
         * 
         * @param networkInterfaces
         *        a consumer that will call methods on {@link List
         *        <LaunchTemplateInstanceNetworkInterfaceSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkInterfaces(List<LaunchTemplateInstanceNetworkInterfaceSpecification>)
         */
        Builder networkInterfaces(Consumer<LaunchTemplateInstanceNetworkInterfaceSpecification.Builder>... networkInterfaces);

        /**
         * <p>
         * The ID of the AMI that was used to launch the instance.
         * </p>
         * 
         * @param imageId
         *        The ID of the AMI that was used to launch the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The name of the key pair.
         * </p>
         * 
         * @param keyName
         *        The name of the key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * The monitoring for the instance.
         * </p>
         * 
         * @param monitoring
         *        The monitoring for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoring(LaunchTemplatesMonitoring monitoring);

        /**
         * <p>
         * The monitoring for the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link LaunchTemplatesMonitoring.Builder} avoiding the
         * need to create one manually via {@link LaunchTemplatesMonitoring#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchTemplatesMonitoring.Builder#build()} is called immediately
         * and its result is passed to {@link #monitoring(LaunchTemplatesMonitoring)}.
         * 
         * @param monitoring
         *        a consumer that will call methods on {@link LaunchTemplatesMonitoring.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoring(LaunchTemplatesMonitoring)
         */
        default Builder monitoring(Consumer<LaunchTemplatesMonitoring.Builder> monitoring) {
            return monitoring(LaunchTemplatesMonitoring.builder().applyMutation(monitoring).build());
        }

        /**
         * <p>
         * The placement of the instance.
         * </p>
         * 
         * @param placement
         *        The placement of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placement(LaunchTemplatePlacement placement);

        /**
         * <p>
         * The placement of the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link LaunchTemplatePlacement.Builder} avoiding the
         * need to create one manually via {@link LaunchTemplatePlacement#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchTemplatePlacement.Builder#build()} is called immediately
         * and its result is passed to {@link #placement(LaunchTemplatePlacement)}.
         * 
         * @param placement
         *        a consumer that will call methods on {@link LaunchTemplatePlacement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placement(LaunchTemplatePlacement)
         */
        default Builder placement(Consumer<LaunchTemplatePlacement.Builder> placement) {
            return placement(LaunchTemplatePlacement.builder().applyMutation(placement).build());
        }

        /**
         * <p>
         * The ID of the RAM disk, if applicable.
         * </p>
         * 
         * @param ramDiskId
         *        The ID of the RAM disk, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramDiskId(String ramDiskId);

        /**
         * <p>
         * If set to <code>true</code>, indicates that the instance cannot be terminated using the Amazon EC2 console,
         * command line tool, or API.
         * </p>
         * 
         * @param disableApiTermination
         *        If set to <code>true</code>, indicates that the instance cannot be terminated using the Amazon EC2
         *        console, command line tool, or API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableApiTermination(Boolean disableApiTermination);

        /**
         * <p>
         * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
         * operating system command for system shutdown).
         * </p>
         * 
         * @param instanceInitiatedShutdownBehavior
         *        Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using
         *        the operating system command for system shutdown).
         * @see ShutdownBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShutdownBehavior
         */
        Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior);

        /**
         * <p>
         * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
         * operating system command for system shutdown).
         * </p>
         * 
         * @param instanceInitiatedShutdownBehavior
         *        Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using
         *        the operating system command for system shutdown).
         * @see ShutdownBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShutdownBehavior
         */
        Builder instanceInitiatedShutdownBehavior(ShutdownBehavior instanceInitiatedShutdownBehavior);

        /**
         * <p>
         * The user data for the instance.
         * </p>
         * 
         * @param userData
         *        The user data for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(String userData);

        /**
         * <p>
         * The tags.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<LaunchTemplateTagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(LaunchTemplateTagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LaunchTemplateTagSpecification>.Builder}
         * avoiding the need to create one manually via {@link List<LaunchTemplateTagSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LaunchTemplateTagSpecification>.Builder#build()} is called
         * immediately and its result is passed to {@link #tagSpecifications(List<LaunchTemplateTagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on {@link List<LaunchTemplateTagSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(List<LaunchTemplateTagSpecification>)
         */
        Builder tagSpecifications(Consumer<LaunchTemplateTagSpecification.Builder>... tagSpecifications);

        /**
         * <p>
         * The elastic GPU specification.
         * </p>
         * 
         * @param elasticGpuSpecifications
         *        The elastic GPU specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuSpecifications(Collection<ElasticGpuSpecificationResponse> elasticGpuSpecifications);

        /**
         * <p>
         * The elastic GPU specification.
         * </p>
         * 
         * @param elasticGpuSpecifications
         *        The elastic GPU specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuSpecifications(ElasticGpuSpecificationResponse... elasticGpuSpecifications);

        /**
         * <p>
         * The elastic GPU specification.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ElasticGpuSpecificationResponse>.Builder}
         * avoiding the need to create one manually via {@link List<ElasticGpuSpecificationResponse>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ElasticGpuSpecificationResponse>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #elasticGpuSpecifications(List<ElasticGpuSpecificationResponse>)}.
         * 
         * @param elasticGpuSpecifications
         *        a consumer that will call methods on {@link List<ElasticGpuSpecificationResponse>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticGpuSpecifications(List<ElasticGpuSpecificationResponse>)
         */
        Builder elasticGpuSpecifications(Consumer<ElasticGpuSpecificationResponse.Builder>... elasticGpuSpecifications);

        /**
         * <p>
         * The elastic inference accelerator for the instance.
         * </p>
         * 
         * @param elasticInferenceAccelerators
         *        The elastic inference accelerator for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticInferenceAccelerators(
                Collection<LaunchTemplateElasticInferenceAcceleratorResponse> elasticInferenceAccelerators);

        /**
         * <p>
         * The elastic inference accelerator for the instance.
         * </p>
         * 
         * @param elasticInferenceAccelerators
         *        The elastic inference accelerator for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticInferenceAccelerators(LaunchTemplateElasticInferenceAcceleratorResponse... elasticInferenceAccelerators);

        /**
         * <p>
         * The elastic inference accelerator for the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <LaunchTemplateElasticInferenceAcceleratorResponse>.Builder} avoiding the need to create one manually via
         * {@link List<LaunchTemplateElasticInferenceAcceleratorResponse>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <LaunchTemplateElasticInferenceAcceleratorResponse>.Builder#build()} is called immediately and its result is
         * passed to {@link #elasticInferenceAccelerators(List<LaunchTemplateElasticInferenceAcceleratorResponse>)}.
         * 
         * @param elasticInferenceAccelerators
         *        a consumer that will call methods on {@link List
         *        <LaunchTemplateElasticInferenceAcceleratorResponse>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticInferenceAccelerators(List<LaunchTemplateElasticInferenceAcceleratorResponse>)
         */
        Builder elasticInferenceAccelerators(
                Consumer<LaunchTemplateElasticInferenceAcceleratorResponse.Builder>... elasticInferenceAccelerators);

        /**
         * <p>
         * The security group IDs.
         * </p>
         * 
         * @param securityGroupIds
         *        The security group IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The security group IDs.
         * </p>
         * 
         * @param securityGroupIds
         *        The security group IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The security group names.
         * </p>
         * 
         * @param securityGroups
         *        The security group names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * The security group names.
         * </p>
         * 
         * @param securityGroups
         *        The security group names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * <p>
         * The market (purchasing) option for the instances.
         * </p>
         * 
         * @param instanceMarketOptions
         *        The market (purchasing) option for the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceMarketOptions(LaunchTemplateInstanceMarketOptions instanceMarketOptions);

        /**
         * <p>
         * The market (purchasing) option for the instances.
         * </p>
         * This is a convenience that creates an instance of the {@link LaunchTemplateInstanceMarketOptions.Builder}
         * avoiding the need to create one manually via {@link LaunchTemplateInstanceMarketOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchTemplateInstanceMarketOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #instanceMarketOptions(LaunchTemplateInstanceMarketOptions)}.
         * 
         * @param instanceMarketOptions
         *        a consumer that will call methods on {@link LaunchTemplateInstanceMarketOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceMarketOptions(LaunchTemplateInstanceMarketOptions)
         */
        default Builder instanceMarketOptions(Consumer<LaunchTemplateInstanceMarketOptions.Builder> instanceMarketOptions) {
            return instanceMarketOptions(LaunchTemplateInstanceMarketOptions.builder().applyMutation(instanceMarketOptions)
                    .build());
        }

        /**
         * <p>
         * The credit option for CPU usage of the instance.
         * </p>
         * 
         * @param creditSpecification
         *        The credit option for CPU usage of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creditSpecification(CreditSpecification creditSpecification);

        /**
         * <p>
         * The credit option for CPU usage of the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link CreditSpecification.Builder} avoiding the need
         * to create one manually via {@link CreditSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreditSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #creditSpecification(CreditSpecification)}.
         * 
         * @param creditSpecification
         *        a consumer that will call methods on {@link CreditSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #creditSpecification(CreditSpecification)
         */
        default Builder creditSpecification(Consumer<CreditSpecification.Builder> creditSpecification) {
            return creditSpecification(CreditSpecification.builder().applyMutation(creditSpecification).build());
        }

        /**
         * <p>
         * The CPU options for the instance. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimizing CPU
         * Options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param cpuOptions
         *        The CPU options for the instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimizing CPU
         *        Options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuOptions(LaunchTemplateCpuOptions cpuOptions);

        /**
         * <p>
         * The CPU options for the instance. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimizing CPU
         * Options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link LaunchTemplateCpuOptions.Builder} avoiding the
         * need to create one manually via {@link LaunchTemplateCpuOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchTemplateCpuOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #cpuOptions(LaunchTemplateCpuOptions)}.
         * 
         * @param cpuOptions
         *        a consumer that will call methods on {@link LaunchTemplateCpuOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cpuOptions(LaunchTemplateCpuOptions)
         */
        default Builder cpuOptions(Consumer<LaunchTemplateCpuOptions.Builder> cpuOptions) {
            return cpuOptions(LaunchTemplateCpuOptions.builder().applyMutation(cpuOptions).build());
        }

        /**
         * <p>
         * Information about the Capacity Reservation targeting option.
         * </p>
         * 
         * @param capacityReservationSpecification
         *        Information about the Capacity Reservation targeting option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationSpecification(
                LaunchTemplateCapacityReservationSpecificationResponse capacityReservationSpecification);

        /**
         * <p>
         * Information about the Capacity Reservation targeting option.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link LaunchTemplateCapacityReservationSpecificationResponse.Builder} avoiding the need to create one
         * manually via {@link LaunchTemplateCapacityReservationSpecificationResponse#builder()}.
         *
         * When the {@link Consumer} completes,
         * {@link LaunchTemplateCapacityReservationSpecificationResponse.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #capacityReservationSpecification(LaunchTemplateCapacityReservationSpecificationResponse)}.
         * 
         * @param capacityReservationSpecification
         *        a consumer that will call methods on
         *        {@link LaunchTemplateCapacityReservationSpecificationResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityReservationSpecification(LaunchTemplateCapacityReservationSpecificationResponse)
         */
        default Builder capacityReservationSpecification(
                Consumer<LaunchTemplateCapacityReservationSpecificationResponse.Builder> capacityReservationSpecification) {
            return capacityReservationSpecification(LaunchTemplateCapacityReservationSpecificationResponse.builder()
                    .applyMutation(capacityReservationSpecification).build());
        }

        /**
         * <p>
         * The license configurations.
         * </p>
         * 
         * @param licenseSpecifications
         *        The license configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseSpecifications(Collection<LaunchTemplateLicenseConfiguration> licenseSpecifications);

        /**
         * <p>
         * The license configurations.
         * </p>
         * 
         * @param licenseSpecifications
         *        The license configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseSpecifications(LaunchTemplateLicenseConfiguration... licenseSpecifications);

        /**
         * <p>
         * The license configurations.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <LaunchTemplateLicenseConfiguration>.Builder} avoiding the need to create one manually via {@link List
         * <LaunchTemplateLicenseConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LaunchTemplateLicenseConfiguration>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #licenseSpecifications(List<LaunchTemplateLicenseConfiguration>)}.
         * 
         * @param licenseSpecifications
         *        a consumer that will call methods on {@link List<LaunchTemplateLicenseConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #licenseSpecifications(List<LaunchTemplateLicenseConfiguration>)
         */
        Builder licenseSpecifications(Consumer<LaunchTemplateLicenseConfiguration.Builder>... licenseSpecifications);

        /**
         * <p>
         * Indicates whether an instance is configured for hibernation. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate Your Instance</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param hibernationOptions
         *        Indicates whether an instance is configured for hibernation. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate Your Instance</a>
         *        in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hibernationOptions(LaunchTemplateHibernationOptions hibernationOptions);

        /**
         * <p>
         * Indicates whether an instance is configured for hibernation. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate Your Instance</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link LaunchTemplateHibernationOptions.Builder}
         * avoiding the need to create one manually via {@link LaunchTemplateHibernationOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchTemplateHibernationOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #hibernationOptions(LaunchTemplateHibernationOptions)}.
         * 
         * @param hibernationOptions
         *        a consumer that will call methods on {@link LaunchTemplateHibernationOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hibernationOptions(LaunchTemplateHibernationOptions)
         */
        default Builder hibernationOptions(Consumer<LaunchTemplateHibernationOptions.Builder> hibernationOptions) {
            return hibernationOptions(LaunchTemplateHibernationOptions.builder().applyMutation(hibernationOptions).build());
        }

        /**
         * <p>
         * The metadata options for the instance. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance Metadata and
         * User Data</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param metadataOptions
         *        The metadata options for the instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance
         *        Metadata and User Data</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataOptions(LaunchTemplateInstanceMetadataOptions metadataOptions);

        /**
         * <p>
         * The metadata options for the instance. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance Metadata and
         * User Data</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link LaunchTemplateInstanceMetadataOptions.Builder}
         * avoiding the need to create one manually via {@link LaunchTemplateInstanceMetadataOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchTemplateInstanceMetadataOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #metadataOptions(LaunchTemplateInstanceMetadataOptions)}.
         * 
         * @param metadataOptions
         *        a consumer that will call methods on {@link LaunchTemplateInstanceMetadataOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataOptions(LaunchTemplateInstanceMetadataOptions)
         */
        default Builder metadataOptions(Consumer<LaunchTemplateInstanceMetadataOptions.Builder> metadataOptions) {
            return metadataOptions(LaunchTemplateInstanceMetadataOptions.builder().applyMutation(metadataOptions).build());
        }

        /**
         * <p>
         * Indicates whether the instance is enabled for AWS Nitro Enclaves.
         * </p>
         * 
         * @param enclaveOptions
         *        Indicates whether the instance is enabled for AWS Nitro Enclaves.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enclaveOptions(LaunchTemplateEnclaveOptions enclaveOptions);

        /**
         * <p>
         * Indicates whether the instance is enabled for AWS Nitro Enclaves.
         * </p>
         * This is a convenience that creates an instance of the {@link LaunchTemplateEnclaveOptions.Builder} avoiding
         * the need to create one manually via {@link LaunchTemplateEnclaveOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchTemplateEnclaveOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #enclaveOptions(LaunchTemplateEnclaveOptions)}.
         * 
         * @param enclaveOptions
         *        a consumer that will call methods on {@link LaunchTemplateEnclaveOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enclaveOptions(LaunchTemplateEnclaveOptions)
         */
        default Builder enclaveOptions(Consumer<LaunchTemplateEnclaveOptions.Builder> enclaveOptions) {
            return enclaveOptions(LaunchTemplateEnclaveOptions.builder().applyMutation(enclaveOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String kernelId;

        private Boolean ebsOptimized;

        private LaunchTemplateIamInstanceProfileSpecification iamInstanceProfile;

        private List<LaunchTemplateBlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();

        private List<LaunchTemplateInstanceNetworkInterfaceSpecification> networkInterfaces = DefaultSdkAutoConstructList
                .getInstance();

        private String imageId;

        private String instanceType;

        private String keyName;

        private LaunchTemplatesMonitoring monitoring;

        private LaunchTemplatePlacement placement;

        private String ramDiskId;

        private Boolean disableApiTermination;

        private String instanceInitiatedShutdownBehavior;

        private String userData;

        private List<LaunchTemplateTagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private List<ElasticGpuSpecificationResponse> elasticGpuSpecifications = DefaultSdkAutoConstructList.getInstance();

        private List<LaunchTemplateElasticInferenceAcceleratorResponse> elasticInferenceAccelerators = DefaultSdkAutoConstructList
                .getInstance();

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private LaunchTemplateInstanceMarketOptions instanceMarketOptions;

        private CreditSpecification creditSpecification;

        private LaunchTemplateCpuOptions cpuOptions;

        private LaunchTemplateCapacityReservationSpecificationResponse capacityReservationSpecification;

        private List<LaunchTemplateLicenseConfiguration> licenseSpecifications = DefaultSdkAutoConstructList.getInstance();

        private LaunchTemplateHibernationOptions hibernationOptions;

        private LaunchTemplateInstanceMetadataOptions metadataOptions;

        private LaunchTemplateEnclaveOptions enclaveOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ResponseLaunchTemplateData model) {
            kernelId(model.kernelId);
            ebsOptimized(model.ebsOptimized);
            iamInstanceProfile(model.iamInstanceProfile);
            blockDeviceMappings(model.blockDeviceMappings);
            networkInterfaces(model.networkInterfaces);
            imageId(model.imageId);
            instanceType(model.instanceType);
            keyName(model.keyName);
            monitoring(model.monitoring);
            placement(model.placement);
            ramDiskId(model.ramDiskId);
            disableApiTermination(model.disableApiTermination);
            instanceInitiatedShutdownBehavior(model.instanceInitiatedShutdownBehavior);
            userData(model.userData);
            tagSpecifications(model.tagSpecifications);
            elasticGpuSpecifications(model.elasticGpuSpecifications);
            elasticInferenceAccelerators(model.elasticInferenceAccelerators);
            securityGroupIds(model.securityGroupIds);
            securityGroups(model.securityGroups);
            instanceMarketOptions(model.instanceMarketOptions);
            creditSpecification(model.creditSpecification);
            cpuOptions(model.cpuOptions);
            capacityReservationSpecification(model.capacityReservationSpecification);
            licenseSpecifications(model.licenseSpecifications);
            hibernationOptions(model.hibernationOptions);
            metadataOptions(model.metadataOptions);
            enclaveOptions(model.enclaveOptions);
        }

        public final String getKernelId() {
            return kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final LaunchTemplateIamInstanceProfileSpecification.Builder getIamInstanceProfile() {
            return iamInstanceProfile != null ? iamInstanceProfile.toBuilder() : null;
        }

        @Override
        public final Builder iamInstanceProfile(LaunchTemplateIamInstanceProfileSpecification iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(LaunchTemplateIamInstanceProfileSpecification.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        public final Collection<LaunchTemplateBlockDeviceMapping.Builder> getBlockDeviceMappings() {
            if (blockDeviceMappings instanceof SdkAutoConstructList) {
                return null;
            }
            return blockDeviceMappings != null ? blockDeviceMappings.stream().map(LaunchTemplateBlockDeviceMapping::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<LaunchTemplateBlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = LaunchTemplateBlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(LaunchTemplateBlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<LaunchTemplateBlockDeviceMapping.Builder>... blockDeviceMappings) {
            blockDeviceMappings(Stream.of(blockDeviceMappings)
                    .map(c -> LaunchTemplateBlockDeviceMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<LaunchTemplateBlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = LaunchTemplateBlockDeviceMappingListCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final Collection<LaunchTemplateInstanceNetworkInterfaceSpecification.Builder> getNetworkInterfaces() {
            if (networkInterfaces instanceof SdkAutoConstructList) {
                return null;
            }
            return networkInterfaces != null ? networkInterfaces.stream()
                    .map(LaunchTemplateInstanceNetworkInterfaceSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkInterfaces(Collection<LaunchTemplateInstanceNetworkInterfaceSpecification> networkInterfaces) {
            this.networkInterfaces = LaunchTemplateInstanceNetworkInterfaceSpecificationListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(LaunchTemplateInstanceNetworkInterfaceSpecification... networkInterfaces) {
            networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(
                Consumer<LaunchTemplateInstanceNetworkInterfaceSpecification.Builder>... networkInterfaces) {
            networkInterfaces(Stream.of(networkInterfaces)
                    .map(c -> LaunchTemplateInstanceNetworkInterfaceSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkInterfaces(
                Collection<LaunchTemplateInstanceNetworkInterfaceSpecification.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = LaunchTemplateInstanceNetworkInterfaceSpecificationListCopier
                    .copyFromBuilder(networkInterfaces);
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKeyName() {
            return keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final LaunchTemplatesMonitoring.Builder getMonitoring() {
            return monitoring != null ? monitoring.toBuilder() : null;
        }

        @Override
        public final Builder monitoring(LaunchTemplatesMonitoring monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final void setMonitoring(LaunchTemplatesMonitoring.BuilderImpl monitoring) {
            this.monitoring = monitoring != null ? monitoring.build() : null;
        }

        public final LaunchTemplatePlacement.Builder getPlacement() {
            return placement != null ? placement.toBuilder() : null;
        }

        @Override
        public final Builder placement(LaunchTemplatePlacement placement) {
            this.placement = placement;
            return this;
        }

        public final void setPlacement(LaunchTemplatePlacement.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        public final String getRamDiskId() {
            return ramDiskId;
        }

        @Override
        public final Builder ramDiskId(String ramDiskId) {
            this.ramDiskId = ramDiskId;
            return this;
        }

        public final void setRamDiskId(String ramDiskId) {
            this.ramDiskId = ramDiskId;
        }

        public final Boolean getDisableApiTermination() {
            return disableApiTermination;
        }

        @Override
        public final Builder disableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
            return this;
        }

        public final void setDisableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
        }

        public final String getInstanceInitiatedShutdownBehavior() {
            return instanceInitiatedShutdownBehavior;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(ShutdownBehavior instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior == null ? null
                    : instanceInitiatedShutdownBehavior.toString());
            return this;
        }

        public final void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
        }

        public final String getUserData() {
            return userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final Collection<LaunchTemplateTagSpecification.Builder> getTagSpecifications() {
            if (tagSpecifications instanceof SdkAutoConstructList) {
                return null;
            }
            return tagSpecifications != null ? tagSpecifications.stream().map(LaunchTemplateTagSpecification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagSpecifications(Collection<LaunchTemplateTagSpecification> tagSpecifications) {
            this.tagSpecifications = LaunchTemplateTagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(LaunchTemplateTagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<LaunchTemplateTagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications)
                    .map(c -> LaunchTemplateTagSpecification.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagSpecifications(Collection<LaunchTemplateTagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = LaunchTemplateTagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        public final Collection<ElasticGpuSpecificationResponse.Builder> getElasticGpuSpecifications() {
            if (elasticGpuSpecifications instanceof SdkAutoConstructList) {
                return null;
            }
            return elasticGpuSpecifications != null ? elasticGpuSpecifications.stream()
                    .map(ElasticGpuSpecificationResponse::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder elasticGpuSpecifications(Collection<ElasticGpuSpecificationResponse> elasticGpuSpecifications) {
            this.elasticGpuSpecifications = ElasticGpuSpecificationResponseListCopier.copy(elasticGpuSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuSpecifications(ElasticGpuSpecificationResponse... elasticGpuSpecifications) {
            elasticGpuSpecifications(Arrays.asList(elasticGpuSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuSpecifications(
                Consumer<ElasticGpuSpecificationResponse.Builder>... elasticGpuSpecifications) {
            elasticGpuSpecifications(Stream.of(elasticGpuSpecifications)
                    .map(c -> ElasticGpuSpecificationResponse.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setElasticGpuSpecifications(
                Collection<ElasticGpuSpecificationResponse.BuilderImpl> elasticGpuSpecifications) {
            this.elasticGpuSpecifications = ElasticGpuSpecificationResponseListCopier.copyFromBuilder(elasticGpuSpecifications);
        }

        public final Collection<LaunchTemplateElasticInferenceAcceleratorResponse.Builder> getElasticInferenceAccelerators() {
            if (elasticInferenceAccelerators instanceof SdkAutoConstructList) {
                return null;
            }
            return elasticInferenceAccelerators != null ? elasticInferenceAccelerators.stream()
                    .map(LaunchTemplateElasticInferenceAcceleratorResponse::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder elasticInferenceAccelerators(
                Collection<LaunchTemplateElasticInferenceAcceleratorResponse> elasticInferenceAccelerators) {
            this.elasticInferenceAccelerators = LaunchTemplateElasticInferenceAcceleratorResponseListCopier
                    .copy(elasticInferenceAccelerators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticInferenceAccelerators(
                LaunchTemplateElasticInferenceAcceleratorResponse... elasticInferenceAccelerators) {
            elasticInferenceAccelerators(Arrays.asList(elasticInferenceAccelerators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticInferenceAccelerators(
                Consumer<LaunchTemplateElasticInferenceAcceleratorResponse.Builder>... elasticInferenceAccelerators) {
            elasticInferenceAccelerators(Stream.of(elasticInferenceAccelerators)
                    .map(c -> LaunchTemplateElasticInferenceAcceleratorResponse.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setElasticInferenceAccelerators(
                Collection<LaunchTemplateElasticInferenceAcceleratorResponse.BuilderImpl> elasticInferenceAccelerators) {
            this.elasticInferenceAccelerators = LaunchTemplateElasticInferenceAcceleratorResponseListCopier
                    .copyFromBuilder(elasticInferenceAccelerators);
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ValueStringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ValueStringListCopier.copy(securityGroupIds);
        }

        public final Collection<String> getSecurityGroups() {
            if (securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = ValueStringListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = ValueStringListCopier.copy(securityGroups);
        }

        public final LaunchTemplateInstanceMarketOptions.Builder getInstanceMarketOptions() {
            return instanceMarketOptions != null ? instanceMarketOptions.toBuilder() : null;
        }

        @Override
        public final Builder instanceMarketOptions(LaunchTemplateInstanceMarketOptions instanceMarketOptions) {
            this.instanceMarketOptions = instanceMarketOptions;
            return this;
        }

        public final void setInstanceMarketOptions(LaunchTemplateInstanceMarketOptions.BuilderImpl instanceMarketOptions) {
            this.instanceMarketOptions = instanceMarketOptions != null ? instanceMarketOptions.build() : null;
        }

        public final CreditSpecification.Builder getCreditSpecification() {
            return creditSpecification != null ? creditSpecification.toBuilder() : null;
        }

        @Override
        public final Builder creditSpecification(CreditSpecification creditSpecification) {
            this.creditSpecification = creditSpecification;
            return this;
        }

        public final void setCreditSpecification(CreditSpecification.BuilderImpl creditSpecification) {
            this.creditSpecification = creditSpecification != null ? creditSpecification.build() : null;
        }

        public final LaunchTemplateCpuOptions.Builder getCpuOptions() {
            return cpuOptions != null ? cpuOptions.toBuilder() : null;
        }

        @Override
        public final Builder cpuOptions(LaunchTemplateCpuOptions cpuOptions) {
            this.cpuOptions = cpuOptions;
            return this;
        }

        public final void setCpuOptions(LaunchTemplateCpuOptions.BuilderImpl cpuOptions) {
            this.cpuOptions = cpuOptions != null ? cpuOptions.build() : null;
        }

        public final LaunchTemplateCapacityReservationSpecificationResponse.Builder getCapacityReservationSpecification() {
            return capacityReservationSpecification != null ? capacityReservationSpecification.toBuilder() : null;
        }

        @Override
        public final Builder capacityReservationSpecification(
                LaunchTemplateCapacityReservationSpecificationResponse capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification;
            return this;
        }

        public final void setCapacityReservationSpecification(
                LaunchTemplateCapacityReservationSpecificationResponse.BuilderImpl capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification != null ? capacityReservationSpecification
                    .build() : null;
        }

        public final Collection<LaunchTemplateLicenseConfiguration.Builder> getLicenseSpecifications() {
            if (licenseSpecifications instanceof SdkAutoConstructList) {
                return null;
            }
            return licenseSpecifications != null ? licenseSpecifications.stream()
                    .map(LaunchTemplateLicenseConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder licenseSpecifications(Collection<LaunchTemplateLicenseConfiguration> licenseSpecifications) {
            this.licenseSpecifications = LaunchTemplateLicenseListCopier.copy(licenseSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseSpecifications(LaunchTemplateLicenseConfiguration... licenseSpecifications) {
            licenseSpecifications(Arrays.asList(licenseSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseSpecifications(Consumer<LaunchTemplateLicenseConfiguration.Builder>... licenseSpecifications) {
            licenseSpecifications(Stream.of(licenseSpecifications)
                    .map(c -> LaunchTemplateLicenseConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLicenseSpecifications(
                Collection<LaunchTemplateLicenseConfiguration.BuilderImpl> licenseSpecifications) {
            this.licenseSpecifications = LaunchTemplateLicenseListCopier.copyFromBuilder(licenseSpecifications);
        }

        public final LaunchTemplateHibernationOptions.Builder getHibernationOptions() {
            return hibernationOptions != null ? hibernationOptions.toBuilder() : null;
        }

        @Override
        public final Builder hibernationOptions(LaunchTemplateHibernationOptions hibernationOptions) {
            this.hibernationOptions = hibernationOptions;
            return this;
        }

        public final void setHibernationOptions(LaunchTemplateHibernationOptions.BuilderImpl hibernationOptions) {
            this.hibernationOptions = hibernationOptions != null ? hibernationOptions.build() : null;
        }

        public final LaunchTemplateInstanceMetadataOptions.Builder getMetadataOptions() {
            return metadataOptions != null ? metadataOptions.toBuilder() : null;
        }

        @Override
        public final Builder metadataOptions(LaunchTemplateInstanceMetadataOptions metadataOptions) {
            this.metadataOptions = metadataOptions;
            return this;
        }

        public final void setMetadataOptions(LaunchTemplateInstanceMetadataOptions.BuilderImpl metadataOptions) {
            this.metadataOptions = metadataOptions != null ? metadataOptions.build() : null;
        }

        public final LaunchTemplateEnclaveOptions.Builder getEnclaveOptions() {
            return enclaveOptions != null ? enclaveOptions.toBuilder() : null;
        }

        @Override
        public final Builder enclaveOptions(LaunchTemplateEnclaveOptions enclaveOptions) {
            this.enclaveOptions = enclaveOptions;
            return this;
        }

        public final void setEnclaveOptions(LaunchTemplateEnclaveOptions.BuilderImpl enclaveOptions) {
            this.enclaveOptions = enclaveOptions != null ? enclaveOptions.build() : null;
        }

        @Override
        public ResponseLaunchTemplateData build() {
            return new ResponseLaunchTemplateData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
