/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a terminated Client VPN endpoint client connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TerminateConnectionStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<TerminateConnectionStatus.Builder, TerminateConnectionStatus> {
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConnectionId")
            .getter(getter(TerminateConnectionStatus::connectionId))
            .setter(setter(Builder::connectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionId")
                    .unmarshallLocationName("connectionId").build()).build();

    private static final SdkField<ClientVpnConnectionStatus> PREVIOUS_STATUS_FIELD = SdkField
            .<ClientVpnConnectionStatus> builder(MarshallingType.SDK_POJO)
            .memberName("PreviousStatus")
            .getter(getter(TerminateConnectionStatus::previousStatus))
            .setter(setter(Builder::previousStatus))
            .constructor(ClientVpnConnectionStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousStatus")
                    .unmarshallLocationName("previousStatus").build()).build();

    private static final SdkField<ClientVpnConnectionStatus> CURRENT_STATUS_FIELD = SdkField
            .<ClientVpnConnectionStatus> builder(MarshallingType.SDK_POJO)
            .memberName("CurrentStatus")
            .getter(getter(TerminateConnectionStatus::currentStatus))
            .setter(setter(Builder::currentStatus))
            .constructor(ClientVpnConnectionStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentStatus")
                    .unmarshallLocationName("currentStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ID_FIELD,
            PREVIOUS_STATUS_FIELD, CURRENT_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String connectionId;

    private final ClientVpnConnectionStatus previousStatus;

    private final ClientVpnConnectionStatus currentStatus;

    private TerminateConnectionStatus(BuilderImpl builder) {
        this.connectionId = builder.connectionId;
        this.previousStatus = builder.previousStatus;
        this.currentStatus = builder.currentStatus;
    }

    /**
     * <p>
     * The ID of the client connection.
     * </p>
     * 
     * @return The ID of the client connection.
     */
    public String connectionId() {
        return connectionId;
    }

    /**
     * <p>
     * The state of the client connection.
     * </p>
     * 
     * @return The state of the client connection.
     */
    public ClientVpnConnectionStatus previousStatus() {
        return previousStatus;
    }

    /**
     * <p>
     * A message about the status of the client connection, if applicable.
     * </p>
     * 
     * @return A message about the status of the client connection, if applicable.
     */
    public ClientVpnConnectionStatus currentStatus() {
        return currentStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(previousStatus());
        hashCode = 31 * hashCode + Objects.hashCode(currentStatus());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateConnectionStatus)) {
            return false;
        }
        TerminateConnectionStatus other = (TerminateConnectionStatus) obj;
        return Objects.equals(connectionId(), other.connectionId()) && Objects.equals(previousStatus(), other.previousStatus())
                && Objects.equals(currentStatus(), other.currentStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TerminateConnectionStatus").add("ConnectionId", connectionId())
                .add("PreviousStatus", previousStatus()).add("CurrentStatus", currentStatus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionId":
            return Optional.ofNullable(clazz.cast(connectionId()));
        case "PreviousStatus":
            return Optional.ofNullable(clazz.cast(previousStatus()));
        case "CurrentStatus":
            return Optional.ofNullable(clazz.cast(currentStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TerminateConnectionStatus, T> g) {
        return obj -> g.apply((TerminateConnectionStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TerminateConnectionStatus> {
        /**
         * <p>
         * The ID of the client connection.
         * </p>
         * 
         * @param connectionId
         *        The ID of the client connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionId(String connectionId);

        /**
         * <p>
         * The state of the client connection.
         * </p>
         * 
         * @param previousStatus
         *        The state of the client connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousStatus(ClientVpnConnectionStatus previousStatus);

        /**
         * <p>
         * The state of the client connection.
         * </p>
         * This is a convenience that creates an instance of the {@link ClientVpnConnectionStatus.Builder} avoiding the
         * need to create one manually via {@link ClientVpnConnectionStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClientVpnConnectionStatus.Builder#build()} is called immediately
         * and its result is passed to {@link #previousStatus(ClientVpnConnectionStatus)}.
         * 
         * @param previousStatus
         *        a consumer that will call methods on {@link ClientVpnConnectionStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #previousStatus(ClientVpnConnectionStatus)
         */
        default Builder previousStatus(Consumer<ClientVpnConnectionStatus.Builder> previousStatus) {
            return previousStatus(ClientVpnConnectionStatus.builder().applyMutation(previousStatus).build());
        }

        /**
         * <p>
         * A message about the status of the client connection, if applicable.
         * </p>
         * 
         * @param currentStatus
         *        A message about the status of the client connection, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentStatus(ClientVpnConnectionStatus currentStatus);

        /**
         * <p>
         * A message about the status of the client connection, if applicable.
         * </p>
         * This is a convenience that creates an instance of the {@link ClientVpnConnectionStatus.Builder} avoiding the
         * need to create one manually via {@link ClientVpnConnectionStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClientVpnConnectionStatus.Builder#build()} is called immediately
         * and its result is passed to {@link #currentStatus(ClientVpnConnectionStatus)}.
         * 
         * @param currentStatus
         *        a consumer that will call methods on {@link ClientVpnConnectionStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #currentStatus(ClientVpnConnectionStatus)
         */
        default Builder currentStatus(Consumer<ClientVpnConnectionStatus.Builder> currentStatus) {
            return currentStatus(ClientVpnConnectionStatus.builder().applyMutation(currentStatus).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String connectionId;

        private ClientVpnConnectionStatus previousStatus;

        private ClientVpnConnectionStatus currentStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateConnectionStatus model) {
            connectionId(model.connectionId);
            previousStatus(model.previousStatus);
            currentStatus(model.currentStatus);
        }

        public final String getConnectionId() {
            return connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public final ClientVpnConnectionStatus.Builder getPreviousStatus() {
            return previousStatus != null ? previousStatus.toBuilder() : null;
        }

        @Override
        public final Builder previousStatus(ClientVpnConnectionStatus previousStatus) {
            this.previousStatus = previousStatus;
            return this;
        }

        public final void setPreviousStatus(ClientVpnConnectionStatus.BuilderImpl previousStatus) {
            this.previousStatus = previousStatus != null ? previousStatus.build() : null;
        }

        public final ClientVpnConnectionStatus.Builder getCurrentStatus() {
            return currentStatus != null ? currentStatus.toBuilder() : null;
        }

        @Override
        public final Builder currentStatus(ClientVpnConnectionStatus currentStatus) {
            this.currentStatus = currentStatus;
            return this;
        }

        public final void setCurrentStatus(ClientVpnConnectionStatus.BuilderImpl currentStatus) {
            this.currentStatus = currentStatus != null ? currentStatus.build() : null;
        }

        @Override
        public TerminateConnectionStatus build() {
            return new TerminateConnectionStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
