/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for AssignPrivateIpAddresses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssignPrivateIpAddressesRequest extends Ec2Request implements
        ToCopyableBuilder<AssignPrivateIpAddressesRequest.Builder, AssignPrivateIpAddressesRequest> {
    private static final SdkField<Boolean> ALLOW_REASSIGNMENT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowReassignment")
            .getter(getter(AssignPrivateIpAddressesRequest::allowReassignment))
            .setter(setter(Builder::allowReassignment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowReassignment")
                    .unmarshallLocationName("allowReassignment").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId")
            .getter(getter(AssignPrivateIpAddressesRequest::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("networkInterfaceId").build()).build();

    private static final SdkField<List<String>> PRIVATE_IP_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PrivateIpAddresses")
            .getter(getter(AssignPrivateIpAddressesRequest::privateIpAddresses))
            .setter(setter(Builder::privateIpAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress")
                    .unmarshallLocationName("privateIpAddress").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("PrivateIpAddress")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("PrivateIpAddress").unmarshallLocationName("PrivateIpAddress")
                                                    .build()).build()).build()).build();

    private static final SdkField<Integer> SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("SecondaryPrivateIpAddressCount")
            .getter(getter(AssignPrivateIpAddressesRequest::secondaryPrivateIpAddressCount))
            .setter(setter(Builder::secondaryPrivateIpAddressCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryPrivateIpAddressCount")
                    .unmarshallLocationName("secondaryPrivateIpAddressCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_REASSIGNMENT_FIELD,
            NETWORK_INTERFACE_ID_FIELD, PRIVATE_IP_ADDRESSES_FIELD, SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD));

    private final Boolean allowReassignment;

    private final String networkInterfaceId;

    private final List<String> privateIpAddresses;

    private final Integer secondaryPrivateIpAddressCount;

    private AssignPrivateIpAddressesRequest(BuilderImpl builder) {
        super(builder);
        this.allowReassignment = builder.allowReassignment;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.secondaryPrivateIpAddressCount = builder.secondaryPrivateIpAddressCount;
    }

    /**
     * <p>
     * Indicates whether to allow an IP address that is already assigned to another network interface or instance to be
     * reassigned to the specified network interface.
     * </p>
     * 
     * @return Indicates whether to allow an IP address that is already assigned to another network interface or
     *         instance to be reassigned to the specified network interface.
     */
    public Boolean allowReassignment() {
        return allowReassignment;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * Returns true if the PrivateIpAddresses property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasPrivateIpAddresses() {
        return privateIpAddresses != null && !(privateIpAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more IP addresses to be assigned as a secondary private IP address to the network interface. You can't
     * specify this parameter when also specifying a number of secondary IP addresses.
     * </p>
     * <p>
     * If you don't specify an IP address, Amazon EC2 automatically selects an IP address within the subnet range.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPrivateIpAddresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more IP addresses to be assigned as a secondary private IP address to the network interface. You
     *         can't specify this parameter when also specifying a number of secondary IP addresses.</p>
     *         <p>
     *         If you don't specify an IP address, Amazon EC2 automatically selects an IP address within the subnet
     *         range.
     */
    public List<String> privateIpAddresses() {
        return privateIpAddresses;
    }

    /**
     * <p>
     * The number of secondary IP addresses to assign to the network interface. You can't specify this parameter when
     * also specifying private IP addresses.
     * </p>
     * 
     * @return The number of secondary IP addresses to assign to the network interface. You can't specify this parameter
     *         when also specifying private IP addresses.
     */
    public Integer secondaryPrivateIpAddressCount() {
        return secondaryPrivateIpAddressCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(allowReassignment());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrivateIpAddresses() ? privateIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(secondaryPrivateIpAddressCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignPrivateIpAddressesRequest)) {
            return false;
        }
        AssignPrivateIpAddressesRequest other = (AssignPrivateIpAddressesRequest) obj;
        return Objects.equals(allowReassignment(), other.allowReassignment())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && hasPrivateIpAddresses() == other.hasPrivateIpAddresses()
                && Objects.equals(privateIpAddresses(), other.privateIpAddresses())
                && Objects.equals(secondaryPrivateIpAddressCount(), other.secondaryPrivateIpAddressCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AssignPrivateIpAddressesRequest").add("AllowReassignment", allowReassignment())
                .add("NetworkInterfaceId", networkInterfaceId())
                .add("PrivateIpAddresses", hasPrivateIpAddresses() ? privateIpAddresses() : null)
                .add("SecondaryPrivateIpAddressCount", secondaryPrivateIpAddressCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllowReassignment":
            return Optional.ofNullable(clazz.cast(allowReassignment()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "PrivateIpAddresses":
            return Optional.ofNullable(clazz.cast(privateIpAddresses()));
        case "SecondaryPrivateIpAddressCount":
            return Optional.ofNullable(clazz.cast(secondaryPrivateIpAddressCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssignPrivateIpAddressesRequest, T> g) {
        return obj -> g.apply((AssignPrivateIpAddressesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, AssignPrivateIpAddressesRequest> {
        /**
         * <p>
         * Indicates whether to allow an IP address that is already assigned to another network interface or instance to
         * be reassigned to the specified network interface.
         * </p>
         * 
         * @param allowReassignment
         *        Indicates whether to allow an IP address that is already assigned to another network interface or
         *        instance to be reassigned to the specified network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowReassignment(Boolean allowReassignment);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * One or more IP addresses to be assigned as a secondary private IP address to the network interface. You can't
         * specify this parameter when also specifying a number of secondary IP addresses.
         * </p>
         * <p>
         * If you don't specify an IP address, Amazon EC2 automatically selects an IP address within the subnet range.
         * </p>
         * 
         * @param privateIpAddresses
         *        One or more IP addresses to be assigned as a secondary private IP address to the network interface.
         *        You can't specify this parameter when also specifying a number of secondary IP addresses.</p>
         *        <p>
         *        If you don't specify an IP address, Amazon EC2 automatically selects an IP address within the subnet
         *        range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(Collection<String> privateIpAddresses);

        /**
         * <p>
         * One or more IP addresses to be assigned as a secondary private IP address to the network interface. You can't
         * specify this parameter when also specifying a number of secondary IP addresses.
         * </p>
         * <p>
         * If you don't specify an IP address, Amazon EC2 automatically selects an IP address within the subnet range.
         * </p>
         * 
         * @param privateIpAddresses
         *        One or more IP addresses to be assigned as a secondary private IP address to the network interface.
         *        You can't specify this parameter when also specifying a number of secondary IP addresses.</p>
         *        <p>
         *        If you don't specify an IP address, Amazon EC2 automatically selects an IP address within the subnet
         *        range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(String... privateIpAddresses);

        /**
         * <p>
         * The number of secondary IP addresses to assign to the network interface. You can't specify this parameter
         * when also specifying private IP addresses.
         * </p>
         * 
         * @param secondaryPrivateIpAddressCount
         *        The number of secondary IP addresses to assign to the network interface. You can't specify this
         *        parameter when also specifying private IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean allowReassignment;

        private String networkInterfaceId;

        private List<String> privateIpAddresses = DefaultSdkAutoConstructList.getInstance();

        private Integer secondaryPrivateIpAddressCount;

        private BuilderImpl() {
        }

        private BuilderImpl(AssignPrivateIpAddressesRequest model) {
            super(model);
            allowReassignment(model.allowReassignment);
            networkInterfaceId(model.networkInterfaceId);
            privateIpAddresses(model.privateIpAddresses);
            secondaryPrivateIpAddressCount(model.secondaryPrivateIpAddressCount);
        }

        public final Boolean getAllowReassignment() {
            return allowReassignment;
        }

        @Override
        public final Builder allowReassignment(Boolean allowReassignment) {
            this.allowReassignment = allowReassignment;
            return this;
        }

        public final void setAllowReassignment(Boolean allowReassignment) {
            this.allowReassignment = allowReassignment;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final Collection<String> getPrivateIpAddresses() {
            if (privateIpAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return privateIpAddresses;
        }

        @Override
        public final Builder privateIpAddresses(Collection<String> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressStringListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(String... privateIpAddresses) {
            privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        public final void setPrivateIpAddresses(Collection<String> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressStringListCopier.copy(privateIpAddresses);
        }

        public final Integer getSecondaryPrivateIpAddressCount() {
            return secondaryPrivateIpAddressCount;
        }

        @Override
        public final Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
            return this;
        }

        public final void setSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssignPrivateIpAddressesRequest build() {
            return new AssignPrivateIpAddressesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
